
int g_ULAforcecolor=-1;
int g_ULArevisit=0;
boolean g_ULADEBUG=false;
int g_ular[]={0,0x24,0x49,0x6d,0x92,0xb6,0xdb,0xff};
int g_ulag[]={0,0x24,0x49,0x6d,0x92,0xb6,0xdb,0xff};
int g_ulab[]={0,0x6d,0xb6,0xff};

void ulaprintln(String ss){
  if(ss.equals(" ")){println("");return;}
  if(g_ULADEBUG){
    println("  ULAP:"+ss);
  }
}

void mark_color(int c){
  g_marked[c]=1;
  g_markctr=10;
}

void reset_marked(){
  int amount=0;
  
  for(int i=0;i<g_maxcolors;i++){
    if(g_marked[i]>0)amount++;
  }
  if(amount==0)return;// only really ULAplus but let's try to keep things generic
  amount=0;
  int c=histogram();
  for(int i=0;i<g_maxcolors;i++){
    if(g_marked[i]==1&&g_histo_amount[i]==0){
      makecolor(i,0,0,0);
      amount++;
    }
    g_marked[i]=0;
  }
}

int ularamp_rg(int rng){
  if(rng==0)return 0;
  if(rng==36)return 1;
  if(rng==73)return 2;
  if(rng==109)return 3;
  if(rng==146)return 4;
  if(rng==182)return 5;
  if(rng==219)return 6;
  if(rng==255)return 7;
  return 0;
}

int ularamp_b(int rng){
  if(rng==0)return 0;
  if(rng==109)return 1;
  if(rng==182)return 2;
  if(rng==255)return 3;
  return 0;
}

int ularetroramp_rg(int rng){
  if(rng==0)return 0;
  if(rng==1)return 36;
  if(rng==2)return 73;
  if(rng==3)return 109;
  if(rng==4)return 146;
  if(rng==5)return 182;
  if(rng==6)return 219;  
  if(rng==7)return 255;
  return 0;  
}

int ularetroramp_b(int rng){
  if(rng==0)return 0;
  if(rng==1)return 109;
  if(rng==2)return 182;
  if(rng==3)return 255;
  return 0;  
}

int not_underneath(int x,int y){
  int i=easygetcolor(x,y);
  int a=getattra(x,y,0);
  int b=getattra(x,y,1);
  if(i==a)return b;
  return a;
}

void recolorl(int xx,int yy,int c){
  int mx=xx/8;
  int my=yy/8;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
      int ad=65536+(xx/8)+(my*8)*MX+y*MX;
      g_map[ad]=byte(c);
    }   
   }    
}

void ulaflip(int xx,int yy){
  int mx=xx/8;
  int my=yy/8;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
      int cad=1024+(mx*8+x)+(my*8+y)*X;
      int d=int(g_map[cad]);
      d=1-d;
      g_map[cad]=byte(d);  
     }
   }  
}

void recolorr(int xx,int yy,int c){
  int mx=xx/8;
  int my=yy/8;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
      int ad=65536+(xx/8)+(my*8)*MX+y*MX;
      g_map[ad+(MX*MY)*8]=byte(c);
    }   
   }    
}

void primeULA(int xx,int yy,int c){
  int mx=xx/8;
  int my=yy/8;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
      int cad=1024+(mx*8+x)+(my*8+y)*X;
      int ad=65536+(xx/8)+(my*8)*MX+y*MX;
        if(getCLUTside(c)==0){
          g_map[cad]=byte(0);
          g_map[ad]=byte(c+8);
          g_map[ad+(MX*MY)*8]=byte(c);
        }else{
          g_map[cad]=byte(1);
          g_map[ad]=byte(c);
          g_map[ad+(MX*MY)*8]=byte(c-8);
        }
    }   
   }  
}


void ulafill(int xx,int yy,int bitmode,int kolor,int kolor2){  
  
  ulaprintln("ulafill "+bitmode+" ink:"+kolor+" pap:"+kolor2);
  int mx=xx/8;
  int my=yy/8;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
       int cad=1024+(mx*8+x)+(my*8+y)*X;
       int ad=65536+(xx/8)+(my*8)*MX+y*MX;
         g_map[cad]=byte(bitmode);
         g_map[ad]=byte(kolor);
         g_map[ad+(MX*MY)*8]=byte(kolor2); 
     }
   }
}

//NOT USED here?
void primeULA2(int xx,int yy,int c){
  if(getCLUTside(c)==0)ulafill(xx,yy,0,c+8,c);//left->0
  if(getCLUTside(c)==1)ulafill(xx,yy,1,c,c-8);//right->1
}

//NOT USED here, at the exporter (?)
void ulafixer(int xx,int yy){
  //if visibly similar colors fill the area
  //prime it properly
  int mx=xx/8;
  int my=yy/8;
  int okay=1;
  int prev=easygetcolor(xx,yy); 
  
  for(int x=0;x<8;x++){
    for(int y=0;y<8;y++){
      if(easygetcolor(mx*8+x,my*8+y)!=prev)okay=0;
    }
  }
  if(okay==0)return;
  primeULA2(xx,yy,prev);
  ulaprintln("fix");

}

int realinkpoint(int xx, int yy){
  int mx=xx/8;
  int my=yy/8;
  int res=0;
  int prev=easygetcolor(mx*8,my*8); 
  for(int x=0;x<8;x++){
    for(int y=0;y<8;y++){
      if(easygetcolor(mx*8+x,my*8+y)==prev)res++;
    }
  }
  ulaprintln("E:"+res);
  return res;
}

int amountinkpoint(int x1,int y1){
  int mx=x1/8;
  int my=y1/8;
  int kval=0;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
       int cad=1024+(mx*8+x)+(my*8+y)*X;
       kval=kval+g_map[cad];
     }
   }
   return kval;
}

int amountink(int mx,int my){
  int kval=0;
   for(int x=0;x<8;x++){
     for(int y=0;y<8;y++){
       int cad=1024+(mx*8+x)+(my*8+y)*X;
       kval=kval+g_map[cad];
     }
   }
   return kval;
}

int getCLUT(int pen){
  return pen/16;
}

int getCLUTside(int pen){
  pen=pen&0x0f;
  if(pen<=7)return 0;
  if(pen>=8)return 1;
  return -1;
}

int findcolorCLUT(int pen,int fromclut){
  int fr=fromclut*16;
  int to=fromclut*16+15;
  if(getCLUTside(pen)==0)fr=fr+8;
  if(getCLUTside(pen)==1)to=to-8;
 // ulaprintln("finding "+pen+" ---from "+fr+" to "+to);
  for(int i=fr;i<=to;i++){
    if(comparecolors(i,pen))return i;
  }
  return -1;
}

int ULAgetink(int x,int y){
  return getattra(x,y,0);
}

int ULAgetpaper(int x,int y){
  return getattra(x,y,1);  
}

void ulapoint(int xx,int yy,int fari){
  int pad=1024+xx+yy*X;
  int mx=xx/8;
  int my=yy/8;
  int ink_ad=65536+mx+(my*8)*MX;
  int paper_ad=65536+mx+(my*8)*MX+(MX*MY)*8;;
  int swap, underneath=0;
  int kval=0;
  int valid=1;
  int probecolorl=getattra(xx,yy,0);
  int probecolorr=getattra(xx,yy,1);
  ulaprintln(".Ulapoint init");
  
  if(g_ULAforcecolor==256){
    g_ULAforcecolor=-1;
    return;
  }
  
  if(g_ULAforcecolor>=0){
    fari=g_ULAforcecolor;
    g_ULAforcecolor=-1;
  }
  ulaprintln("ulapoint phase 1");
  
  underneath=easygetcolor(xx,yy);
  
  //last chance to avoid drawing black on black etc.
  
  if(comparecolors(underneath,fari))return;
  
  ulaprintln("ulapoint phase 2");
  kval=realinkpoint(xx,yy);
   
  //simple case:
  //add a point of same CLUT to square filled with 1 color
   
   if(kval==64){
     ulaprintln("64:");
     if(getCLUT(fari)==getCLUT(underneath)){
       ulaprintln("U");
       if(getCLUTside(fari)!=getCLUTside(underneath)){
         ulaprintln("<>");
         if(getCLUTside(fari)==0){
           simplepaint(xx,yy,1,fari);//ink
           g_map[pad]=0;
         }
         if(getCLUTside(fari)==1){
           simplepaint(xx,yy,0,fari);//pap
           g_map[pad]=1;
         }
         return;
       }
     }
   }
     
   if(getCLUTside(fari)==0)g_map[pad]=0;
   if(getCLUTside(fari)==1)g_map[pad]=1;
}

int col0(int clut){
  return clut*16;
}
int col7(int clut){
  return clut*16+7;
}
int col8(int clut){
  return clut*16+8;
}
int col15(int clut){
  return clut*16+15;
}

int ulaforgery(int x,int y,int fg, int atclut){
  
  // find a legal combo to draw on a square
  // return the pen color
 
  ulaprintln("Attempt forgery at CLUT"+atclut+" >");  
      
  int under=easygetcolor(x,y);
  int penc=fg;
  int newpen=-1;
  int newund=-1;
  
  //to avoid false positive
  //if similar colors aren't here at all
  //the forgery can't proceed
  
  if(comparecolors(ULAgetink(x,y),penc)==false){
    if(comparecolors(ULAgetpaper(x,y),penc)==false){
      ulaprintln("->false: similar color not present at 8x8");
      if(realinkpoint(x,y)!=64)return -1;
    }
  }
  
  // a valid case
  
  if(penc==under){
    ulaprintln("->no need");
    return fg;
  }
  
      ulaprintln("  forge "+penc+" over "+under);
      
      // VARIANT A
      // pen color found from right side of CLUT
      // 
      
      for(int i=col7(atclut);i>=col0(atclut);i--){
        if(comparecolors(i,under)){
          newund=i;
        }     
      }
      for(int i=col15(atclut);i>=col8(atclut);i--){
        if(comparecolors(i,penc)){
          newpen=i;
        }    
      }      
      
      if(newpen>=0&&newund>=0){          
        if(getCLUTside(newpen)==getCLUTside(newund)){
            return -1;
          }
        ulafill(x,y,0,newpen,newund);
        ulaprintln("  -variant A");
        return newpen;
      }

      // VARIANT B
      // pen color found from left side of CLUT
      //
      
      for(int i=col7(atclut);i>=col0(atclut);i--){
        if(comparecolors(i,penc)){
          newpen=i;
        }     
      }
      for(int i=col15(atclut);i>=col8(atclut);i--){
        if(comparecolors(i,under)){
          newund=i;
        }    
      }      
      
      if(newpen>=0&&newund>=0){
          if(getCLUTside(newpen)==getCLUTside(newund)){
            return -1;
          }
          ulaprintln("  -variant B");
          ulafill(x,y,1,newund,newpen);
          return newpen;
      }  
      
      
    ulaprintln("no");
   return -1;
}

int ularearranger(int x,int y,int penc,int under,int atclut){
  //find the penc/under combo from a clut, no matter which way
  int newpen=-1;
  int newund=-1;
  int paper=getattra(x,y,0);
  int ink=getattra(x,y,1);
  int other=paper;
  
  if(realinkpoint(x,y)==64){
    ulaprintln("no rearranger on 8x8");
    return -1;
  }
  
  if(getCLUTside(under)==1)other=ink;
  if(getCLUTside(under)==0)other=paper;  
  ulaprintln("Rearranger @CLUT"+atclut+": pen "+penc+" (under:"+under+" other:"+other+")");
    for(int i=col7(atclut);i>=col0(atclut);i--){
      if(comparecolors(i,other)){
        newund=i;
      }     
    }
    for(int i=col15(atclut);i>=col8(atclut);i--){
      if(comparecolors(i,penc)){
        newpen=i;
      }    
    }      
    
    if(newpen>=0&&newund>=0){     
      ulaprintln("newpen"+newpen+" newund:"+newund);     
      if(getCLUTside(newpen)==getCLUTside(newund)){
          return -1;
        }
      if(getCLUTside(under)==1){
        ulaprintln("s1");
        recolorr(x,y,newund);
        recolorl(x,y,newpen);
      }else{
        ulaprintln("s2");
        ulaflip(x,y);
        recolorr(x,y,newund);
        recolorl(x,y,newpen);        
      }
      ulaprintln("  -rearranger 1");
      return newpen;
    }
        
    ulaprintln("NUL1");
    newpen=-1;
    newund=-1;
      
    for(int i=col7(atclut);i>=col0(atclut);i--){ 
      if(comparecolors(i,penc)){
        newpen=i;
      }          
    }
    for(int i=col15(atclut);i>=col8(atclut);i--){
      if(comparecolors(i,other)){
        newund=i;
      } 
    }      
    
    if(newpen>=0&&newund>=0){          
      if(getCLUTside(newpen)==getCLUTside(newund)){
          return -1;
        }
      if(getCLUTside(under)==0){        
        ulaprintln("as1");
        //ulaflip(x,y);
        recolorr(x,y,newpen);
        recolorl(x,y,newund);
      }else{   
        ulaprintln("as2");
        ulaflip(x,y);
        recolorr(x,y,newpen);
        recolorl(x,y,newund);        
      }
      ulaprintln("  -rearranger 2!");
      return newpen;
    }      
      ulaprintln("NUL2");
  return -1;
}
  
void ulakaveri(int x,int y,int foreg,int backg,int query)
{
  
  //point of the IQ:
  
  //if similar colors (RGB) can make up a valid combo, it ought to be chosen
  
  //if query ==1 then we'll only check if there's a solution
  //needed for the replace mode 'd'
  
    //force priming
    
    if(g_control){
      primeULA(x,y,foreg);
      g_ULAforcecolor=256;
      return;
    }
    
    int ink=getattra(x,y,0);
    int paper=getattra(x,y,1); 
 
   //any "broken" square fixed and go on
   
   if(ink==paper){
     primeULA(x,y,paper);    
     ink=getattra(x,y,0);
     paper=getattra(x,y,1); 
   }
 
   ulaprintln("ulakaveri:("+ink+"/"+paper+")");
   int under=easygetcolor(x,y); 

   // if pen color is identical to either color on a non-empty square, go on 
   // but how about color in differnt clut? (shouldn't matter)
   
   //if(realinkpoint(x,y)!=64){
     if(comparecolors(ink,foreg)){
         ulaprintln("Kaveri says: ink exists "+ink);
         foreg=ink;
         g_ULAforcecolor=ink;
         return;
       }
   
     if(comparecolors(paper,foreg)){
         ulaprintln("Kaveri says: paper exists "+paper);
         foreg=paper;
         g_ULAforcecolor=paper;
         return;
      }
  // }
     
   // if the pen appears valid at this point, why do anything
   // let the pen function handle it - the pen function should be limited in what it does
   
   if(realinkpoint(x,y)==64){
     if(getCLUT(foreg)==getCLUT(under)){
       if(getCLUTside(foreg)!=getCLUTside(under)){
         ulaprintln("kaveri says: valid on 8x8");
         return;
       }
     }
   }
      
   // if the color is equivalent to the the visible color on a filled square
   // also return
   
   if(realinkpoint(x,y)==64){
       if(comparecolors(under,foreg)){
         ulaprintln("Kaveri says: ink exists on full square");
         foreg=under;
         g_ULAforcecolor=under;
         return;
       }
   }
 
 
    
    //16.7.2019
    //Only if NOT 64empty square ?
    //strike that, apparently NOT!
    
    int pekka=0;
    if(realinkpoint(x,y)!=64||pekka==0){
        // fix square color to a legal combo
        // starting from the same CLUT
        
        int a,b,c;
        a=0;b=1;c=2;
        int o=getCLUT(foreg);//get pen CLUT
        //set three others
        if(o==0){a=1;b=2;c=3;}
        if(o==1){a=0;b=2;c=3;}
        if(o==2){a=0;b=1;c=3;}
        if(o==3){a=0;b=1;c=2;}    
        
        int ret=-1;
        
        ret = ulaforgery(x,y,foreg,o);
        
        if(ret==-1)ret=ulaforgery(x,y,foreg,a);
        if(ret==-1)ret=ulaforgery(x,y,foreg,b);
        if(ret==-1)ret=ulaforgery(x,y,foreg,c);
        
        if(ret>=0) {
          g_ULAforcecolor=ret;
          return;
        }
        
        //what if still no legal colour? 
     
     
        // If color underneath can be meaningfully changed,
        // do it
      
    
        // fix square color to a legal combo
        // starting from the same CLUT
        
        a=0;b=1;c=2;
        o=getCLUT(foreg);//get pen CLUT
        //set three others
        if(o==0){a=1;b=2;c=3;}
        if(o==1){a=0;b=2;c=3;}
        if(o==2){a=0;b=1;c=3;}
        if(o==3){a=0;b=1;c=2;}    
        
        ret=-1;
        
        ret = ularearranger(x,y,foreg,under,o);
        
        if(ret==-1)ret=ularearranger(x,y,foreg,under,a);
        if(ret==-1)ret=ularearranger(x,y,foreg,under,b);
        if(ret==-1)ret=ularearranger(x,y,foreg,under,c);
        
        if(ret>=0) {
          g_ULAforcecolor=ret;
          return;
        }  
  
    } //64
  
  //CLUT automator
  
  //As all else has failed,
  
  //here it ought to find "unused" slots preferably from the same CLUT,
  //if not then from some other CLUT
  //Similar colors ought to be preferred, not just "empty"!
  
  //should also work with 64empty squares...
  
  if(g_data['q']==1)return;
  
  if(getCLUT(under)==getCLUT(foreg)){ //at the same CLUT
    
    ulaprintln("AUTOMATOR CLUT=SAME");
    int empty=histogram();
    int fr=0,to=0;
    int base=getCLUT(foreg)*16;
    if(getCLUTside(foreg)==0){
      fr=8;to=15;
    }else{
      fr=0;to=7;
    }
    
    // simplest case:
    // there's room at the SAME CLUT
    // but the already-filled?
    // SHOULD also check if the underlying color is in the opposite side of the CLUT
    
    // still check if the color is present, although at this point we should know(?!)
    for(int i=base+fr;i<=base+to;i++){
      if(comparecolors(i,foreg)){
        g_ULAforcecolor=i;
        return;
      }
    }
    
    //1st-prefer black colors
    for(int i=base+fr;i<=base+to;i++){
      if(g_histo_amount[i]==0&&g_r[i]==0&&g_g[i]==0&&g_b[i]==0){
        makecolor(i,g_r[foreg],g_g[foreg],g_b[foreg]);
        mark_color(i);
        g_ULAforcecolor=i;
        return;
      }
    }
    //then any color will do
    for(int i=base+fr;i<=base+to;i++){
      if(g_histo_amount[i]==0){
        makecolor(i,g_r[foreg],g_g[foreg],g_b[foreg]);
        
        mark_color(i);
        g_ULAforcecolor=i;
        return;
      }
    }
    // in the external CLUT-situation...
    // the system should seek a CLUT where the color pair could most
    // profitably exist...
    // not too easy!
    // I think: instead of wiggling all here, 
    // the colors are created on another CLUT and then the IQ routine 
    // is re-launched "somehow" before the makepoint
    
    /*
    for(int clt=0;clt<=3;clt++){
      int cltbase=clt*16;
      for(int i=cltbase+fr;i<=cltbase+to;i++){
        if(g_histo_amount[i]==0){
          makecolor(i,g_r[foreg],g_g[foreg],g_b[foreg]);
          g_ULAforcecolor=i;
          return;
        }
      }
    }
    */
  
    
  }
  

  // re-automator?
  if(getCLUT(under)!=getCLUT(foreg)){
      
      ulaprintln("AUTOMATOR2 CLUT=DIFFERENT");
      int empty=histogram();
      int other=not_underneath(x,y);
      int fr=0,to=0;
      int base=getCLUT(foreg)*16;
      if(getCLUTside(foreg)==0){
        fr=8;to=15;
      }else{
        fr=0;to=7;
      }  
      
      //1st-prefer black colors
      
      for(int i=base+fr;i<=base+to;i++){
        if(g_histo_amount[i]==0&&g_r[i]==0&&g_g[i]==0&&g_b[i]==0){
          
          if(realinkpoint(x,y)==64){
            makecolor(i,g_r[under],g_g[under],g_b[under]);
            mark_color(i);
            ulaprintln("8x8 exit1");
            return;
          }
          makecolor(i,g_r[other],g_g[other],g_b[other]);
          mark_color(i);
          if(getCLUTside(other)!=getCLUTside(foreg)){g_ULAforcecolor=foreg;}else{g_ULAforcecolor=i;}
          ulaprintln("nice exit1");
          return;
        }
      } 
      
      //then "unused"
      for(int i=base+fr;i<=base+to;i++){
        if(g_histo_amount[i]==0){
          if(realinkpoint(x,y)==64){
            makecolor(i,g_r[under],g_g[under],g_b[under]);
            mark_color(i);
            ulaprintln("8x8 exit2");
            return;
          }
          makecolor(i,g_r[other],g_g[other],g_b[other]);
          mark_color(i);
          if(getCLUTside(other)!=getCLUTside(foreg)){g_ULAforcecolor=foreg;}else{g_ULAforcecolor=i;}
          ulaprintln("nice exit2");
          return;
        }
      }     
      
      //at this point have to assume the clut with the foreground colour
      //is filled, so
      //check from the underlying CLUT
      
      ulaprintln("AUTOMATOR2 CLUT=DIFFERENT --- UNDER");
      
      base=getCLUT(under)*16;
      if(getCLUTside(under)==1){
        fr=8;to=15;
      }else{
        fr=0;to=7;
      }  
         // still check if the color is present, although at this point we should know(?!)
      
      //1st-prefer black colors
      
      for(int i=base+fr;i<=base+to;i++){
        if(g_histo_amount[i]==0&&g_r[i]==0&&g_g[i]==0&&g_b[i]==0){
          
          if(realinkpoint(x,y)==64){
            makecolor(i,g_r[under],g_g[under],g_b[under]);
            mark_color(i);
            ulaprintln("8x8 exit1 AU");
            return;
          }
          makecolor(i,g_r[foreg],g_g[foreg],g_b[foreg]);
          mark_color(i);
          if(getCLUTside(other)!=getCLUTside(foreg)){g_ULAforcecolor=foreg;}else{g_ULAforcecolor=i;}
          ulaprintln("nice exit1 AU");
          return;
        }
      }       
  }

  int kalle=0;
  if(kalle==0){
    g_ULAforcecolor=256;
    return;
  }
  
  //at this point the automator ought to be creative
  //on some other CLUT than the ones involved so far
  //(to-do)
  
  
  //
  //
  //
  
  //no political solution: force prime CLUT
 
    ulaprintln("All failed: prime the 8x8 area");
    ulaprintln(" ");
    g_ULAforcecolor=256;
    if(query==1&&realinkpoint(x,y)!=64)return;
    
    primeULA(x,y,foreg);
    g_ULAforcecolor=256;

}


int[] g_histo_amount = new int[256];

//should be called less often...
//ULAplus specific, so something could be done

int histogram(){
  int empties=0;
  for(int i=0;i<g_maxcolors;i++){
    g_histo_amount[i]=0;
  }
  for(int y=0;y<Y;y++){
      for(int x=0;x<X;x++){
        int c=easygetcolor(x,y);
        g_histo_amount[c]++;
      }
  }
  if(int(g_map[13])==ULAPLUS){
    if(g_histo_amount[g_map[0]]==0)g_histo_amount[g_map[0]]=1;
  }
  for(int i=0;i<g_maxcolors;i++){
    if(g_histo_amount[i]==0)empties++;
  }
  return empties;
}

void floodfill_ula(int xx,int yy,int mou)
{
  int x,y,valid,okay,par,npar;
  npar=0;par=0;
  if(mou==LEFT)par=g_farge;
  if(mou==RIGHT)par=g_backg;
  if(comparecolors(easygetcolor(xx,yy),par))return;
  npar=easygetcolor(xx,yy);
  
  fillmap_clear();
  
  g_fillmap[1024+xx+yy*X]=1;
  valid=0;okay=0;
  while(okay==0){
      valid=0;
      for(y=0;y<Y;y++){
        for(x=0;x<X;x++){
          if(g_fillmap[1024+x+y*X]==1){
             valid=1; 
             if((y>0)&&comparecolors(easygetcolor(x,y-1),npar)&&g_fillmap[1024+x+(y-1)*X]==0)g_fillmap[1024+x+(y-1)*X]=1; 
             if((x>0)&&comparecolors(easygetcolor(x-1,y),npar)&&g_fillmap[1024+(x-1)+y*X]==0)g_fillmap[1024+(x-1)+y*X]=1; 
             if((x<X-1)&&comparecolors(easygetcolor(x+1,y),npar)&&g_fillmap[1024+(x+1)+y*X]==0)g_fillmap[1024+(x+1)+y*X]=1;          
             if((y<Y-1)&&comparecolors(easygetcolor(x,y+1),npar)&&g_fillmap[1024+x+(y+1)*X]==0)g_fillmap[1024+x+(y+1)*X]=1;     
             g_fillmap[1024+x+y*X]=2;
          }
        }
      }
      if(valid==0)okay=1;
  }
  
  g_farge=par;
  for(y=0;y<Y;y++){
    for(x=0;x<X;x++){
      if(g_fillmap[1024+x+y*X]==2)makepoint(x,y);
    }
  }
  g_farge=g_ofarge; 
}

int g_newp[]=new int[64];


void findonly(int c){
  for(int clut=0;clut<4;clut++){
    for(int i=0;i<16;i++){
      if(g_newp[clut*16+i]==c)return;
    }
  }
  for(int clut=0;clut<4;clut++){
    for(int i=0;i<16;i++){
      if(g_newp[clut*16+i]==-1){
        g_newp[clut*16+i]=c;
        return;
      }
    }
  }    
}

void finder(int c1,int c2){
  //pair exists?
  
  for(int clut=0;clut<4;clut++){
    for(int i=0;i<8;i++){
      if(g_newp[clut*16+i]==c1){
        for(int j=8;j<16;j++){
          if(g_newp[clut*16+j]==c2)return;//pair exists L
        }
      }
    }
    for(int i=8;i<16;i++){
      if(g_newp[clut*16+i]==c1){
        for(int j=0;j<8;j++){
          if(g_newp[clut*16+j]==c2)return;//pair exists R
        }
      }
    }    
  }
  
  //half of pair exists?
  for(int clut=0;clut<4;clut++){
    for(int i=0;i<8;i++){
      if(g_newp[clut*16+i]==-1){
        for(int j=8;j<16;j++){
          if(g_newp[clut*16+j]==c2){
            g_newp[clut*16+i]=c1;
            return;//half-created
          }
          if(g_newp[clut*16+j]==c1){
            g_newp[clut*16+i]=c2;
            return;//half-created
          }          
        }
      }
    }
    for(int i=8;i<16;i++){
      if(g_newp[clut*16+i]==-1){
        for(int j=0;j<8;j++){
          if(g_newp[clut*16+j]==c2){
            g_newp[clut*16+i]=c1;
            return;//half-created
          }
          if(g_newp[clut*16+j]==c1){
            g_newp[clut*16+i]=c2;
            return;//half-created
          }          
        }
      }
    }     
  }
  
  //none exists?
  
  for(int clut=0;clut<4;clut++){
    for(int i=0;i<8;i++){
      if(g_newp[clut*16+i]==-1){
        for(int j=8;j<16;j++){
          if(g_newp[clut*16+j]==-1){
            g_newp[clut*16+i]=c1;
            g_newp[clut*16+j]=c2;
            return;//created L
          }
        }
      }
    }
    for(int i=8;i<16;i++){
      if(g_newp[clut*16+i]==-1){
        for(int j=0;j<8;j++){
          if(g_newp[clut*16+j]==-1){
            g_newp[clut*16+i]=c1;
            g_newp[clut*16+j]=c2;
            return;//created R
          }
        }
      }
    }    
  }
}

//for preparing mode-internal conversions
//for source modes with 16 unique colors or less(?)

//mode = external, internal

void ulaplus_prepalette(int mode){
  for(int i=0;i<64;i++){
    g_newp[i]=-1;
  }    
  g_newp[15]=255;
  for(int y=0;y<24;y++){
    for(int x=0;x<32;x++){
      int c1=-1;
      int c2=-1;
      for(int xx=0;xx<8;xx++){
        for(int yy=0;yy<8;yy++){
          int ad=((y*8)+yy)*g_interimwid;
          ad=ad+(x*8)+xx;
          int c=g_fillmap[ad];
          if(c1==-1)c1=c;
          if(c1!=-1&&c2==-1&&c!=c1)c2=c;
        }
      }
      if(c1>=0&&c2>=0){
        finder(c1,c2);
        c1=-1;c2=-1;
      }
      if(c1==-1&&c2>=0){
        findonly(c2);        
        c1=-1;c2=-1;
      }
      if(c2==-1&&c1>=0){
        findonly(c1);
      }      
    }
  }
  
    for(int clut=0;clut<4;clut++){
      for(int i=0;i<16;i++){
        if(i==8)print("/");
        print(nf(g_newp[clut*16+i],2)+". ");
      }
      println();
    }
  
  g_newp[15]=-1;
  for(int i=0;i<64;i++){
    if(g_newp[i]>=0){
      g_r[i]=g_intr[g_newp[i]];
      g_g[i]=g_intg[g_newp[i]];
      g_b[i]=g_intb[g_newp[i]];
    }else{
      g_r[i]=0;
      g_g[i]=0;
      g_b[i]=0;
    }
  }
  for(int i=0;i<64;i++){    
    makecolor(i,g_r[i],g_g[i],g_b[i]);
  }  
  g_newp[15]=0;
}
