// machine definitions
// source writer and other export/import functions
// the machine_export() makes use of bitmapexport() and colorexport() below
// Amstrad templates from Marq's PixelPolizei

// BIN specs
// g_map[88000]  parameters_
// 0        border
// 1        background (c64/plus4 multicolor 0)
// 2        background 2 (plus4 multicolor 1)
// 3        MODE variable = which MODE? = machine
// 4        max colors-1 (255=max=256 colours) = last colour #
// 5        (bitmap width/8)=MX (2-pixel wide resolutions like 160 are still 40)
// 6        0
// 7        (bitmap height/8)=MY
// 8        0
// 9        0
// 10       'M'  <-File ID since 2019
// 11       'P'  <-File ID since 2019
// 12       tool # shortcut
// 13       machine colorsystem (e.g C64) not the same as 'machine', i.e. all C64 modes share the same colorsystem
// 14       bitplanes (for pixelmodes 3,4) since 2020
// 15       pixelmode (internal 1,2,3,4) since 2020
// 16       Image preference bits 128=comm,129=32w,130=db,131=hex,132,133,134,135
// 17       General preference bits 136=border,137=hexify,138=pixelgrid,139,140,141,142,143 (mirrored?)
// 32-95    Internal stored export filename for autput export
// 240      palette range #0 start
// 241      palette range #0 end
// 242      palette range #1 start
// 243      palette range #1 end
// 244      palette range #2 start
// 245      palette range #2 end
// 246      palette range #3 start
// 247      palette range #3 end
// 250-251  TURTLEX
// 252-253  TURTLEY
// 254-255  TURTLEA
// 256-1023 palette R,G,B 8-bit definitions (none present if not paletted mode)
// 1024-    bitmap etc definitions
// 65536-   typically, 8x8 attributes, but can have 2 colormaps

// Image prefs
// 128 comments?
// 129 force 32 wid
// 130 byte/db
// 131 hex out

//   01 23 45 67
//   po=ad[0]+ad[1]*2;
   
// 00 00 00 00 0 zeroc g_map[1]
// 10 10 10 10 1 cad+1000
// 01 01 01 01 2 cad
// 11 11 11 11 3 cad+2000
 
// supported

final int C64=0, MSX=5, SPECTRUM=6, C64M=10, PLUS4=9, PLUS4M=19, CPC=2;

final int CPC1=25; // Amstrad 320 x 200 with 4 colors

final int QLLOW=66,ULAPLUS=67,ATARIST=12,AMIGA=11;

final int CPCOC=26; // Amstrad Overscan test
final int C64NOLIMIT=32; // Commodore 64 without attribute limitations
final int VIC=22; // VIC-20 hires 176x176
final int VICM=222; // VIC-20 multi 88x176

// experimental or incomplete

final int C64MNOLIMIT=42; // Commodore 64 without attribute limitations
final int GX4000=27;
final int COCO3=34;
final int BK0010=99;

//reserved but completely unimplemented

final int C64FLI=20,C64FLIM=21; //incomplete FLI & AFLI modes
final int ULATMX=68; // ULAplus 256x192 8x1 Timex mode
final int CGA=23; // 320 x 200 PC CGA screen with black, white, cyan, magenta
final int CGAX=24; // 320 x 200 PC CGA screen with black, yellow, green, red-ish
final int EGA=200; // 320 x 200 PC EGA screen, 16 colors of 64
final int VGA=255; // 320 x 200 PC VGA screen, 256 colors of 65536
final int NES=90; // 8-bit NES
final int SEGAM=91; // 8-bit Sega Master System
final int ULAFREE=69;
final int TIMEX=7;
final int JR200=8;
final int BBCLOW=35;
final int BBCHI=36;

// hypothetical or test

final int PICO8=88;
final int UNIA=33;

//profiles
final int PROF_BORDER=0;
final int PROF_BACKGND=1;
final int PROF_BACKGND2=2;
final int PROF_PALTOOLS=3;
final int PROF_FXTOOLS=4;
final int PROF_LOADPALETTE=5;
final int PROF_RESIZE=6;
final int PROF_REBITPLANE=7;
 
PImage image;

int g_palstepsr;
int g_palstepsg;
int g_palstepsb;

String g_formatname, g_formatextension;
String g_machinename;
String g_tempname;

int g_headpos;

int []wd=new int[16];

int []g_grids=new int[16];
int []g_colorprofile=new int[16];//0 border? 1 backg? 2 back2? 3 paltools? 4 fxtools?
int []g_usablecolor=new int[256];//bit 1=can use for border 2=can use for backgnd1  4=can use for backgnd2 8=can use for pen
int OLD=0;
int NEW=1;
int FLATRATIO=1;
int SQUARERATIO=0;
int g_gridmode=OLD;
int g_pixelw=1;
int g_planes=1;
int g_aspect=SQUARERATIO;
int g_interimwid=0;
int g_interimhei=0;
int []g_intr=new int[256];
int []g_intg=new int[256];
int []g_intb=new int[256];

String g_report;//file import report

int tdeek(int ad){
  return(int(g_template[ad])*256+int(g_template[ad+1]));
}

void palettesteps(int s){
  g_palstepsr=s;
  g_palstepsg=s;
  g_palstepsb=s;
  make_slider_steps();
}

void make_pixelwidth()
{
  g_pixelw=1;
  if(g_multic==1||g_hzoomer==2)g_pixelw=2;    
}          

//validate width & height as multiples of X or Y
int xpass(int wid){
  if(wid==X)return 1;
  if(wid==X*2)return 1;
  if(wid==X*3)return 1;
  if(wid==X*4)return 1;
  return 0;
}
int ypass(int hei){
  if(hei==Y)return 1;
  if(hei==Y*2)return 1;
  if(hei==Y*3)return 1;
  if(hei==Y*4)return 1;
  return 0;
}

// image-based
int bbox(color cc,int par,int x1,int y1,int x2,int y2){
  if(par==1){
    for(int x=x1;x<x2;x++){
      for(int y=y1;y<y2;y++){
        if(image.get(x,y)!=cc)return x;
      }
    }
  }
  if(par==2){
   for(int y=y1;y<y2;y++){
    for(int x=x1;x<x2;x++){
        if(image.get(x,y)!=cc)return y;
      }
    }
  }
  if(par==3){
    for(int x=x2;x>x1;x--){
      for(int y=y1;y<y2;y++){
        if(image.get(x,y)!=cc)return x+1;
      }
    }
  } 
  if(par==4){
     for(int y=y2;y>y1;y--){
      for(int x=x2;x>x1;x--){
        if(image.get(x,y)!=cc)return y+1;
      }
    }
  }   
  return 0;
}

int[] border_analyser(){
  //println("[Border analyser]");
  int[] ret = new int[4];
  color cc=image.get(0,0);
  int wid=image.width;
  int hei=image.height;
  int x1=bbox(cc,1,0,0,wid/2,hei);
  int y1=bbox(cc,2,0,0,wid,hei/2);
  int x2=bbox(cc,3,wid/2,0,wid-1,hei-1);
  int y2=bbox(cc,4,0,hei/2,wid-1,hei-1);  
  
  if(xpass(x2-x1)==1&&ypass(y2-y1)==1){
    ret[0]=x1;
    ret[1]=y1;
    ret[2]=x2;
    ret[3]=y2;
    g_report=g_report+"Border crop OK|";
    if(g_colorprofile[PROF_BORDER]==1){
      set_border(find_rgb(cc));
    }
    return ret;
  }
  g_report=g_report+"No border fit|";
  ret[0]=0;
  ret[1]=0;
  ret[2]=wid;
  ret[3]=hei;
  return ret;
}

// do resize results fit within memory
// improve memory model in future

int tentative_mode(int x,int y,int bpl){
  x=x*8;
  y=y*8;
  if(g_colorprofile[PROF_REBITPLANE]==0)bpl=4;
 // println(x+","+y+" w "+bpl);
  int memrq=(x*y)/8*bpl;
  //println("="+memrq);
  if(memrq<80000)return 1;
  return 0;
}

void resize_mod(int ox,int oy,int bp){
  int plus=1;
  if(g_shift||g_button==RIGHT)plus=4;
  for(int i=1;i<=plus;i++){
    if(tentative_mode(g_data[NEWX]+ox,g_data[NEWY]+oy,g_data[NEWBPL]+bp)==0)return;
    g_data[NEWY]=byte(g_data[NEWY]+oy);
    g_data[NEWX]=byte(g_data[NEWX]+ox);
    g_data[NEWBPL]=byte(g_data[NEWBPL]+bp);
    if(g_data[NEWY]<8)g_data[NEWY]=8;
    if(g_data[NEWY]>64)g_data[NEWY]=64;//512 tops
    if(g_data[NEWX]<8)g_data[NEWX]=8;
    if(g_data[NEWX]>80)g_data[NEWX]=80;//650 tops
    if(g_data[NEWBPL]<1)g_data[NEWBPL]=1;
    if(g_data[NEWBPL]>5)g_data[NEWBPL]=5;
  }
}



//mode 0=external image
//mode 1=internal fillmap
//par 0=passive count
//par 1=order palette, too

int count_unique_colors(int mode,int par){
  color list[]=new color[256];
  for(int i=0;i<256;i++){
    list[i]=color(0,0,0);
  }  
  int ptr=0;
  int count=0;
  boolean exists=false;
  int r=0,g=0,b=0;
  int ww=g_interimwid;
  int hh=hh=g_interimhei;
  if(mode==0){
    ww=image.width;
    hh=image.height;
  }
  for(int y=0;y<hh;y++){
    for(int x=0;x<ww;x++){
      
      color rgb=color(0,0,0);
      if(mode==0)rgb=image.get(x,y);
      if(mode==1){
        r=g_intr[g_fillmap[x+y*ww]];
        g=g_intg[g_fillmap[x+y*ww]];        
        b=g_intb[g_fillmap[x+y*ww]];
        rgb=color(r,g,b);
      }
      exists=false;
      if(ptr>0){
        for(int c=0;c<ptr;c++){
          if(list[c]==rgb)exists=true;
        }
      }
      if(exists==false){
        if(par==1){
          makecolor(ptr,r,g,b);
        }
        list[ptr]=rgb;
        ptr++;
        count++;
        if(ptr>=256)return 256;
      }
    }
  }
  return count;
}

color g_clist[]=new color[256];
int g_citem[]=new int[256];

int addlist(color c){
  for(int i=0;i<256;i++){
    if(g_citem[i]!=0&&g_clist[i]==c){
      return i;
    }
  }  
  for(int i=0;i<256;i++){
    if(g_citem[i]==0){
      g_citem[i]=1;
      g_clist[i]=c;
      return i;
    }
  }
  return 0;
}

//low-color images
//after knowing the border situation

void internalize(int offsetx,int offsety,float ww,float hh){
  float fx,fy;
  int x2,y2;
  color c;
  fillmap_clear();
  for(int i=0;i<256;i++){
    g_citem[i]=0;
  }
  for(int x=0;x<image.width;x++){
    for(int y=0;y<image.height;y++){
      c=image.get(x, y);
      int rr=dampr(int(red(c)));
      int gg=dampg(int(green(c)));
      int bb=dampb(int(blue(c)));
      //fill(rr,gg,bb);
      image.set(x,y,color(rr,gg,bb));
    }
  }
  //image.save("paska.png");
  for(int yy=0;yy<Y;yy++){
    for(int xx=0;xx<X;xx++){      
      fx=(ww/X)*xx;
      fy=(hh/Y)*yy;
      x2=int(fx);
      y2=int(fy);
      c=image.get(x2+offsetx, y2+offsety);   
      int res=addlist(c);
      g_fillmap[xx+yy*g_interimwid]=byte(res);
    }
  }
  for(int i=0;i<256;i++){
    if(g_citem[i]==1){
      g_intr[i]=int(red(g_clist[i]));
      g_intg[i]=int(green(g_clist[i]));
      g_intb[i]=int(blue(g_clist[i]));
      
      //makecolor(i,red(g_clist[i]),green(g_clist[i]),blue(g_clist[i]));
    }
  }
}

//void image_import
void import_image(String name,int mode,int sourcemode) // ,1 = internal using g_fillmap
{  
    int passhistogram=0;
    g_report="| [X]  CONVERSION |-|";
    System.gc(); 
    println("IMPORT_IMAGE "+name+" , "+mode);
    if(mode==0){
      image = loadImage(name);      
      clear_autohistogram();
    }
    int balx, baly, xx, yy, x2, y2, rr, gg, bb, avg, molox, i, j, target;
    int cx, cy;
    int aas, bbs, swap, idefix, avx, avy;
    int[] pixut= new int[260];
    int[] idx=new int[260];
    int[] histog=new int[8192];
    float ww, hh, fld, compa, fx2, fy2;
    color c;
    int xcolors, limitter, vertti, erkki;
    int rh,gh,bh;
    int startcolor=0;
    int offsetx=0;
    int offsety=0;
    
    if(g_machine==MSX)startcolor=1;
    
    xcolors=g_maxcolors;
    vertti=CY;
    erkki=1;
    limitter=2;//for 2-attribute modes
    
    int uniques;
    
    uniques=count_unique_colors(mode,0);
    //println("Unique colors:"+uniques);
    
    if (g_machine==SPECTRUM) {
       // xcolors=8;
    }
    if (g_attrimode==0) {
        vertti=1;
        erkki=8;
    }
    if (int(g_map[13])==ULAPLUS&&sourcemode==SPECTRUM){
        make_ulaplus_zx_palette();
        passhistogram=1;
    }    
    if (int(g_map[13])==ULAPLUS&&sourcemode==C64){
   //     prepare_ulaplus(0);
  //      passhistogram=1;
    }
    
    if(int(g_map[13])==ULAPLUS&&passhistogram==0){
      if(uniques<=16){
        if(mode==1){//internal
          ulaplus_prepalette(mode);
          passhistogram=1;
          println("kukku");
        }
        if(mode==0){//external
        }        
      }
    }
    if (g_multic==1) {
        limitter=4;
    }//because zero color can be anywhere?
    
    if (g_multic==2||g_multic==3||g_multic==4) {//amiga,st,etc...
        limitter=g_maxcolors;
    }
    molox=1;
        
    store_undo();
    global_clear();
    
    if (g_multic==1||g_hzoomer==2) {
        molox=2;
    }
    ww=0;
    hh=0;
    
    if(mode==0){//file loaded externally
    
      ww=image.width;
      hh=image.height;
      if(ww>2048||hh>2048){
      //  return;
      }
      if(xpass(int(ww))==1&&ypass(int(hh))==1)
      {
          g_report="| [X]  CONVERSION |-|";
      }
      
      g_report=g_report+str(image.width)+" x "+str(image.height)+"|";
      
      if(ww>X&&hh>Y){
        if(xpass(int(ww))==0||ypass(int(hh))==0){
          int[]extents=border_analyser();
          offsetx=extents[0];
          offsety=extents[1];
          ww=extents[2]-extents[0];
          hh=extents[3]-extents[1];
        }         
        if(xpass(int(ww))==0||ypass(int(hh))==0){
          g_report=g_report+"Image scaled|";
        }
      }
      if(int(g_map[13])==ULAPLUS&&passhistogram==0){
        if(uniques<=64){    
          println("  ****");
          internalize(offsetx,offsety,ww,hh);
          ulaplus_prepalette(mode);
          passhistogram=1;
          g_data['q']=1;
          //return;
        }
      }
    }
    
    //println("sourcemode:"+sourcemode);
    //println("newmode:"+g_machine);
    
    if(mode==1){//file "loaded" internally
      //previous screenmode
      println("internal");
      ww=g_interimwid;
      hh=g_interimhei;
      //println("int:"+ww+"."+hh);
      if(ww<=X&&hh<=Y){
        ww=X;
        hh=Y;
        g_report=g_report+"Image cropped|";
      }
      ww=X;
      hh=Y;
 
      if (g_conv_exception==1) {
        //println("VIC->not VIC");
        ww=ww*2;
      }      
      if (g_conv_exception==2) {
        //println("not VIC->VIC");
        ww=ww/2;
      }
      if(g_machine==ULAPLUS){ // preferable
          ulaplus_prepalette(mode);
          passhistogram=1;
          g_data['q']=1;
      }
    }
    
    // internal or not
    
    if (ww<=16||hh<=16)return;
    
    if(uniques<256){
      g_report=g_report+"Colors:"+uniques+"|";
    }
    if(uniques>=256){
      g_report=g_report+"Colors:256+|";      
    }
    
    balx=int(ww/X);
    balx=balx*molox;
    baly=int(hh/Y);
    
    if (balx<1)balx=1;
    if (baly<1)baly=1;

  //stepped palettes

    g_markctr=10;
    if(g_palstepsr>0&&passhistogram==0){
        for(i=0;i<g_maxcolors;i++){
          println("emptypal");
          makecolor(i,0,0,0);
        }
        
      int maxhis;
      int pstepsr,pstepsg,pstepsb;
      int pallsr,pallsg,pallsb;
      int palbc,palrc,palgc;
      pstepsr=int(g_divsr);
      pstepsg=int(g_divsg);
      pstepsb=int(g_divsb);
      maxhis=0;
      pallsr=round(255/g_divsr);
      palrc=pallsr+1;
      pallsg=round(255/g_divsg);
      palgc=pallsg+1;
      pallsb=round(255/g_divsr);
      palbc=pallsb+1;
      //println("pallsr:"+pallsr+" * "+g_divsr+" = "+round(pallsr*g_divsr));
      for (cy=0; cy<MY*erkki; cy++) {
        for (cx=0; cx<MX; cx++) {
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;
                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;

                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                          if(mode==0){
                            c=image.get(x2+avx+offsetx, y2+avy+offsety);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));
                          }
                          if(mode==1){
                            if(x2+avx<g_interimwid&&y2+avy<g_interimhei){
                              c=int(g_fillmap[x2+avx+(y2+avy)*g_interimwid]);
                            }
                              else
                            {c=0;}
                            
                            rr=rr+g_intr[c];
                            gg=gg+g_intg[c];
                            bb=bb+g_intb[c];                            
                          }
                            avg++;
                        }
                    }
                    rh=rr/(avg);
                    gh=gg/(avg);
                    bh=bb/(avg);
                    int closestb=-1;
                    int closestr=-1;
                    int closestg=-1;
                    float distanceb=65536;                   
                    for(int bt=0;bt<g_palstepsr;bt++){
                      float dtest=dist(rh,0,g_stepr[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestr=bt;
                      }
                    }                    
                    distanceb=65536;
                    for(int bt=0;bt<g_palstepsg;bt++){
                      float dtest=dist(gh,0,g_stepg[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestg=bt;
                      }
                    }
                    distanceb=65536;
                    for(int bt=0;bt<g_palstepsb;bt++){
                      float dtest=dist(bh,0,g_stepb[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestb=bt;
                      }
                    }
                    bh=round(g_stepb[closestb]/g_divsb);
                    rh=round(g_stepr[closestr]/g_divsr);
                    gh=round(g_stepg[closestg]/g_divsg);
                    histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)]++;
                    if(histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)]>maxhis)
                      {
                        maxhis=histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)];
                      }
                }
              }
            }
          }
    
      int step=0;
      for(j=maxhis;j>0;j--){
        for(i=0;i<=4096;i++){
           if(histog[i]==j){
              rh=i/int(g_palstepsr*g_palstepsr);
              gh=i-int(rh*(g_palstepsg*g_palstepsg));
              gh=gh/int(g_palstepsg);
              bh=i-int(rh*(g_palstepsr*g_palstepsr));
              bh=bh-int(gh*g_palstepsg);
              rh=round(rh*g_divsr);
              gh=round(gh*g_divsg);
              if(int(g_map[13])==ULAPLUS){
                bh=g_stepb[int(bh)];
              }else{
                bh=round(bh*g_divsb);
              }
              if(step<g_maxcolors){
                if(int(g_map[13])!=ULAPLUS){
                  makecolor(step,rh,gh,bh);
                  step++;
                }
                if(int(g_map[13])==ULAPLUS){
                  makecolor(step,rh,gh,bh);
                  step=step+16;
                  if(step>63)step=step-63;
                }
              }
            }
          }
        }

    }                            
    
    
    
    //histogrammed, let's draw, 8x8 area at time
    global_clear();
    g_markctr=10;
    
    int passes=1;
    if(int(g_map[13])==ULAPLUS)passes=2;
    
    for(int pass=0;pass<passes;pass++){
      
      g_data['q']=0;
      if(pass==0)g_data['q']=1;
      
      for(i=0;i<g_maxcolors;i++){
      
        //println(i+":"+g_intr[i]+"."+g_intg[i]+"."+g_intb[i]);
        //println(i+":"+g_r[i]+"."+g_g[i]+"."+g_b[i]);
        
      }
        
      for (cy=0; cy<MY*erkki; cy++) {
        for (cx=0; cx<MX; cx++) {
            for (i=0; i<xcolors; i++) {
                pixut[i]=0;
                idx[i]=i;
            }  
            
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
              
                for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;

                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;
                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                          if(mode==0){
                            c=image.get(x2+avx+offsetx, y2+avy+offsety);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));              
                            avg++;
                          }
                          
                          if(mode==1){
                            
                            if(x2+avx<g_interimwid&&y2+avy<g_interimhei){
                                c=int(g_fillmap[x2+avx+(y2+avy)*g_interimwid]);}
                              else{
                                c=0;
                              }
                                
                              rr=rr+g_intr[c];
                              gg=gg+g_intg[c];
                              bb=bb+g_intb[c];                                           
                              avg++;                 
                          }            
                        }
                    }
                    rr=round(rr/(avg));
                    gg=round(gg/(avg));
                    bb=round(bb/(avg));
                    g_farge=0;
                    target=-1;
                    compa=65536;
                    for (i=startcolor; i<xcolors; i++) {
                      
                        fld=dist(rr, gg, bb, g_r[i], g_g[i], g_b[i]);
                        
                        if((rr==g_r[i])&&(gg==g_g[i])&&(bb==g_b[i])){
                          compa=-65536;
                          target=i;
                        }
                        if (fld<compa) {
                          compa=fld;
                          target=i;
                        }
                    }

                    g_farge=target;
                    pixut[target]++;//histogramming
                }
            }

            for (aas=0; aas<xcolors; aas++) {
                for (bbs=0; bbs<=aas; bbs++) {
                    if (pixut[aas]>pixut[bbs]) {
                        swap=pixut[aas];
                        pixut[aas]=pixut[bbs];
                        pixut[bbs]=swap;
                        swap=idx[aas];
                        idx[aas]=idx[bbs];
                        idx[bbs]=swap;
                    }
                }
            }

            //colors identified in this square, are drawn in order
            
            //if(cy<4){println(cx+","+cy+" = "+idx[0]+" & "+idx[1]);}
            int blimitter=limitter;
            
            for (idefix=0; idefix<limitter; idefix++) {
                
              i=idx[idefix];
                
                for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                    for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {

                        fx2=(ww/X)*xx;
                        fy2=(hh/Y)*yy;
                    
                        x2=int(fx2);
                        y2=int(fy2);

                        rr=0;
                        gg=0;
                        bb=0;
                        avg=0;
                        for (avy=0; avy<baly; avy++) {
                            for (avx=0; avx<balx; avx++) {
                              if(mode==0){
                                c=image.get(x2+avx+offsetx, y2+avy+offsety);
                                rr=rr+int(red(c));
                                gg=gg+int(green(c));
                                bb=bb+int(blue(c));                      
                                avg++;
                              }
                            if(mode==1){
                              if(x2+avx<g_interimwid&&y2+avy<g_interimhei){
                                c=int(g_fillmap[x2+avx+(y2+avy)*g_interimwid]);
                              }
                              else{
                                c=0;
                              }
                                rr=rr+g_intr[c];
                                gg=gg+g_intg[c];
                                bb=bb+g_intb[c];                                           
                                avg++;                      
                              }        
                            }
                        }
                        rr=round(rr/(avg));
                        gg=round(gg/(avg));
                        bb=round(bb/(avg));
                        g_farge=0;
                        target=-1;
                        compa=256*256;
                        //comparison only with the # of colors in area (e.g. 2)
                        for (j=0; j<limitter; j++) {
                            fld=dist(rr, gg, bb, g_r[idx[j]], g_g[idx[j]], g_b[idx[j]]);
                            if(rr==g_r[idx[j]]&&gg==g_g[idx[j]]&&bb==g_b[idx[j]]){
                              compa=-1;
                              target=idx[j];
                            }                            
                            if (fld<compa) {
                              compa=fld;
                              target=idx[j];
                            }
                        }
                        if (i==target&&idefix!=0) {
                            g_farge=target;
                            if(g_machine==MSX && g_farge==0){
                              g_farge=1;
                            }
                            makepoint(xx, yy);
                        }
                    }
                }
                
                if (idefix==0) {//idefix
                      g_farge=idx[0];
                      if(g_machine==MSX && g_farge==0){
                        g_farge=1;
                      }
                      for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                        for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                            makepoint(xx, yy);
                        }
                    }
                }
            }
        }
    }
  }
  g_data['q']=0;
}

void export_charimage(String name){

    PImage output;
    int wid=0;
    int hei=0;
    int xoff=0;
    int yoff=0;
    
    xoff=0;
    yoff=0;
    wid=128*g_omag;
    hei=128*g_omag;
  
    output= createImage (wid,hei,RGB);
  
    //output the visible graphics as image
    //with border
    //processing style
    int xx, yy, f, x2;
    color c;
    for (xx=0; xx<output.width; xx++) {
        for (yy=0; yy<output.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            output.set(xx, yy, c);
        }
    }

    for (xx=0; xx<128; xx++) {
        for (yy=0; yy<128; yy++) {
            x2=xx; 
            f=getabsa(x2, yy, 0);
            f=easygetcolor(x2,yy);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2; 
                f=getmultic(x2, yy, 0);
            }
            if (g_machine==MSX) {
                if (f==0) {
                    f=g_map[1];
                }
            }
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<=g_omag; vertti++) {
                for (int mortti=0; mortti<=g_omag; mortti++) {
                    output.set(xoff+xx*g_omag+mortti, yoff+yy*g_omag+vertti, c);
                }
            }
        }
    }    
    output.save(name);
}

void export_image(String name)
{
    PImage output;
    int wid=0;
    int hei=0;
    int xoff=0;
    int yoff=0;
    
    if(getbit(136)==0){
      xoff=0;
      yoff=0;
      wid=X*g_omag;
      hei=Y*g_omag;
    }//sans border
    
    if(getbit(136)==1){
      //println("bordv:"+g_bordv);
      wid=X*g_omag+(g_bordh)*g_omag;
      hei=Y*g_omag+(g_bordv)*g_omag;
      xoff=(g_bordh*g_omag)/2;
      yoff=(g_bordv*g_omag)/2;
    }//with border
    
    output= createImage (wid,hei,RGB);
  
    //output the visible graphics as image
    //with border
    //processing style
    int xx, yy, f, x2;
    color c;
    for (xx=0; xx<output.width; xx++) {
        for (yy=0; yy<output.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            output.set(xx, yy, c);
        }
    }

    for (xx=0; xx<X; xx++) {
        for (yy=0; yy<Y; yy++) {
            x2=xx; 
            //f=getabsa(x2, yy, 0);
            f=easygetcolor(x2,yy);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2; 
                f=getmultic(x2, yy, 0);
            }
            
            if (g_machine==MSX && f==0 )f=g_map[1];
            
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<g_omag; vertti++) {
                for (int mortti=0; mortti<g_omag; mortti++) {
                    output.set(xoff+xx*g_omag+mortti, yoff+yy*g_omag+vertti, c);
                }
            }
        }
    }
    output.save(name);
}

void copy_palette(int from,int to){
  for(int i=0;i<16;i++){
    makecolor(to+i,g_r[from+i],g_g[from+i],g_b[from+i]);
  }
}

void prepare_ulaplus(int parm){
  if(parm==0){//for c64 convs
    hard_c64_palette(3,0);
    hard_c64_palette(3,16);
    hard_c64_palette(3,32);
    hard_c64_palette(3,48);    
  }
  if(parm==1){
    copy_palette(0,16);
    copy_palette(0,32);
    copy_palette(0,48);
  }
}

int closest_ulared(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ular.length;i++){
    float dtest=dist(val,0,g_ular[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ular[closest];
}

int closest_ulagreen(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ulag.length;i++){
    float dtest=dist(val,0,g_ulag[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ulag[closest];
}

int closest_ulablue(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ulab.length;i++){
    float dtest=dist(val,0,g_ulab[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ulab[closest];
}

int dampr(int v){
  return closest_ulared(v);
}
int dampg(int v){
  return closest_ulagreen(v);
}
int dampb(int v){
  return closest_ulablue(v);
}

void damp_palette(int par){
  int rh,gh,bh;
  for(int i=0;i<256;i++){
    rh=closest_ulared(g_r[i]);
    gh=closest_ulagreen(g_g[i]);
    bh=closest_ulablue(g_b[i]);
    if(par==0)makecolor(i,rh,gh,bh);
    if(par==1){
      g_intr[i]=rh;
      g_intg[i]=gh;
      g_intb[i]=bh;
    }
  }
}


void hard_c64_palette(int parm,int ofs){
  
  g_map[9]=byte(parm);
  
  if(parm==0){//pepto
    makecolor(0,0,0,0);
    makecolor(1,0xFF,0xFF,0xFF);
    makecolor(2,0x68,0x37,0x2B);
    makecolor(3,0x70,0xA4,0xB2);
    
    makecolor(4,0x6F,0x3D,0x86);
    makecolor(5,0x58,0x8D,0x43);
    makecolor(6,0x35,0x28,0x79);
    makecolor(7,0xB8,0xC7,0x6F);
    
    makecolor(8,0x6F,0x4F,0x25);
    makecolor(9,0x43,0x39,0x00);
    makecolor(10,0x9A,0x67,0x59);
    makecolor(11,0x44,0x44,0x44);
    
    makecolor(12,0x6C,0x6C,0x6C);
    makecolor(13,0x9A,0xD2,0x84);
    makecolor(14,0x6C,0x5E,0xB5);
    makecolor(15,0x95,0x95,0x95);  
  }
  
  if(parm==1){//colodore
    makecolor(0,0,0,0);
    makecolor(1,0xFF,0xFF,0xFF);
    makecolor(2,0x81, 0x33, 0x38);
    makecolor(3,0x75, 0xCE, 0xC8);
    
    makecolor(4,0x8E, 0x3C, 0x97);
    makecolor(5,0x56, 0xAC, 0x4D);
    makecolor(6,0x2E, 0x2C, 0x9B);
    makecolor(7,0xED, 0xF1, 0x71);
    
    makecolor(8,0x8E, 0x50, 0x29);
    makecolor(9,0x55, 0x38, 0x00);
    makecolor(10,0xC4, 0x6C, 0x71);
    makecolor(11,0x4A, 0x4A, 0x4A);
    
    makecolor(12,0x7B, 0x7B, 0x7B);
    makecolor(13,0xA9, 0xFF, 0x9F);
    makecolor(14,0x70, 0x6D, 0xEB);
    makecolor(15,0xB2, 0xB2, 0xB2);  
  }  
  if(parm==2){//ptoing
    makecolor(0,0x00,0x00,0x00); 
    makecolor(1,0xff,0xff,0xff);
    makecolor(2,0x8c,0x3e,0x34);
    makecolor(3,0x7a,0xbf,0xc7);
    
    makecolor(4,0x8d,0x47,0xb3); 
    makecolor(5,0x68,0xa9,0x41);
    makecolor(6,0x3e,0x31,0xa2);
    makecolor(7,0xd0,0xdc,0x71);

    makecolor(8,0x90,0x5f,0x25);
    makecolor(9,0x57,0x42,0x00);
    makecolor(10,0xbb,0x77,0x6d);
    makecolor(11,0x54,0x54,0x54);
    
    makecolor(12,0x80,0x80,0x80);
    makecolor(13,0xac,0xea,0x88);
    makecolor(14,0x7c,0x70,0xda);
    makecolor(15,0xab,0xab,0xab);
  }
  if(parm==3){//ulaplus "dr. terrorz"
    makecolor(0+ofs,0x00,0x00,0x00); 
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0x6d,0x24,0x00);//922464 technically?
    makecolor(3+ofs,0x6d,0xdb,0xb6);
    
    makecolor(4+ofs,0x92,0x49,0xb6); 
    makecolor(5+ofs,0x49,0xb6,0x6d);
    makecolor(6+ofs,0x24,0x24,0xb6);
    makecolor(7+ofs,0xdb,0xdb,0x6d); //dbff6d technically?

    makecolor(8+ofs,0x92,0x49,0x00);
    makecolor(9+ofs,0x49,0x24,0x00); //49 49 00 technically?
    makecolor(10+ofs,0xb6,0x6d,0x6d);
    makecolor(11+ofs,0x49,0x49,0x6d);
    
    makecolor(12+ofs,0x6d,0x6d,0x6d);
    makecolor(13+ofs,0xb6,0xff,0xb6);
    makecolor(14+ofs,0x6d,0x6d,0xff);
    makecolor(15+ofs,0xb6,0xb6,0xb6);
  }    
  if(parm==4){//ulaplus "canonical"
    makecolor(0+ofs,0x00,0x00,0x00); 
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0x92,0x00,0x00);
    makecolor(3+ofs,0xb6,0xff,0xff);
    
    makecolor(4+ofs,0xdb,0x49,0xff); 
    makecolor(5+ofs,0x00,0xdb,0x6d);
    makecolor(6+ofs,0x00,0x00,0xb6);
    makecolor(7+ofs,0xff,0xff,0x6d);

    makecolor(8+ofs,0xdb,0xb6,0x6d);
    makecolor(9+ofs,0x6d,0x49,0x00);
    makecolor(10+ofs,0xff,0x6d,0x6d);
    makecolor(11+ofs,0x24,0x24,0x00);
    
    makecolor(12+ofs,0x6d,0x6d,0x6d);
    makecolor(13+ofs,0xb6,0xff,0x6d);
    makecolor(14+ofs,0x00,0x92,0xff);
    makecolor(15+ofs,0xb6,0xb6,0xb6);
  }  
}

int []g_stepr=new int[16];
int []g_stepg=new int[16];
int []g_stepb=new int[16];

float g_divsr;
float g_divsg;
float g_divsb;
float g_divsbfix;

void make_slider_steps(){
  
   g_divsr=(255.0/(g_palstepsr-1));
   g_divsg=(255.0/(g_palstepsg-1));
   g_divsb=(255.0/(g_palstepsb-1));
   g_divsbfix=(255.0/(g_palstepsr-1));
   
  for(int i=0;i<g_palstepsr;i++){
    g_stepr[i]=round(i*g_divsr);
  }
  for(int i=0;i<g_palstepsg;i++){
    g_stepg[i]=round(i*g_divsg);
  }
  for(int i=0;i<g_palstepsb;i++){
    g_stepb[i]=round(i*g_divsb);
  }
  
  if(int(g_map[13])==ULAPLUS){    
    g_stepb[0]=0;
    g_stepb[1]=0x6d;
    g_stepb[2]=0xb6;
    g_stepb[3]=0xff;
  }    
}

void make_vic_palette()
{
    /*int rgb[]={#000000,#FFFFFF,#c63729,#99ffff,#db44f9,#81ff5d,#4832ff,#ffff32,#e98f00,#ffdc6f,#ffb6ac,#bcffff,#ffaeff,#bfffa0,#baaaff,#ffff51};
    */
      
    int rgb[]={#000000,#FFFFFF,#8D3C34,#9ADEE3,#A24EB4,#84D171,#4236C4,#E0E866,
               #AF7C36,#EBBC81,#E6A39D,#B6F7FD,#ECA3FC,#B6FEA5,#A098FF,#FAFF85};
               
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#282828;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }       
    for(int i=8;i<16;i++){
      g_usablecolor[i]=6; // can use for backgs, but not for border or pen
    }
    g_map[13]=byte(VIC);
}

void make_c64_palette()
{
    // Pepto's murky C64 palette: http://www.pepto.de/projects/colorvic
    int rgb[]={#000000,#FFFFFF,#68372B,#70A4B2,#6F3D86,#588D43,#352879,#B8C76F, #6F4F25,#433900,#9A6759,#444444,#6C6C6C,#9AD284,#6C5EB5,#959595};
                                       
    //jampal
    
   // int rgb[]={#000000, #ffffff, #7d202c, #4fb3a5, #84258c, #339840, #2a1b9d, #bfd04a, #7f410d, #4c2e00, #b44f5c, #3c3c3c, #646464, #7ce587, #6351db, #939393};                 
                     
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#282828;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_grids[1]=#d0d0d0;g_gridmode=NEW;
    g_map[13]=byte(C64);
    g_colorprofile[PROF_LOADPALETTE]=1;
}

void make_coco_palette()
{
    for(int i=0;i<g_maxcolors;i++){
      makecolor(i,0,0,0);
    }
}

void make_plus4_palette()
{
  int rgb[]={
    #000000,#2C2C2C,#621307,#00424C,#510378,#004E00,#27188E,#303E00,#582100,#463000,#244400,#630448,#004E0C,#0E2784,#33118E,#184800,
    #3B3B3B,#702419,#00505A,#601685,#125D00,#36289B,#3F4C00,#663100,#553F00,#345200,#711656,#005C1D,#1F3691,#42229B,#285700,
    #424242,#772C21,#055861,#661E8C,#1B6400,#3E30A2,#475400,#6D3900,#5C4700,#3B5900,#771F5D,#046325,#273E98,#492AA1,#305E00,
    #515151,#843B31,#17656F,#742E99,#2B7100,#4C3FAF,#556200,#7A4709,#6A5500,#4A6700,#852F6B,#177135,#364CA5,#5739AE,#3F6B00,
    #7A7A7A,#AC665C,#468E97,#9C5AC0,#57992E,#766AD5,#7E8A13,#A2713A,#927E20,#748F14,#AC5A93,#459960,#6276CB,#8064D4,#6A9419,
    #959595,#C58178,#62A8B1,#B675D9,#73B34C,#9185ED,#99A433,#BB8C57,#AC993E,#8FAA34,#C676AD,#62B37B,#7D91E4,#9B80ED,#85AE38,
    #AFAFAF,#DE9B93,#7DC2CA,#CF90F2,#8DCD68,#AB9FFF,#B3BE51,#D5A673,#C6B35B,#A9C351,#DF91C7,#7DCC96,#97ABFD,#B59AFF,#9FC755,
    #E1E1E1,#FFCFC6,#B2F4FC,#FFC4FF,#C1FE9D,#DDD2FF,#E5F088,#FFD9A8,#F7E591,#DBF588,#FFC4F9,#B1FEC9,#CBDDFF,#E7CDFF,#D2F98C
  };
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_map[13]=byte(CPC);
}

void make_msx_palette()
{
    int rgb[]={
    #000000,
    #000000,
    #3EB849,
    #74D07D,
    #5955E0,
    #8076F1,
    #B95E51,
    #65DBEF,
    #DB6559,
    #FF897D,
    #CCC35E,
    #DED087,
    #3AA241,
    #B766B5,
    #CCCCCC,
    #FFFFFF};

    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#1f1f1f;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_grids[5]=#9f95Ff;
    g_grids[7]=#84faEF;
    g_grids[9]=#ffa99d;
    g_grids[15]=#d8d8d8;g_gridmode=NEW;
    g_map[13]=byte(MSX);
}

void make_bk_palette()
{
  int rgb[]={#000000,#0000ff,#00ff00,#ff0000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,};
  for(int i=0;i<g_maxcolors;i++){
    rgb[i]=rgb[i]&0xffffff;
    if(i<=8){g_grids[i]=rgb[i]+#282828;}
    makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
  }
}

void make_ql_palette()
{
  int rgb[]={#000000,#0000FF,#FF0000,#FF00FF,#00FF00,#00FFFF,#FFFF00,#FFFFFF};
    g_grids[0]=#282828;
    g_grids[1]=#0000d8;
    g_grids[2]=#d80000;
    g_grids[3]=#d800d8;
    g_grids[4]=#00d800;
    g_grids[5]=#00d8d8;
    g_grids[6]=#d8d800;
    g_grids[7]=#d8d8d8;  
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_gridmode=NEW;  
}

void make_ulaplus_palette(){
  //int rgb[]={#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,
  //           #000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff,#000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff};
             int rgb[]={#000000,#b60000,#00b600,#0000b6,#000000,#000000,#000000,#000000,
                        #000000,#6d6d6d,#b6b6b6,#ffffff,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000};
    for(int i=0;i<64;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);   
    }
    for(int i=16;i<24;i++){
      rgb[i]=rgb[i]&0xffffff;  
    }     
    g_map[13]=byte(ULAPLUS);
}

void make_ulaplus_zx_palette(){
  int rgb[]={#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,
             #000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff,#000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff};

    for(int i=0;i<64;i++){
      makecolor(i,0,0,0);
    }
    for(int i=0;i<16;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i+16,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
      makecolor(i+24,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);    
    }
    for(int i=16;i<24;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i+16,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
      makecolor(i+24,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);    
    }     
    g_map[13]=byte(ULAPLUS);
}

void make_spectrum_palette()
{
  int rgb[]={#000000,#0000B6,#B60000,#B600B6,#00B600,#00B6B6,#B6B600,#B6B6B6,
              #000000,#0000FF,#FF0000,#FF00FF,#00FF00,#00FFFF,#FFFF00,#FFFFFF};
              
    g_grids[9]=#0000d8;
    g_grids[10]=#d80000;
    g_grids[11]=#d800d8;
    g_grids[12]=#00d800;
    g_grids[13]=#00d8d8;
    g_grids[14]=#d8d800;
    g_grids[15]=#d8d8d8;
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      if(i<=8){g_grids[i]=rgb[i]+#282828;}
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_gridmode=NEW;
    g_map[13]=byte(SPECTRUM);
}


void invoke_machine(String mname){
  for(int i=0;i<g_machinecalled.length;i++){
    if(mname.equals(g_machinecalled[i])){
      change_mode(g_machinemenu[i],i);
    }
  }
}

//provisional non-standard sizes
//follows from APPLY used in RESIZE window
void change_size(){
    int complexity=interim_store();
    MX=int(g_data[NEWX]);
    MY=int(g_data[NEWY]);
    X=MX*8;
    Y=MY*8;
    g_map[5]=byte(MX);
    g_map[7]=byte(MY);
    
    if(g_colorprofile[PROF_REBITPLANE]==1){
      int newc=byte(g_data[NEWBPL]);
      g_planes=newc;
      //println("newplanes:"+g_planes);
      newc=2<<(newc-1);
      g_maxcolors=newc;
      //println("new colors:"+newc);
      g_map[4]=byte(newc-1);
      g_map[14]=byte(g_planes);
    }
    realdiscardmenus(0);
    make_grid(8,8);// conflicting?
    re_scale();
    update_ui(false,0);
    clear_brush();

    import_image("",1,1); // ,1 = internal using g_fillmap    
}

// for loading e.g. Amiga files
void infer_bitplanes(){
  g_planes=int(g_map[14]);
  g_maxcolors=int(g_map[4])+1;
  g_data[NEWBPL]=byte(g_planes);
}

// for loading e.g. Amiga files
void infer_size(){
  if(g_map[5]==0||g_map[7]==0)return;
  MX=int(g_map[5]);
  MY=int(g_map[7]);
  X=MX*8;
  Y=MY*8;
  realdiscardmenus(0);
 // make_grid(8,8);
  re_scale();
  update_ui(false,0);
}

void change_mode_value(int m){
  for(int i=0;i<g_machineidx.length;i++){
    if(g_machineidx[i]==m){
      for(int j=0;j<g_machinemenu.length;j++){
       if(g_machinemenu[j]==m){
         change_mode(g_machineidx[i],j);
        return;
       }
      }
    }
  }
}

int g_conv_exception;
//void mode_change
void change_mode(int m,int idx)
{  
   store_undo();
   
   if((m==ULAPLUS||m==ULAFREE||m==ULATMX)){
     if(int(g_map[13])==C64){
       hard_c64_palette(3,0);//ulaplus variant 
       //println("ULAPALT prepare");
     }else{
        // damp ulaplus palette
       damp_palette(0);
     }
   }
            
    g_banctr=20;
    reset_iconlist();
    store_palette(1);
    remake_palette();
    int oldmachine=g_machine;
    int complexity=interim_store();
    int pastcolormode=int(g_map[13]);
    int pastcolors=g_maxcolors;
    int oldborder=int(g_map[0]);
    
    // previous size is in g_interimwid,hei
    
    g_conv_exception=0;
    
    if(oldmachine==VIC&&m!=VIC){
      g_conv_exception=1;
    }
    if(oldmachine!=VIC&&m==VIC){
      g_conv_exception=2;
    }    
    g_machine=m;
    g_machineindex=idx;
    g_machinename=get_machinename(m);
    println("MODENAME:"+g_machinename);
    println("MODECHANGE:("+m+","+idx+")");
    create_aspects();
    g_ext_executed=-1;
    g_ext_executeds=-1;
    g_extfilename="";
    g_extfilenames="";
    for(int i=0;i<256;i++){
      g_usablecolor[i]=255;
    }
    for(int i=0;i<16;i++){
       g_colorprofile[i]=0;
       g_grids[i]=#282828;
       g_rgb[i]=0xffffff;
    } 
    g_gridmode=OLD;
    
    //makecolor(257,255,180,180);
    //g_rgb[257]=0xff808080;
        

   set_machine(g_machine);
  
   //inter-c64 modes
   if(pastcolormode==C64&&int(g_map[13])==C64){
     recall_palette(1);
     remake_palette();
   }   
   
    if(width<viewport_width(0)+64*g_uizoom||height<viewport_height(0)+56*g_uizoom){
      surface.setSize(viewport_width(0)+64*g_uizoom,viewport_height(0)+56*g_uizoom);
    }
    
    if(g_aspect_override==1 && g_machine==MSX)g_aspect=SQUARERATIO;

    MX=X/8;
    MY=round(Y/8);   
    
    g_map[5]=byte(MX);
    g_map[7]=byte(MY);
    
    g_data['m']=0;
    g_data['M']=0;
    
    g_maglevel=0;
    
    g_trustorex=X*g_magpix[magmode()];
    g_trustorey=Y*g_magpiy[magmode()];
        
    setup_windows(g_guileft,X,Y);//1=lefthander
    
    g_windowx=int(g_winlocx[0]);
    g_windowy=int(g_winlocy[0]); 
    
    if(g_hadjust>0)g_windowx=width-(g_hedge)-(g_wzoom*X)-g_hadjust;
    if(g_vadjust>0)g_windowy=height-(g_vedge)-(paspect*Y)-g_vadjust;
 
    g_map[4]=byte(g_maxcolors-1);
    //g_map[13]=byte(machine);
    g_data[FX]=byte(0);//paintmode
    g_ofarge=g_farge;
  
    clear_parameters();
    
    g_ofx=0;g_ofy=0;
    g_rubbermode=0;
    magmode();
    
    if(pastcolormode==int(g_map[13])&&pastcolors==g_maxcolors){
      set_border(oldborder);
    }
    
    sussborder();
    true_clear();
  
   if(g_forcedpalette.length()>3)palette_loader(g_forcedpalette);
   
   wipe_out();
   global_clear();
   
   g_spare=0;
   copy_to_spare();
   refresh_all();
   update_ui(true,0);
   int x=int(g_data[GRIDX]);
   int y=int(g_data[GRIDY]);
   //x=8;
   //y=8;
   make_grid(CX,CY);
   
   clear_brush();
   
   g_spare=1;
   setname("",1);
   clamp_undo();
   untouch();
   
   g_spare=0;
   
   setname("",0);
   clamp_undo();
   untouch();
   set_tool(3);
   g_data['f']=1;
   g_data['g']=1;
   g_btype=0;
   g_bsize=0;
   
   if(complexity>1&&g_interimwid>0){   
     if(pastcolormode==int(g_map[13])){
       //prepare_ulaplus(0);
     }
     interim_recall(pastcolormode);
     clamp_undo();   
   }   
   
   if(pastcolormode==C64&&int(g_map[13])==C64){
     recall_palette(1);
     remake_palette();
     set_border(oldborder);
   }
   force_autohistogram();  
   reboot();
}

int interim_store(){
  for(int i=0;i<256;i++){
    g_intr[i]=g_r[i];
    g_intg[i]=g_g[i];
    g_intb[i]=g_b[i];
  }
  g_interimwid=X;
  g_interimhei=Y;
  int complex=get_complexity();
  return complex;    
}

int get_complexity(){
  int prev=easygetcolor(0,0);
  int comp=0;
  //println("getc:"+X+"*"+Y);
  for(int y=0;y<Y;y++){
    for(int x=0;x<X;x++){
      int c=easygetcolor(x,y);
      if(c!=prev)comp++;
      prev=c;
      g_fillmap[x+y*X]=byte(c);
    }
  }
  return comp;
}

void interim_recall(int original){
  import_image("",1,original);
}

void wipe_out(){
   for(int y=0;y<Y;y++){
     for(int x=0;x<X;x++){
       absolute_clearpoint(x,y);
     }
  }
  for(int i=1024;i<65535;i++){
    g_map[i]=byte(0);
  }
  if(g_multic!=3&&g_multic!=4){
     for(int i=0;i<MX*MY*8;i++){
      g_map[65536+i]=byte(0);
      g_map[65536+i+MX*MY*8]=byte(0);
    }   
  }
 }
   
void set_machine(int m)
{
    g_machine=m;
    g_multic=0;
    g_expname="";
    g_tempname="";
    g_map[3]=byte(g_machine);
    g_map[13]=byte(g_machine);
    palettesteps(0);
    g_map[0]=0;
    g_farge=1;g_backg=0;g_britemode=0;
    g_charlimit=0;g_hzoomer=1;g_backmode=0;
    g_pixelw=1;
    g_formatname="";
    g_gridmode=OLD;
    g_formatextension="";
    g_maxcolors=16;X=320;Y=200;
    g_aspect=SQUARERATIO;
    g_colorprofile[PROF_BORDER]=1;//border changeable?
    g_colorprofile[PROF_BACKGND]=1;//backg changeable?
    g_colorprofile[PROF_BACKGND2]=0;//backg2 changeable? plus4
    g_colorprofile[PROF_PALTOOLS]=0;//paltools changeable? atari ST, ulap, cpc
    g_colorprofile[PROF_FXTOOLS]=0;//fxtools atari st
    g_map[240]=0;
    g_map[241]=0;//range
    CX=8;
    CXM=4;
    CY=8;
    
    if (g_machine==VIC) {    //vic "hires" 
        g_colorprofile[PROF_BACKGND]=1;
        g_charlimit=1;
        g_backmode=1;
        g_name="vch";g_expname="prg";
        X=176*2;Y=176;
        g_attrimode=1;
        g_multic=1;
        g_map[1]=byte(1);  
        g_map[0]=3;
        g_maxcolors=16;
        make_vic_palette();
        make_grid(16,16);
        CX=16;
        CXM=8;
        CY=16;
        g_backg=1;
        g_farge=0;
    }
    if (g_machine==VICM) {    //vic "multicolor" bit like plus4m but not really
        g_colorprofile[PROF_BACKGND]=1;
        g_colorprofile[PROF_BACKGND2]=1;//backg2
        g_backmode=1;
        g_charlimit=1;
        g_multic=1;
        g_name="vcm";g_expname="prg";
        X=176;Y=176;
        CX=8;
        CXM=4;
        CY=16;
        g_attrimode=1; 
        g_map[0]=byte(3);
        g_map[1]=byte(1); 
        g_map[2]=byte(14); 
        g_maxcolors=16;
        make_vic_palette();
        make_grid(8,16);
        g_backg=1;
        g_farge=0;
    }    
    
    if (g_machine==C64) {//c64 hires
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="prg";
        g_formatname="Art Studio";
        g_formatextension="art";
        g_tempname="c64show.prg";
        g_name="c64";
        g_attrimode=1;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (g_machine==C64M) {    //c64 multicolor
        g_backmode=1;
        g_charlimit=3;
        g_multic=1;
        g_name="c64m";g_expname="prg";
        g_formatname="Koala";
        g_tempname="c64mnew.prg";
        g_formatextension="kla";
        g_attrimode=1;
        g_map[1]=byte(0);  
        g_map[0]=6;
        make_c64_palette();
    }
    
    if (g_machine==GX4000) {  //Amstrad Plus/GX4000
        X=320;Y=200;
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_FXTOOLS]=1;//fxtool
        g_hzoomer=2;
        palettesteps(16);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;
        
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            }
        }
      g_map[240]=0;
      g_map[241]=15;//range
    }
    
    if (g_machine==CPC) {  //Amstrad CPC mode 0
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }
    
    if (g_machine==CPC1) {  //Amstrad CPC mode 1
        g_colorprofile[PROF_BACKGND]=0;
        palettesteps(3);
        g_name="cp1";
        g_expname="bin";
        g_tempname="cpc_mode1.bin";
        g_formatname="";
        g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_maxcolors=4;

        g_colorprofile[PROF_PALTOOLS]=1;
        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }
    
    if (g_machine==CGA) {  //PC CGA 4-color
        g_colorprofile[PROF_BACKGND]=0;
        g_name="cga";g_expname="";
        g_formatname="";g_formatextension="";
        g_multic=4;
        g_planes=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_maxcolors=4;

        makecolor(0, 0, 0, 0);
        makecolor(1, 0x55, 0xFF, 0xFF);
        makecolor(2, 0xFF, 0x55, 0xFF);
        makecolor(3, 0xFF, 0xFF, 0xFF);
    }
    
    if (g_machine==CPCOC) {  //Amstrad CPC mode 0 overscan
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0oc.bin";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        X=384;Y=272;
        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }    
    if (g_machine==MSX) {    // MSX
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=1;//misleading?
        g_map[1]=0;
        g_name="msx";
        g_expname="com";
        g_formatname="Screen 2";        
        g_tempname="msxshow.com";
        g_formatextension="sc2";
        X=256;Y=192;
        g_attrimode=0;
        g_backmode=1;
        g_aspect=FLATRATIO;
        g_farge=15;
        g_backg=0; 

        make_msx_palette();
    }
    
    if (g_machine==ULATMX) {    // Ulaplus Timex 8x1
    
        g_colorprofile[PROF_BORDER]=1;//border changeable?
        g_colorprofile[PROF_BACKGND]=1;//misleading?
        g_map[1]=0;
        g_name="tmx";
        g_expname="scr";
        g_formatname="ULA Timex";
        g_formatextension="scr";
        X=256;Y=192;
        g_attrimode=0;
        g_backmode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);

        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }
    
    if (g_machine==ULAFREE) {//ULAplus with less palette limitations
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        g_name="ULAfree";
        X=256;Y=192;
        g_attrimode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);
        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }    
    
    if (g_machine==ULAPLUS) { // ZX Spectrum ULAPLUS //grb332
        g_colorprofile[PROF_BACKGND]=0;   
        g_name="ulap";
        g_expname="tap";
        X=256;Y=192;
        g_formatname="Screen$";g_formatextension="scr";
        g_tempname="ulashow.tap";
        g_farge=9;
        g_backg=0;
        g_attrimode=1;
        g_britemode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);
        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }
 
    if (g_machine==SPECTRUM) { // ZX Spectrum
        g_colorprofile[PROF_BACKGND]=0;
        g_name="spec";
        g_expname="tap";
        X=256;Y=192;
        g_formatname="Screen$";g_formatextension="scr";
        g_tempname="specshow.tap";
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_britemode=1;
        g_map[0]=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }   
    if (g_machine==TIMEX) {    // timex sinclair
        g_colorprofile[PROF_BACKGND]=0;
        g_name="tmx";
        X=256;Y=192;
        g_farge=7;
        g_backg=0;
        g_attrimode=0;
        g_britemode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }

    if (g_machine==JR200) {  // Panasonic JR200
        g_colorprofile[PROF_BACKGND]=0;
        g_name="jr200";
        X=256;Y=192;
        g_maxcolors=8;
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();//cheating
    }

    if (g_machine==PLUS4M||g_machine==PLUS4) { // Commodore plus/4
        g_colorprofile[PROF_BACKGND]=1;
        g_colorprofile[PROF_BACKGND2]=1;//backg2
        g_backmode=1;
        g_multic=1;    
        g_name="plus4m";
        g_expname="prg";
        g_attrimode=1;
        g_maxcolors=121;
        g_charlimit=2;
        g_map[1]=0;g_map[2]=61;g_farge=61;
        g_formatname="M.Botticelli";
        g_formatextension="prg";
        g_tempname="showpfourm.prg";
        if (g_machine==PLUS4) { // plus/4 hires
            g_tempname="showpfour.prg";
            g_colorprofile[PROF_BACKGND]=0;
            g_colorprofile[PROF_BACKGND2]=0;//backg2
            g_formatname="Botticelli";
            g_formatextension="prg";
            g_multic=0;
            g_backmode=0;
            g_charlimit=0;
            g_name="plus4";
            g_attrimode=1;
            g_map[1]=byte(255);
        }
        g_map[0]=6;
        make_plus4_palette();
    }


    if (g_machine==QLLOW) { // Sinclair QL low        
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_backmode=0;
        g_maxcolors=8;
        X=256;Y=256;
        g_name="QL";
        g_tempname="internal";
        g_formatname="mode8";
        g_formatextension="scr";
        g_multic=2;
        g_attrimode=2;
        g_aspect=FLATRATIO;
        g_map[1]=byte(0);       
        make_ql_palette();
    }
    
    if (g_machine==BK0010) { // BK0010 patch
        g_colorprofile[PROF_BACKGND]=0;
        g_backmode=0;
        g_maxcolors=4;
        X=256;Y=256;
        g_name="BK";
        g_multic=2;
        g_attrimode=2;
        g_aspect=FLATRATIO;
        g_map[1]=byte(0);       
        make_bk_palette(); 
    }    

    if (g_machine==CPCOC) {  //Amstrad CPC mode 0 overscan
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0oc.bin";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        X=384;Y=272;
    }    
    
    if (g_machine==BBCHI) {    //generic 16bit 4096 color
        
        palettesteps(2);
        g_colorprofile[PROF_BACKGND]=0;
        g_planes=2;
        g_maxcolors=4;
        g_name="bbclo";g_expname="";
        g_tempname="";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        X=320;Y=256;
        
        makecolor(0,0,0,0);
        makecolor(1,255,0,0);
        makecolor(2,0,255,0);
        makecolor(3,255,255,0);
        makecolor(4,0,0,255);
        makecolor(5,255,0,255);
        makecolor(6,0,255,255);
        makecolor(7,255,255,255);
    }
    
    if (g_machine==BBCLOW) {    //generic 16bit 4096 color
        
        palettesteps(2);
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        g_maxcolors=8;
        g_name="bbclo";g_expname="";
        g_tempname="";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        X=320;Y=256;
        
        makecolor(0,0,0,0);
        makecolor(1,255,0,0);
        makecolor(2,0,255,0);
        makecolor(3,255,255,0);
        makecolor(4,0,0,255);
        makecolor(5,255,0,255);
        makecolor(6,0,255,255);
        makecolor(7,255,255,255);
    }
    
    if (g_machine==AMIGA) {    //generic 16bit 4096 color
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=1;//resizable
        g_colorprofile[PROF_REBITPLANE]=1;//1-5 bitplanes
        g_backmode=1;
        X=320;Y=256;
        g_maxcolors=32;
        g_multic=4;
        g_planes=5;
        g_data[NEWBPL]=byte(g_planes);
        palettesteps(16);
        g_name="amy";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            } else
            {
                makecolor(z, round((z-16)*g_divsr), 0, 0);
            }
        }
    }

    if (g_machine==ATARIST) {    //ATARI ST 512 color
        g_colorprofile[PROF_BORDER]=0;   //border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;  
        g_backmode=1;
        g_maxcolors=16;
        palettesteps(8);
        g_name="st";
        g_formatname="Degas";
        g_tempname="internal";
        g_formatextension="pi1";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(0);
        g_map[240]=byte(0);
        g_map[241]=byte(7);
              
        for (int z=0; z<8; z++) {
            makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsb));
            makecolor(z+8, round(z*g_divsr),0,0);
        }
    }
    
    
    if (g_machine==C64FLI) {    //c64 hires FLI = AFLI
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="prg";
        g_formatname="";g_formatextension="";
        g_name="afli";
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (g_machine==C64FLIM) {    //C64 FLI multicolor 
        g_hzoomer=2;
        g_maxcolors=16;
        g_name="fli";g_expname="";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }
    
    if (g_machine==C64NOLIMIT) {    // C64 hires without attribute limits
        g_name="c64hino";
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_BACKGND2]=0;
        g_colorprofile[PROF_RESIZE]=1;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=320;Y=200;
        g_multic=4;
        g_planes=4;
        g_attrimode=2;
        g_farge=15;
        g_backg=0; 
        make_c64_palette();
    }
    if (g_machine==C64MNOLIMIT) {    // C64 multicolor without attribute limits
        g_name="c64hino";
        g_colorprofile[PROF_BACKGND]=0;//backgnd should be enabled but maybe not now
        g_colorprofile[PROF_BACKGND2]=0;
        g_colorprofile[PROF_RESIZE]=1;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=320;Y=200;
        g_multic=3;
        g_planes=4;
        g_attrimode=2;
        g_farge=15;
        g_backg=0; 
        g_hzoomer=2;
        make_c64_palette();
    }    
    if (g_machine==PICO8) {    // Pico-8 fantasy console
        g_name="pico8";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=128;Y=128;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0, 0);
        makecolor(1, 32, 51, 123);
        makecolor(2, 126, 37, 83);
        makecolor(3, 0, 144, 61);        
        makecolor(4, 171, 82, 54);
        makecolor(5, 52, 54, 53);
        makecolor(6, 194, 195, 199);
        makecolor(7, 255, 241, 232);      
        makecolor(8, 255, 0, 77);
        makecolor(9, 255, 155, 0);
        makecolor(10, 255, 231, 39);
        makecolor(11, 0, 226, 50);       
        makecolor(12, 41, 173, 255);
        makecolor(13, 132, 112, 169);
        makecolor(14, 255, 119, 168);
        makecolor(15, 255, 214, 197);
    }
    
    if (g_machine==COCO3) {    //6-bit RGB, 16 out of 64 possible
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_backmode=1;
        g_maxcolors=16;
        palettesteps(4);
        
        g_colorprofile[PROF_PALTOOLS]=1;
        //00 00 00
        g_name="coco";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(0);
        make_coco_palette();
    }
    
    if (g_machine==UNIA) {    // Unia digital palette
        g_name="unia";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=256;Y=192;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0 , 0);
        makecolor(1, 0xff, 0xff, 0xff);
        makecolor(2, 0xff, 0xfd, 0x38);
        makecolor(3, 0xff, 0xc5, 0x00);        
        makecolor(4, 0xff, 0x00, 0x00);
        makecolor(5, 0xff, 0x3c, 0xb4);
        makecolor(6, 0xa0, 0x23, 0xbc);
        makecolor(7, 0x1b, 0xa1, 0xfc);      
        makecolor(8, 0xe1, 0xe1, 0xe1);
        makecolor(9, 0xb9, 0x63, 0x00);
        makecolor(10, 0xff, 0xaa, 0xbe);
        makecolor(11, 0xd2, 0x9b, 0xd7);       
        makecolor(12, 0xad, 0xad, 0xad);
        makecolor(13, 0x00, 0xb7, 0xb7);
        makecolor(14, 0x23, 0xaf, 0x32);
        makecolor(15, 0x29, 0xf7, 0xa7);
    }
    
    g_map[14]=byte(g_planes);
    g_map[15]=byte(g_multic);
    
    make_pixelwidth();
    make_slider_steps();
}
