//some of the more basic file operations

int g_untouched=1;
int g_untoucheds=1;
int g_filemode=0;
String g_filetowrite;
String g_filetoread;
String g_sourcefilename;
String g_candidatename;
int g_bailout=0;

int g_filetype=0;
final int FILE_PALETTE=1;

public class DisposeHandler
{
  DisposeHandler(PApplet pa)
  {
    pa.registerMethod("dispose",this);
  }
 
  public void dispose()
  {
    if(g_bailout==0){
      g_bailout=1;
      println("CORRECT EXIT");
      
      println("-AUTOSAVE 1");  
      g_map[3]=byte(g_machine);
      g_map[5]=byte(MX);
      g_map[7]=byte(MY);
      g_map[9]=byte(0);
      g_map[10]=byte('M');
      g_map[11]=byte('P');
      saveBytes("multipaint_auto_page1.bin",g_map);
     
      println("-AUTOSAVE 2");
      g_sparepage[3]=byte(g_machine);
      g_sparepage[5]=byte(MX);
      g_sparepage[7]=byte(MY);
      g_sparepage[9]=byte(0);
      g_sparepage[10]=byte('M');
      g_sparepage[11]=byte('P');
      saveBytes("multipaint_auto_page2.bin",g_sparepage);
      
    }
  }
}

//void stop()
//{

//}

void exit(){
  //apparently won't work on exported sketches
//  store("autosave.bin");
 x_com(0,"QUIT",0,0,0);
  //super.exit();
}

String last_chars(String inp,int amo){
  if(inp==null)return "null";
  int l=inp.length();
  String res="...";
  if(amo>l){amo=l;res="";}
  //String res="";
  for(int i=l-amo;i<l;i++){
    char c=inp.charAt(i);
    res=res+c;
  }
  return res;
  
}

String readfrombin(int ofs){
  String ss="";
  while(true){
    char c=char(g_map[ofs]);
    if(c>0){ss=ss+c;}
    if(c==0)return ss;
    ofs++;
  }
}

void writetobin(int ofs,String ss){
  if(ss.length()>64){
    g_map[ofs]=0;
    return;
  }
  for(int i=0;i<ss.length();i++){
    char c=ss.charAt(i);
    g_map[ofs+i]=byte(c);
  }
  g_map[ofs+ss.length()]=0;
}

//par=0
//par=1
//par=2
//par=3 = palette
//par=4 = extension

void suggest_store(String fname,int par){
  
  g_filemode=par;
  g_filetowrite=fname;
  
  println("STORING ("+g_sourcefilename+") **** "+fname);
  
  if(g_sourcefilename.equals(fname)){
    confirm_filewrite();
    return;    
  }
  
  if(fexists(fname)){
    launch_dialogue(72);
  }
  else{
    confirm_filewrite();
  }
}

void suggest_restore(String name, int par){
  println("suggest_restore:"+name);
  g_filetoread=name;
  
  int fpar=par;
  String[] act1 = match(name, "[.]act");if (act1 != null)fpar=3;
  String[] act2 = match(name, "[.]ACT");if (act2 != null)fpar=3;    
  
  g_filemode=fpar;//0=bin... 2=fmt ... 3= palt ...  4=ext
  
  if(fpar!=3){
    if(untouched()==0){
      launch_dialogue(71);
      return;    
    }
  }
  confirm_fileread();
}

void savekey(String fname){
  // pressing save instead of save as
  // now for all kinds of image files, png, format, bin ...
   println("savekey:");
   println(g_ext_executed);
   println(g_ext_executeds);
   
    if(g_spare==0){
      if(g_ext_executed>=0){
        //println("re-execute script");    
        xbasic_run(g_extrun[g_ext_executed]);
        return;
      }
    }
    if(g_spare==1){
      if(g_ext_executeds>=0){
        //println("re-execute script:s");  
        xbasic_run(g_extrun[g_ext_executeds]);
        return;
      }
    }

  g_filemode=-1;
  g_filetowrite=fname;
  g_sourcefilename=fname;

  String[] m1 = match(fname, "[.]bin");if (m1 != null)g_filemode=0;
  m1 = match(fname, "[.]BIN"); if (m1 != null)g_filemode=0;
  m1 = match(fname, "[.]jpg"); if (m1 != null)g_filemode=0;
  m1 = match(fname, "[.]png"); if (m1 != null)g_filemode=0;
  m1 = match(fname, "[.]JPG"); if (m1 != null)g_filemode=0;
  m1 = match(fname, "[.]PNG"); if (m1 != null)g_filemode=0;  
    
  //if(g_ext_choice>=0)println(g_extext[g_ext_choice]);
  
 // println(g_formatextension);
 // println(g_filemode);
  
  if(g_formatextension.length()>1){
   // m1 = match(fname, ("."+g_formatextension));
   // if (m1 != null)g_filemode=2; 
   // String ipa=g_formatextension.toUpperCase();
   // m1 = match(fname, ("."+ipa));
   // if (m1 != null)g_filemode=2;  
  }
  
  //println(g_filemode);
  if(g_filemode!=-1){
    confirm_filewrite();
  }
}

// more "low level" stuff


int count_touched(){
  return (1-g_untouched)+(1-g_untoucheds);
}

int touched(){
  if(g_spare==0)return 1-g_untouched;
  if(g_spare==1)return 1-g_untoucheds;
  return -1;
}

int untouched(){
  if(g_spare==0)return g_untouched;
  if(g_spare==1)return g_untoucheds;
  return -1;
}

void touch(){
  if(g_spare==0){
    g_untouched=0;
    surface.setTitle(filename+"*");
  }
  if(g_spare==1){
    g_untoucheds=0;
    surface.setTitle(sfilename+"*");
  }
}

void untouch(){
  if(g_spare==0){
    g_untouched=1;
    surface.setTitle(filename);
  }
  if(g_spare==1){
    g_untoucheds=1;
    surface.setTitle(sfilename);
  }
}
  
void setname(String fname,int sparem){

  if(sparem==0){
    filename=fname;
    surface.setTitle(fname);
    println("setname:"+fname);
  }  
  
  if(sparem==1){
    sfilename=fname;
    surface.setTitle(fname);
    println("setnames:"+fname);
  }
}


boolean has_extension(String fname){
  for(int i=0;i<fname.length();i++){
    char c=fname.charAt(i);
    if(c=='.')return true;
  }
  return false;
}

boolean has_correct_extension(String fname,String ext){
  if(fname.indexOf(ext)>=0){
    return true;
  }
  return false;
}

String remove_extension(String fname){
  String out="";
  for(int i=0;i<fname.length();i++){
    char c=fname.charAt(i);
    if(c=='.')return out;
    out=out+c;
  }
  return out;
}

boolean fexists(String fname)
{
 //File f = new File(sketchPath(fname));
  File f = new File(fname);
  
  println("FILE_EXISTS?:'"+path+"' = '"+fname+"'");
  
  if (f.exists()){
    println(" -> TRUE");
    return true;
  }
  
  println(" -> FALSE");
  return false;
}

void create_lastfile(String fname)
{
  PrintWriter output;
  output = createWriter("recentfiles.txt");
  output.println(fname);
  output.flush(); // Writes the remaining data to the file
  output.close(); // Finishes the file
}

void recover_lastfile()
{
  if(fexists("recentfiles.txt")==false)return;
  BufferedReader reader = createReader("recentfiles.txt");
  String line = null;
  try {
    while ((line = reader.readLine()) != null) {
      //println("recover:"+line);
    }
    reader.close();
  } catch (IOException e) {
    e.printStackTrace();
  }  
}

void add_to_lastfile(String fname)
{
  PrintWriter output;
  if(fexists("recentfiles.txt")==false){
    create_lastfile(fname);
  }  
  output = createWriter("recentfiles.txt");
  output.println(fname);
  output.flush(); 
  output.close(); 
}

void palette_loader(String fname)
{
  if(g_colorprofile[5]==0){
    message("Not on|this platform");
    return;
  }
  if(fexists(fname)==false)return;
  
  byte actpal[]=loadBytes(fname);
  if(actpal.length>772){
    message("FILE|TOO LONG");
      return;
  }
  
  for(int i=0;i<16;i++){
    makecolor(i,int(actpal[i*3]),int(actpal[i*3+1]),int(actpal[i*3+2]));
  }
  
   gui_colors();
   
   sussborder();
   refresh_all(); 
}

void icon_loader()
{
  for(int i=0;i<88000;i++){
    g_icons[i]=byte(0);
  }
    for (int y=0; y<192; y++) {
      for (int x=0; x<32; x++) {
        int blk=y/64;
        int crow=y/8;
        int yr=y-crow*8;
        int ad=1024+x*8+y*256;
        crow=crow-blk*8;
        int head=blk*2048+crow*32+yr*256+x; 
        int bbit=128;
        for(int bit=0;bit<8;bit++){
            if((g_disk[head]&bbit)==bbit)g_icons[ad+bit]=byte(1);
            bbit=bbit/2;
        }    
      }
  }
  for(int y=0;y<24;y++){
    for(int x=0;x<32;x++){
      for(int v=0;v<8;v++){
        int ab=g_disk[32*192+x+y*32];
        if(ab==56)ab=1;
        if(ab==7)ab=0;
        g_icons[65536+x+y*256+v*32]=byte(1-ab);
      }
    }
  }
}

void dump_icons(){
  for(int i=1024;i<65536;i++){
    g_map[i]=g_icons[i];
  }
  int op,ip;
  for(int y=0;y<24;y++){
    for(int x=0;x<32;x++){
      for(int v=0;v<8;v++){
        int ab=g_disk[32*192+x+y*32];
        op=0;ip=7;
        if(ab==56){op=0;ip=7;}
        if(ab==7){op=7;ip=0;}
        g_map[65536+x+y*256+v*32]=byte(op);
        g_map[65536+x+y*256+v*32+MX*MY*8]=byte(ip);
      }
    }
  }
}


void restore(String name, int spared)
{
  //load the picture page g_map[] with parameters
  boolean im_import=false;
  boolean palt_import=false;
  if(fexists(name)==false){
    message("NO FILE");
    return;
  }
  String[] act1 = match(name, "[.]act");if (act1 != null)palt_import=true;
  String[] act2 = match(name, "[.]ACT");if (act2 != null)palt_import=true;
  String[] act3 = match(name, "[.]pal");if (act3 != null)palt_import=true;
  String[] act4 = match(name, "[.]PAL");if (act4 != null)palt_import=true;   
  String[] m1 = match(name, "[.]png");if (m1 != null)im_import=true;
  String[] m2 = match(name, "[.]PNG");if (m2 != null)im_import=true;
  String[] m3 = match(name, "[.]jpg");if (m3 != null)im_import=true;
  String[] m4 = match(name, "[.]JPG");if (m4 != null)im_import=true;

  if(palt_import){
    palette_loader(name);
    message("PALETTE|IMPORTED");
    touch();
    return;
  }
  
  if(im_import){
      int lefth=g_farge;
      int righth=g_backg;
      store_parameters();
      g_data['d']=0;
      g_data['t']=0;
      g_data['r']=0;
      g_data['R']=0;
      g_data['x']=0;
      g_data['y']=0;
      g_data['X']=0;
      g_data['Y']=0;
      g_data[FX]=byte(0);
      
      import_image(name,0,-1);
      
      force_autohistogram();
      
      restore_parameters();
      refreshpalette();
      refresh();
      g_boxreconstruct=2;
      message("Image|loaded");
      selectcolor(0,lefth);
      selectcolor(1,righth);
      g_data['b']=0;//old IQ off
      setname(name,spared);
      if(g_spare==0)g_ext_executed=-1;
      if(g_spare==1)g_ext_executeds=-1;
      clamp_undo();
      
      make_grid(g_gridx,g_gridy);
      if(g_report.length()>3){
        launch_dialogue(83);//file report
      }
      
      return;
  }
  
  // load BIN file
  
  g_readbuffer=loadBytes(name);
  
  if(is_multipaint()==0){
    launch_alert("å  Warning!|-|Multipaint|can't read this|| [ OK ]");
    return;
  }
    
  if(int(g_readbuffer[3])!=g_machine){
    global_clear();
    change_mode_value(int(g_readbuffer[3]));    
  }
  
  int le=88000;
  if(g_readbuffer.length<88000)le=g_readbuffer.length;
  for(int i=0;i<le;i++){
    g_map[i]=g_readbuffer[i];
  }
  
  infer_size();
  if(g_colorprofile[7]==1){
    infer_bitplanes();
  }
  
  if(g_machine==MSX&&int(g_map[1])>=15){
    g_map[1]=0;
  }
  
  untouch();
  set_tool(1);
  
  setname(name,spared);
  if(g_spare==0)g_ext_executed=-1;
  if(g_spare==1)g_ext_executeds=-1;

  refreshpalette();  
  consistency();
    
  fix_colorsystem();//for old multipaint files    
    
  force_autohistogram();
  
  g_farge=int(g_realfront);
  g_ofarge=g_farge;
  g_backg=int(g_realback);
  sussborder();
  message("Page|loaded");
  clamp_undo();
  
  make_grid(g_gridx,g_gridy);
}

// some old bin files behave badly as they don't have
// internal palette definitions
// just in case stamp them with new info

void fix_colorsystem(){  
  g_map[10]=byte('M');
  g_map[11]=byte('P');      
  g_map[15]=byte(g_multic);
      
  if(g_machine==C64||g_machine==C64M){
    g_map[13]=byte(C64);
    if(g_r[1]==0&&g_g[1]==0&&g_b[1]==0){
      make_c64_palette();
    }
  }
  if(g_machine==PLUS4||g_machine==PLUS4M){
    g_map[13]=byte(PLUS4);
    if(g_r[1]==0&&g_g[1]==0&&g_b[1]==0){
      make_plus4_palette();
    }
  } 
  if(g_machine==SPECTRUM){
    g_map[13]=byte(SPECTRUM);
    if(g_r[1]==0&&g_g[1]==0&&g_b[1]==0){
      make_spectrum_palette();
    }
    if(g_r[7]==0xC0&&g_g[7]==0xC0&&g_b[7]==0xC0){
      make_spectrum_palette();
    }    
  } 
  if(g_machine==MSX){
    g_map[13]=byte(MSX);
    if(g_r[2]==0&&g_g[2]==0&&g_b[2]==0){
      make_msx_palette();
    }
  }     
}

void export_palette(String name){
  println("PALETTE EXPORT");
  byte temp[]=new byte[256*3+4];
  temp[256*3+1]=byte(0x10);
  temp[256*3+2]=byte(0xff);
  temp[256*3+3]=byte(0xff);
  
  for(int i=0;i<256;i++){
    temp[i*3]=g_map[256+i*3];
    temp[i*3+1]=g_map[256+i*3+1];
    temp[i*3+2]=g_map[256+i*3+2];
    
  }
  saveBytes(name,temp);
  message("PALETTE|SAVED");
  //should care for ACT and PAL forms
}

void confirm_fileread(){
  println("confirm "+g_filetoread);
  if(g_filemode==0){
    if(g_spare==0){
      restore(g_filetoread,0);//can still fail if wrong machine etc
    }    
    if(g_spare==1){
      restore(g_filetoread,1);//can still fail if wrong machine etc
    }
  }  
  
  if(g_filemode==2){
      store_parameters();
      g_data['d']=0;
      g_data['t']=0;
      g_data['r']=0;
      g_data['R']=0;
      g_data['x']=0;
      g_data['y']=0;
      g_data['X']=0;
      g_data['Y']=0;
      g_data[FX]=byte(0);
    
    // these are no longer in use
    
    if(g_spare==0){
      //format_import(g_filetoread);//can still fail if wrong machine etc
    }    
    if(g_spare==1){
      //format_import(g_filetoread);//can still fail if wrong machine etc
    }
    
    restore_parameters();
    
  }
  // palette loader
  
  if(g_filemode==3){
    palette_loader(g_filetoread);
    message("PALETTE|IMPORTED");
    touch();
    return;    
  }
  
  // extension for loading
  // prefer this over mode 2
  
  if(g_filemode==4){
    store_parameters();
    g_data['d']=0;
    g_data['t']=0;
    g_data['r']=0;
    g_data['R']=0;
    g_data['x']=0;
    g_data['y']=0;
    g_data['X']=0;
    g_data['Y']=0;
    g_data[FX]=byte(0);    
    xbasic_run(g_extrun[g_ext_choice]);  
    restore_parameters();    
    return;        
  }
  
}


void confirm_filewrite(){
  boolean success;
  
  //g_filemode is set in suggest_store
  
  if(g_filemode==0){//bin...jpg
    if(g_spare==0){
      if(g_sourcefilename.equals(g_filetowrite)){
        
      }else{
        clamp_undo();
      }
      setname(g_filetowrite,g_spare);
      message("Page Saved");      
      g_ext_executed=-1;
    }    
    if(g_spare==1){      
      if(g_sourcefilename.equals(g_filetowrite)){
        
      }else{
        clamp_undo();
      }
      setname(g_filetowrite,g_spare);
      message("Spare page|saved");
      g_ext_executeds=-1;
    }
    store(g_filetowrite);
  }
  
  // mode 2 no longer exists
  
  if(g_filemode==3){// ACT palette
    export_palette(g_filetowrite);  
  }
  
  // extension for saving or making
  
  // filemode 4=extension script
  // filemode 5=MAKE disk etc.
  
  int maker=0;
  
  // except if 5, and no bake name-
  // revert to 4?
  
  if(g_filemode==5){
    if(g_extmake[g_ext_choice].length()<3){
      println("Direct make->save");
      g_filemode=4;
      maker=1;
    }
  }  
  
  if(g_filemode==4||g_filemode==5){
    
    if(g_spare==0){
      if(g_sourcefilename.equals(g_filetowrite)){
      }else{
        clamp_undo();
      }
      if(g_filemode==4&&maker==0){// not on DIRECT MAKE->SAVE
        setname(g_filetowrite,g_spare);
      }
      message("Page|exported|");
    }    
    
    if(g_spare==1){      
      if(g_sourcefilename.equals(g_filetowrite)){
      }else{
        clamp_undo();
      }
      if(g_filemode==4&&maker==0){// not on DIRECT MAKE->SAVE
        setname(g_filetowrite,g_spare);
      }
      message("Spare page|exported"+g_formatname);
    }
    
    //println("filemode:"+g_filemode);
    xbasic_run(g_extrun[g_ext_choice]);  
    
    if(g_filemode==5){
      g_filemode=4;
      String mname=g_extmake[g_ext_choice];
      if(mname.length()>3){
        xbasic_run(mname);
      }
      else{        
        println("direct Make->Save "+g_xhead);
        save_baked();
      }
    }
    return;        
  }  
}

int save_baked(){

    byte out[]=new byte[g_xhead];
    String fname="";
    if(g_spare==0)fname=g_extfilename;
    if(g_spare==1)fname=g_extfilenames;
    for(int i=0;i<g_xhead;i++){
      out[i]=g_xmem[i];
    }
    if(fname.length()<2)return 0;
    //println("Save "+g_xhead);
    saveBytes(fname,out);
    if(g_exttype[g_ext_choice]!=0){
      if(g_exttype[g_ext_choice]!=3){
        setname(fname,g_spare);
        untouch();
      }
    }
    return 1;
}
    
int is_multipaint(){
  
  if(g_readbuffer.length<16)return 0;
  //sure (newer)
  if(g_readbuffer[9]==0){
    if(g_readbuffer[10]=='M'){
      if(g_readbuffer[11]=='P'){
        return 2;
      }
    }
  }
  
  //unsure (older)
  
  if(g_readbuffer[6]==0&&g_readbuffer[8]==0){
    if(g_readbuffer[5]>10&&g_readbuffer[7]>10){
       // if(g_readbuffer[4]>0){
          return 1;
       // }
    }
  }
  
  return 0;
}

void store(String name)
{
  String[] m1 = match(name, "[.]png");
  String[] m10 = match(name, "[.]PNG");
  if (m1 != null || m10 != null) {
    export_image(name);
    return;
  }
  String[] m2 = match(name, "[.]act");
  String[] m20 = match(name, "[.]ACT");
  if (m1 != null || m20 != null) {
    export_palette(name);
    return;
  }  
  String[] m3 = match(name, "[.]pal");
  String[] m30 = match(name, "[.]PAL");
  if (m1 != null || m30 != null) {
    export_palette(name);
    return;
  }    
  
  //save the picture page g_map[], make sure some essential parameters are correct
  g_map[3]=byte(g_machine);
  g_map[5]=byte(MX);
  g_map[7]=byte(MY);
  g_map[9]=byte(0);
  g_map[10]=byte('M');
  g_map[11]=byte('P');
  saveBytes(name,g_map);
  untouch();
  //add_to_lastfile(name);
}
