// This collects UI stuff, viewport
// i.e. Icons, color selectors and the like
// not the windowing though

//fixed ditheR parameters
int g_raster_offset_x;
int g_raster_offset_y;
int g_raster_no;
int g_leftedge,g_topedge;

int[] g_seen = new int[16];
int[] g_con = new int[32*8];

final String[] g_pmodename={"Normal","Shade","Smooth","Cycler","Smear","Darken","Mix","Tint","Blend","Bitfy"};

final int PAINT=0;
final int SHADE=1;
final int SMOOTH=2;//blur really
final int CYCLE=3;
final int SMEAR=4;
final int DARKEN=5;
final int MIX=6;
final int TINT=7;
final int BLENDER=8;
final int BITFY=9;


final int HBORDER=64;
final int TBORDER=64;
final int BBORDER=64;

int g_cstate;
void cursor_state(int ct){
  if(g_cstate!=ct){
    cursor(ct);
    g_cstate=ct;
  }
}

void gui_colors(){ 

  //R,G and B for the palette sliders
  
   makecolor(260,255,0,0);
   makecolor(261,0,255,0);
   makecolor(262,0,0,255);
  
   makecolor(256,255,0,255);//rubber_band
   makecolor(257,190,190,190);//grid
   //g_rgb[257]=0xffff8080;
   makecolor(258,0,0,0);
   makecolor(259,48,48,48);//border?
   makecolor(260,255,0,0);
   makecolor(261,0,255,0);
   makecolor(262,0,0,255);
   makecolor(263,48,48,48);//backest UI background
   makecolor(264,90,90,90);//dark gui midgrey
   makecolor(265,0xd0,0xd0,0xd0);//normal dialogues & menus, used to be c0c0c0
}
    
void grid_lightness(int brt){
  brt=brt/8;
  brt=brt*8;
  if(brt<8)brt=8;
  if(brt>248)brt=248;
  //println("intensity "+brt);
  makecolor(257,brt,brt,brt);
  g_data['g']=1;
}

void setup_raster()
{
  g_raster_offset_x=0;
  g_raster_offset_y=0;
  g_raster_no=3;
  set_fixed_raster(g_raster_no);
}

void toggle_aspect(){
  println("TOGGLE_ASPECT");
  g_aspect_override=0;
  if(g_machine==MSX){
    if(g_aspect==FLATRATIO){
      g_aspect=SQUARERATIO;
      reset_windows();
      update_ui(false,0);
      return;
    }
    if(g_aspect==SQUARERATIO){
      g_aspect=FLATRATIO;
      reset_windows();
      update_ui(false,0);
      return;
    }
    g_aspect=FLATRATIO;
    reset_windows();
    update_ui(false,0);
  }
}

int magmode()
{
  //return the mode "number" based on g_uizoom and 'm' and 'M'
  //currently valid outputs are 0,10,20,1,11,21,2,12,22
  //flat variants: 100,110,120,101,111,121,102,112,122
  int base=0;
  if(g_aspect==FLATRATIO)base=100;
  if(g_uizoom==1)base=base+10;
  if(g_uizoom==3)base=base+20;
  base=base+g_maglevel;
  return base;
}

// return pixel dimensions of the unzoomed screen

int viewport_width(int override){
  int base=0;
  int opt=g_uizoom;
  if(override>0)opt=override;
  if(g_aspect==FLATRATIO)base=100;
  if(opt==1)base=base+10;
  if(opt==3)base=base+20;
  return X*g_magpix[base];
}

int viewport_height(int override){
  int base=0;
  int opt=g_uizoom;
  if(override>0)opt=override;
  if(g_aspect==FLATRATIO)base=100;
  if(opt==1)base=base+10;
  if(opt==3)base=base+20;
  return Y*g_magpiy[base];  
}

int magpixelx()
{
  //return the amount of horizontal zoomed pixels in current mode ('m' or 'M')
  int psize,mag;
  psize=g_magpix[magmode()];
  mag=psize;
  return ((width-int(g_realw[4]))/mag);
}

int magpixely()
{
  //return the amount of vertical zoomed pixels in current mmode
  int psize=g_magpiy[magmode()];
  int mag=psize;
  return ((height-(int(g_realh[6])+int(g_realy[4])) )/mag); //how many chars in a magmode
}

int magx()
{
  //return the amount of horizontal 8x8 characters in current mmode
  int psize=g_magpix[magmode()];
  int mag=psize*8;
  return (width-(33*g_uizoom))/mag;
}

int magy()
{
  //return the amount of vertical 8x8 characters in current mmode
  int psize=g_magpiy[magmode()];
  int mag=psize*8;
  return (height-(33*g_uizoom))/mag; //how many chars in a magmode
}

void sussborder(){
  makecolor(259,g_r[g_map[0]],g_g[g_map[0]],g_b[g_map[0]]);
  g_boxreconstruct=2;
}

void set_console(){
  for(int x=0;x<32*8;x++){
    g_con[x]=0;   
  }
}

void makecolor(int c, int rr,int gg,int bb)
{
  //0-255 go to g_map[] up until 1021-1023
  //the rest is not stored
  if(c<256){
    g_map[256+c*3]=byte(rr);
    g_map[256+c*3+1]=byte(gg);
    g_map[256+c*3+2]=byte(bb);
    
    g_interpalt[c*3]=byte(rr);//kludge for interfering with the switched totality- see switcher
    g_interpalt[c*3+1]=byte(gg);
    g_interpalt[c*3+2]=byte(bb);    
  }
  g_r[c]=rr;
  g_g[c]=gg;
  g_b[c]=bb;
  g_rgb[c]=0xff000000;
  if(c==257)g_rgb[c]=0x60000000;
  g_rgb[c]=g_rgb[c]+rr*0x00010000;
  g_rgb[c]=g_rgb[c]+gg*0x00000100;
  g_rgb[c]=g_rgb[c]+bb*0x00000001;  
}

int fylli()
{
  //for the animated rubberband thingy
  g_rband++;
  if(g_rband>g_rbang){
    g_rband=0;
    g_rbang++;
    if(g_rbang>12)g_rbang=8;
  }
  if(g_rband>=3)return 0;
  return 1;
}

void h_rect(int x1,int y1,int w,int h){
  int res=viewport_width(0)/8;
  if(res>w)res=w;
  fill(80,80,80);
  rect(x1,y1,w-res,h);
  fill(255,255,255);
  rect(x1+w-res,y1,res,h);
}

void e_rect(int x1,int y1,int w,int h,int rgb)
{
  fill((rgb&0xff0000)>>16,(rgb&0x00ff00)>>8,rgb&0x0000ff);
  rect(x1,y1,w,h);
}

void t_rect(int x1,int y1,int w,int h,int rgb)
{
  // transparent rectangle for grids 
  rect(x1,y1,w,h);
}

void drawtext(int xo,int yo, String ss)
{
  //draw a bunch of text maybe not needed
  for(int i=0;i<ss.length();i++)drawchar(xo+i*8*2,yo,ss.charAt(i));
}

void drawicon(int xo,int yo, int t,int mm)
{
  //draw one icon
  int ad,cad,xx,yy,pop,far;
  int metal;
  int ink;
  color r[]={0xffd0d0d0,0xff303030,0xffffff80,0xffd0d0d0,0xff000000,0xffd0d0d0,0xff000000,0xffd0d0d0};
  
  if(g_data[GUIDARK]==0){
    r[0]=0xff000000;
    r[1]=0xffd0d0d0;    
  }

  r[3]=g_rgb[g_farge];
  r[4]=g_rgb[g_backg];
  yy=t/16;
  xx=t-yy*16;
  xx=xx*2;
  yy=yy*2;
  ad=1024+xx*8+yy*2048;
    for(int y=0;y<15;y++){            
       for(int x=0;x<15;x++){    
         ink=0;
         if(mm==1&&g_data[GUIDARK]==1)ink=1;
         if(t==52){//'d' mode indicator
           if(x<6&&y<15)ink=4;//far=int(g_rgb[g_backg]);
           if(x>9&&x<15&&y<15)ink=3;//far=int(g_rgb[g_farge]);           
         }         
         
         pop=1;
         cad=65536+(xx+x/8)+yy*256+y*32; 
         if(int(g_icons[cad])==0){
           pop=0;
         }
         if(int(g_icons[ad+x])==pop){
            ink=1;            
            if(mm==1)ink=2;
         }
         if(t==66){//dither icon
         ink=1;
         if(mm==1)ink=2;
           if(x>=1&&y>=2&&x<=13&&y<=12){
             if(mm==1)ink=2;
             if(get_raster(x+1,y)==1){
               ink=0;
               if(mm==1&&g_data[GUIDARK]==1)ink=1;
             }
          }
        }
        fill(r[ink]);
        rect(xo+x*g_uizoom,yo+y*g_uizoom,g_uizoom,g_uizoom);
      }
      ad=ad+256;
    }
}

void drawchar(int xo,int yo, int t)
{
  //characters at the help box
  //also the preset brushes
  int ad,cad,x,y,xx,yy,far;
  color r[]={0xffd0d0d0,0xff303030,0xffffff80,0xffd0d0d0,0xff000000,0xff008000,0xff0000ff,0xff000000};
  if(g_data[GUIDARK]==0){
    r[0]=0xff000000;
    r[1]=0xffd0d0d0;
  }  
  int ink;
  int ot=t-32;
  yy=ot/32;
  xx=ot-yy*32;
  yy=yy+18;
  for(y=0;y<=7;y++){   
     cad=65536+xx+yy*256+y*32;
     ad=1024+xx*8+yy*2048+y*256;   
     
     for(x=0;x<=7;x++){   
       
       ink=7;
       
       if(t>=128&&t<=136){
         ink=0;
          if(int(g_icons[ad+x])==1){
            ink=1;
             if(g_bsize<4){
               if(g_bsize+(g_btype*4)+96==ot)ink=2;
             }
          }
         }
        else
        {
          ink=7;
          if(g_spare==1)ink=5;//different background color for spare mode
          if(g_msgctr>0)ink=6;//different background color
          if(int(g_icons[ad+x])==1)ink=3;
        }
        
        fill(r[ink]);
        rect(xo+x*g_uizoom,yo+y*g_uizoom,g_uizoom,g_uizoom);
      }
  }
}

void putchar(int xo,int yo, int t)
{
  //more generic char routine
  //for windows & stuff
  int ad,xx,yy;
  //yo=yo+g_uizoom;
  t=t-32;
  yy=t/32;
  xx=t-yy*32;
  yy=yy+18;
  ad=1024+xx*8+yy*2048;  
  fill(0,0,0);
  if(g_data[GUIDARK]==1)fill(160,160,160);
  for(int y=0;y<=7;y++){            
     for(int x=0;x<=7;x++){    
        if(int(g_icons[ad+x])==1){
           rect(xo+x*g_uizoom,yo+y*g_uizoom,g_uizoom,g_uizoom);
        }
      }
      ad=ad+256;
  }
}

boolean doicon_drag(int xx,int yy,int ww,int hh)
{
  if(g_global_dragmode==1)return false;
  if(g_iconx>=xx&&g_iconx<xx+ww&&g_icony>=yy&&g_icony<yy+hh){
    g_iconx=-1;
    g_icony=-1;
    g_repanel=-2;
    return true;
  }
  if(g_piconx>=xx&&g_piconx<xx+ww&&g_picony>=yy&&g_picony<yy+hh){
    g_piconx=-1;
    g_picony=-1;
    g_repanel=-2;
    return true;
  }
  return false;
}


void printat(int xx,int yy,String tex)
{
  //creating text into the help box
  for(int tit=0;tit<tex.length();tit++){
    if(tex.charAt(tit)!='|'){
      if(g_data[256+xx+yy*12]!=byte(tex.charAt(tit))){
        g_data[256+xx+yy*12]=byte(tex.charAt(tit));
        g_chaup[xx+yy*16]=1;
      }
    }
    xx++;
    if(tex.charAt(tit)=='|'){
      xx=0;
      yy++;
    }
  }
}

void clearmsg()
{
  for (int y=0;y<=3;y++){
    for (int x=0;x<=11;x++){
       g_data[256+x+y*12]=byte(32);
       g_chaup[x+y*16]=1;
    }
  }
}

void message(String tex)
{
  if(tex.equals("*")){g_msgctr=100;return;}
  clearmsg();
  printat(0,0,tex);
  g_msgctr=50;
}
  
  //coords
void coordhelper(int a){
    
    a=a-1000;
    int b=a/X;
    a=a-(b*X);
    if(tool()==4&&g_phase==1){      
        a=abs(g_rx2-g_rx)+1;
        b=abs(g_ry2-g_ry)+1;
    }
    if(tool()==6&&g_phase==1){      
        a=abs(g_rx2-g_rx)+1;
        b=abs(g_ry2-g_ry)+1;
    }
    if(tool()==7&&g_phase==1){      
        a=abs(g_rx2-g_rx)*2+1;
        b=abs(g_ry2-g_ry)*2+1;
    }
    if(tool()==8&&g_phase==1){      
        a=abs(g_rx2-g_rx)+1;b=abs(g_ry2-g_ry)+1;
        if(g_data['c']==1||g_shift){a--;b--;}//purkkaa
    }   
    //coordinates

    int uc=easygetcolor(a,b);
    if(g_hzoomer==2||g_multic==1){
      a=a/2;
    };
    
    if(a<X&&b<Y){
      
      if((g_usablecolor[g_farge]&8)==0){
        if(g_farge!=g_map[0]&&g_farge!=g_map[1]&&g_farge!=g_map[2]){
          helper_message("Cannot use|this color|as pen");
          return;
        }
      }
      
        if(getbit(137)==0){
          printat(0,0,str(a));
          printat(4,0,str(b));
        }else{
          printat(0,0,hex(a,3));
          printat(4,0,hex(b,3));          
        }
        if(g_phase==0)printat(0,1,"C:"+uc);
        if(tool()==6&&g_phase==1){
            printat(0,2,"L:"+nf(dist(0,0,a-1,b-1),0,2));             
            float av = getangel(g_rx2-g_rx,g_ry2-g_ry);
            printat(0,3,"A:"+nf((av),0,2));  
        }
        int byt=a/8;
        int ad=1024+byt*8+b*X;
        if(g_multic==3||g_multic==4){
          ad=1024+byt*4+b*(X/2);//nonsense
        }
       // int valu=g_map[ad+0]*128+g_map[ad+1]*64+g_map[ad+2]*32+g_map[ad+3]*16+g_map[ad+4]*8+g_map[ad+5]*4+g_map[ad+6]*2+g_map[ad+7]*1;
    }
    return;
  }
  
void helper_message(String teks){

  if(g_msgctr>0)return;
  if(g_global_dragmode==1)return;
  clearmsg();
  printat(0,0,teks);
}

void help(int a)
{
  String teks;
  int b,byt,ad,valu;
  if(g_msgctr>0)return;
  if(g_global_dragmode==1)return;
  teks="No Help";
  clearmsg();
  
  if(a>=1000){
      coordhelper(a);
      return;
  }

  printat(7,3,"Key:"+char(a));
  
  switch(a){
    case '.':
      teks="Preset pens|.=reset";
    break;
    case TAB:
      int res=histogram();
      teks="Pick color|#"+str(g_farge)+"|";
    break;
    case'<':
      teks="Swap colors|Right<>Left";
    break;
    case'>':
      teks="Pick backgnd|shift=set";
      if(g_backmode==0)teks="Pick backgnd|not here";
    break;
    case'1':
      teks="Draw";
    break;
    case'2':
      teks="Spray can";
    break;
    case'3':
      teks="Continuous|Draw";
    break;
    case'4':
      teks="Grab brush";
    break;
    case'5':
      teks="Flood fill";
    break;
    case'8':
      teks="Rectangle";
    break;
    case'7':
      teks="Ellipse";
    break;
    case'6':
      teks="Line";
    break;
    case'9':
      teks="Brush tool";
    break;    
    case'0':
      teks="Magnifier|m=direct";
    break;    
    case'a':
      teks="Pan tool|";
    break;
    case'A':
      teks="Export as|"+g_expname;
    break;
    case'b':
      teks="A.I. phased out";
    break;
    case'B':
      teks="Set border|[Export=N]";
      if(getbit(136)==1)teks="Set border|[Export=Y]";
    break;
    case'C':
      teks="Set backgnd";
      if(g_machine==PLUS4M)teks="Set backgnd|V/RMB=back2";
      if(g_machine==VICM)teks="Set backgnd|V/RMB=aux";
      if(int(g_map[1])==255)teks="Set backnd|-Not here";
    break;
    case'i':
      teks="Increase|luminance";
    break;
    case'k':
      teks="Decrease|luminance";
    break;
    case'r':
      teks="Fill ditheR|on/off|RMB=swap";
    break;
    case'R':
      teks="ditheR from|brush|on/off";
    break;
    case'd':
      teks="Recolor|right->left|on/off";
    break;
    case'p':
      teks="Brush|recolor|on/off";
    break;
    case'q':
      teks="Lock ULAplus|autopalette|on/off";
    break;
    case't':
      teks="Tile mode|on/off";
    break;
    case'x':
      teks="Brush|flip X|on/off";
    break;
    case'y':
      teks="Brush|flip Y|on/off";
    break;
    case'z':
      teks="Brush|rotate";
    break;
    case'h':
      teks="Pen size "+(g_bsize+1)+"|LMB/h=less|RMB/H=bigger";
    break;
    case'j':
      if(g_spare==0){ teks="Switch to|spare page|RMB=CopyTo";}
        else
      {teks="Switch to|front page|RMB=CopyTo";}
    break;
    case'f':
      teks="Geometry|fill|on/off";
    break;
    case'c':
      teks="Constrain|to grid|on/off";
    break;
    case'm':
      teks="Magnify|on/off";
    break;
    case'g':
      teks="Draw grid|on/off|G=size "+str(g_gridx);
    break;    
    case'X':
      teks="Mirror X|on/off";
    break;
    case'Y':
      teks="Mirror Y|on/off";
    break;
    case'l':
      teks="Load data|bin/png";
    break;
    case's':
      teks="Save as|[RMB=Save]|bin/png";
    break;
    case'u':
      teks="Undo u LMB|Redo U RMB";
    break;
    case'U':
      teks="Redo";
    break;
    case'e':
      teks="Pipette|Direct key ,|or MMB";
    break;
    case'E':
      teks="Export as|source";
    break;
    case'o':
      teks="Clear|screen";
    break;
    case 'O':
      teks="Export|specific";
    break;
    case 'n':
      teks="Playbrush|on/off|RMB=speed";
    break;
    case 'w':
      teks="Format|Import:|no support";
      if(g_formatname!="")teks="Import as|"+g_formatname;
    break;
    case 'W':
      teks="Export:|no support";
      if(g_formatname!="")teks="Export as|"+g_formatname;
    break;
  }
  printat(0,0,teks);
}

void icontable_new(int owin,int xx,int yy,int tabletype)
{
  String pan="";
  int x=0,y=0;
  int ad;
  
  g_data['9']=0;
  if(g_btype==9)g_data['9']=1;
  
  // the main and sideboard icon panel order
 // if(tabletype==0)pan=";;h9::123456::78::pzxy::XYtn::lsEAwW::jc0g::uo::";
  if(tabletype==0){
    pan=";;h9::12345678::pzxy::XYtn::jc0g::uo::ae";
    xx=xx+8*g_uizoom;  
  }
  if(tabletype==1){
    pan="*rRfd";//BCrRfd
    if(g_machine==ULAPLUS||g_machine==ULATMX){
      pan="*rRfd.q";
    }
    if(g_machine==PLUS4||g_machine==PLUS4M){ // w brightness
      pan="ik*rRfd";//ik::BCrRfd
    }
  }
 
  for(int tit=0;tit<pan.length();tit++){
    ad=pan.charAt(tit);
      if(ad!=';'&&ad!=':'&&ad!='.'&&ad!='#'&&ad!='*'){
          int icolor=g_data[ad];
          if(ad=='j'&&g_spare==1)icolor=1;
          drawicon(xx+x,yy+y,ad-48,icolor);
          add_iconlist(1,"@t"+char(ad),xx+x,yy+y,xx+x+16*g_uizoom,yy+y+16*g_uizoom);
      }
      if(ad=='*'){
        colorindicator(owin,xx+x,yy+y);
        y=y+16*g_uizoom;
        x=x+8*g_uizoom;
      }
      if(ad==';'){//draw the preset brush box
          drawchar(xx,yy,128);
          drawchar(xx+8*g_uizoom,yy,129);
          drawchar(xx+15*g_uizoom,yy,130);
          drawchar(xx+23*g_uizoom,yy,131);
          drawchar(xx,yy+8*g_uizoom,132);
          drawchar(xx+8*g_uizoom,yy+8*g_uizoom,133);
          drawchar(xx+15*g_uizoom,yy+8*g_uizoom,134);
          drawchar(xx+23*g_uizoom,yy+8*g_uizoom,135);
          for(int ii=0;ii<4;ii++){
            for(int jj=0;jj<2;jj++){
              int val=ii+jj*4;
              add_iconlist(1,"@b"+str(val),xx+ii*8*g_uizoom,yy+jj*8*g_uizoom,xx+ii*8*g_uizoom+8*g_uizoom,yy+jj*8*g_uizoom+8*g_uizoom);
              //if(doicon(xx+ii*8*g_uizoom,yy+jj*8*g_uizoom,8*g_uizoom,8*g_uizoom))command(128+ii+jj*4);
            }
          }
        }      

    if(tabletype==0){
      x=x+16*g_uizoom;
      if(ad=='.')x=x-8*g_uizoom;
      if(x>16*g_uizoom){
        x=0;
        y=y+16*g_uizoom;
        if(ad==':'){
          y=y-10*g_uizoom;
          if(g_data[GUIDARK]==1){
            fill(90,90,90);
            rect(xx+x+g_uizoom*2,yy+y-4*g_uizoom,27*g_uizoom,1*g_uizoom);
          }
        }
      }
    }
    if(tabletype==1||tabletype==2){
      y=y+16*g_uizoom;
      if(ad=='.')y=y-8*g_uizoom;
      if(ad=='#'){x=x+8*g_uizoom;y=0;}
      if(y>16*g_uizoom){y=0;x=x+16*g_uizoom;}
    }
  }
  g_data['9']=0;
}


int nextluminance(int f,int d)
{
  int res=f+d;
  if(g_machine==PLUS4||g_machine==PLUS4M){
    if(f+d*15>120)return f;
    if(f+d*15<1)return f;
    if(d==1)return f+15;
    if(d==-1)return f-15;
    return res;
  }
  
  if(g_map[13]==C64){//here the "C64" is generic across C64,C64M and potential FLI modes
    int out[]={6,1,11,15,8,10,9,13,14,2,3,4,5,1,12,7}; // from "Ptoing"
    if(d==1)res=out[f];
    if(d==-1){
      if(f==0)return 0;
      for(int i=0;i<g_maxcolors;i++){
          if(out[i]==f)res=i;
      }
    }
  }
  
  if(g_map[13]==MSX){
    int out[]={ 1, 4, 9,10, 6,12,13,14, 5, 3, 7,15, 2, 8,11,15}; // calculated Y
    if(d==1)res=out[f];
    if(d==-1)
    {
      if(f==0)return 0;
        for(int i=0;i<g_maxcolors-1;i++){
            if(out[i]==f)res=i;
        }
    }
  }
  return res;
}

int tool()
{
  //returns the current tool #, for convenience
  //as there is no "tool" variable really 
  if(g_data['e']==1)return 12;
  if(g_data['a']==1)return 13;
  for(int i='0';i<='9';i++){
    if(g_data[i]==1)return i-'0';
  }
  return 0;
}

boolean twophasetool(){
  int i=int(g_map[12]);
  if(i==4||i==6||i==7||i==8)return true;
  return false;
}

void set_tool(int s)
{
  if(s!=13)cursor_state(ARROW);
  //set current tool, for convenience , change_tool
  //if(s>=0&&s<=11){
  g_rubbermode=0;
  //println(s);
  g_data['e']=0;
  g_data['a']=0;
  //}
  if(s>=1&&s<=9){
    g_prevtool=s;
  }
  for(int i='0';i<='9';i++){
    g_data[i]=0;
  }
  if(s==12)g_data['e']=1;
  if(s==13)g_data['a']=1;
  if(s<11){
    g_data[48+s]=byte(1);
  }
  g_map[12]=byte(s);
}

void selectcolor(int hand,int x)
{
  if(x>=g_maxcolors)x=x-g_maxcolors;
  if(x<0)x=x+g_maxcolors;
  if(hand==0){
    g_farge=x;g_ofarge=x; //kludgey, the colour and the "original colour"
    if(g_btype==9){
      g_data['p']=1;
      refresh_all();
      g_trueclearbit=true;
    }
    g_realfront=byte(g_farge);
    g_realback=byte(g_backg);
    return;
  }
  if(hand==1){
    g_backg=x;
    g_realback=byte(g_backg);
    g_realfront=byte(g_farge);
    return;
  } 
  g_farge=x;g_ofarge=x; //kludgey, the colour and the "original colour"
  if(g_btype==9){
    g_data['p']=1;
    refresh_all();
    g_trueclearbit=true;
  }
  g_realfront=byte(g_farge);
  g_realback=byte(g_backg);
}

void refresh()
{
  //refreshes all "dirty chars" and icon panels
    for(int i=0;i<MX*MY;i++){
      g_redo[i]=byte(0);
      g_remdo[i]=byte(1);
    }
  if(g_boxreconstruct==0)g_boxreconstruct=1;
  //elsewhere use g_boxreconstruct=2 for complete window reconstruction
}

void refresh_all()
{
  refresh();
  g_boxreconstruct=2;
}

//sliders

void palettebox(int owin,int x,int y,float wid,float hei,int in)
{
   int f=g_farge;
   if(in==0&&g_colorprofile[3]==0)return;
   float wids=wid/256;
   e_rect(x-4*g_uizoom,y,int(wid+8*g_uizoom),int(hei),g_rgb[258]);
   float expandr=((wid)/g_palstepsr);
   float expandg=((wid)/g_palstepsg);
   float expandb=((wid)/g_palstepsb);
   int ybox=int(hei/3);
   int ysize=ybox/2+g_uizoom*2;
   y=y+g_uizoom*2;
   int prepl=0,prepr=0;
   
   add_iconlist(in_window(x,y),"@XR#Red",int(x-4*g_uizoom),y,x+int(wid+4*g_uizoom),y+ysize+g_uizoom);
   add_iconlist(in_window(x,y),"@XG#Green",int(x-4*g_uizoom),y+ybox,x+int(wid+4*g_uizoom),y+ybox+ysize+g_uizoom);
   add_iconlist(in_window(x,y),"@XB#Blue",int(x-4*g_uizoom),y+ybox*2,x+int(wid+4*g_uizoom),y+ybox*2+ysize+g_uizoom);

   for(int i=0;i<g_palstepsr;i++){   
       if(i==0){
         prepl=4*g_uizoom;
         prepr=int(g_stepr[1]*wids)/2; 
       }
       if(i>0&&i<g_palstepsr-1){
         prepl=int((g_stepr[i]-g_stepr[i-1])*wids)/2;
         prepr=int((g_stepr[i+1]-g_stepr[i])*wids)/2;     
       }
       if(i==g_palstepsr-1){
         prepl=int((g_stepr[i]-g_stepr[i-1])*wids)/2;
         prepr=4*g_uizoom;
       }                
   }
   for(int i=0;i<g_palstepsg;i++){       
       if(i==0){
         prepl=4*g_uizoom;
         prepr=int(g_stepg[1]*wids)/2; 
       }
       if(i>0&&i<g_palstepsg-1){
         prepl=int((g_stepg[i]-g_stepg[i-1])*wids)/2;
         prepr=int((g_stepg[i+1]-g_stepg[i])*wids)/2;     
       }
       if(i==g_palstepsg-1){
         prepl=int((g_stepg[i]-g_stepg[i-1])*wids)/2;
         prepr=4*g_uizoom;
       }
   }
   for(int i=0;i<g_palstepsb;i++){       
     if(i==0){
         prepl=4*g_uizoom;
         prepr=int(g_stepb[1]*wids)/2; 
       }
       if(i>0&&i<g_palstepsb-1){
         prepl=int((g_stepb[i]-g_stepb[i-1])*wids)/2;
         prepr=int((g_stepb[i+1]-g_stepb[i])*wids)/2;     
       }
       if(i==g_palstepsb-1){
         prepl=int((g_stepb[i]-g_stepb[i-1])*wids)/2;
         prepr=4*g_uizoom;
       }
   }
   
   e_rect(int(x+(g_r[f])*wids)-2*g_uizoom,y, int(g_uizoom*5),ysize,g_rgb[260]);   
   e_rect(int(x+(g_g[f])*wids)-2*g_uizoom,y+ybox, int(g_uizoom*5),ysize,g_rgb[261]);
   e_rect(int(x+(g_b[f])*wids)-2*g_uizoom,y+ybox*2, int(g_uizoom*5),ysize,g_rgb[262]);  
   
   for(int i=0;i<3;i++){
     if(g_lockerid==i+1){
       e_rect(int(x),y+i*ybox+g_uizoom*2,int(256*wids),g_uizoom*3,g_rgb[257]);      
     }else{
       e_rect(int(x),y+i*ybox+g_uizoom*3,int(256*wids),g_uizoom,g_rgb[257]); 
     }
   }

   for(int i=0;i<g_palstepsr;i++){
     e_rect(int(x+g_stepr[i]*wids),y+0*ybox,int(g_uizoom),ysize,g_rgb[257]);
   }
   for(int i=0;i<g_palstepsg;i++){
     e_rect(int(x+g_stepg[i]*wids),y+1*ybox,int(g_uizoom),ysize,g_rgb[257]);
   }
   for(int i=0;i<g_palstepsb;i++){
     e_rect(int(x+g_stepb[i]*wids),y+2*ybox,int(g_uizoom),ysize,g_rgb[257]);       
   }
   if(g_lockerid==255){g_lockerid=0;}
   
}

void drawicon_s(String ss,String ttp,int x,int y,int x2,int y2){
  if(ss.equals("c"))return;//cancel
  add_iconlist(0,ss+"#"+ttp,x,y+g_uizoom,x2,y2);
}

void e_rewrite(int x,int y,String ss){
  for(int i=0;i<ss.length();i++){
    char c=ss.charAt(i);   
    putchar(x,y,c);
    x=x+8*g_uizoom;
  }  
}

void clean_writer(int x,int y,String ss){  
  int xleft=x;
  int xorig=x;
  int yleft=y;
  y=y+g_uizoom;
  String comms="";
  for(int i=0;i<ss.length();i++){
    char c=ss.charAt(i);        
    if(c=='|'){
        c=0;
        x=xorig;
        xleft=x;
        y=y+12*g_uizoom;
        yleft=y;
      }        
    if(c!=0){
      putchar(x,y,c);
      x=x+8*g_uizoom;
    }
  }
}

void e_writer(int x,int y,String ss,String ttip){
  y=y+g_uizoom;
  int xleft=x;
  int xorig=x;
  int yleft=y;
  int close=0;
  int value=0;
  boolean hilited=false;
  String alt_tip="";
  String comms="";
    for(int i=0;i<ss.length();i++){
      char c=ss.charAt(i);
      
        if(close==1&&c=='/'){close=4;c=0;}
        
        if(close==1&&c>=' '&&c<='Z')comms=comms+c;
        if(close==1&&c>='a'&&c<='z')comms=comms+c;
        
        if(close==2&&c>='0'&&c<='9'){
          value=value*10;
          value=value+(c-48);
          c=0;
        }
        
        if(close==0&&c=='*'&&((g_writemode&LITERAL)==0)){
          hilited=true;
          c=0;
        }
        
        if(close==0&&c=='-'&&((g_writemode&LITERAL)==0)){
          
          int ink=263;
          if(g_data[GUIDARK]==1)ink=264;
          fill(g_rgb[ink]);
            
          rect(g_menuleft,y+4*g_uizoom,g_menuwidth,g_uizoom);
          c=' ';
        }
        
        if(c=='{'){//swatch
          value=0;
          close=2;//value expected
          comms="";
          c=0;
          xleft=x;
        }
        
        if(c=='['){//icon
          close=1;
          comms="";
          c=0;
          xleft=x;
        }
        
        if(c=='('){//address tickbox radiobutton
          value=0;//prep address
          close=2;
          c=0;
          xleft=x;  
        }    
        
        if(c==']'){
         
          if(comms.equals("PBOX")){
            int ff=0;
            if(g_data[XYMODE]==1)ff=1;
            palettebox(-1,g_menuleft+32*g_uizoom,yleft,g_menuwidth-48*g_uizoom,38*g_uizoom,ff);
            g_writemode=-1;comms="c";
          }
          
          if(close==4)ttip=alt_tip;
          
          if(g_writemode==PULLDOWN){
              drawicon_s(comms,ttip,g_menuleft,yleft-g_uizoom,g_menuleft+g_menuwidth,yleft+10*g_uizoom);
          }else{
            drawicon_s(comms,ttip,xleft-4*g_uizoom,yleft-g_uizoom,xleft+comms.length()*(8*g_uizoom)+8*g_uizoom,yleft+10*g_uizoom);
            if(g_writemode==INTERACTIVE){
              int ink=263;
              if(g_data[GUIDARK]==1)ink=264;
              e_rect(xleft-8*g_uizoom,y-4*g_uizoom,g_uizoom*2,16*g_uizoom,g_rgb[ink]);
              e_rect(xleft+comms.length()*(8*g_uizoom)+5*g_uizoom,y-4*g_uizoom,g_uizoom*2,16*g_uizoom,g_rgb[ink]);
              
              e_rect(xleft-8*g_uizoom,y-4*g_uizoom,comms.length()*(8*g_uizoom)+13*g_uizoom,g_uizoom,g_rgb[ink]);
              e_rect(xleft-8*g_uizoom,y+11*g_uizoom,comms.length()*(8*g_uizoom)+13*g_uizoom,g_uizoom,g_rgb[ink]);
            }
          }
          
          if(hilited){
                int seen=0;
                //if(comms.equals("Settings"))seen=1;
                //if(comms.equals("Palette"))seen=2;
                if(seen>0){
                  if(g_seen[seen]<100)g_seen[seen]++;       
                  if(g_seen[seen]<90){
                    e_rect(g_menuleft,y-g_uizoom,g_menuwidth,10*g_uizoom,0xffffffff);  
                    e_rewrite(xleft,y,comms);//draw on top of highlight, again
                  }
                }
                hilited=false;
          }
          
          //yellow highlight
          if(g_understring.equals(comms)){
            if(g_writemode==PULLDOWN){
                e_rect(g_menuleft,y-g_uizoom,g_menuwidth,10*g_uizoom,0xffffff80);
            }else{
              e_rect(xleft-4*g_uizoom,y-g_uizoom,comms.length()*(8*g_uizoom)+(8*g_uizoom),10*g_uizoom,0xffffff80);
            }
            e_rewrite(xleft,y,comms);//draw on top of highlight, again
          }
          comms="";
          alt_tip="";
          c=0;
          close=0;
        }
        
        if(c=='}'){
          close=0;
          int farv1=value;
          
          if(value>=256&&value<=512){
            farv1=value-256;
            add_iconlist(0,"@f"+farv1,xleft+g_uizoom,y,xleft+g_uizoom+13*g_uizoom,y+g_uizoom+8*g_uizoom);          
          }
          
          if(value==1001)farv1=g_farge;
          if(value==1002)farv1=g_backg;
          
          if((g_farge==farv1||g_backg==farv1)&&g_writemode!=PULLDOWN){
            e_rect(xleft,y-g_uizoom,15*g_uizoom,10*g_uizoom,g_rgb[258]);
            
            if(g_farge==farv1)e_rect(xleft,y-g_uizoom*2,2*g_uizoom,2*g_uizoom,g_rgb[258]);
            if(g_backg==farv1)e_rect(xleft+13*g_uizoom,y-g_uizoom*2,2*g_uizoom,2*g_uizoom,g_rgb[258]);
          }
          e_rect(xleft+g_uizoom,y,13*g_uizoom,8*g_uizoom,g_rgb[258]);
          if(farv1>=int(g_map[240])&&farv1<=int(g_map[241])&&g_writemode!=PULLDOWN){
            e_rect(xleft,y+g_uizoom+8*g_uizoom,16*g_uizoom,1*g_uizoom,g_rgb[258]);            
          }
          e_rect(xleft+g_uizoom*2,y+g_uizoom,11*g_uizoom,6*g_uizoom,g_rgb[farv1]);
          comms="";
          c=0;
        }       
        
        if(c==')'){ //tickbox radiobutton
          int ink=258;
          int bink=265;
          if(g_data[GUIDARK]==1)
          {
            ink=264;
            bink=263;
          }
          close=0;
          e_rect(xleft+g_uizoom*2,y-4*g_uizoom,12*g_uizoom,14*g_uizoom,g_rgb[ink]);
          e_rect(xleft,y-3*g_uizoom,16*g_uizoom,12*g_uizoom,g_rgb[ink]);
          e_rect(xleft+g_uizoom*3,y-g_uizoom*3,10*g_uizoom,12*g_uizoom,g_rgb[bink]);
          e_rect(xleft+g_uizoom*2,y-g_uizoom*3,12*g_uizoom,12*g_uizoom,g_rgb[bink]);
          add_iconlist(0,"@x"+value,xleft+g_uizoom,y-3*g_uizoom,xleft+g_uizoom+13*g_uizoom,y-3*g_uizoom+16*g_uizoom);
          if(getbit(value)==1){
            e_rect(xleft+g_uizoom*5,y-g_uizoom,6*g_uizoom,8*g_uizoom,g_rgb[ink]); 
          }
          comms="";
          c=0;
        }
        
        if(c=='|'&&close!=4){
          c=0;
          x=xorig;
          xleft=x;
          y=y+12*g_uizoom;
          yleft=y;
        }
        if(c=='§'&&close!=4){
          c=0;
          x=xorig;
          xleft=x;
          y=y+6*g_uizoom;
          yleft=y;
        }        
        if(c=='å'){
          drawicon(x,y-4*g_uizoom,'p'+16-48,0);
        }
        if(c=='ö'){
          drawicon(x,y-4*g_uizoom,'4'-50,0);
        }        
        
        if(c!=0&&close==4){
          alt_tip=alt_tip+c;
        }
        if(c!=0&&close!=4){       
          putchar(x,y,c);
          x=x+8*g_uizoom;
        }

    }
}

void menubar(int owin,int x,int y,int wid,int hei){
      int menuc=265;
      if(g_data[GUIDARK]==1)menuc=263;
      g_menuleft=x;
      g_menuwidth=wid;
     // println(g_machineindex);
      String status=g_machinecalled[g_machineindex];
      if(g_colorprofile[4]==1){
        status=status+"   [FX]";
        status=status+" "+g_pmodename[int(g_data[FX])];
      }
      
      e_rect(x,y,wid-1,hei-1,g_rgb[menuc]);
      drawicon_s("MBAR","",x,y,x+wid-1,y+hei-1);
      g_writemode=DIALOGUE;
      e_writer(x,y+g_uizoom,"      [File]  [Edit]  [Tools]  [Other]   "+status,"");     
}

int g_menuleft=0;
int g_menutop=0;
int g_menuwidth=0;
int g_menuheight=0;
int g_forreal=0;
int g_menux=0;
int g_menuy=0;
int g_optioncount=0;

int g_extension=0;
int g_ext_choice=-1;
int g_ext_executed=-1;
int g_ext_executeds=-1;
String g_extfilename;
String g_extfilenames;
String g_extname[]=new String[16];
String g_extmenu[]=new String[16];
String g_exttip[]=new String[16];
String g_extrun[]=new String[16];
String g_exthook[]=new String[16];
String g_extext[]=new String[16];
String g_extsave[]=new String[16];
String g_extmake[]=new String[16];
int g_exttype[]=new int[16];

void build(String ss,String ttip){
    if(g_forreal==1){
      e_writer(g_menux+8*g_uizoom,g_menuy,ss,ttip);
    }
    g_menuy=g_menuy+12*g_uizoom;
    g_optioncount++;
}

void x_resetitems(){
  g_extension=0;
}

//0=item
//1=load
//2=save
//3=make = 
void x_additem(String inp,int type){
  if(g_extension>15)return;
  String com[]=split(inp,",");
  g_extname[g_extension]=com[0].toUpperCase();
  g_extmenu[g_extension]=com[0];
  g_exttip[g_extension]=com[1];
  g_exthook[g_extension]=com[2];
  g_extext[g_extension]=com[3];
  g_extrun[g_extension]=com[4];
  g_exttype[g_extension]=type;
  if(type==1){
    //implies save script for SAVE, ctrl+S
    g_extsave[g_extension]=com[5];
  }
  if(type==3){//MAKE
    //one-directional SAVE, no ctrl+S resave.
    //also used to bake exports to disk formats
    g_extmake[g_extension]=com[5];
   // println("g_extmake:"+g_extmake[g_extension]);
  }
  g_extension++;
}

void buildmenu(int type,int forreals){
  int x=g_menux;
  int y=g_menuy;
  String wman;
  g_optioncount=0;
  g_forreal=forreals;
  g_writemode=DIALOGUE;
  switch(type){
    case 32:
      g_writemode=PULLDOWN;
      build(" |[New] Mode","Change|platform");
      build("|[Open]        l","Open|BIN,JPG,PNG");
      build("|[Save]        S","Save with|current|filename");
      build("|[Save As]     s","Save as|BIN,JPG,PNG");
      build("|-","");
      
      for(int i=0;i<g_extension;i++){
        build("|["+g_extmenu[i]+"]",g_exttip[i]);      
      }
      if(g_formatextension.length()>1){
       // build("|[IMPORT] ."+g_formatextension+" w","Import in|platform|format");  
       // build("|[EXPORT] ."+g_formatextension+" W","Export in|platform|format");
      }
      if(g_expname.length()>1){
       // build("|[OUTPUT] ."+g_expname+" A","Export as|executable");
      }
      build("|[Export TXT]  E","Output as|text data");
      build("|-","");
      build("|*[Settings]","Adjust|this image|settings");   
      build("|[Extras]","Unfinished|and|non-standard|modes");  
      if(g_colorprofile[6]==1)build("|[Resize]","Change|image size");
      build("|-","");
      build("|[Quit]      esc","Leave|Multipaint"); 
    break;
    case 33:
      g_writemode=PULLDOWN;
    
      build(" |[Clear ]{1001}       ","Clear|whole page");  
      build(" |[Clear] {1002}      o","Clear|whole page");
      
      build("|[Undo]        u","Undo step");
      build("|[Redo]        U","Redo step");
      //build("|[Recall]       ","Recall mode");
      build("|-","");
      build("|[Spare]       j","Switch to|other page");
      build("|[To Spare]    J","Copy this|to other|page");
      build("|-","");
      build("|[Copy All]   cA","Make screen|into brush");
      build("|[Flip]","Mirror|whole page");
    break;
    case 34:
      g_writemode=PULLDOWN;
      build(" |[Reset]     spc","Reset tool|parameters");
      build("|-","");
      build("|*[Palette]","Open Palette|window");
      build("|[Swap] {1001}  /{1002}    <","Swap left|and right|colors");  
      if(g_colorprofile[0]==1)build("|[Set Border]  B","Change|border to|current|color");
      if(g_colorprofile[1]==1)build("|[Set Back1]   C","Change|background|to current|color");
      if(g_colorprofile[2]==1){
        if(g_machine==VICM){
            build("|[Set Aux]     V","Change Aux|background|to current|color");
        }
        else{
          build("|[Set Back2]   V","Change 2nd|background|to current|color");
        }
      }
      //if(g_palstepsr>0&&g_attrimode==2){
        build("|[Make] {1002}  ={1001}   ","Change|all color|on page");     
      //  build("|[XCHG] {1002}  /{1001}   ","Exchange|palette|items");
      //}
      build("|-","");      
      build("|[Set Grid]","Complete|grid|settings");
      int cheat=0;
      if(g_hzoomer==2||g_multic==1)cheat=1;
      
      if(cheat==1&&int(g_map[13])==VIC)cheat=2;
      if(cheat==0){
        build("|[Grid 8*0]","MSX style|grid");
      }
      if(cheat==0){
        build("|[Grid 8*8]","8 x 8|grid");
        build("|[Grid 16*16]","16 x 16|grid");
      }
      if(cheat==1){
        build("|[Grid 4*8]","4 x 8|grid");
        build("|[Grid 8*16]","8 x 16|grid");
      }
      if(cheat==2){
        build("|[Grid 4*16]","4 x 16|grid");
        build("|[Grid 8*16]","8 x 16|grid");
      }
      if(int(g_map[13])==C64){
        if(cheat==0){
          build("|[Grid 24*21]","C64 sprite|grid");
        }
        if(cheat==1){
          build("|[Grid 12*21]","C64 sprite|grid");
        }
        
      }
      if(g_data['g']==1){
        build("|[Hide Grid]   g","Do not|display grid");
      }else{
        build("|[Show Grid]   g","Display grid");
      }
    break;
    case 35:
      g_writemode=PULLDOWN;
      build(" |[Toolbar Side]","Switch|toolbar|handedness");
      if(g_data[GUIDARK]==0)build(" |[Dark Theme]","Change to|Dark icons");
      if(g_data[GUIDARK]==1)build(" |[Light Theme]","Change to|Light icons");
      if(g_data[GUILOCK]==1){
        build(" |[AutoScale]","Scale|when app|resized");
      }else{
        build(" |[AutoScale]   +","Scale|when app|resized");
      }
      if(g_data[GUILOCK]==0){
        build(" |[Scale 1]","Tiny GUI");
        build(" |[Scale 2]","Medium GUI");
        build(" |[Scale 3]","Large GUI");
      }

      if(g_data[GUILOCK]==1){
        if(g_uizoom==1){build(" |[Scale 1]     +","Tiny GUI");}else{build(" |[Scale 1]   ","Tiny scale|Locked");}
        if(g_uizoom==2){build(" |[Scale 2]     +","Medium GUI");}else{build(" |[Scale 2]   ","Medium scale|Locked");}
        if(g_uizoom==3){build(" |[Scale 3]     +","Large GUI");}else{build(" |[Scale 3]   ","Large scale|Locked");}
      }      
      
      
      build("|-","");
      build("|[Preview]    bs","Toggle|preview|window");
      if(g_wizard){
        build("|[ICONED]","Iconed");  
        build("|[DEBUG]","Debug");
        build("|[WMAN]","Wman");
        build("|[CONSOLE]","Console");     
        build("|[LINEAR]","Linear|export");
        build("|[TTILES]","Mctiles|export");
        build("|[TSPRITES]","Sprites|export");
        build("|[PATHS]","Show|Processing|paths");
        build("|[SCRIPT]","Script|status|helper");
        build("|[NOWIZ]","Shut|wizard|mode");
      }   
      if(int(g_map[13])==C64){
        build("|[Pepto] Palt","Use|'pepto'|colors");
        build("|[Colodore] Palt","Use|'colodore'|colors");            
      }      
      if(g_machine==MSX){
        build("|[Aspect]","Toggle aspect|ratio");
      }
      build("|-","");
      build("|[About]","Who what?");
   //   build("|[OPAQUE]","Make brush|opaque");
    break;
    case 36:
      g_writemode=PULLDOWN;
          
      build("|[Normal]","Paint with|color|LMB=col1|RMB=col2");
      build("|[Shade]","Step the|color range|LMB=-1|RMB=+1");
      build("|[Smooth]","Blur area|");
      build("|[Darken]/Light","Step darker|or lighter|LMB=-1|RMB=+1");
      build("|[Mix]","Mix colors|with color|under");
      build("|[Tint]","Recolor|with color|LMB=Tint|RMB=Desat.");
      build("|[Smear]","Smear|pixels|");
      build("|[Blend]","Blend|pixels|");
      //build("|[BITFY]","1-bit|Bayer|filter");
    break;    
        
    // dialogueboxes      
    case 69:
      g_writemode=INTERACTIVE;
      String juto=".byte";
      if(getbit(130)==1)juto=".db";
      wman="| [X/Close]  Export as Text|-| (128)   Include comments§| (129)   Force 32 wide§| (130)   "+juto+"§|";
      wman=wman+" (131)   Hex|";
      wman=wman+"-|§";
      g_data[XYMODE]=0;
      for(int i=0;i<g_extension;i++){
        if(g_exttype[i]==2)wman=wman+"  ["+g_extmenu[i]+"/"+g_exttip[i]+"]||";      
      }
      e_writer(x+8*g_uizoom,y,wman,""); 
      break;
    case 70:
    
      g_writemode=INTERACTIVE;
      if(g_colorprofile[5]==0){
        wman="| [X/Close]  Palette|-|";
      }else{
        wman="| [X/Close]  Palette            [LOAD ACT/Load .ACT|palette]|-|";
      
      }

      int amount=0;
      for(int i=0;i<g_maxcolors;i++){
        if(amount==16){amount=0;wman=wman+"|";}
        wman=wman+"{"+(256+i)+"}  ";
        amount++;
      }

       if(g_colorprofile[0]!=0||g_colorprofile[1]!=0||g_colorprofile[2]!=0){
         wman=wman+"|-| ";
       }
      if(g_colorprofile[0]==1)wman=wman+"[Set Border/Change|border]   ";
      if(g_colorprofile[1]==1)wman=wman+"[Set Back1/Change|background]   ";
      if(g_colorprofile[2]==1)wman=wman+"[Set Back2/Change|background 2]   ";  
      
      if(g_colorprofile[3]==1){
        wman=wman+"|-| [Set Range/Set range|color1 to|color2]   [Cycle/Cycles|Range]";
        wman=wman+"|| [Spread/Spread from|color1|to color2]   [Copy/Duplicate|Color]   [XCHG/Exchange|two colors|>Image is|unchanged]";
        if(g_machine!=ULAPLUS)wman=wman+"   [Roll/Roll from|c1 to c2|>Image is|unchanged]";
      }
      int cl=g_farge;
      wman=wman+"|-|{"+(256+g_farge)+"}   #"+nf(cl,3)+":"+nf(g_r[cl],3)+" "+nf(g_g[cl],3)+" "+nf(g_b[cl],3);
      if(g_colorprofile[3]==1){
        wman=wman+"|"+nf(round(g_r[cl]/g_divsr),2)+" [PBOX]|"+nf(round(g_g[cl]/g_divsg),2)+"|"+nf(round(g_b[cl]/g_divsb),2);
      }
     // wman=wman+"|-| [CLOSE]";
      if(int(g_map[13])==C64){
        wman=wman+"|-| [Pepto/Use|Pepto|Palette]   [Colodore/Use|Colodore|Palette]   ";
      }
      if(int(g_map[13])==CGA){
        wman=wman+"|-| [CGA0/CGA|Variant 0]    [CGA1/CGA|Variant 1]    [CGA2/CGA|Variant 2]    [CGA3/CGA|Variant 3]";
      }
      e_writer(x+8*g_uizoom,y,wman,""); 
      //palettebox(-1,g_menuleft+32*g_uizoom,g_menutop+g_menuheight-32*g_uizoom,g_menuwidth-48*g_uizoom,38*g_uizoom);
      break;
      
    case 71:
      g_writemode=INTERACTIVE;
      wman="|å  Warning!|-|You may have unsaved|work! Can't Undo.||  [Ignore]    [Cancel]";
      e_writer(x+8*g_uizoom,y,wman,""); 
    break;  
    case 72:
      g_writemode=INTERACTIVE;
      String hupa=last_chars(g_filetowrite,23);
      wman="|å  Warning!|-|Overwrite file?||   ||   [Overwrite]      [Cancel]";
      e_writer(x+8*g_uizoom,y,wman,"");
      wman="|||||"+hupa+" ";
      clean_writer(x+8*g_uizoom,y,wman); 
    break;
    case 73:
      g_writemode=INTERACTIVE;
      wman="|WINDOWMAN|-";
      for(int w=0;w<MAXW;w++){
        if(g_wintype[w]!=0){
         wman=wman+"|"+nf(w,2)+" = "+nf(int(g_wintype[w]),3)+" @ "+nf(int(g_winlocx[w]),5)+" , "+nf(int(g_winlocy[w]),5);
        }
      }
      e_writer(x+8*g_uizoom,y,wman,""); 
    break;
    case 74:
      // alert boxes
      g_writemode=INTERACTIVE;
      e_writer(x+8*g_uizoom,y,"|"+g_alertmessage,"");    
    break;
    case 75:
      g_writemode=INTERACTIVE;
      String alert="|Could not find|'prefs.txt'|| See docs|| [Cancel]";
      e_writer(x+8*g_uizoom,y,alert,"");
    break;
    case 76:
      g_writemode=INTERACTIVE;
      //print(getbit(6*8)+".");
      //println(getbit(7*8));
      String helper="|DEBUG g_map    [UP]  [DOWN]|-";
      for(int j=0;j<16;j++){
        int base=0+j*8+winparam_get(find_window(76))*8;
        helper=helper+"|"+hex(base,5)+":";
        for(int i=0;i<8;i++){
          helper=helper+hex(g_map[base+i],2)+" ";
        }
      }
      e_writer(x+8*g_uizoom,y,helper,"");
    break;
    case 77:
      g_writemode=PULLDOWN;
      String llist=" |Select platform: |-";
      for(int i=0;i<g_realmenu.length;i++){
        llist=llist+"|["+g_machinecalled[g_realmenu[i]]+"/"+g_machinetip[g_realmenu[i]]+"]";
      }
      e_writer(x+8*g_uizoom,y,llist,"");
    break;              
    case 78:
      g_writemode=INTERACTIVE;
      wman=" |  Exit Multipaint?|-";
      if(g_untouched==0){wman=wman+"|  * Page unsaved!";}
      if(g_untoucheds==0){wman=wman+"|  * Spare unsaved!";}
      wman=wman+"||  [Exit]      [Cancel]";
      e_writer(x+8*g_uizoom,y,wman,"");
      
    break;      
    case 79:
      g_writemode=INTERACTIVE;
      e_writer(x+8*g_uizoom,y," |ö  Multipaint 2023|-|           |    "+g_version_date+"   |   Tero Heikkinen | |       [Cancel]","");
    break;
    case 80:
      g_writemode=INTERACTIVE;
      e_writer(x+8*g_uizoom,y," | [X/Close]  Image settings|-|§ (136)   Add borders to .PNG?§ | (137)   Hex coordinates?§ | (138)   Pixelgrid in magnify?||","");
    break;
    case 81:
      g_writemode=DIALOGUE|LITERAL;
      String dhelper="";
      for(int cy=0;cy<7;cy++){
        for(int cx=0;cx<32;cx++){
          dhelper=dhelper+char(g_con[cx+cy*32]);
        }
        dhelper=dhelper+"|";
      }       
      for(int cx=0;cx<32;cx++){
        char c=char(g_con[cx+7*32]);
        if(c!=0){
          dhelper=dhelper+c;
        }
        if(c==0){
          dhelper=dhelper+'#';
          break;  
        }
      }
      e_writer(x+8*g_uizoom,y+3*g_uizoom,dhelper,"");
    break;      
    case 82:
      g_writemode=DIALOGUE|LITERAL;
      dhelper="|PROCESSING PATHS | |";
      dhelper=dhelper+"H:"+last_chars(System.getProperty("user.home"),40)+"|";
      dhelper=dhelper+"d:"+last_chars(System.getProperty("user.dir"),40)+"|";
      dhelper=dhelper+"S:"+last_chars(sketchPath(""),40)+"|";
      dhelper=dhelper+"D:"+last_chars(dataPath(""),40)+"|";
      dhelper=dhelper+"Slash:"+File.separator+"|";
      e_writer(x+8*g_uizoom,y,dhelper,"");
    break;
    case 83:
      g_writemode=INTERACTIVE;
      dhelper=g_report;
      e_writer(x+8*g_uizoom,y,dhelper,"");      
    break;
    case 84:
      g_writemode=INTERACTIVE;
      dhelper="| [X/Close]  Resize |-|Old: "+str(X)+" x "+str(Y)+"|";
      dhelper=dhelper+"New: ";
      dhelper=dhelper+str(int(g_data[NEWX])*8);
      dhelper=dhelper+" x ";
      dhelper=dhelper+str(int(g_data[NEWY])*8);
      g_data[XYMODE]=0;
      dhelper=dhelper+"|| [X-/Width-]  [X+/Width+]  [Y-/Height-]  [Y+/Height+]||";
      
      if(g_colorprofile[7]==1){
        
        dhelper=dhelper+"Bitplanes: ";
        dhelper=dhelper+str(int(g_data[NEWBPL]));
        dhelper=dhelper+"|| [BPL-/Less]  [BPL+/More]||";
      }
      dhelper=dhelper+" [Apply/Apply|Changes]";
      
      e_writer(x+8*g_uizoom,y,dhelper,"");      
    break;
    case 85:
      g_writemode=INTERACTIVE;
      int ox=int(g_data[XOFFSET]);
      int oy=int(g_data[YOFFSET]);
      
      int cheaterx=g_gridx;
      //if(int(g_map[13])==VIC)cheaterx=g_gridx/2;
      if(g_hzoomer==2||g_multic==1)cheaterx=g_gridx/2;
      
      dhelper="| [X/Close]  Set Grid|-|Size: "+str(cheaterx)+" x "+str(g_gridy)+"§";
      g_data[XYMODE]=1;
      dhelper=dhelper+"| [X-/Grid X]  [X+/Grid X]  [Y-/Grid Y]  [Y+/Grid Y]|";
      dhelper=dhelper+"|Offset: "+str(ox)+" x "+str(oy)+"§";
      g_data[XYMODE]=1;
      dhelper=dhelper+"| [OX-/Offset X]  [OX+/Offset X]  [OY-/Offset Y]  [OY+/Offset Y]|§-|";        
      dhelper=dhelper+" [Darker/Darker|Grid]   [Brighter/Lighter|Grid]  "+str(g_r[257]);
      dhelper=dhelper+"||(138)   Pixelgrid in magnify?|";
      e_writer(x+8*g_uizoom,y,dhelper,""); 
    break;
    case 86://paths
      g_writemode=LITERAL;
      wman="| Script status| |";
      wman=wman+"ext choice:"+g_ext_choice+"|";
      wman=wman+"ext executed:"+g_ext_executed+"|";
      wman=wman+"ext executeds:"+g_ext_executeds+"|";
      wman=wman+"ext filename:"+last_chars(g_extfilename,24)+"|";
      wman=wman+"ext filenames:"+last_chars(g_extfilenames,24)+"|";
      e_writer(x+8*g_uizoom,y,wman,"");      
    break;
    case 87://extras
      g_writemode=INTERACTIVE;
      wman="| [X]  Extras |-";
      wman=wman+"| [SYS 32/C64|hires|no limits]  C64 hires free|";
      wman=wman+"| [SYS 42/C64|multicolor|no limits]  C64 mc free|";
      wman=wman+"| [SYS 27/Amstrad|Gx4000 Plus|No exports]  Amstrad GX4000|";
      wman=wman+"| [SYS 69/ZX ULAplus|zx-like|attributes]  ULAplus direct|";
      wman=wman+"| [SYS 34/Tandy Coco3|No exports]  Tandy Coco3|";
      wman=wman+"| [SYS 99/BK0010|Unfinished|No exports]  BK0010";
      e_writer(x+8*g_uizoom,y,wman,"");      
    
    break;
  }
}

void menubox(int owin,int x,int y,int wid,int hei,int tp){
      //any dialogue actually
      int menuc=265;
      if(g_data[GUIDARK]==1)menuc=263;
      String helper="";
      g_menuleft=x+4*g_uizoom;
      g_menutop=y+2*g_uizoom;
      g_menuwidth=wid-8*g_uizoom;
      g_menuheight=hei-8*g_uizoom;
      e_rect(x,y,wid,hei,g_rgb[menuc]);
      drawicon_s("MBOX","",x,y,x+wid,y+hei);      
      
      if(tp>=69&&tp<=90)add_iconlist(owin,"MDRAG#",x,y,x+wid,y+32*g_uizoom);
      fill(g_rgb[258]);
      
      rect(x,y,wid+g_uizoom,g_uizoom);
      rect(x,y+hei,wid+g_uizoom,g_uizoom);
      
      rect(x-g_uizoom,y,2*g_uizoom,hei+g_uizoom);
      rect(x+wid,y,2*g_uizoom,hei+g_uizoom);      
      
      g_menux=x;
      g_menuy=y;
      buildmenu(tp,1);
}

void colorindicator(int owin,int x,int y){
  e_rect(x,y,24*g_uizoom,24*g_uizoom-1,g_rgb[g_backg]);
  add_iconlist(1,"@t<",x,y,x+23*g_uizoom,y+23*g_uizoom);
  e_rect(x+4*g_uizoom,y+4*g_uizoom,16*g_uizoom,17*g_uizoom-1,g_rgb[g_farge]);
  e_rect(x+3*g_uizoom,y+5*g_uizoom,18*g_uizoom,15*g_uizoom-1,g_rgb[g_farge]);
  
  if(g_machine==VICM){
    e_rect(x,y+24*g_uizoom,7*g_uizoom,7*g_uizoom,g_rgb[int(g_map[0])]);
    add_iconlist(1,"@f"+str(int(g_map[0])),x,y+24*g_uizoom,x+7*g_uizoom,y+24*g_uizoom+7*g_uizoom);
    
    e_rect(x+8*g_uizoom,y+24*g_uizoom,7*g_uizoom,7*g_uizoom,g_rgb[int(g_map[1])]);
    add_iconlist(1,"@f"+str(int(g_map[1])),x+8*g_uizoom,y+24*g_uizoom,x+15*g_uizoom,y+24*g_uizoom+7*g_uizoom);
    
    e_rect(x+16*g_uizoom,y+24*g_uizoom,7*g_uizoom,7*g_uizoom,g_rgb[int(g_map[2])]);
    add_iconlist(1,"@f"+str(int(g_map[2])),x+16*g_uizoom,y+24*g_uizoom,x+23*g_uizoom,y+24*g_uizoom+7*g_uizoom);
    return;
  }
  
  if(g_colorprofile[1]==1){
    e_rect(x,y+24*g_uizoom,7*g_uizoom,7*g_uizoom,g_rgb[int(g_map[1])]);
    add_iconlist(1,"@f"+str(int(g_map[1])),x,y+24*g_uizoom,x+7*g_uizoom,y+24*g_uizoom+7*g_uizoom);
  }
  if(g_colorprofile[2]==1){
    e_rect(x+8*g_uizoom,y+24*g_uizoom,7*g_uizoom,7*g_uizoom,g_rgb[int(g_map[2])]);
    add_iconlist(1,"@f"+str(int(g_map[2])),x+8*g_uizoom,y+24*g_uizoom,x+15*g_uizoom,y+24*g_uizoom+7*g_uizoom);
  }


}

void fargebox(int xloc,int yloc,int xbox,int ybox,int idx){
  int yip=4*g_uizoom;
  if(ybox<xbox/2)yip=yip/2;
  if(idx<0)idx=0;
  if(idx>g_maxcolors)idx=g_maxcolors;
    e_rect(int(xloc),int(yloc),int(xbox),int(ybox),g_rgb[idx]);
    if(g_farge==idx){      
      e_rect(xloc,yloc,6*g_uizoom,yip,g_rgb[258]);
      e_rect(xloc,yloc,4*g_uizoom,yip/2,g_rgb[265]);
    }
    if(g_backg==idx){      
      e_rect(xloc+xbox-6*g_uizoom,yloc,6*g_uizoom,yip,g_rgb[258]);
      e_rect(xloc+xbox-4*g_uizoom,yloc,4*g_uizoom,yip/2,g_rgb[265]);
    }    
    
    if(g_map[0]==idx&&g_colorprofile[0]==1){ //border      
      e_rect(int(xloc),int(yloc),int(g_uizoom),int(ybox-g_uizoom),g_rgb[265]); 
      e_rect(int(xloc+g_uizoom),int(yloc),int(g_uizoom),int(ybox-g_uizoom),g_rgb[258]);
      
      e_rect(int(xloc+xbox-g_uizoom*1),int(yloc),int(g_uizoom),int(ybox-g_uizoom),g_rgb[265]); 
      e_rect(int(xloc+xbox-g_uizoom*2),int(yloc),int(g_uizoom),int(ybox-g_uizoom),g_rgb[258]);    
      
    }   
    
    if(g_map[1]==idx&&g_colorprofile[1]==1){ //back1
      e_rect(int(xloc),int(yloc+ybox-g_uizoom),int(xbox),int(g_uizoom),g_rgb[258]);
      e_rect(int(xloc),int(yloc+ybox-g_uizoom*1),int(xbox),int(g_uizoom),g_rgb[265]);  
    }      
    
    if(g_map[2]==idx&&g_colorprofile[2]==1){ //back2
      e_rect(int(xloc),int(yloc+ybox-g_uizoom*1),int(xbox),int(g_uizoom),g_rgb[258]);
      e_rect(int(xloc),int(yloc+ybox-g_uizoom*2),int(xbox),int(g_uizoom),g_rgb[265]);  
    }
    
    
    
    if(g_maxcolors<=16){
      if(g_ahistoshow[idx]>0){      
        e_rect(int(xloc),int(yloc+ybox),int(xbox),int(g_uizoom*2),g_rgb[265]);
      }else{
        e_rect(int(xloc),int(yloc+ybox),int(xbox),int(g_uizoom*2),g_rgb[258]);
      }
    }
    if(g_maxcolors>=17){
       if(g_ahistoshow[idx]>0){      
        e_rect(int(xloc),int(yloc+ybox-g_uizoom),int(g_uizoom),int(g_uizoom),g_rgb[265]);
        e_rect(int(xloc+g_uizoom),int(yloc+ybox-g_uizoom),int(g_uizoom),int(g_uizoom),g_rgb[258]);
      }     
    }   
}

void colorselector_new(int owin,int x,int y,float wid,float hei){
  float xloc=x;
  float yloc=y;
  int rows=1;
  int cols=1;
  int pipx=g_uizoom*1;
  int pipy=g_uizoom*1;
  int offset=0;
  int yoffset=0;
  int idx=0;
  if(g_machine==VIC||g_machine==VICM){
    wid=wid-g_uizoom*2;
  }
  if(g_maxcolors==32)rows=2;
  if(g_maxcolors==64){
    rows=4;
    pipx=0;
    pipy=0;
  }
  if(g_machine==PLUS4||g_machine==PLUS4M){
    rows=8;
    pipy=0;
    idx=0;
  }
  if(int(g_map[13])==ULAPLUS){
    rows=4;
    pipx=1;
    pipy=4;
  }
  int rowcolors=g_maxcolors/rows;
  float xbox=wid/rowcolors;
  if(g_machine==PLUS4||g_machine==PLUS4M){
    rowcolors=15;
    xbox=wid/(rowcolors+1);
  }
  float ybox=hei/rows;
  int swide=int(xbox);
  int stall=int(ybox);
  if(g_maxcolors<=8){
   // ybox=xbox*0.7;
   // y=y+int(ybox/3);
   // yloc=int(y);
  }
  if(ybox>xbox*1.5){
    ybox=xbox*1.5;
    if(rows==1){
      y=y+int(ybox/3);
      yloc=int(y);
    }
  }
  if(g_machine==PLUS4||g_machine==PLUS4M){
    fargebox(int(xloc),int(yloc),int(xbox-pipx),int(ybox-pipy),0);
    add_iconlist(1,"@f"+0,int(xloc),int(yloc),int(xloc+xbox),int(yloc+ybox));
    xloc=xloc+swide;
  }  
  for(int r=0;r<rows;r++){
    for(int i=0;i<rowcolors;i++){
      offset=0;
      if(g_machine==PLUS4||g_machine==PLUS4M){
        idx=121-15-r*15+i;
      }
      if(g_machine==VIC){
        offset=g_uizoom*2;  
        yoffset=0;
        pipy=0;
        if(i>=8){
          if(g_map[1]!=i){
            yoffset=g_uizoom*2;
            pipy=g_uizoom*6;
          }
        }
      }      
      if(g_machine==VICM){
        offset=g_uizoom*2;  
        yoffset=0;
        pipy=0;
        if(i>=8){
          if(g_map[0]!=i&&g_map[1]!=i&&g_map[2]!=i){
            yoffset=g_uizoom*2;
            pipy=g_uizoom*6;
          }
        }
      }
      if(int(g_map[13])==ULAPLUS&&i>=8){
         offset=g_uizoom*2;
      }
      fargebox(int(xloc+offset),int(yloc+yoffset),int(xbox-pipx),int(ybox-pipy),idx);
      add_iconlist(1,"@f"+idx,int(xloc),int(yloc),int(xloc+xbox),int(yloc+ybox));
      xloc=xloc+swide;
      idx++;
    }
    xloc=x;
    if(g_machine==PLUS4||g_machine==PLUS4M)xloc=xloc+swide;
    yloc=yloc+stall;
  }
}

void messagebox(int owin,int ox,int oy)
{
  int cz=8*g_uizoom;
  // lcd character display chardisplay textbox
  // coordinates. has its own "dirtychar"
  for(int xx=0;xx<12;xx++){
    for(int yy=0;yy<4;yy++){
      if(g_chaup[xx+yy*16]==1){
        g_chaup[xx+yy*16]=0;
        drawchar(ox+xx*cz,oy+yy*cz,g_data[256+xx+yy*12]);
      }
    }
  }
}

void magport()
{
  int b=g_uizoom*2;
  int xo=0;
  int yo=0;
  for(int y=0;y<Y;y++){
    for(int x=0;x<X;x++){
      int raddr=(xo*24+x)+(yo*24+y)*width;
    //  pixels[raddr]=int(g_rgb[easygetcolor(x,y)]);
    }
  }
}

void viewport()
{
  // main machine screen redraw
  
  int offx=g_ofx+g_panx;
  int offy=g_ofy+g_pany;
  
  int xx,yy,xo,yo,xwin,ywin,x,y,winsux,winsuy,rubx;
  int ad,cad,a,b,c,mmode,fari,psize,psizey;
  int zonx,zony,maxx,mayy,mag,magy,raddr;
  int left=32*g_uizoom;
  
  int DX=MX;
  int DY=MY;
  
  if(g_machine==VIC){
    DX=MX/2;
    DY=MY/2;
  }
  if(g_machine==VICM){
    DY=MY/2;
  }  
  raddr=0;
  winsux=0;
  winsuy=0;
  if(g_backmode==0)g_map[1]=0;//some computers have overall background

  fari=0;
  makecolor(259,g_r[g_map[0]],g_g[g_map[0]],g_b[g_map[0]]);//use border color

  mmode=magmode();
  psize=g_magpix[mmode];
  psizey=g_magpiy[mmode];
  
  mag=psize*CX;
  magy=psizey*CY;
  maxx=magpixelx();
  mayy=magpixely();
    
  //borders, collars, rely on explicit window index which is still a bit ugly
  // 0 =viewport, 1=border, 4=toolbox 6= colorselector

  if(g_boxreconstruct==2){
    //Borders in case of full window update
    if(g_maglevel==0){
        fill(g_rgb[259]);
        if(g_guileft==0){
           // left,top
           rect(int(g_realx[1]),int(g_realy[0]),int(g_realx[0]+1),int(g_realy[6])-int(g_realy[0]));
           rect(int(g_realx[1]),int(g_realy[1]),int(g_realw[0]+g_realx[0]),int(g_realy[0])-int(g_realy[1]));
           // right,bottom
           rect(int(g_realx[0]+g_realw[0]),int(g_realy[1]),int(g_realx[4]-(g_realw[0]+g_realx[0])),int(g_realy[6])-int(g_realy[1]));          
           rect(int(g_realx[0]),int(g_realy[0]+g_realh[0]),int(g_realx[4]-g_realx[0]),int(g_realy[6])-int(g_realy[0]+g_realh[0]));
        }
        if(g_guileft==1){
           //left, top
           rect(int(g_realw[4]),int(g_realy[0]),int(g_realx[0]+1-g_realw[4]),int(g_realy[6])-int(g_realy[0]));
           rect(int(g_realw[4]),int(g_realy[1]),int(g_realx[0]+g_realw[0]-g_realw[4]),int(g_realy[0])-int(g_realy[1]));
           //right, bottom           
           rect(int(g_realx[0]+g_realw[0]),int(g_realy[1]),width-int(g_realx[4]+(g_realw[0]+g_realx[0])),int(g_realy[6])-int(g_realy[1]));
           rect(int(g_realw[4]),int(g_realy[0]+g_realh[0]),int(g_realx[0]+g_realw[0]-g_realw[4]),int(g_realy[6])-int(g_realy[0]+g_realh[0]));      
        }
    }
     else{
      // e_rect(int(g_realx[1]),int(g_realy[1]),int(g_realw[1]+1),int(g_realh[1]),g_rgb[263]);
     }   
  }
  
  // collars rely on border at 1
  
  fill(g_rgb[263]);
  if(g_global_dragmode==1||g_boxreconstruct==2){ // avoid preview window embarassment
      if(g_maglevel==0){
        if(g_guileft==0){
          rect(int(g_realx[4]),g_realy[1],width-int(g_realx[4]),height-int(g_realy[1]));          
          rect(0,g_realy[6],(int(g_realx[1]+g_realw[1])),height-int(g_realy[6]));
        }
        if(g_guileft==1){
          rect(0,g_realy[1],int(g_realw[4]),height-int(g_realy[1]));
          rect(g_realw[4],g_realy[6],width-g_realw[4],height-int(g_realy[6]));   
        }
      }else{
         if(g_guileft==0){
          rect(int(maxx*psize),g_realy[1],width-(int(maxx*psize)),height-int(g_realy[1]));
          rect(0,int(mayy*psize+12*g_uizoom),(int(maxx*psize)),height-int(mayy*psize+12*g_uizoom));
        }
        if(g_guileft==1){
          rect(0,g_realy[1],int(g_realw[4]),height-int(g_realy[1]));
          rect(int(g_realw[4]),int(mayy*psize+12*g_uizoom),(int(maxx*psize)),height-int(mayy*psize+12*g_uizoom));
        }       
      }
  }   
  
  if(g_boxreconstruct==2)g_boxreconstruct=0;
  maxx--;
  mayy--;
  zonx=X-magpixelx();//extents
  zony=Y-magpixely();
  
  if(offx>zonx+HBORDER)offx=zonx+HBORDER;
  if(offy>zony+BBORDER)offy=zony+BBORDER;
  if(offx<-HBORDER)offx=-HBORDER;
  if(offy<-TBORDER)offy=-TBORDER;

  //non full viewport
  
  g_leftedge=0;
  if(g_guileft==1)g_leftedge=int(g_realw[4]);
  winsux=g_leftedge;
  winsuy=12*g_uizoom;
  
  //full viewports  
  if(mmode==0||mmode==10||mmode==20||mmode==100||mmode==110||mmode==120){
    g_ofx=0;
    g_ofy=0;
    maxx=DX-1;
    mayy=DY-1;
    winsux=g_windowx;
    winsuy=g_windowy;
  }
  
  b=0;
  c=0;
  a=5;
  
  int gridminy=height;
  int gridmaxy=0;
  int gridminx=width;
  int gridmaxx=0;  
  int ycomp=0,xcomp=0;  
  
  // magnified viewport
  
  if(g_maglevel>0){
    
    for(int yabs=0;yabs<=mayy;yabs++){
        y=yabs+offy;
        for(int xabs=0;xabs<=maxx;xabs++){
          x=xabs+offx;
          xo=0;
          yo=0;
          xx=x/CX;yy=y;
          switch(g_multic){
            case 0://specu etc
              cad=65536+xx+y*MX;
              a=int(g_map[cad]);
              b=int(g_map[(MX*MY)*8+cad]);
              c=int(g_map[(MX*MY)*8+cad]);
            break;
            case 1://c64 plus4
              cad=65536+xx+(y/CY)*MX;
              if(g_machine==VIC||g_machine==VICM){
                cad=65536+x/CX+(y/CY)*(DX);
              }
              a=int(g_map[cad]);
              b=int(g_map[cad+1000]);
              c=int(g_map[cad+2000]);
              if(g_machine==PLUS4M){c=int(g_map[2]);}
              if(g_machine==VICM){c=int(g_map[2]);b=int(g_map[0]);}
            break;
            case 2://cpc etc no need
            break;
            case 3://bitplane mode, no need
            break;      
            case 4://bitplane mode, no need
            break;              
          }         
          
          ad=1024+x+y*X;
          xcomp=xo*(8*psize)+xabs*(psize)+g_leftedge;
          ycomp=yo*(8*psizey)+yabs*(psizey)+12*g_uizoom;    
          
          if(x<0||y<0||x>=X||y>=Y){
            fari=g_map[0];//@border
          }else{
            
            if(ycomp<gridminy)gridminy=ycomp;
            if(ycomp+psizey>gridmaxy)gridmaxy=ycomp+psizey-1;
            if(xcomp<gridminx)gridminx=xcomp;
            if(xcomp+psize>gridmaxx&&xcomp+psize<width)gridmaxx=xcomp+psize;
                   
            if(g_multic==0){
              if(int(g_map[ad])==1){
                fari=a;
                if(fari==0)fari=g_map[1];
              }
              else{
                fari=b;
                if(fari==0)fari=g_map[1];
              }
            }
            
            if(g_multic==1){        
              int xp=x/2;
              xp=xp*2;
              int vop=1024+xp+y*X;
              int po=int(g_map[vop])+int(g_map[vop+1]*2);
              if(po==0)fari=g_map[1];//00 comes from $d021 in real c64 and background 1 in plus/4
              if(po==1)fari=a; //10
              if(po==2)fari=b; //01 // in VICM, the border global 
              if(po==3)fari=c; //g_map[2]  11  comes from $d800 in real c64 and background 2 in plus/4             
            }            
            if(g_multic==2){// "amiga" mode
              fari=int(g_map[ad]);
            }
            if(g_multic==3){// bitplane mode wide pix            
              fari=bpl_getxy(x/2,y,0);
            }              
            if(g_multic==4){// bitplane mode pix            
              fari=bpl_getxy(x,y,0);
            }                
            
            // rubberband mode
            
            if(g_rubbermode==1){
              rubx=x;
              
              if(g_multic==1 || g_hzoomer==2){
                rubx=rubx&0xfffe;
                g_rx=g_rx/2;
                g_rx=g_rx*2;
                g_rx2=g_rx2/2;
                g_rx2=g_rx2*2;                
              }
              if(fylli()==1){//in magnify
                if(rubx==g_rx || rubx==g_rx2)
                {
                  if(y>=g_ry&&y<=g_ry2)fari=256;
                }
                if(y==g_ry || y==g_ry2){
                  if(rubx>=g_rx&&rubx<=g_rx2)fari=256;
                }
              }
            }               
            
          }             
          
          if(fari<0)fari=0;
          fill(g_rgb[fari]);
          rect(xcomp,ycomp,psize,psizey);
      }
    }    
   
   // grid in magnify
    
   if(int(g_data['g'])==1){   
      
      fill(g_rgb[257]);
      int thicc=1;
      if(g_maglevel>=3)thicc=g_uizoom;
        for(int xabs=0;xabs<=maxx;xabs++){
          x=xabs+offx;
          int yabs=0;     
          if(x<X&&x>=0){
            if(g_gridmarkerx[x]==1)rect(xabs*(psize)+g_leftedge,gridminy,thicc,gridmaxy-gridminy);
            if(g_gridmarkerx[x]==2)rect((xabs+1)*(psize)+g_leftedge,gridminy,thicc,gridmaxy-gridminy);            
            if(g_gridmarkerx[x]==4&&thicc>1)rect(xabs*(psize)+g_leftedge,gridminy,1,gridmaxy-gridminy);            
          }
        }
             
     if(gridmaxx-gridminx>0){
      for(int yabs=0;yabs<=mayy;yabs++){
        y=yabs+offy;
        int xabs=0;     
        if(y>=0&&y<Y){
          if(g_gridmarkery[y]==1)rect(gridminx,yabs*(psizey)+12*g_uizoom,gridmaxx-gridminx,thicc);
          if(g_gridmarkery[y]==2)rect(gridminx,(yabs+1)*(psizey)+12*g_uizoom,gridmaxx-gridminx,thicc);
          if(g_gridmarkery[y]==4&&thicc>1)rect(gridminx,yabs*(psizey)+12*g_uizoom,gridmaxx-gridminx,1);            
        }
      }  
     }
    }
        
    return;
  }
  
  // end of magnified viewport
  
  
  
  // full pixel display

  
  for(ywin=0;ywin<=mayy;ywin++){
    for(xwin=0;xwin<=maxx;xwin++){
  
      // source coords: is 0,0
      
      xx=xwin;
      yy=ywin;
      
      // divided into character area blocks
      // which are only updated if necessary
      
      xo=xwin;
      yo=ywin;
      if(int(g_redo[xx+yy*DX])==0){
    
        for(y=0;y<CY;y++){//pixel rows inside "char", normally 8

          switch(g_multic){
            case 0:
              cad=65536+xx+((yy*X)+y*DX);
              a=int(g_map[cad]);
              b=int(g_map[(DX*DY)*8+cad]);
              c=int(g_map[(DX*DY)*8+cad]);
            break;
            case 1:
              cad=65536+xx+(yy*DX);
              if(g_machine==VIC||g_machine==VICM){
                cad=65536+xx+yy*DX;
              }
              
              
              a=int(g_map[cad]);
              b=int(g_map[cad+1000]);
              c=int(g_map[cad+2000]);
              if(g_machine==PLUS4M){c=int(g_map[2]);}
              if(g_machine==VICM){c=int(g_map[2]);b=int(g_map[0]);}
            break;
            case 2:
            break;
            case 3:
            break;
            case 4:
            break;
          }
    
          ad=1024+xx*CX+yy*(X*CY)+y*X;
              
          ycomp=yo*(CY*psizey)+y*(psizey)+g_windowy;   
          
          int po,vop;
          
          for(x=0;x<CX;x++){//pixel columns inside pixel row
            xcomp=xo*(CX*psize)+x*(psize)+g_windowx;
            vop=x/2;
            
            if(g_multic==0){
              if(int(g_map[ad+x])==1){
                fari=a;
                if(fari==0 && g_machine==MSX)fari=g_map[1];
              }
              else{
                fari=b;
                if(fari==0 && g_machine==MSX)fari=g_map[1];
              }
            }
            
            if(g_multic==1)
            {
              po=int(g_map[ad+vop*2])+int(g_map[ad+vop*2+1]*2);
              if(po==0)fari=g_map[1];//00 comes from $d021 in real c64 and background 1 in plus/4
              if(po==1)fari=a;//10
              if(po==2)fari=b;//01
              if(po==3)fari=c; //g_map[2];//11 // comes from $d800 in real c64 and background 2 in plus/4             
            }            
            if(g_multic==2){// chunky byte mode (now redundant?)
              fari=int(g_map[ad+x]);
            }            
            if(g_multic==3){// bitplane mode wide pix
              fari=bpl_getxy((xx*8+x)/2,yy*8+y,0);
            }
            if(g_multic==4){// bitplane mode norm pix 
              fari=bpl_getxy((xx*8+x),yy*8+y,0);
            }            
            
            if(g_rubbermode==1){// rubberband mode in fullscreen
              rubx=x;
              if(g_multic==1||g_hzoomer==2){
                  rubx=x/2;
                  rubx=rubx*2;
                  g_rx=g_rx/2;
                  g_rx=g_rx*2;
                  g_rx2=g_rx2/2;
                  g_rx2=g_rx2*2;
              }
              if(fylli()==1){
                if(xx*CX+rubx==g_rx||xx*CX+rubx==g_rx2)
                {
                  if(yy*CY+y>=g_ry&&yy*CY+y<=g_ry2)fari=256;                    
                }
                if(yy*CY+y==g_ry||yy*CY+y==g_ry2){
                  if(xx*CX+x>=g_rx&&xx*CX+x<=g_rx2)fari=256;
                }
              }
            }
           if(fari<0)fari=0;           
           
           if(yy*CY+y<Y){
             fill(g_rgb[fari]);             
             rect(xcomp,ycomp,psize,psizey);
           }
            

        }//one pixel inside pixel row
    }//one pixel row inside char
    
    //draw grid full viewport
            
    if(int(g_data['g'])==1){      
      fill(g_rgb[257]);
      for(int i=0;i<CX;i++){
        if(g_gridmarkerx[xx*CX+i]==1)rect((xo*psize*CX)+(i*psize)+winsux,yo*magy+winsuy,1,magy);
        if(g_gridmarkerx[xx*CX+i]==2)rect((xo*psize*CX)+(i*psize+psize-1)+winsux,yo*magy+winsuy,1,magy);
      }
      for(int i=0;i<CY;i++){
        if(g_gridmarkery[yy*CY+i]==1)rect(xo*psize*CX+winsux,(yy*CY+i)*psizey+winsuy,psize*CX,1);
        if(g_gridmarkery[yy*CY+i]==2)rect(xo*psize*CX+winsux,(yy*CY+i)*psizey+winsuy+psizey-1,psize*CX,1);
      }      
      
    }//grid
        
    g_redo[xx+yy*DX]=byte(1); 
                  
  } //dirty char?

  }//x char
 }//y char
 
 
}


void gui_stuff(){    
   
    String prepfilename;
    //if(g_spare==0)g_extfilename="";
    //if(g_spare==1)g_extfilenames="";
    
    if(ext_select) // Fileselect "event" for extensions
    {
      int quibble=EXTENDR;
        if(g_exttype[g_ext_choice]==1){
          quibble=LOADFMT;
        }
        if(g_exttype[g_ext_choice]==2){
          quibble=SAVEFMT;
        }
        if(g_exttype[g_ext_choice]==3){
          quibble=SAVEEMU;
        }
        
        //println("FSEL:"+path);
        //println("FSELq:"+quibble);
        String s=fileselector(path,quibble);
        g_candidatename=s;
        
        if(s!=null)
        {
           store_undo();
           
           if(g_exttype[g_ext_choice]==0){
              xbasic_run(g_extrun[g_ext_choice]);
           }           
           
           if(g_exttype[g_ext_choice]==1){
             
             //loader
             if(g_spare==0){
               // g_extfilename=s;
                suggest_restore(s,4);
              }
              if(g_spare==1){
               // g_extfilenames=s;
                suggest_restore(s,4);
              }               
           }
           if(g_exttype[g_ext_choice]==2){
             //saver
             if(g_spare==0){               
                if(has_extension(s)==false){
                  s=s+"."+g_extext[g_ext_choice];
                }
                if(has_extension(s)==true){
                  if(has_correct_extension(s,g_extext[g_ext_choice])==false){
                    s=remove_extension(s);
                    s=s+"."+g_extext[g_ext_choice];                    
                  }
                }
                g_sourcefilename=filename;
                g_ext_executed=g_ext_choice;
                g_extfilename=s;
                suggest_store(s,4);
              }
              if(g_spare==1){
                if(has_extension(s)==false){
                  s=s+"."+g_extext[g_ext_choice];
                }
                if(has_extension(s)==true){
                  if(has_correct_extension(s,g_extext[g_ext_choice])==false){
                    s=remove_extension(s);
                    s=s+"."+g_extext[g_ext_choice];                    
                  }
                }
                g_sourcefilename=sfilename;
                g_ext_executeds=g_ext_choice;
                g_extfilenames=s;
                suggest_store(s,4);
              }             
           }
           if(g_exttype[g_ext_choice]==3){
             
             //make, maker
             //=save and launch another script
             
             //should not become the filename
             
             if(g_spare==0){
                g_sourcefilename=filename;
                g_ext_executed=g_ext_choice;
                g_ext_executed=-1;//g_ext_choice;
                g_extfilename=s;
                suggest_store(s,5);
              }
              
              if(g_spare==1){
                g_sourcefilename=sfilename;
                g_ext_executeds=g_ext_choice;
                g_ext_executeds=-1;//g_ext_choice;
                g_extfilenames=s;
                suggest_store(s,5);
              }
              
           }              
           refresh();
        }
        ext_select=false;
        g_shift=false;
        g_control=false;
    }   
    
    if(fileselect) // Fileselect "event" for Load
    {
      int quibble=LOADIMG;
      if(g_filetype==FILE_PALETTE)quibble=LOADACT;
        String s=fileselector(path,quibble);
        
        if(s!=null)
        {
           store_undo();
           if(g_spare==0){
              suggest_restore(s,0);
            }
            if(g_spare==1){
              suggest_restore(s,0);
            }
            refresh();
        }
        fileselect=false;
        g_shift=false;
        g_control=false;
    }
    
    if(saveas) // Fileselect "event" for Save as
    {
        String s=fileselector(path,SAVEIMG);
        String orig="";
        int kuva=0;
        if(g_spare==0)orig=filename;
        if(g_spare==1)orig=sfilename;
        if(s!=null)
        {
            // Add extension if needed
            if(s.length()<=2)s+=".bin";
            s=s+".dummy.dummy";
            String[]l=split(s,'.');
            String []m1=match(l[1],"png");
            String []m2=match(l[1],"PNG");
            String []m3=match(l[1],"bin");
            String []m4=match(l[1],"BIN");
            String []m5=match(l[1],"act");
            String []m6=match(l[1],"ACT");
            if(m1!=null||m2!=null)kuva=1;
            if(m1==null&&m2==null&&m3==null&&m4==null&&m5==null&&m6==null)l[1]="bin";
            
            if(m5!=null||m6!=null){
              g_sourcefilename=filename;
              prepfilename=l[0]+"."+l[1];
              suggest_store(prepfilename,3);//filemode 3=palette
              saveas=false;
              g_shift=false;
              g_control=false;
              return;
            }
            if(g_spare==0){
              g_sourcefilename=filename;
              prepfilename=l[0]+"."+l[1];
              suggest_store(prepfilename,0);
            }
            
            if(g_spare==1){
              g_sourcefilename=sfilename;
              prepfilename=l[0]+"."+l[1];
              suggest_store(prepfilename,0);
            }
        }
        saveas=false;
        g_shift=false;
        g_control=false;
    }
    
    if(exporttxt)
    {      
       String s=fileselector(path,SAVETXT);
        if(s!=null)
        {
            // Add extension if needed
            if(s.length()<=2)s+=".txt";
            s=s+".dummy.dummy";
            String[]l=split(s,'.');
            if(l[1].equals("dummy")){
              l[1]="txt";
            }
            if(g_spare==0){
              exportemuname=l[0]+"."+l[1];
              writetobin(32,exportemuname);
              x_open(exportemuname);
              xbasic_run(g_extrun[g_ext_choice]);
              x_close();              
            }
            if(g_spare==1){
              exportemuname=l[0]+"."+l[1];
              writetobin(32,exportemuname);
              x_open(exportemuname);
              xbasic_run(g_extrun[g_ext_choice]);
              x_close();
            }
        }
        exporttxt=false;
        g_shift=false;
        g_control=false;
    }
    
}
