
// essentials for 'hires' type 0/1 modes with 2-attribute limitations
// zx, msx, c64hires, plus4hires, timex

int getblockminy(int yy){
  if(g_attrimode==1)return 0;
  return yy&7;
}

int getblockmaxy(int yy){
  if(g_attrimode==1)return 7;
  return yy&7;
}

int getblockmaxpixels(){
  if(g_attrimode==1)return 64;
  return 8;
}

// assuming the helper (kaveri) have done their job

void hirespoint(int xx,int yy,int c){
  
  int ad = 1024+xx+yy*X;
  int cad;
  int xblock = xx/8;
  int yblock = yy/8;  
  
  if(g_britemode==1&&c==8)c=0;
  
  yblock=yblock*8;

  int ink = getattra(xx,yy,0);
  int paper = getattra(xx,yy,1);
  int yfrom = getblockminy(yy);
  int yto = getblockmaxy(yy); 
  
  // is color equal?
  
  if(comparecolors(easygetcolor(xx,yy),c))return;
  
  // is color already present?
  // in either "ink" or "paper"
  
  if(comparecolors(paper,c)){
    g_map[ad] = byte(0);
    return;
  } 
  
  if(comparecolors(ink,c)){
    g_map[ad] = byte(1);
    return;
  }
  
  // it's not present at all
  
  // adjust color accordingly
  
  // if it's paper underneath, do 1
  
  if(comparecolors(easygetcolor(xx,yy),paper)){
    //g_map[ad] = byte(1);
    for(int i=yfrom;i<=yto;i++){
      int bad=65536+(xblock)+(yblock+i)*MX;
      cad=bad+(MX*Y);
      g_map[cad]=byte(c);
    }
    return;
  }
  
  // if it's ink underneath, do 0
  
  if(comparecolors(easygetcolor(xx,yy),ink)){
   // g_map[ad] = byte(0);
    for(int i=yfrom;i<=yto;i++){
      int bad=65536+(xblock)+(yblock+i)*MX;
      cad=bad+(MX*Y);
      g_map[bad]=byte(c);
    }
    return;
  }  
}


void kaveri(int x,int y,int foreg,int backg)
{
  if(g_multic == 2)return;
  
  int ad,bad,cad;
  
  if(g_multic!=0 || g_hzoomer==2)return;
  
  if(g_data['d']==1)return;
  
  int mx = x / 8;
  int my = y / 8;
 
  int k_max = getblockmaxpixels();
  int miny = getblockminy(y);
  int maxy = getblockmaxy(y);
  
  if(g_britemode==1 && foreg==8)foreg=0;

    if(g_control==true){
        for(int yy=miny;yy<=maxy;yy++){
          ad=1024+(mx*8)+(my*8+yy)*X;
          cad=65536+mx+((my*8+yy)*MX);
          g_map[cad]=byte(foreg);
          g_map[cad+MX*(MY*8)]=byte(foreg);
          for(int xx=0;xx<=7;xx++){
            g_map[ad+xx]=0;
          }
        }
      return;    
    }
  
  
  //check the amount of colors in the area
        
    if(g_britemode==1 && foreg!=0){
      fixbrightness(x,y,getbrightness(foreg));
    }
    
    int prev = easygetcolor(x,y);
    int res = 0;
    
    for(int yy=miny;yy<=maxy;yy++){
      for(int xx=0;xx<=7;xx++){
        if(comparecolors(easygetcolor(mx*8+xx,my*8+yy),prev)==true)res++;
      }
    }
    
    if(res>=k_max){   
      for(int yy=miny;yy<=maxy;yy++){
        ad=1024+(mx*8)+(my*8+yy)*X;
        cad=65536+mx+((my*8+yy)*MX);
        for(int xx=0;xx<=7;xx++){
          g_map[ad+xx]=0;
          g_map[cad]=byte(foreg);
          g_map[cad+MX*(MY*8)]=byte(prev);
        }
      }
    }
    
}
