//Read preferences from file
//Adapted from Marq's PETSCII editor

final String machinenames[]={
          "C64",
          "C64M",
          "SPECTRUM",
          "ULAPLUS",
          "MSX",
          "PLUS4",
          "PLUS4M",
          "CPC",
          "QLLOW",
          "AMIGA",
          "ATARIST",
          "VIC",
          "VICM",
          "GX4000",          
          };          
          
final String ext_machinenames[]={
          "C64",
          "C64M",
          "SPECTRUM",
          "MSX",
          "PLUS4",
          "PLUS4M",
          "CPC",
          "QLLOW",
          "AMIGA",
          "C64NOLIMIT",
          "PICO8",
          "BK0010",
          "COCO3",
          "ULAPLUS",
          "ATARIST",
          "ULATMX",
          "CPC1",          
          "CPCOC",
          "ULAFREE",
          "VIC",
          "VICM",
          "GX4000",
          "C64MNOLIMIT"
};

//what appears in the top menu bar
final String g_machinecalled[]={
          "C64 Hires",
          "C64 Multicolor",
          "ZX Spectrum",
          "ZX ULAplus",
          "MSX1 Mode 2",
          "Plus4 Hires",
          "Plus4 Multicolor",
          "Amstrad CPC Mode 0",
          "Sinclair QL Mode 8",
          "Amiga Low",
          "Atari ST Low",
          "ULA Timex",
          "C64 Hires Free",
          "Pico8",
          "BK0010",
          "COCO3",
          "Amstrad CPC Mode 1",
          "CPC Mode 0 Overscan",
          "ZX ULAplus Direct",
          "VIC 20 Hires",
          "VIC 20 Multi",
          "GX4000",
          "C64 Mcolor Free"
        };
final String g_machinetip[]={
          "320x200 16",
          "160x200 16",
          "256*192 15",
          "256*192 64|of 256",
          "256*192 16",
          "320x200 121",
          "160x200 121",
          "160x200 16|of 27",
          "256x256 8",
          "320x200 32|of 4096",
          "320x200 16|of 512",
          "256*192 64|of 256",
          "320x200 16|Not a real|C64 mode!",
          "aa",
          "aa",
          "aa",
          "320x200 4|of 27",
          "192x272 16|of 27|Overscan",
          "256*192 64|of 256|Not a real|ULAplus mode",
          "176*176 8-16|of 16|with limits",
          "88*176  8-16|of 16|with limits",
          "160*200 16|of 4096",
          "160*200 16|Not a real|C64 mode!"
        };        
        
        
final int g_getindex[]={0,1,2,4,5,6,7,8,9,12,13,14,15,3,10,11,16,17,18,20,21,22,23};

//the real real menu
final int g_realmenu[]={0,1,2,3,4,5,6,7,16,17,8,10,9,19,20}; //21 for gx4000
final int g_machinemenu[]={C64,C64M,SPECTRUM,ULAPLUS,MSX,PLUS4,PLUS4M,CPC,QLLOW,AMIGA,ATARIST,ULATMX,C64NOLIMIT,PICO8,BK0010,COCO3,CPC1,CPCOC,ULAFREE,VIC,VICM,GX4000,C64MNOLIMIT};


//a bit sad
final int g_machineidx[]={C64,C64M,SPECTRUM,MSX,PLUS4,PLUS4M,CPC,QLLOW,AMIGA,C64NOLIMIT,PICO8,BK0010,COCO3,ULAPLUS,ATARIST,ULATMX,CPC1,CPCOC,ULAFREE,VIC,VICM,GX4000,C64MNOLIMIT};

int g_filelist=0;
int g_forcex=0;
int g_forcey=0;
int g_hadjust=0;
int g_vadjust=0;
int g_wheelup=':';
int g_wheeldown=';';
int g_middlebutton=',';
int g_guileft=0;
int g_aspect_override=0;
int g_fselector_force=0;

String g_prefname="";

String g_forcedpalette="";

String get_machinename(int m){
  
  for(int i=0;i<g_machineidx.length;i++){
    if(g_machineidx[i]==m){
      return ext_machinenames[i];
    }
  }
  return "Unknown";
}

boolean pref_runner(){
  g_prefname="";
  if(pref_loader()==true){
    readprefs(g_prefname);
    return true;
  }
  return false;
}

boolean pref_loader(){
  
      println("PREF_LOADER");
      
      println("0. Default way");
      g_prefname="prefs.txt";
      
      String row[]=loadStrings(g_prefname);
      
      if(row!=null){        
        println("FOUND");
        return true;
      }
      
      println("1. Explicit way");
      g_prefname=sketchPath("prefs.txt");
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("2. Explicit way datapath");
      g_prefname=dataPath("prefs.txt");
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("3. Explicit way superpath");
      g_prefname=g_superpath+"prefs.txt";
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("4. User home");
      String last=System.getProperty("user.home")+File.separator;
      
      g_prefname=last+"prefs.txt";
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("prefs.txt read FAIL");
      return false;
}

void readprefs(String fname){
  
  String row[]=loadStrings(fname);
  
  if(row==null){
    println("-readprefs : null");
    return;
  }
      
  for(int i=0;i<row.length;i++) // Parse each line
  {
      if(row[i].length()>1)
      {
          String s[]=split(row[i],"=");
          
          if(s[0].equals("ZOOM"))
          {
              g_uizoom=int(s[1]);
              if(g_uizoom<1)g_uizoom=1;//lv 1 reinstated
              if(g_uizoom>3)g_uizoom=2;
              //g_uizoom=3;
          }
          
          if(s[0].equals("FORCEX"))
          {
              g_forcex=int(s[1]);
          }

          if(s[0].equals("FORCEY"))
          {
              g_forcey=int(s[1]);
          }             
          
          if(s[0].equals("INVERTGUI"))
          {
              g_guileft=int(s[1]);
          } 

          if(s[0].equals("DARKTHEME"))
          {
              g_data[GUIDARK]=byte(int(s[1]));
          } 

          if(s[0].equals("SCALELOCK"))
          {
              g_data[GUILOCK]=byte(int(s[1]));
          } 
          
          if(s[0].equals("HADJUST"))
          {
              g_hadjust=int(s[1]);
          } 
           if(s[0].equals("VADJUST"))
          {
              g_vadjust=int(s[1]);
          }                
          if(s[0].equals("MACHINE") && s.length>1)
          {
              for(int j=0;j<ext_machinenames.length;j++)
                  if(s[1].equals(ext_machinenames[j])){
                      g_machine=g_machineidx[j];
                      g_machineindex=g_getindex[j];
                    }
          }
          
          if(s[0].equals("PATH") && s.length>1)
          {
              path=s[1];
          }

          //if(s[0].equals("FILELIST") && s.length>1)
          //{
          //    g_filelist=int(s[1]);
          //}

          if(s[0].equals("PALETTE64") && s.length>1)
          {
              g_forcedpalette=s[1];
          }

          if(s[0].equals("GRIDBRIGHTNESS") && s.length>1)
          {
              grid_lightness(int(s[1]));
          }
          
          if(s[0].equals("KEYMACRO") && s.length>1 && s.length<80)
          {
              g_keymacro=s[1];
          }      
          
          if(s[0].equals("PNGSCALE"))
          {
              g_omag=int(s[1]);
              if(g_omag<1||g_omag>10)g_omag=1;
          }
          
          if(s[0].equals("PNGHBORDER"))
          {
              g_bordh=int(s[1]);
              if(g_bordh<1||g_bordh>256)g_bordh=64;
          }
          
          if(s[0].equals("PNGVBORDER"))
          {
              g_bordv=int(s[1]);
              if(g_bordv<1||g_bordv>256)g_bordv=72;
          }

          if(s[0].equals("NOASPECT"))
          {
              g_aspect=SQUARERATIO;
              g_aspect_override=1;
          }    
          
          if(s[0].equals("WHEELUP"))
          {
              g_wheelup=int(s[1]);
          }
          if(s[0].equals("WHEELDOWN"))
          {
              g_wheeldown=int(s[1]);
          } 
          if(s[0].equals("MIDDLEBUTTON"))
          {
              g_middlebutton=int(s[1]);
          }
          if(s[0].equals("FSELECTOR"))
          {
              g_fselector_force=int(s[1]);
          }            
      }
  }
}
    
