byte[] g_xmem=new byte[256000];
byte[] g_xint=new byte[256000];
int[] g_var=new int[128];
int[] g_loopptr=new int[128];
int[] g_loopstep=new int[128];
int[] g_loopend=new int[128];
int[] g_condi=new int[128];
byte[] inp_file=new byte[256];
int g_tab=0;
int g_xhead=0;
int g_xinthead=0;
int g_xflen=0;
int g_xcur=0;
int g_outmode=0;
int g_hexout=0;
int g_xedge=0;
int g_xbytes=0;
int g_xfirst=0;
int g_xterminator=0;

boolean g_xdump;

PrintWriter g_dump;

final int TOKEN_POKE=1;
final int TOKEN_ADDITEM=2;
final int TOKEN_ADDSAVE=3;
final int TOKEN_ADDMAKE=4;
final int TOKEN_ADDLOAD=5;
final int TOKEN_PEEK=6;
final int TOKEN_LENGTH=7;
final int TOKEN_COLORS=8;
final int TOKEN_BITPLANES=9;
final int TOKEN_ALERT=10;
final int TOKEN_SCALERGB=11;
final int TOKEN_GETPOINT=12;
final int TOKEN_PUTPOINT=13;
final int TOKEN_REM=14;
final int TOKEN_LET=15;
final int TOKEN_READ=16;
final int TOKEN_RESTORE=17;
final int TOKEN_XMOVE=18;
final int TOKEN_SETINT=19;
final int TOKEN_READW=20;
final int TOKEN_MAKECOLOR=21;
final int TOKEN_SAVE=22;
final int TOKEN_LOAD=23;
final int TOKEN_ECHO=24;
final int TOKEN_VERBOSE=25;
final int TOKEN_REFRESH=26;
final int TOKEN_XBYTE=27;
final int TOKEN_XREPEAT=28;
final int TOKEN_XWORD=29;
final int TOKEN_XWORDR=30;
final int TOKEN_XLONG=31;
final int TOKEN_XREM=32;
final int TOKEN_BYTE=33;
final int TOKEN_WORD=34;
final int TOKEN_LONG=35;
final int TOKEN_FOR=36;
final int TOKEN_NEXT=37;
final int TOKEN_IF=38;
final int TOKEN_ENDIF=39;
final int TOKEN_GRAB=40;
final int TOKEN_TO=41;
final int TOKEN_STEP=42;
final int TOKEN_STOP=43;

void x_open(String fname){
  println("x_open");
  g_dump=createWriter(fname);
  g_outmode=0;//byte 1, word 2 or comment 32 output
  g_xcur=0;//output tab
  g_xdump=true;//active
  g_xedge=80;//right edge
  g_hexout=0;//hexmode
  g_xbytes=0;//length limiter
  g_xterminator=0;//break 
  g_xfirst=1;
  if(getbit(129)==1)g_xedge=32;
  if(getbit(131)==1)g_hexout=1;
}

void x_prepline(){
  String preline="";
  if(g_outmode==0){
    if(getbit(130)==0)preline=char(9)+".byte ";
    if(getbit(130)==1)preline=char(9)+".db ";
  }
  if(g_outmode==1){
    if(getbit(130)==0)preline=char(9)+".word ";
    if(getbit(130)==1)preline=char(9)+".dw ";
  }
  if(g_outmode==32){
    preline="; ";
  }
  
  g_dump.print(preline);
  g_xcur=preline.length();
  if(g_outmode!=32)g_xcur=g_xcur+6;
  g_xbytes=g_xbytes+preline.length();  
  g_xfirst=1;
}

void x_dump(int v){
  if(g_xdump==false)return;
    
  if(g_xcur==0)x_prepline();
  
  int bam=0;  
  if(g_outmode==0)bam=2;
  if(g_outmode==1)bam=4;
  String ss=str(v);
  if(g_hexout==1){
    ss="$"+hex(v,bam);
  }
  
  if(g_outmode==32)ss=""+char(v);
      
  if(g_xcur+ss.length()>=g_xedge){
    g_dump.println();
    x_prepline();
  }   
  
  if(g_outmode!=32){
    if(g_xfirst==0){
      g_dump.print(",");
      g_xcur++;
      g_xbytes++;
    }
  }
  
  g_dump.print(ss);
  g_xfirst=0;
  g_xcur=g_xcur+ss.length();
  g_xbytes=g_xbytes+ss.length();

  if(g_xbytes>256*1024){
    x_close();
    launch_alert("å  Terminated!|-|Output length|exceeds 256Kb||  [Cancel/Close|window]");    
    g_xterminator=1;
    return;
  }

}

void x_dump_newline(){
  if(g_xdump==false)return;
    g_xcur=0;
    g_xbytes++;
    g_dump.println();
}

void x_close(){
  if(g_xdump==false)return;
  println("x_close");
  g_dump.println();
  g_dump.println();
  g_dump.flush();
  g_dump.close();
  g_xdump=false;
}

int x_evaluate(String s){

  int closed=0;
  String com="";
  String res="";
  for(int i=0;i<s.length();i++){
    char c=char(s.charAt(i));
    if(closed==1&&c!=')'){
      com=com+c;
    }
    if(c=='('){
      closed=1;
      c=0;
    }
    if(c==')'&&closed==1){
      c=0;
      closed=0;
      int r=all_evaluate(com);
      res=res+str(r);
      com="";
    }
    if(c>0&&closed==0){
      res=res+c;
    }
  }  
  int r=all_evaluate(res);
  return r;
}

int all_evaluate(String s){
   if(s.length()==1){
     char c=char(s.charAt(0));
      if(c>='A'&&c<='Z'){
        return g_var[c];
      }
      if(c>='a'&&c<='z'){
        return g_var[c];
      }       
   }  
   //println(s);
  //s=s+"_";
  int ll=s.length()-1;
  int v=0;
  int sign=0;
  int symbol=0;
  int imode=0;//DEC-HEX
  int mulu=10;//BASE
  int val[]=new int[32];
  int mod[]=new int[32];
  int p=0;
  

   //print("*");
  for(int i=0;i<s.length();i++){
    char c=char(s.charAt(i));
    if(c=='$'){
      imode=1;
      mulu=16;
    }    
    if(c>='0'&&c<='9'){
      v=v*mulu;
      v=v+c-'0';
      symbol=0;
    }
    if(imode==1){
      if(c>='A'&&c<='F'){    
        v=v*mulu;
        v=v+c-'A'+10;
        symbol=0;
      }
      if(c>='a'&&c<='f'){    
        v=v*mulu;
        v=v+c-'a'+10;
        symbol=0;
      }      
    }

    if(imode==0){
      if(c>='A'&&c<='Z'){
        v=g_var[c];
        symbol=0;
      }
      if(c>='a'&&c<='z'){
        v=g_var[c];
        symbol=0;
      }               
    }
 
    if(c=='/'||c=='*'||c=='+'||c=='|'||c=='&'||c=='^'||i==ll){
      imode=0;
      mulu=10;
      val[p]=v;
      if(sign>0)val[p]=-v;
      mod[p]=c;
      sign=0;
      symbol=1;
      v=0;
      p++;
    }
    if(i!=0&&c=='-'&&symbol==0){
      imode=0;
      mulu=10;
      val[p]=v;
      mod[p]='-';
      v=0;
      p++;
    }
    if(i>0&&c=='-'&&symbol==1){
      sign=1;
      imode=0;
      mulu=10;
      symbol=0;
    }        
    if(i==0&&c=='-'&&sign==0){
      sign=1;
      imode=0;
      mulu=10;
    }   
    /*
    if(c=='_'){
      imode=0;
      mulu=10;
      val[p]=v;
      if(sign>0)val[p]=-v;
      mod[p]=0;
      v=0;
      sign=0;
      p++;
    }*/
  }

  for(int i=0;i<p;i++){
    if(mod[i]=='*'){
      val[i+1]=val[i]*val[i+1];
      val[i]=0;
      mod[i]='+';
    }
    if(mod[i]=='/'){
      val[i+1]=val[i]/val[i+1];      
      val[i]=0;
      mod[i]='+';     
    }
  }
  
  for(int i=0;i<p;i++){
    if(mod[i]=='+'){
      val[i+1]=val[i]+val[i+1];
    }
    if(mod[i]=='-'){
      val[i+1]=val[i]-val[i+1];
    }
    if(mod[i]=='&'){
      val[i+1]=val[i]&val[i+1];//AND
    }
    if(mod[i]=='|'){
      val[i+1]=val[i]|val[i+1];//OR
    }
    if(mod[i]=='^'){
      val[i+1]=val[i]^val[i+1];//EOR
    }        
  }
  return(val[p-1]);
}

void xbasic_run(String fname){
  g_xhead=0;
  g_xinthead=0;
  g_tab=0;
  println("xbasic_run:"+fname);
  int clock=millis();
  for(int i=0;i<128;i++){
    g_condi[i]=0;
  }
  for(int i=0;i<65536;i++){
    g_xmem[i]=0;
  }
  String[] line = loadStrings(fname);
  for(int s=0;s<line.length;s++){   
    if(line[s].length()>1){
      line[s]=trim(line[s]);
      line[s]=line[s]+" ";
    }
  }
  int i=0;
  while(i<line.length){
    int rev=interpret(i,line[i]);
    if(rev==65536)return;
    if(rev==0)i++;
    if(rev>0)i=rev;//jump
  }

}

int g_verbose=0;


void x_xbyte(byte b)
{
  if(g_filemode!=5){
    g_xmem[g_xhead]=b;
    g_xhead++;
  }else
  {
    g_xint[g_xinthead]=b;
    g_xinthead++;
  }
}
      
int interpret(int line, String s){
  
  if(s.length()<2)return 0;
  if(s.charAt(0)=='#')return 0;  
  if(g_xterminator==1)return 65536;
  /*
    if(g_verbose==1){
      if(g_condi[g_tab]==0)print(g_tab+" OK:");
      if(g_condi[g_tab]==1)print(g_tab+" NOT:");
      println(s);
    }
  */
  int condi=0;
  char nc=' ';
  
  for(int i=1;i<s.length()-1;i++){
    if(condi==0){
      char c=s.charAt(i);
      if(c=='=')condi=1;
      if(c=='>'){
         condi=2;
         nc=s.charAt(i+1);
         if(nc=='=')condi=4;
      }
      if(c=='<'){
        condi=3;
        nc=s.charAt(i+1);
        if(nc=='=')condi=5;
        if(nc=='>')condi=6;
      }
    }
  }  
  
  String com="";
  String zom="";
  int quote=0;
  String words[]=new String[255];
  int tok[]=new int[255];
  int wptr=0;
  int inside=0;
  int token=-1;
  
  for(int i=0;i<s.length();i++){
    char c=s.charAt(i);

    if(c=='['){inside=1;c=0;}
    if(c==']'){inside=0;c=0;}
    if(quote==1&&c!=34){
      words[wptr]=str(int(c));
      tok[wptr]=int(c);
      //println(wptr+" quote:"+c+" = "+words[wptr]);
      zom="";
      com="";
      wptr++;
      c=0;
    }    
    
    if(c==34){
      quote++;
      quote=quote&1;
      c=0;
    }
    if(c=='='||c==','||c=='<'||c=='>'){
      if(zom.length()>0){
        words[wptr]=zom;
        tok[wptr]=int(c);
        zom="";
        com="";
        wptr++;
      }
      c=0;
    }
    
    token=-1;
    
    if(com.length()>0&&inside==0&&c==' '){
      char ch=com.charAt(0);
      switch(ch){
        case 'A':
          if(com.equals("ALERT")){
            token=TOKEN_ALERT;
          }  
          if(com.equals("ADDSAVE")){
            token=TOKEN_ADDSAVE;
          }
          if(com.equals("ADDMAKE")){
            token=TOKEN_ADDMAKE;
          }        
          if(com.equals("ADDLOAD")){
            token=TOKEN_ADDLOAD;
          } 
          if(com.equals("ADDITEM")){
            token=TOKEN_ADDITEM;
          }
        break;        
        case 'B':
          if(com.equals("BITPLANES")){
            token=TOKEN_BITPLANES;
          }       
          if(com.equals("BYTE")){
            token=TOKEN_BYTE;
          }    
        break;        
        case 'C':
          if(com.equals("COLORS")){
            token=TOKEN_COLORS;
          }
        break;
        case 'E':      
          if(com.equals("ECHO")){
            token=TOKEN_ECHO;
          }
          if(com.equals("ENDIF")){
            token=TOKEN_ENDIF;
          }             
        break;
        case 'F':
          if(com.equals("FOR")){
            token=TOKEN_FOR;
          }      
        break;
        case 'G':
          if(com.equals("GETPOINT")){
            token=TOKEN_GETPOINT;
          }
          if(com.equals("GRAB")){
            token=TOKEN_GRAB;
          }      
        break;
        case 'I':
        if(com.equals("IF")){
          token=TOKEN_IF;
        }    
        break;
        case 'L':
          if(com.equals("LENGTH")){
            token=TOKEN_LENGTH;
          }
          if(com.equals("LET")){
            token=TOKEN_LET;
          }   
          if(com.equals("LOAD")){
            token=TOKEN_LOAD;
          }
          if(com.equals("LONG")){
            token=TOKEN_LONG;
          }      
        break;
        case 'M':
          if(com.equals("MAKECOLOR")){
            token=TOKEN_MAKECOLOR;
          }
        break;
        case 'N':
        if(com.equals("NEXT")){
          token=TOKEN_NEXT;
        }  
        break;
        case 'P':
          if(com.equals("POKE")){
            token=TOKEN_POKE;
          }   
          if(com.equals("PEEK")){
            token=TOKEN_PEEK;
          }
          if(com.equals("PUTPOINT")){
            token=TOKEN_PUTPOINT;
          }        
        break;
        case 'R':
          if(com.equals("REM")){
            token=TOKEN_REM;
          }
          if(com.equals("READ")){
            token=TOKEN_READ;
          }        
          if(com.equals("READW")){
            token=TOKEN_READW;
          }
          if(com.equals("RESTORE")){
            token=TOKEN_RESTORE;
          }       
          if(com.equals("REFRESH")){
            token=TOKEN_REFRESH;
          }       
        break;
        case 'S':
          if(com.equals("SCALERGB")){
            token=TOKEN_SCALERGB;
          } 
          if(com.equals("SETINT")){
            token=TOKEN_SETINT;
          }         
          if(com.equals("SAVE")){
            token=TOKEN_SAVE;
          }
         
          if(com.equals("STOP")){
            token=TOKEN_STOP;
          }          
          if(com.equals("STEP")){
            token=TOKEN_STEP;
            if(zom.length()>0){
              words[wptr]=zom.substring(0,zom.length()-4);
              tok[wptr]=0;
              wptr++;
              zom="";
            }        
            words[wptr]=com;
            tok[wptr]=token;
            wptr++;
            com="";
            token=-1;
          }    
        break;
        case 'T':
        if(com.equals("TO")){
          token=TOKEN_TO;
          if(zom.length()>0){
            words[wptr]=zom.substring(0,zom.length()-2);
            tok[wptr]=0;
            wptr++;
            zom="";
          }        
          words[wptr]=com;
          tok[wptr]=token;
          wptr++;
          com="";
          token=-1;
        }      
        break;
        case 'V':
          if(com.equals("VERBOSE")){
            token=TOKEN_VERBOSE;
          }
        break;
        case 'W':
          if(com.equals("WORD")){
            token=TOKEN_WORD;
          }      
        break;
        case 'X': 
          if(com.equals("XBYTE")){
            token=TOKEN_XBYTE;
          }      
          if(com.equals("XWORD")){
            token=TOKEN_XWORD;
          }
          if(com.equals("XMOVE")){
            token=TOKEN_XMOVE;
          }  
          if(com.equals("XREPEAT")){
            token=TOKEN_XREPEAT;
          }
          if(com.equals("XWORDR")){
            token=TOKEN_XWORDR;
          }      
          if(com.equals("XLONG")){
            token=TOKEN_XLONG;
          }
          if(com.equals("XREM")){
            token=TOKEN_XREM;
          }    
        break;            
      }
      
      if(token>=0){
        words[wptr]=com;
        tok[wptr]=token;
        wptr++;
        com="";
        zom="";  
      }
      com="";
    }
    
    
    /*
    if(inside==1&&c=='+'){
      c=char(0);
    } 
    */
    if(c>' '){
      com=com+c;
      zom=zom+c;
    }
    if(inside==1&&c==' '){
      com=com+c;
      zom=zom+c;
    }  
  }
  if(zom.length()>0){
    words[wptr]=zom;
    tok[wptr]=token;
    wptr++;
    inside=0;
  }
  
  /*for(int i=0;i<wptr+1;i++){
    println(i+":"+words[i]);
  }*/

  if(tok[0]==TOKEN_REM)return 0;

// IF and ENDIF always move the 'tab' for conditions
// later, a valid IF will check if the commands within that 'tab' are executed

  if(tok[0]==TOKEN_IF){
    if(g_condi[g_tab]==1){
      words[0]="";
      tok[0]=-1;
      g_tab++;    
      g_condi[g_tab]=1;
    }
  }  
  if(tok[0]==TOKEN_ENDIF){
    if(g_condi[g_tab]==1){
      g_condi[g_tab]=0;
      g_tab--;
    }
    else{
      g_tab--;
    }
  }  
  
  if(g_condi[g_tab]==1){words[0]="";tok[0]=-1;}
  
  if(tok[0]==TOKEN_LET||words[0].length()==1){
    int pos=1;
    if(words[0].length()==1)pos=0;
    char p=words[pos].charAt(0);
    if(tok[pos+1]==TOKEN_GRAB){
      int px=x_evaluate(words[pos+2]);
      int py=x_evaluate(words[pos+3]);
      int ad=1024+px*CX+py*X;
      g_var[p]=int(g_map[ad+7])+int(g_map[ad+6])*2+int(g_map[ad+5])*4+int(g_map[ad+4])*8+int(g_map[ad+3])*16+int(g_map[ad+2])*32+int(g_map[ad+1])*64+int(g_map[ad])*128;
      
      if(g_machine==VIC){
        g_var[p]=int(g_map[ad+14])+int(g_map[ad+12])*2+int(g_map[ad+10])*4+int(g_map[ad+8])*8+int(g_map[ad+6])*16+int(g_map[ad+4])*32+int(g_map[ad+2])*64+int(g_map[ad])*128;
       // g_var[p]=255-g_var[p];
      
      }
      return 0;
    }    
    if(tok[pos+1]==TOKEN_PEEK){
      int pp=x_evaluate(words[pos+2]);
      g_var[p]=int(g_map[pp]);
      return 0;
    }
    if(tok[pos+1]==TOKEN_LENGTH){
      g_var[p]=g_xflen;
      return 0;
    }
    if(tok[pos+1]==TOKEN_BITPLANES){
      g_var[p]=int(g_map[14]);
      return 0;
    }
    if(tok[pos+1]==TOKEN_COLORS){
      g_var[p]=int(g_map[4]);
      return 0;
    }    
    if(words.length>pos+1){
      if(tok[pos+1]==TOKEN_GETPOINT){
        int xx=x_evaluate(words[pos+2]);
        int yy=x_evaluate(words[pos+3]);
        if(g_multic==4){
          g_var[p]=bpl_getxy(xx,yy,0);
          return 0;
        }
        g_var[p]=easygetcolor(xx,yy);//map onto tools
        return 0;
      }
      if(tok[pos+1]==TOKEN_SCALERGB){
        int val=x_evaluate(words[pos+2]);
        int steps=x_evaluate(words[pos+3]);
        //val1=round(g_g[i]/(255/(g_palstepsg-1)));
        g_var[p]=round(val/(255/(steps-1)));
        return 0;
      }   
    }
    
    g_var[p]=x_evaluate(words[1+pos]);
    return 0;
  }
      
  if(tok[0]==TOKEN_READ){
    char p=words[1].charAt(0);
    g_var[p]=int(g_xmem[g_xhead]);
   // println(g_xhead+":"+g_var[p]);
    g_xhead++;
    return 0;
  }
  if(tok[0]==TOKEN_READW){
    char p=words[1].charAt(0);
    int hi=int(g_xmem[g_xhead]);
    g_xhead++;
    int lo=int(g_xmem[g_xhead]);
    g_var[p]=hi*256+lo;
    g_xhead++;
    return 0;
  } 
  if(tok[0]==TOKEN_XMOVE){ // always imported single byte, repeat times
      for(int j=0;j<x_evaluate(words[1]);j++){
        int v=g_xint[g_xinthead];
        g_xinthead++;
        v=v&0xff;   
        x_xbyte(byte(v));
        x_dump(v);
      }
    return 0;
  }      
  if(tok[0]==TOKEN_STOP){
    return 65536;
  } 
  if(tok[0]==TOKEN_LOAD){
    println("load");
    System.gc();
    String fname="";
    fname=g_candidatename;
    if(fname.length()<2)return 0;
    inp_file=loadBytes(fname);
    g_xflen=inp_file.length;
    println("Length:"+g_xflen);
    for(int i=0;i<inp_file.length;i++){
      g_xmem[i]=inp_file[i];
    }
    g_xhead=0;  
    return 0;
  }    
  
  if(tok[0]==TOKEN_REFRESH){
    String ss=g_extsave[g_ext_choice];
    String fname="";
    for(int i=0;i<16;i++){
      if(g_extrun[i]!=null){
        if(g_extrun[i].equals(ss)){
          if(g_spare==0)g_ext_executed=i;
          if(g_spare==1)g_ext_executeds=i;
        }
      }
    }
    if(g_spare==0){
      g_extfilename=g_candidatename;
      fname=g_extfilename;
    }
    if(g_spare==1){
      g_extfilenames=g_candidatename;
      fname=g_extfilenames;
    }
    if(g_exttype[g_ext_choice]!=0)setname(fname,g_spare);  
    refresh_all();
    return 0;
  }
  
  if(tok[0]==TOKEN_SAVE){
    if(g_xdump==true)return 0;
    save_baked();//check return too
    return 0;
  }  

  if(tok[0]==TOKEN_ECHO){ // debugging
    int v=x_evaluate(words[1]);
    println("ECHO:"+v);
    return 0;
  }
  if(tok[0]==TOKEN_ALERT){ // debugging
    int v=x_evaluate(words[1]);
    String ms="";
    if(v==1)ms="Wrong file format?|| [CANCEL]";
    launch_alert("Alert no. "+v+"|-|"+ms);
    return 0;
  }
  if(tok[0]==TOKEN_VERBOSE){ // debugging
    g_verbose=x_evaluate(words[1]);
    return 0;
  }  
  if(tok[0]==TOKEN_POKE){ // executable header byte
    int ad=x_evaluate(words[1]);
    int v=x_evaluate(words[2]);
    v=v&0xff;
    if(ad>=88000||ad<0)ad=0;
    g_map[ad]=byte(v);
    return 0;
  }
  if(tok[0]==TOKEN_MAKECOLOR){ 
    int i=x_evaluate(words[1]);
    float rmax=float(x_evaluate(words[2]));
    float gmax=float(x_evaluate(words[3]));
    float bmax=float(x_evaluate(words[4]));

    float r=float(x_evaluate(words[5]));
    float g=float(x_evaluate(words[6]));
    float b=float(x_evaluate(words[7]));
    if(rmax==7&&gmax==7&&bmax==3){
      //000 00 0
      //001 00 0
      //010 00 0
      //011 01 1
      //100 00 0
      //101 10 1
      //110 00 0
      //111 11 1       
      if(b>0){
        int vb=int(b);
        vb=vb*2;vb=vb|1;bmax=7;
        b=float(vb);
      }
    }
    makecolor(i,int(round(r/rmax*255.0)),int(round(g/gmax*255.0)),int(round(b/bmax*255.0)));
    return 0;
  }  
  if(tok[0]==TOKEN_PUTPOINT){ 
    int x=x_evaluate(words[1]);
    int y=x_evaluate(words[2]);
    int p=x_evaluate(words[3]);
    g_farge=p;
    makepoint(x,y);
    return 0;
  }  
  if(tok[0]==TOKEN_ADDITEM){ // add and item to menu
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,0);
    return 0;
  }
  if(tok[0]==TOKEN_ADDLOAD){ // add an item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,1);
    return 0;
  }
  if(tok[0]==TOKEN_ADDMAKE){ // add a special item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,3);
    return 0;
  }      
  if(tok[0]==TOKEN_ADDSAVE){ // add an item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,2);
    return 0;
  }     
  if(tok[0]==TOKEN_BYTE){ // executable header byte
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      g_xmem[g_xhead]=byte(v);
      g_xhead++;
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_WORD){ // executable header word
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      g_xmem[g_xhead]=byte(hi);
      g_xhead++;
      g_xmem[g_xhead]=byte(lo);
      g_xhead++;
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_LONG){ // executable header longword
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int l1=v&0xff000000;
      l1=l1/(0x1000000);
      int l2=v&0x00ff;
      l2=l2/(0x10000);
      int l3=v&0x0000ff;
      l3=l3/(0x100);
      int l4=v&0x000000ff;    
      g_xmem[g_xhead]=byte(l1);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l2);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l3);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l4);
      g_xhead++;      
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XREM){ // exported comment
    if(getbit(128)==0)return 0;
    x_dump_newline();
    x_dump_newline();
    g_outmode=32;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      x_dump(v);
    }
    x_dump_newline();
    return 0;
  }  
  if(tok[0]==TOKEN_XBYTE){ // always exported byte
    if(g_outmode!=0)x_dump_newline();
    g_outmode=0;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      x_xbyte(byte(v));
      x_dump(v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XWORD){ // always exported word MSB,LSB
    if(g_outmode!=1)x_dump_newline();
    g_outmode=1;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      x_xbyte(byte(hi));
      x_xbyte(byte(lo));
      x_dump(hi*256+lo);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XWORDR){ // always exported word LSB,MSB
    if(g_outmode!=1)x_dump_newline();
    g_outmode=1;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      x_xbyte(byte(lo));
      x_xbyte(byte(hi));
      x_dump(hi*256+lo);
    }
    return 0;
  }    
  if(tok[0]==TOKEN_XLONG){ // always exported longword
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int l1=v&0xff000000;
      l1=l1/(0x1000000);
      int l2=v&0x00ff0000;
      l2=l2/(0x10000);
      int l3=v&0x0000ff00;
      l3=l3/(0x100);
      int l4=v&0x000000ff;    
      x_xbyte(byte(l1));
      x_xbyte(byte(l2));
      x_xbyte(byte(l3));
      x_xbyte(byte(l4));
      x_dump(v);
    }
    return 0;
  }     
  if(tok[0]==TOKEN_XREPEAT){ // always exported single byte, repeat times
      int v=x_evaluate(words[1]);
      v=v&0xff;
      for(int j=0;j<x_evaluate(words[2]);j++){  
        x_xbyte(byte(v));
        x_dump(v);
      }
    return 0;
  }
  if(tok[0]==TOKEN_RESTORE){ // set internal readhead
    int v=x_evaluate(words[1]);
    g_xinthead=v;
    return 0;
  }    

  if(tok[0]==TOKEN_IF){
    char p=words[1].charAt(0);
    int v=x_evaluate(words[2]);
    //print("if "+p+" "+v+" ("+condi+")");
   
    g_tab++;
   // print(" tab:"+g_tab);
    g_condi[g_tab]=1;
    if((condi==1)&&(g_var[p]==v))g_condi[g_tab]=0;
    if((condi==2)&&(g_var[p]>v))g_condi[g_tab]=0;
    if((condi==3)&&(g_var[p]<v))g_condi[g_tab]=0;
    if((condi==4)&&(g_var[p]>=v))g_condi[g_tab]=0;
    if((condi==5)&&(g_var[p]<=v))g_condi[g_tab]=0;
    if((condi==6)&&(g_var[p]!=v))g_condi[g_tab]=0;
  }  
  if(tok[0]==TOKEN_FOR){
    char p=words[1].charAt(0);
    g_loopptr[p]=line+1;
    //print("loopptr "+p+" = "+line);
    g_var[p]=x_evaluate(words[2]);
    g_loopend[p]=x_evaluate(words[4]);
    g_loopstep[p]=1;
    if(words[5]!=null&&words[5].equals("STEP")){
      g_loopstep[p]=x_evaluate(words[6]);
    }
    return 0;
  }
  if(tok[0]==TOKEN_NEXT){
    char p=words[1].charAt(0);
    g_var[p]=g_var[p]+g_loopstep[p];
    if(g_var[p]<=g_loopend[p]){
      //println(" ... loop to "+g_loopptr[p]);
      
      return g_loopptr[p];
    }
  }  
  //println();
  return 0;
}
