//undo / spare

final int UNDOSTEPS=30;// max # of undo steps

byte[] g_fillmap = new byte[1024+640*512];
byte[] g_sparepage = new byte[88000];
byte[] g_operations = new byte[1024+640*512];
byte[] g_swappage = new byte[88000];
byte[][] g_undob = new byte[UNDOSTEPS+1][88000];
byte[][] g_undobs = new byte[UNDOSTEPS+1][88000];
byte[][] g_recallbox = new byte[2][88000];
int [] g_uindex = new int[8];
int [] g_ubottom = new int[8];
int [] g_utop = new int[8];

int [] g_gridmarkerx = new int[641];
int [] g_gridmarkery = new int[513];

byte[] g_interpalt = new byte[256*3*2];  
byte[] g_nextpalt = new byte[256*3];//8bit palt kludge  
int[] g_marked = new int[256];  

final int TURTLEX=250;
final int TURTLEY=252;
final int TURTLEA=254;


// if g_map is the virtual videocard memory...

// ...g_data is the program state memory

byte[] g_data = new byte[1024];
final int FX=250;//position in g_data

// parameter store/restore in case some functions need to bypass grid, attribute modes etc

// g_data[]
// 0-255 = state, can be switched to 768-1023
// 0-255 0...9 a...b A...Z parameters
// 250  FX
// 256-319 message box contents

// 320-free memory

final int GUILOCK=320;
final int GUIDARK=321;
final int NEWX=322;
final int NEWY=323;
final int XYMODE=324;
final int XOFFSET=325;
final int YOFFSET=326;
final int GRIDX=327;
final int GRIDY=328;
final int NEWBPL=329;
final int DUMPMSG=330;

// 768-1023 parameter store

void clear_brush()
{
   g_bsourcex=0;
   g_bsourcey=0;
   g_bsourcex2=0;
   g_bsourcey2=0;
   if(g_btype==9)g_btype=0;
}
   

void clear_parameters()
{
  for(int i='a';i<='z';i++)g_data[i]=0;
  for(int i='A';i<='Z';i++)g_data[i]=0;
  g_data[FX]=0;
}

void store_parameters()
{
  for(int i=0;i<=255;i++)g_data[767+i]=g_data[i];
}

void restore_parameters()
{
  for(int i=0;i<=255;i++)g_data[i]=g_data[767+i];
}

void reset_parameters()
{
  clear_parameters();
  g_spare=0;
  g_bsize=0;
  g_btype=0;
  g_phase=0;
  g_button=LEFT;
  g_data['f']=1;// fill on
  g_data['g']=1;// grid on
  g_data['m']=0;
  g_data['M']=0; // mags off
  g_maglevel=0;
  g_phase=0;
  set_tool(1);
  setup_raster(); 
}
  
void ustats()
{
  //a debug thingie in case the step undo does not work
  //println("UINDEX:"+g_uindex[g_spare]);
  //println("UTOP:"+g_utop[g_spare]);
  //println("UBOTTOM:"+g_ubottom[g_spare]);
}

void clamp_undo()
{
  g_uindex[g_spare]=g_ubottom[g_spare];
  g_utop[g_spare]=g_uindex[g_spare];
}

void store_undo() //to_undo
{
  
  if(g_spare==0)g_undob[g_uindex[g_spare]]=g_map.clone();
  if(g_spare==1)g_undobs[g_uindex[g_spare]]=g_map.clone();
  g_uindex[g_spare]++;
  if(g_uindex[g_spare]>UNDOSTEPS)g_uindex[g_spare]=0;
  if(g_uindex[g_spare]==g_ubottom[g_spare]){
    g_ubottom[g_spare]++;
    if(g_ubottom[g_spare]>UNDOSTEPS)g_ubottom[g_spare]=0;
  }  
  g_utop[g_spare]=g_uindex[g_spare];
  
  refreshpalette();
  ustats();
}

void make_recallpoint(){
  store_undo();
  int i=g_uindex[g_spare];
  i--;
  if(i<0)i=UNDOSTEPS;
  
  g_recallbox[0]=g_undob[i].clone();
  g_recallbox[1]=g_undobs[i].clone();  
}

void recall_mode(){
  int newmode=g_recallbox[g_spare][3];
  println("Recall mode:"+newmode);
  //println("recall: new mode:"+newmode);
  change_mode_value(newmode);
  if(g_spare==0)g_map=g_recallbox[0].clone();
  if(g_spare==1)g_map=g_recallbox[1].clone();
  remake_palette();
  MX=int(g_map[5]);
  MY=int(g_map[7]);
  X=MX*8;
  Y=MY*8;
  resize_preview();
  g_planes=int(g_map[14]);
  g_maxcolors=int(g_map[4])+1;
  refocus();
}

void restore_undo()
{
  if(g_uindex[g_spare]==g_ubottom[g_spare])return;
  if(g_spare==0)g_undob[g_uindex[g_spare]]=g_map.clone();
  if(g_spare==1)g_undobs[g_uindex[g_spare]]=g_map.clone();
  g_uindex[g_spare]--;
  if(g_uindex[g_spare]<0)g_uindex[g_spare]=UNDOSTEPS;
  if(g_spare==0)g_map=g_undob[g_uindex[g_spare]].clone();
  if(g_spare==1)g_map=g_undobs[g_uindex[g_spare]].clone();
  
  refreshpalette();
  ustats();
}

void redo_undo()
{
  if(g_uindex[g_spare]==g_utop[g_spare])return;
  g_uindex[g_spare]++;
  if(g_uindex[g_spare]>UNDOSTEPS)g_uindex[g_spare]=0;
  if(g_spare==0)g_map=g_undob[g_uindex[g_spare]].clone();
  if(g_spare==1)g_map=g_undobs[g_uindex[g_spare]].clone();
  if(g_uindex[g_spare]>UNDOSTEPS)g_uindex[g_spare]=0;
  refreshpalette();
  ustats();
}

void copy_to_spare(){
  switcher(3);
}

void spare() //dpaint style spare page
{
  int sets=int(g_map[0x11]); // save radio buttons
  int tool=int(g_map[12]); // preserve quick tool id
  if(g_spare==0){// in REAL page, change to SPARE page
     g_swappage=g_sparepage.clone();
     g_sparepage=g_map.clone();
     g_map=g_swappage.clone();
     surface.setTitle(sfilename);
     if(g_untoucheds==0)surface.setTitle(sfilename+"*");
  }
  else
  {// in SPARE page, change to REAL page
     g_swappage=g_sparepage.clone();
     g_sparepage=g_map.clone();
     g_map=g_swappage.clone();
     surface.setTitle(filename);
     if(g_untouched==0)surface.setTitle(filename+"*");
  }
  g_spare=1-g_spare;
  g_realfront=byte(g_farge);
  g_realback=byte(g_backg);
  refreshpalette();  
  //make_grid(g_gridx,g_gridy);
  g_map[0x11]=byte(sets);// save radio buttons
  g_map[12]=byte(tool);//preserve quick tool id
  
}

// experimental

void merge_pages(){
  store_undo();
  spare();
  for(int y=0;y<Y;y++){
    for(int x=0;x<X;x++){
      g_operations[x+y*X]=byte(easygetcolor(x,y));
    }
  }
  spare();
  for(int y=0;y<Y;y++){
    for(int x=0;x<X;x++){
      g_farge=int(g_operations[x+y*X]);
      if(g_farge!=g_backg){
        makepoint(x,y);
      }
    }
  }
}

void store_palette(int plt){
  for(int i=0;i<256*3;i++)g_interpalt[i+plt*(256*3)]=g_map[256+i];
  
}

void recall_palette(int plt){
  //the stored palette can be interjected with makecolor, during ULAplus for instance
  for(int i=0;i<256*3;i++)g_map[256+i]=g_interpalt[i+plt*(256*3)]; 
}

void remake_palette(){
  for(int i=0;i<256;i++){
    int r=int(g_map[256+i*3]);
    int g=int(g_map[256+i*3+1]);
    int b=int(g_map[256+i*3+2]);
    makecolor(i,r,g,b);
  }
}

void switcher(int di)
{
  // this achieves varieties of whole screen copying
  // needed for brush copy and pre-drawing the shapes when a
  // tool is active etc.
  switch(di)
  {
    case 0:
      store_palette(0);
      g_rmap=g_map.clone();
    break;
    case 1:
      g_map=g_rmap.clone();
      for(int i=0;i<MX*MY;i++){
        if(g_remdo[i]==1){
          g_remdo[i]=0;
          g_redo[i]=0;
        }
      }
      recall_palette(0);
    break;
    case 2:
       g_brush=g_map.clone();
    break;
    case 3:
       g_sparepage=g_map.clone();
    break;
    case 4:
       g_map=g_sparepage.clone();
    break;
  }
}

void grid_iron(int xs,int ys,int ox,int oy){
  
  int mag=1;
  
  if(g_hzoomer==2||g_multic==1)xs=xs*2;
    
  if(g_shift||g_button==RIGHT)mag=8;
  
  g_gridx=g_gridx+xs*mag;
  g_gridy=g_gridy+ys*mag;
  if(g_gridx<0)g_gridx=0;
  if(g_gridx>128)g_gridx=128;
  if(g_gridy<0)g_gridy=0;
  if(g_gridy>128)g_gridy=128;  
  int x=int(g_data[XOFFSET]);
  int y=int(g_data[YOFFSET]);
  if(g_gridx<x)x=g_gridx;
  if(g_gridy<y)y=g_gridy;
  x=x+ox*mag;
  if(x<0)x=0;
  if(x>g_gridx)x=g_gridx;
  y=y+oy*mag;
  if(y<0)y=0;
  if(y>g_gridy)y=g_gridy;
  g_data[XOFFSET]=byte(x);
  g_data[YOFFSET]=byte(y);
  make_grid(g_gridx,g_gridy);
  g_data['g']=1;
}

void clear_offset(){
  g_data[XOFFSET]=byte(0);
  g_data[YOFFSET]=byte(0);  
}

void grid_doubler(){
  int sx=g_gridx;
  int sy=g_gridy;
  sx=sx*2;
  sy=sy*2;
  if(sx>24){sx=4;sy=4;}
  sy=sx;
  make_grid(sx,sy);
}
        
void make_mirror(int x,int y){
  doke(24,x);
  doke(26,y);
}

void make_grid(int xsize,int ysize){
  int step=int(g_data[XOFFSET]);
  for(int i=0;i<X;i++){
    g_gridmarkerx[i]=0;
    if(getbit(138)==1){
      g_gridmarkerx[i]=4;
      if(g_hzoomer==2||g_multic==1){
        if((i&1)==1)g_gridmarkerx[i]=0;
      }
    }//pixel level subgrid
    if(i==step){
      g_gridmarkerx[i]=1;
      step=step+xsize;
    }
  }
  g_gridmarkerx[X]=1; // edge gridline
  step=int(g_data[YOFFSET]);

  for(int i=0;i<Y;i++){
    g_gridmarkery[i]=0;
    if(getbit(138)==1){g_gridmarkery[i]=4;}//pixel level subgrid  
    if(i==step){
      g_gridmarkery[i]=1;
      step=step+ysize;
    }
  }
  
  if(g_machine==C64NOLIMIT||g_machine==C64MNOLIMIT){
    if(X>320&&X<=416){
        int opx=X/16;
        if(opx*16==X){
          int what=X-320;
          what=what/2;
          g_gridmarkerx[what-1]=3;
          g_gridmarkerx[X-what-1]=3;
        }
    }  
    if(Y>200&&Y<=264){
        int opy=(200-Y)/16;
        if(opy*16==(200-Y)){
          int what=Y-200;
          what=what/2;
          g_gridmarkery[what-1]=3;
          g_gridmarkery[Y-what-1]=3;
        }
    }  
  }
  
  g_gridmarkery[Y]=1; // edge gridline
  g_gridx=xsize;
  g_gridy=ysize;
  g_data[GRIDX]=byte(g_gridx);
  g_data[GRIDY]=byte(g_gridy);
}

//setbit,set_bit

void putbit(int offset,int state){
  int ad=offset/8;
  int val=int(g_map[ad]);
  int bt=offset%8;
  if(state==1){
    val=val|int(pow(2,bt));
  }
  if(state==0){
    val=val&int(255-pow(2,bt));  
  }
  g_map[ad]=byte(val);
  if(offset==138)make_grid(g_gridx,g_gridy);
}

int g_bpr[]={1,2,4,8,16,32,64,128};

int getbit(int offset){
  int val=int(g_map[offset/8]);
  int bt=offset%8;
  int res=val&g_bpr[bt];
  return res>>bt;
}

int getbit_brush(int offset){
  int val=int(g_brush[offset/8]);
  int bt=offset%8;
  int res=val&g_bpr[bt];
  return res>>bt;
}

int getbit_recallmap(int offset){
  int val=int(g_readbuffer[offset/8]);
  int bt=offset%8;
  int res=val&g_bpr[bt];
  return res>>bt;
}

void doke(int ad,int val){
  int hi=(val&0xff00)>>8;
  int lo=val&0xff;
  g_map[ad]=byte(hi);
  g_map[ad+1]=byte(lo);
}

int deek(int ad){
  return int(g_map[ad])*256+int(g_map[ad+1]);
}

void create_aspects(){

  //generate pixel dimensions (integer)
  
  //a matrix of zoom scale levels 0,1,2,3,4 and GUI scales 0,10,20
  //normal = 0 flat = 100
  
  //mini=1 scale GUI
  //norm=2 scale GUI
  //maxi=3 scale GUI
  //mega=4 scale GUI - 
  
  //norm
  g_magpix[0]=3;g_magpix[1]=5;g_magpix[2]=8;g_magpix[3]=12;g_magpix[4]=16;
  g_magpiy[0]=3;g_magpiy[1]=5;g_magpiy[2]=8;g_magpiy[3]=12;g_magpiy[4]=16;
  
  //FLAT norm
  g_magpix[100]=3;g_magpix[101]=6;g_magpix[102]=9;g_magpix[103]=12;g_magpix[104]=15;
  g_magpiy[100]=2;g_magpiy[101]=4;g_magpiy[102]=6;g_magpiy[103]=8;g_magpiy[104]=10;
  
  //maxi
  g_magpix[20]=4;g_magpix[21]=8;g_magpix[22]=16;g_magpix[23]=24;g_magpix[24]=32;
  g_magpiy[20]=4;g_magpiy[21]=8;g_magpiy[22]=16;g_magpiy[23]=24;g_magpiy[24]=32;

  //FLAT maxi
  g_magpix[120]=3;g_magpix[121]=6;g_magpix[122]=12;g_magpix[123]=15;g_magpix[124]=30;
  g_magpiy[120]=2;g_magpiy[121]=4;g_magpiy[122]=8;g_magpiy[123]=10;g_magpiy[124]=20;
  
  //mini
  g_magpix[10]=2;g_magpix[11]=4;g_magpix[12]=8;g_magpix[13]=12;g_magpix[14]=16;
  g_magpiy[10]=2;g_magpiy[11]=4;g_magpiy[12]=8;g_magpiy[13]=12;g_magpiy[14]=16;
  
  //FLAT mini (fake)
  g_magpix[110]=2;g_magpix[111]=4;g_magpix[112]=8;g_magpix[113]=12;g_magpix[114]=16;
  g_magpiy[110]=2;g_magpiy[111]=4;g_magpiy[112]=8;g_magpiy[113]=12;g_magpiy[114]=16;  
  

  if(g_machine==VIC||g_machine==VICM){
    //norm
    g_magpix[0]=2;g_magpix[1]=4;g_magpix[2]=6;g_magpix[3]=8;g_magpix[4]=10;
    g_magpiy[0]=3;g_magpiy[1]=6;g_magpiy[2]=9;g_magpiy[3]=12;g_magpiy[4]=15;

    //maxi
    g_magpix[20]=4;g_magpix[21]=6;g_magpix[22]=8;g_magpix[23]=10;g_magpix[24]=12;
    g_magpiy[20]=6;g_magpiy[21]=9;g_magpiy[22]=12;g_magpiy[23]=15;g_magpiy[24]=18;   
    
    //mini = fake
    g_magpix[10]=1;g_magpix[11]=2;g_magpix[12]=4;g_magpix[13]=6;g_magpix[14]=8;
    g_magpiy[10]=2;g_magpiy[11]=4;g_magpiy[12]=8;g_magpiy[13]=12;g_magpiy[14]=16;
    
    
    if(g_machine==VICM){
      for(int i=0;i<255;i++){
        g_magpix[i]=g_magpix[i]*2;
      }     
    }
  }
}
