// Collect all that "writes" the virtual image in some way or other
// plus other active manipulations

void createpoint(int x,int y,int mo)
{
  if(mo==LEFT)makepoint(x,y);
  if(mo==RIGHT)clearpoint(x,y);
}

void memorizepoints(){
  g_readbuffer=g_map.clone();
}

int recallpoint(int x,int y){
  
  if(g_multic==4){//amiga etc
    return bpl_getxy(x,y,2);
  }
  return int(g_readbuffer[1024+x+y*X]);
}

void doborx(int xf,int yf,int xt,int yt)
{
  for(int ii=xf;ii<=xt;ii++){
    for(int jj=yf;jj<=yt;jj++){
        createpoint(ii,jj,g_button);
    }
  }  
}

void bitmap_brush(int x,int y,int c){
  
    int mb=g_button;
    int passes=2; // two pass is standard but exceptions with more direct modes (Amiga,CPC)
  
    int tempox,tempoy,tempx,tempy,moloy;
    moloy=1;
    tempox=g_bsourcex; tempoy=g_bsourcey;
    tempx=g_bsourcex2; tempy=g_bsourcey2;
    if(g_data['t']==1){
        if(tempx>g_bsourcex+32)tempx=g_bsourcex+32;
        if(tempy>g_bsourcey+32)tempy=g_bsourcey+32;
    }
   int  midx=(g_bsourcex2-g_bsourcex)/2;
   int  midy=(g_bsourcey2-g_bsourcey)/2;
    if(g_data['c']==1||g_shift==true){
      if(g_data['Z']==1){
        // grid offset
        if(g_gridy>0){
          midy=midy-int(g_data[YOFFSET]);
          midy=midy/g_gridy;
          midy=midy*g_gridy;
          midy=midy+int(g_data[YOFFSET]);
        }
        if(g_gridx>0){
          midx=midx-int(g_data[XOFFSET]);
          midx=midx/g_gridx;
          midx=midx*g_gridx;
          midx=midx+int(g_data[XOFFSET]);
        }
      }
    }
    
    int orient=g_data['x']*100+g_data['y']*10+g_data['Z'];
    
    if(g_multic==1||g_hzoomer==2){
      x=x/2;
      x=x*2;
      passes=2;
    }
    if(g_multic>1)passes=1;

    for(int pp=1;pp<=passes;pp++){
      for(int yy=tempoy;yy<=tempy;yy=yy+moloy){
        for(int xx=tempox;xx<=tempx;xx=xx+g_pixelw){
        int   s1=easygetcolor_brush(xx,yy);
          
          int valid=1;
          
          if(comparecolors(s1,g_backg))valid=0; // brush transparency
          
          if(valid==1){ 
            int x0=x+xx-g_bsourcex;
            int y0=y+yy-g_bsourcey;
    
            if(g_data['Z']==1){
              x0=x-(yy-g_bsourcey2);
              y0=y+(xx-g_bsourcex);
              x0=x0+midx;
              x0=x0-midy;
              y0=y0+midy;
              y0=y0-midx;
            }  
    
            if(g_data['x']==1){
              x0=x0-(x+midx);
              x0=-x0;
              x0=x0+(x+midx);  
            }

            if(g_data['y']==1){
              y0=y0-(y+midy);
              y0=-y0;
              y0=y0+(y+midy);
            }
          
           if(g_data['c']==1||g_shift){
             //grid offset
              if(orient==10)y0=y0+1;
              if(orient==11)y0=y0+g_gridy-g_pixelw;
              if(orient==100)x0=x0+1;
              if(orient==101)x0=x0+g_gridx-1;
              if(orient==110){x0=x0+1;y0=y0+1;}
              if(orient==111){x0=x0+g_gridx-1;y0=y0+g_gridy-g_pixelw;}
           }
            
           if(mb==LEFT){  
             if(g_multic>0){
                g_farge=s1;
                if(pp==1&&g_colorprofile[1]==1)g_farge=g_map[1];
                if(g_data['p']==1)g_farge=g_ofarge;
                if(g_multic==1||g_hzoomer==2){
                  if(g_data['Z']==0)makepoint(x0,y0);
                  if(g_data['Z']==1){
                    makepoint(x0-x+x0,y+(y0-y));
                    makepoint(x0-x+x0,y+(y0-y)+1);
                  }
                }else{    
               makepoint(x0,y0);
               }              
              }else
              {
                g_farge=s1;
                if(pp==1&&g_colorprofile[1]==1)g_farge=g_map[1];
                if(zxcolor(g_farge)!=zxcolor(g_backg)){
                  if(g_data['p']==1)g_farge=g_ofarge;
                  makepoint(x0,y0);
                }
              }
            }
  
            if(mb==RIGHT){

              if(g_multic>0){
                if(g_multic==1||g_hzoomer==2){
                  if(g_data['Z']==0)clearpoint(x0,y0);
                  if(g_data['Z']==1){
                    clearpoint(x0-x+x0,y+(y0-y));
                    clearpoint(x0-x+x0,y+(y0-y)+1);
                  }
                }else{              
               clearpoint(x0,y0);}
              }else
              {
               clearpoint(x0,y0);
              }
             }
             
             
            }
           }
          }
         }
    g_farge=g_ofarge;
    return;
    
}

void craft(int x,int y, int c)
{
  //foundational brush control
  //whether hard coded, circular or bitmap brush
  int calc,mb;
  int a1,b1,s1,x0,y0,midx,midy,passes,ofx,ofy;
  ofx=x;
  ofy=y;
  mb=g_button;
  
  clear_fxtrigger(0);
       
  if(g_btype==1){
    if(g_bsize<4){
      //some hardcoded brushes
          switch(g_bsize)
          {
          case 0:
            doborx(ofx,ofy,ofx+1,ofy+1);
          break;
          case 1:
            if(g_data['c']==1||g_shift==true){
              ofx=ofx+1;
              ofy=ofy+1;
            }
            doborx(ofx-1,ofy-1,ofx+1,ofy+1);
          break;
          case 2:
            if(g_data['c']==1||g_shift==true){
              ofx=ofx+2;
              ofy=ofy+2;
            }
            doborx(ofx-2,ofy-2,ofx+1,ofy+1);
          break;
          case 3:
          if(g_data['c']==1||g_shift==true){
              ofx=ofx+3;ofy=ofy+3;
            }
            doborx(ofx-3,ofy-3,ofx+4,ofy+4);
          break;
          }
    }
    else
    {  //larger size brushes
      calc=g_bsize-3;
      calc=calc*calc;
      calc=calc+4;
      doborx(x-calc,y-calc,x+calc,y+calc);
    }
    return;
  }

  if(g_btype==9){ //bitmap brush  
    bitmap_brush(x,y,c);
    return;
  }
  
  int hs=1;

  if(g_multic==1 || g_hzoomer==2)hs=2;

    if(g_bsize<4){
      switch(g_bsize)
      {
      case 0:
        createpoint(x,y,g_button);
      break;
      case 1:
        createpoint(x,y+1,g_button);
        createpoint(x,y-1,g_button);
        createpoint(x,y,g_button);
        createpoint(x-1,y,g_button);
        createpoint(x+hs,y,g_button);
      break;
      case 2:        
        doborx(x-1,y-2,x+1,y+2);
        doborx(x-(1+hs),y-1,x+2,y+1);       
      break;
      case 3:
        doborx(x-3,y-1,x+3,y+1);
        doborx(x-(1+hs),y-2,x+2,y+2);
        doborx(x-1,y-3,x+1,y+3);
      break;
      }
    }else
    {
      calc=g_bsize-3;
      calc=calc*calc;calc=calc+4;
      docircx(x,y,calc,calc);
    }
}

void doline(int xfrom,int yfrom,int xto,int yto,int prevent)
{
  //bresenham almost exactly from Wikipedia
  int swap,pex,pey;
  boolean steep;
  //multicolor 160 pixel reso
  
  int startpoint=0;
  
  if(g_pixelw==2){
    xfrom=xfrom/2;
    xfrom=xfrom*2;
    xto=xto/2;
    xto=xto*2;
  }
  
  g_mousevectorx=0;
  g_mousevectory=0;
  
  craft(xfrom,yfrom,0);
  pex=xfrom;pey=yfrom;
   
  if(prevent==0)craft(xto,yto,0); 
  if(g_pixelw==2){xfrom=xfrom/2;xto=xto/2;}
  
  int x0=xfrom;
  int y0=yfrom;
  int x1=xto;
  int y1=yto;
  
  steep=abs(y1 - y0) > abs(x1 - x0);

  if(steep){
    swap=x0;x0=y0;y0=swap;
    swap=x1;x1=y1;y1=swap;
  }  

  float deltax = abs(x1 - x0);
  float deltay = abs(y1 - y0);
  float error = deltax/2;
  int ystep;
   
  if(deltax==0)return;
  
  int y = y0;
  int inc;
   
  if(x0<x1){inc=1;}else{inc=-1;}
  if(y0<y1){ystep=1;}else{ystep=-1;}
  int x;
  x=x0;
  while(x!=x1){
    if(steep){
      if(y*g_pixelw!=pex||x!=pey){
        craft(y*g_pixelw,x,0);
        pex=y*g_pixelw;pey=x;
      }
    }
    else
    {
      if(x*g_pixelw!=pex||y!=pey){
        craft(x*g_pixelw,y,0);
        pex=x*g_pixelw;pey=y;
      }
    }
     
    error=error-deltay;
    if(error<0){
      y=y+ystep;
      g_mousevectory=ystep*2;
      error=error+deltax;  
    }
    x=x+inc;
    g_mousevectorx=inc*2;
    
   // if(startpoint==0){startpoint=1;craft(xfrom,yfrom,0);}
  
  }
  
}
  

void docircx(int xf,int yf,int hh,int vv)
{
  
  int hmod=0;
  if(g_multic==1||g_hzoomer==2){
    xf=xf-1;
    xf=xf/2;
    xf=xf*2;
    hh=hh/2;
    hh=hh*2;
    hmod=1;
  }
    
  //circle for brush drawing
  float prop;
  float fh=hh;
  float fv=vv;
  if(vv>0){
    prop=fh/fv;
  }else{
    prop=1;
  }
  hh++;
  for(int ii=-hh;ii<=hh;ii++){
    for(int jj=-vv;jj<=vv;jj++){
      int mod=0;
      if(ii>=0)mod=1&hmod;
      if(round(dist(xf+ii+mod,yf+jj*prop,xf,yf))<=hh-1){
        createpoint(xf+ii,yf+jj,g_button);
      }
    }
  }
}

void elhipse(int x,int y,int rx,int ry)
{
    //ellipse(x,y,rx*2,ry*2);
    
    for(int j=0;j<=ry;j++)
    {
        int ex=(int)round(sqrt(rx*rx*(1.0-float(j*j)/float(ry*ry))));
        doline(x+ex,y-j,x-ex,y-j,0);
        doline(x+ex,y+j,x-ex,y+j,0);
    }
}

// based on Marq's ellipse code
void docircle(int x1,int y1,int x2,int y2)
{

  if(x2<x1)x2=x1-(x2-x1);
  if(y2<y1)y2=y1-(y2-y1);
    if(g_data['t']==1&&x2>x1+15)x2=x1+16;
    if(g_data['t']==1&&y2>y1+15)y2=y1+16; 
    
    int rx=abs(x2-x1);
    int ry=abs(y2-y1);
    int x=x1;
    int y=y1;
    int mag=1;
    
    if(g_multic==1||g_hzoomer==2){
      x1=x1/2;
      x1=x1*2;
      x2=x2/2;
      x2=x2*2;
      rx=abs(x2-x1);
      rx=rx/2;
      x=x1;      
      mag=2;
    }
  
  int primer=1;
  if(g_machine==VICM)primer=0;
  
  if(g_data['f']==1&&g_btype!=9){
    if(primer==1){
      if(g_multic==1&&g_data['d']==0){
        g_farge=g_map[1];
        //elhipse(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
        docircx(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
        g_farge=g_ofarge;     
      }
    }
    docircx(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
    //elhipse(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
    return;
  }
  
    for(int j=0;j<=ry;j++)
    {
        int ex=(int)round(sqrt(rx*rx*(1.0-float(j*j)/float(ry*ry))));
            
        if(g_multic==1||g_hzoomer==2){
          ex=ex*2;
        }
        craft(x+ex,y+j,g_button);
        craft(x-ex,y+j,g_button);
        craft(x+ex,y-j,g_button);
        craft(x-ex,y-j,g_button);
    }
    
    for(int i=0;i<=rx;i++)
    {
        int ey=(int)round(sqrt(ry*ry*(1.0-float(i*i)/float(rx*rx))));
        craft(x+i*mag,y+ey,g_button);
        craft(x-i*mag,y+ey,g_button);
        craft(x+i*mag,y-ey,g_button);
        craft(x-i*mag,y-ey,g_button);
    }
  
}

/*

void old_docircle(int x1,int y1,int x2,int y2)
{
  float dds,a,t,sx,sy,gear1,gear2,x0,y0;
  int kimea,prex,prey;
  int primer=1;
  if(g_machine==VICM)primer=0;
  
  dds=dist(x1,y1,x2,y2);
  gear1=int(dds);
  if(gear1<=12)gear1=12;
  if(gear1>120)gear1=120;
  gear2=int(gear1*2);

  if(x2<x1)x2=x1-(x2-x1);
  if(y2<y1)y2=y1-(y2-y1);
  
  if(g_data['t']==1&&x2>x1+15)x2=x1+16;
  if(g_data['t']==1&&y2>y1+15)y2=y1+16; 
  
  prex=0;prey=0;
  kimea=y1-(y2-y1);
  
  if(g_data['f']==1&&g_btype!=9){
    if(primer==1){
      if(g_multic==1&&g_data['d']==0){
        g_farge=g_map[1];
        //elhipse(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
        docircx(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
        g_farge=g_ofarge;     
      }
    }
    docircx(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
    //elhipse(x1,y1,abs(x2-int(x1)),abs(y2-int(y1)));
    return;
  }
     
  for(t=0;t<=(gear2);t++){
   a=t/(gear1)*PI;
   sx=(x2-x1)*sin(a);sy=(y1-y2)*cos(a);
   if(t>0)doline(prex,prey,x1+int(sx),y1+int(sy),1);  
   prex=(x1+int(sx));prey=(y1+int(sy)); 
  }
  
  int x=x1;
  int y=y1;
  int rx=x2-x1;
  int ry=y2-y1;
  
  // Marq's ellipse code
  
    for(int j=0;j<=ry;j++)
    {
        int ex=(int)round(sqrt(rx*rx*(1.0-float(j*j)/float(ry*ry))));
        
        createpoint(x+ex,y+j,g_button);
        createpoint(x-ex,y+j,g_button);
        createpoint(x+ex,y-j,g_button);
        createpoint(x-ex,y-j,g_button);
    }
    
    for(int i=0;i<=rx;i++)
    {
        int ey=(int)round(sqrt(ry*ry*(1.0-float(i*i)/float(rx*rx))));
        createpoint(x+i,y+ey,g_button);
        createpoint(x-i,y+ey,g_button);
        createpoint(x+i,y-ey,g_button);
        createpoint(x-i,y-ey,g_button);
    }
}

*/

void rectangle(int x1,int y1,int x2,int y2)
{
  int x0,y0;
  int yt,xt;
  int xf,yf;
  
  int primer=1;
  if(g_machine==VICM)primer=0;
  
  xf=x1/8;
  xf=xf*8;
  
  xt=x2/8;
  xt=xt*8;
  
  yf=y1/8;
  yf=yf*8;
  
  yt=y2/8;
  yt=yt*8;
  
  yt=yt+7;
  xt=xt+6;
  
  if(x2<x1){x0=x2;x2=x1;x1=x0;}
  if(y2<y1){y0=y2;y2=y1;y1=y0;}
  
  if(g_data['t']==1&&x2>x1+31)x2=x1+32;
  if(g_data['t']==1&&y2>y1+31)y2=y1+32;  
  
  if(g_btype!=9){
    if(g_data['c']==1||g_shift){
      if(x2>x1)x2--;
      if(y2>y1)y2--;
    }
  }

  if(g_data['f']==1&&g_btype!=9){
    
    if(primer==1){
    
      if(g_multic==1&&g_data['d']==0){
         g_farge=g_map[1];
         for(int y=y1;y<=y2;y++){
            for(int x=x1;x<=x2;x=x+g_pixelw){
              if(x>=xf&&y>=yf&&x<=xt&&y<=yt){
               makepoint(x,y);
              }
            }
          }       
      }
    }
    
    g_farge=g_ofarge;
    if(g_button==RIGHT)g_farge=g_backg;
    for(int y=y1;y<=y2;y++){
      for(int x=x1;x<=x2;x=x+g_pixelw){
        makepoint(x,y);
      }
    }
  }
  if(g_data['f']==0||g_btype==9){
    if(g_data['c']==1&&g_btype==1){
      if(x2>x1){
        if(g_bsize==0)x2--;
        if(g_bsize==1)x2=x2-2;
        if(g_bsize==2)x2=x2-3;
        if(g_bsize==3)x2++;
      }
      if(y2>y1){
        if(g_bsize==0)y2--;
        if(g_bsize==1)y2=y2-2;
        if(g_bsize==2)y2=y2-3;
        if(g_bsize==3)y2++;
      }      
    }
    doline(x1,y1,x2,y1,0);
    doline(x1,y1,x1,y2,0);
    doline(x1,y2,x2,y2,0);
    doline(x2,y2,x2,y1,0);
  }
  g_farge=g_ofarge;
}

void makepoint(int xx,int yy)
{
  //central pixelmaking function
  //has become very messy but what are you gonna do
  
  int userxs[]=new int[8];
  int fars[]=new int[8];
  
  int mirrix=0;
  int mirriy=0;
  int tiler=0;
  int ignore=0;
  int fari;
  int usedcolor=g_farge;
  
  //hastily done VICm back1 back2 exception
  
  if((g_usablecolor[usedcolor]&8)==0){
    if(g_machine==VICM){
        if(g_map[1]!=usedcolor&&g_map[2]!=usedcolor){
        return;
      }
    }
    if(g_machine==VIC){
      if(g_map[1]!=usedcolor){
        return;
      }
    }  
  }
  
   int DX=MX;
   if(g_machine==VIC)DX=MX/2;
      
  //for the X/Y mirrors & tiler, the function calls itself with x+10000 or y+10000
  //resolved here
  

  /*
    if(xx>=20000){
      xx=xx-20000;
      mirrix=0;
      mirriy=0;
      tiler=1;
    }
    if(xx>=10000){
      xx=xx-10000;
      mirrix=1;
      mirriy=1;
    }
    if(yy>=10000){
      yy=yy-10000;
      mirriy=1;
      mirrix=1;
    }
    */
    
    tiler  = xx / 20000;   // 1 if xx >= 20000, else 0
    xx    %= 20000;        // remove the 20000 component
    
    mirrix = xx / 10000;   // 1 if xx >= 10000, else 0
    xx    %= 10000;        // strip 10000 if present
    
    mirriy = yy / 10000;   // 1 if yy >= 10000, else 0
    yy    %= 10000;        // strip 10000 if present
    
    // consistency handling (if mirroring implies both axes)
    if (mirrix == 1 || mirriy == 1) {
      mirrix = 1;
      mirriy = 1;
    }
    
    if(xx<0||yy<0||xx>=X||yy>=Y)return;
    
    if(g_pixelw==2){
      xx=xx/2;
      xx=xx*2;
    }

    if(g_data['r']==1){//simple dither
      if(get_raster(xx,yy)==0)ignore=1;
    }
  
  if(g_data['R']==1){//user defined dither
    if(g_bsourcex2 > g_bsourcex && g_bsourcey2 > g_bsourcey){

    int x0=xx/((g_bsourcex2+1)-g_bsourcex);
    int y0=yy/((g_bsourcey2+1)-g_bsourcey);
    int x1=xx-x0*((g_bsourcex2+1)-g_bsourcex);
    int y1=yy-y0*((g_bsourcey2+1)-g_bsourcey);
    int xr=g_bsourcex+x1;
    int yr=g_bsourcey+y1;
    if(g_multic==1||g_hzoomer==2){
       x0=xx/((g_bsourcex2+2)-g_bsourcex);
       y0=yy/((g_bsourcey2+1)-g_bsourcey);
       x1=xx-x0*((g_bsourcex2+2)-g_bsourcex);x1=x1/2;x1=x1*2;
       y1=yy-y0*((g_bsourcey2+1)-g_bsourcey);
       xr=g_bsourcex+x1;xr=xr/2;xr=xr*2;
       yr=g_bsourcey+y1;    
       if(getmultic(xr,yr,1)==g_backg)ignore=1;
      }else{
         if(easygetcolor_brush(xr,yr)==g_backg)ignore=1;
      }
    }
  }
  
    // ULAPLUS adaptive color always, even with floodfill
      
    if(g_machine==ULAPLUS && ignore==0 && g_data['d']==0){
      ulakaveri(xx,yy,usedcolor,0,0);
    }
    
    //  floodfill no longer has unique system
        
    if(g_machine!=ULAPLUS && ignore==0){
      
      if(g_multic==2||g_multic==3||g_multic==4){
        skaveri(xx,yy,usedcolor,0);
      }
      
      if(g_multic!=2){
         if(g_multic==1){
            pre_examine_mc(xx,yy,usedcolor,0);
         }
         else
         { 
           kaveri(xx,yy,usedcolor,0);
         }
      }
    }
  
    
 int xc,yc;
 
 // 'd' mode
 
 if(ignore==0 && g_data['d']==1){
   
   if(g_multic>=3){
     if(easygetcolor(xx,yy)==g_backg){
       usedcolor=g_farge;
     }else{
       ignore=1;
     }     
   }
   
   if(g_attrimode<=1 && g_machine!=ULAPLUS){
     int aba,baba,ii,jj,miny,maxy,ojox,ojoy;
     aba=getattra(xx,yy,0);
     baba=getattra(xx,yy,1);
    
     if(g_multic==0){
       
       ojox = xx & ~7; 
       ojoy = yy & ~7;

       miny=(yy-ojoy);
       maxy=miny;
       if(g_attrimode==1){miny=0;maxy=7;}
       if(baba==g_backg)simplepaint(xx,yy,1,usedcolor);
       if(aba==g_backg)simplepaint(xx,yy,0,usedcolor);
       ignore=1;
       if(g_farge==baba&&g_farge==aba){
          for(jj=miny;jj<=maxy;jj++){
             for(ii=0;ii<8;ii++){
               g_map[1024+ojox+ojoy*X+ii+jj*X]=0;
             }
           }
         }
    }
    
    else
    
    {
      if(aba==g_backg){
        ignore=0;}
      else{ignore=1;}
    }
    xc=xx/CX;
    yc=yy/CY;
    g_redo[xc+yc*DX]=byte(0);//block update
    g_remdo[xc+yc*DX]=byte(1);//block update
   }
 }
 
 if(ignore==0 && g_data['d']==1 && g_machine==ULAPLUS){
   ignore=1;
   int mx=xx/8;
   int my=yy/8;
      for(int yv=0;yv<8;yv++){
         for(int xv=0;xv<8;xv++){
         int under = easygetcolor(mx*8+xv,my*8+yv);
         if(comparecolors(under,g_backg)){
           ulakaveri(mx*8+xv,my*8+yv,usedcolor,0,1);//query
           ulapoint(mx*8+xv,my*8+yv,usedcolor);
         }
       }
     }    
     
    g_redo[mx+my*MX]=byte(0);//block update
    g_remdo[mx+my*MX]=byte(1);//block update
 }
 
 if(ignore==0){
   float rr=0;
   float gg=0;
   float bb=0;
   switch (int(g_data[FX])){
   case SHADE:
     int range_start=int(g_map[240]);
     int range_end=int(g_map[241]);
     int under=easygetcolor(xx,yy);
     usedcolor=under;
     if(under>=range_start&&under<=range_end){
       if(g_operations[xx+yy*X]==0){
         g_operations[xx+yy*X]=1;
         if(g_button==LEFT)under--;
         if(g_button==RIGHT)under++;
         if(under<range_start)under=range_start;
         if(under>range_end)under=range_end;
         usedcolor=under;
       }
     }   
   break;
   case SMOOTH:
      usedcolor=easygetcolor(xx,yy);
       if(g_operations[xx+yy*X]==0){
         g_operations[xx+yy*X]=1;
         under=easygetcolor(xx,yy);
         rr=rr+g_r[under];
         gg=gg+g_g[under];
         bb=bb+g_b[under];         
         under=easygetcolor(xx+1,yy);
         rr=rr+g_r[under];
         gg=gg+g_g[under];
         bb=bb+g_b[under];
         under=easygetcolor(xx-1,yy);
         rr=rr+g_r[under];
         gg=gg+g_g[under];
         bb=bb+g_b[under];
         under=easygetcolor(xx,yy-1);
         rr=rr+g_r[under];
         gg=gg+g_g[under];
         bb=bb+g_b[under];
         under=easygetcolor(xx,yy+1);
         rr=rr+g_r[under];
         gg=gg+g_g[under];
         bb=bb+g_b[under];         
         rr=rr/5.0;gg=gg/5.0;bb=bb/5.0;
         usedcolor=findclosest(rr,gg,bb);
       }
   break;
   case DARKEN:
      int dd=1;
      under=easygetcolor(xx,yy);
      usedcolor=under;
      if(g_button==RIGHT)dd=-1;     
      if(g_operations[xx+yy*X]==0){
          g_operations[xx+yy*X]=1;
          //under=easygetcolor(xx,yy);
          rr=rr+g_r[under]-(g_divsr)*dd;
          gg=gg+g_g[under]-(g_divsg)*dd;
          bb=bb+g_b[under]-(g_divsb)*dd;       
          
          usedcolor=findclosest(rr,gg,bb);
         }         
   break;
   case MIX:
      under=easygetcolor(xx,yy);
      usedcolor=under;  
      if(g_operations[xx+yy*X]==0){
          g_operations[xx+yy*X]=1;
          under=easygetcolor(xx,yy);
          rr=rr+g_r[under]+g_r[g_farge];
          gg=gg+g_g[under]+g_g[g_farge];
          bb=bb+g_b[under]+g_b[g_farge];
          rr=rr/2.0;
          gg=gg/2.0;
          bb=bb/2.0;
          usedcolor=findclosest(rr,gg,bb);
        }
   break;
   case TINT:
      under=easygetcolor(xx,yy);
      usedcolor=under;    
      if(g_operations[xx+yy*X]==0){
         g_operations[xx+yy*X]=1;
          under=easygetcolor(xx,yy);
          float brt=brightness(color(g_r[under],g_g[under],g_b[under]));
          if(g_button==LEFT){
            rr=(brt*g_r[g_farge])/256.0;
            gg=(brt*g_g[g_farge])/256.0;
            bb=(brt*g_b[g_farge])/256.0;
          }else{
            rr=brt;
            gg=brt;
            bb=brt;            
          }
          usedcolor=findclosest(rr,gg,bb);
        }   
   break;
   case SMEAR:
      int ug=easygetcolor(xx,yy);
      if(int(g_map[12])==8||int(g_map[12])==7){
        if(g_data['f']==1){
          g_mousevectorx=-2+int(random(4));
          g_mousevectory=-2+int(random(4));
        }
      }
       usedcolor=ug;
       if(g_operations[xx+yy*X]==0){
           g_operations[xx+yy*X]=1;
           ug=recallpoint(xx,yy);
           usedcolor=ug;
           xx=xx+g_mousevectorx;
           yy=yy+g_mousevectory;
           if(xx>X-1)xx=X-1;
           if(yy>Y-1)yy=Y-1;
           if(xx<0)xx=0;
           if(yy<0)yy=0;
        }   
   break;
   case BLENDER:
      ug=easygetcolor(xx,yy);
      if(int(g_map[12])==8||int(g_map[12])==7){
        if(g_data['f']==1){
          g_mousevectorx=-2+int(random(4));
          g_mousevectory=-2+int(random(4));
        }
      }
       usedcolor=ug;
       if(g_operations[xx+yy*X]==0){
           g_operations[xx+yy*X]=1;
           ug=recallpoint(xx,yy);
           usedcolor=ug;
           xx=xx+g_mousevectorx;
           yy=yy+g_mousevectory;
           if(xx>X-1)xx=X-1;
           if(yy>Y-1)yy=Y-1;
           if(xx<0)xx=0;
           if(yy<0)yy=0;
           //BLENDER
              under=easygetcolor(xx,yy);
              rr=g_r[under]+g_r[ug]*2;
              gg=g_g[under]+g_g[ug]*2;
              bb=g_b[under]+g_b[ug]*2;
              rr=rr/3;
              gg=gg/3;
              bb=bb/3;              
              usedcolor=findclosest(rr,gg,bb);  
        }   
   break;   
   case BITFY:
      under=easygetcolor(xx,yy);
      usedcolor=under;  
      if(g_operations[xx+yy*X]==0){
          g_operations[xx+yy*X]=1;
          under=easygetcolor(xx,yy);
          rr=g_r[under];
          gg=g_g[under];
          bb=g_b[under];
          int xb=xx/8;
          int yb=yy/8;
          int xf=xx-xb*8;
          int yf=yy-yb*8;
          int bay=g_bayer[xf+yf*8];
          int brt=int(brightness(color(rr,gg,bb)));
          usedcolor=g_backg;
          if(brt>bay)usedcolor=g_farge;
        }   
   break;
   case SHIFTER:
      under=easygetcolor(xx,yy);
      usedcolor=under;  
      if(g_operations[xx+yy*X]==0){
          g_operations[xx+yy*X]=1;
          usedcolor=easygetcolor(xx+1,yy);          
        }       
   break;
   }
  
 }
 
 // now the real drawing
 
 if(ignore==0){
   
   xc=xx / CX;
   yc=yy / CY;   
   
   g_redo[xc+yc*DX]=byte(0);//block update
   g_remdo[xc+yc*DX]=byte(1);//block update

   switch (g_multic)
   {
       
     case 0://1-bit + attribute i.e. spectrum
       
       if(g_machine==ULAPLUS)
       {
         ulapoint(xx,yy,usedcolor);
       }
         else
       {
         hirespoint(xx,yy,usedcolor);
       }
       
     break;
   
     case 1: //c64 style zoomed multicolour
      
        //foreg
        int looks,skippo;
        byte bit1,bit2,valu1,valu2;
        int metax,metay,mex,mey,metamax;
        fari=usedcolor;
        int bord=int(g_map[0]);
        int zeroc=int(g_map[1]);
        int zeroc2=int(g_map[2]);
        boolean cut=false;
        
        if(fari==zeroc){ //shortcut
             g_map[1024+xx+yy*X]=byte(0);
             g_map[1024+xx+yy*X+1]=byte(0);
             cut=true;
        }
        if(g_machine==PLUS4M&&fari==zeroc2){ //shortcut
             g_map[1024+xx+yy*X]=byte(1);
             g_map[1024+xx+yy*X+1]=byte(1);
             cut=true;
        }
        if(g_machine==VICM&&fari==bord){ //shortcut1
             g_map[1024+xx+yy*X]=byte(0);
             g_map[1024+xx+yy*X+1]=byte(1);
             cut=true;
        }           
        if(g_machine==VICM&&fari==zeroc2){ //shortcut2
             g_map[1024+xx+yy*X]=byte(1);
             g_map[1024+xx+yy*X+1]=byte(1);
             cut=true;
        }      
        
        if(cut){
             // X Y mirrors      
             if(g_data['t']==1){
               if(tiler==0){
                 int ex=X;
                 if(g_gridx>0)ex=ex/g_gridx;
                 int ey=Y;
                 if(g_gridy>0)ey=ey/g_gridy;
                 for(int tilx=-ex;tilx<=ex;tilx++){
                   for(int tily=-ey;tily<=ey;tily++){
                       makepoint(20000+xx+(X/ex)*tilx,yy+(Y/ey)*tily);
                   }
                 }
               }
               return;
             }           
             if(g_data['X']==1&&mirrix==0)makepoint(10000+(X-1)-xx,yy);
             if(g_data['Y']==1&&mirriy==0)makepoint(xx,10000+(Y-1)-yy);
             if(g_data['X']==1&&g_data['Y']==1){if(mirrix==0){makepoint(10000+(X-1)-xx,10000+(Y-1)-yy);}}
             return;
        }     
        
        userxs[0]=0;
        userxs[1]=0;
        userxs[2]=0;
        userxs[3]=0;
        fars[0]=zeroc;
        fars[1]=zeroc;
        fars[2]=zeroc;
        fars[3]=zeroc;
        mex=xx/CX;
        mey=yy/CY;
        looks=65536+mex+mey*MX;
        mex=mex*CX;
        mey=mey*CY;
        
        if(g_machine==VIC||g_machine==VICM){
          mex=xx/CX;
          mey=yy/CY;
          looks=65536+mex+mey*(DX);
          mex=mex*CX;
          mey=mey*CY;
        }
        int saps=1024+mex+mey*X;
         
        // determine which colours are already used in the colour mem area
        
        for(metay=0;metay<CY;metay++){
         for(metax=0;metax<CXM;metax++){
           saps=1024+mex+mey*X+metax*2+metay*X;
           int pars=g_map[saps]+g_map[saps+1]*2;
           userxs[pars]=1;
           if(pars==0)fars[0]=zeroc;
           if(pars==1)fars[1]=int(g_map[looks]);
           if(pars==2)fars[2]=int(g_map[looks+1000]);
           if(pars==3){
             if(g_machine==C64M)fars[3]=int(g_map[looks+2000]);
             if(g_machine==PLUS4M)fars[3]=zeroc2;
             if(g_machine==VICM)fars[3]=zeroc2;
           }   
         }
        }
  
        bit1=0;
        bit2=0;
        skippo=0;
        
        // mega-escape, if it's not possible to draw at all don't bother
        // apparently pre_examine_mc routines cover re-coloring of existing colours
        
        if(userxs[0]==1&&userxs[1]==1&&userxs[2]==1&&userxs[3]==1){
          if(fari!=fars[0]&&fari!=fars[1]&&fari!=fars[2]&&fari!=fars[3])skippo=100;
        }
   
        if(skippo==0){
          int okay=0; 
          // fixed finally, how many "proper" colours in addition to background(s), can the multicolor do
          metamax=g_charlimit;
          //if(machine==PLUS4M)metamax=2; //old kludge
          
          // if the color is already in the 4x8 area?
          
          for(metay=0;metay<=metamax;metay++){
            if(userxs[metay]==1){
                if(fars[metay]==fari){
                  if(metay==1){
                    bit1=1;
                    bit2=0;
                    g_map[looks]=byte(fari);
                  }
                  if(metay==2){
                    bit1=0;
                    bit2=1;
                    g_map[looks+1000]=byte(fari);
                  }
                  if(metay==3){
                    bit1=1;
                    bit2=1;
                    if(g_machine==C64M)g_map[looks+2000]=byte(fari);
                    if(g_machine==PLUS4M)g_map[looks+2000]=byte(zeroc2);
                    if(g_machine==VICM)g_map[looks+2000]=byte(zeroc2);
                  }
                  g_map[1024+xx+yy*X]=bit1;
                  g_map[1024+xx+yy*X+1]=bit2;
                  okay=1;       
              }
            }
          }
      
          //if the color is not in the 4x8 area CXM*CY
          // the actual, actual drawing of bits
          
          if(okay==0){
            for(metay=1;metay<=metamax;metay++){
              if(userxs[metay]==0){
                 userxs[metay]=1;
                 if(metay==1){bit1=1;bit2=0;g_map[looks]=byte(fari);userxs[2]=1;}
                 if(metay==2){bit1=0;bit2=1;g_map[looks+1000]=byte(fari);userxs[3]=1;}
                 if(metay==3){bit1=1;bit2=1;
                   if(g_machine==C64M)g_map[looks+2000]=byte(fari);
                   if(g_machine==PLUS4M)g_map[looks+2000]=byte(zeroc2);
                   if(g_machine==VICM)g_map[looks+2000]=byte(zeroc2);
                 }   
                 g_map[1024+xx+yy*X]=bit1;
                 g_map[1024+xx+yy*X+1]=bit2;    
              }
            }  
          }
      
      }//skippo0
      
   break;
   
   case 2: // VGA style i.e. Amiga, CPC
     fari=g_farge;
        
     if(g_data['d']==1){
         if(g_map[1024+xx+yy*X]==byte(g_backg)){
           g_map[1024+xx+yy*X]=byte(usedcolor);
           if(g_hzoomer==2) g_map[1024+xx+yy*X+1]=byte(usedcolor);
         }
       }
       else
       {
         g_map[1024+xx+yy*X]=byte(usedcolor);
         if(g_hzoomer==2)g_map[1024+xx+yy*X+1]=byte(usedcolor);
       }
     break;
     
    case 3: // wide nybblemode, testing
      fari=usedcolor;    
      bpl_putxy(xx/2,yy,fari);
    break;
    
    case 4: // nybblemode, testing
      fari=usedcolor;    
      bpl_putxy(xx,yy,fari);
    break;
   }
 }
 
 // end ignore
 
 // X Y mirrors & tiler
 
 
   if(g_data['t']==1){
     if(tiler==0){
       int ex=X;
       if(g_gridx>0)ex=ex/g_gridx;
       int ey=Y;
       if(g_gridy>0)ey=ey/g_gridy;
       for(int tilx=-ex;tilx<=ex;tilx++){
         for(int tily=-ey;tily<=ey;tily++){
             makepoint(20000+xx+tilx*g_gridx,yy+tily*g_gridy);
           }
         }
     }
     
     return; // tiler overrides mirror
   }
   
   
   if(g_data['X']==1 && mirrix==0)makepoint(10001+g_mirrorx-(xx-g_mirrorx),yy);
   if(g_data['Y']==1 && mirriy==0)makepoint(xx,10001+g_mirrory-(yy-g_mirrory)); 
   if(g_data['X']==1 && g_data['Y']==1){
     if(mirrix==0)makepoint(10001+g_mirrorx-(xx-g_mirrorx),10001+g_mirrory-(yy-g_mirrory));
   }
}



void clearpoint(int xx,int yy)
{
  if(g_multic==2||g_multic==3||g_multic==4){
    g_farge=g_backg;makepoint(xx,yy);g_farge=g_ofarge;return;
  }
  if(g_multic==1){
    xx=xx/2;xx=xx*2;
  }
  g_farge=g_backg;makepoint(xx,yy);g_farge=g_ofarge;return;
}


void absolute_clearpoint(int xx,int yy)
{
  int mirrix=0;
  int mirriy=0;
  int ignore=0;
  if(xx>=10000){xx=xx-10000;mirrix=1;mirriy=1;}
  if(yy>=10000){yy=yy-10000;mirriy=1;mirrix=1;}
  if(xx<0)return;
  if(yy<0)return;
  if(xx>=X)return;
  if(yy>=Y)return;
  
  if(g_multic==2&&g_hzoomer!=2){
    g_farge=g_backg;makepoint(xx,yy);g_farge=g_ofarge;return;
  }
  if(g_multic==1||g_hzoomer==2){
    xx=xx/2;xx=xx*2;
  }
  if(g_data['b']==1)return;
  if(g_data['r']==1){//raster
    if(get_raster(xx,yy)==0)ignore=1;
  }
  
  if(g_data['R']==1){ //user defined raster
    if(g_bsourcex2>g_bsourcex&&g_bsourcey2>g_bsourcey){
      int x0=xx/((g_bsourcex2+1)-g_bsourcex);
      int y0=yy/((g_bsourcey2+1)-g_bsourcey);
      int x1=xx-x0*((g_bsourcex2+1)-g_bsourcex);
      int y1=yy-y0*((g_bsourcey2+1)-g_bsourcey);
      int xr=g_bsourcex+x1;
      int yr=g_bsourcey+y1;
      if(g_brush[1024+xr+yr*X]==0)ignore=1;
    }
  }
  
  if(ignore==0){
    if(g_multic!=3&&g_multic!=4){
      g_map[1024+xx+yy*X]=byte(0);
      if(g_multic==1||g_hzoomer==2)g_map[1024+xx+yy*X+1]=byte(0);
    }
    int xc=xx/CX;
    int yc=yy/CY;
    int DX=MX;
    if(g_machine==VIC)DX=MX/2;
    g_redo[xc+yc*DX]=byte(0);//block update
    g_remdo[xc+yc*DX]=byte(1);//block update
  }
  if(g_data['X']==1&&mirrix==0)clearpoint(10000+(X-1)-xx,yy);
  if(g_data['Y']==1&&mirriy==0)clearpoint(xx,10000+(Y-1)-yy);
  if(g_data['X']==1&&g_data['Y']==1){
    if(mirrix==0)clearpoint(10000+(X-1)-xx,10000+(Y-1)-yy);
  }
}

void simplepaint(int xx,int yy,int mode,int attr)
{
  int ad,swad,j,miny,maxy,ojyx;
  xx=xx/8;
  ojyx=yy/8;ojyx=ojyx*8;
  ad=0;swad=0;
  miny=yy-ojyx;maxy=miny;
  if(g_attrimode==1){
    miny=0;maxy=7;
  }
  for(j=miny;j<=maxy;j++){
     if(mode==0){
         ad=65536+xx+(ojyx+j)*MX;
         swad=65536+xx+(ojyx+j)*MX+(MX*MY)*8;
     }
     if(mode==1){
         ad=65536+xx+(ojyx+j)*MX+(MX*MY)*8;
         swad=65536+xx+(ojyx+j)*MX;
     }
     if(g_britemode==1&&g_machine!=ULAPLUS){
       if(attr==8)attr=0;
       if(attr>0){
         if(attr>=8&&g_map[swad]<=7)g_map[swad]=byte(g_map[swad]+8);
         if(attr<=7&&g_map[swad]>=8)g_map[swad]=byte(g_map[swad]-8);
       }
     }
     g_map[ad]=byte(attr);
  }
}

void storecoords(int x,int y){
  
  int ox,oy,psizex,psizey;
  
  psizex=g_magpix[magmode()];
  psizey=g_magpiy[magmode()];
  
  if(g_maglevel<0){
    x=x/psizex;
    y=y/psizey;      
    x=x+g_ofx;
    y=y+g_ofy;
  }
  
  if(g_maglevel>=0){
      x=x/psizex;
      y=y/psizey;
      x=x+g_ofx;
      y=y+g_ofy;
  }
  g_storedcoordx=x;
  g_storedcoordy=y;
}

void do_tool(int x,int y,int mb)
{
  int tt,ox,oy,psizex,psizey;
  
  tt=tool();
  
  psizex=g_magpix[magmode()];
  psizey=g_magpiy[magmode()];
  
  //handles different tool behavior
    
  x=x/psizex;
  y=y/psizey;
  x=x+g_ofx;
  y=y+g_ofy;
  x=x+g_panx;
  y=y+g_pany;
 
  ox=x;oy=y;
  g_storedcoordx=x;g_storedcoordy=y;
 
  int midx=0;
  int midy=0;
  //brush handle mid point
  //some tools are exempted
  if(g_btype==9&&tool()!=4&&tool()!=0&&mb!=255){
      midx=(g_bsourcex2-g_bsourcex)/2;
      midy=(g_bsourcey2-g_bsourcey)/2;
      x=x-midx;y=y-midy;
  } 
  if(g_data['c']==1||g_shift){
    //grid offset
      if(g_gridx>0){
        x=x-int(g_data[XOFFSET]);
        x=x/g_gridx;
        x=x*g_gridx;
        x=x+int(g_data[XOFFSET]);
      }
      if(g_gridy>0){
        y=y-int(g_data[YOFFSET]);
        y=y/g_gridy;
        y=y*g_gridy;
        y=y+int(g_data[YOFFSET]);
      }
  }
  
  if(g_multic==1||g_hzoomer==2){x=x/2;x=x*2;ox=ox/2;ox=ox*2;}

  if(mb==254){//block picker
      switcher(2);g_data['n']=0;g_data['x']=0;g_data['y']=0;g_data['Z']=0;g_data['z']=0;
      if(g_gridx>0){x=ox/g_gridx;x=x*g_gridx;}
      if(g_gridy>0){y=oy/g_gridy;y=y*g_gridy;}
      g_bsourcex=x;g_bsourcey=y;
      g_bsourcex2=x+g_gridx-1;g_bsourcey2=y+g_gridy-1;
      //set_tool(1);
      g_btype=9;
      return;
  }
  
  if(mb>=255){ // color picker pipette, depends on multic
  
    int hand=0;
    if(g_shift)hand=1;
    if(mb>=294)hand=1;
    if(ox<0||oy<0||ox>=X||oy>=Y){
      //message("X!");
      if(g_colorprofile[0]>=1){
        selectcolor(hand,int(g_map[0]));
      }else{
        selectcolor(hand,0);
      }
      return;
    }
    if(g_multic==2||g_multic==3||g_multic==4){
        if(g_hzoomer==2){ox=ox/2;ox=ox*2;}
        selectcolor(hand,getmultic(ox,oy,0));return;
    }
    selectcolor(hand,getabsa(ox,oy,0));
    if(g_multic==1||g_hzoomer==2){
      ox=ox/2;ox=ox*2;
      selectcolor(hand,getattra(ox,oy,0));
    }
    g_ofarge=g_farge;
    if(g_btype==9)g_data['p']=1;
    g_realfront=byte(g_farge);
    return;
  }
  
  if(x>=0&&y>=0&&x<X&&y<Y){
    //println(g_mousex,g_mousey);
    //println(in_window(g_mousex,g_mousey));
    if(in_window(g_mousex,g_mousey)==1){
      help(1000+x+y*X);
    }
  }
  
  //display coordinates
  if(g_phase>0)help(1000+x+y*X);
  
  if(tt==1)craft(x,y,0); //pixeller
  
  if(tt==2){ //spraycan
    //if(random(100)<50){fixed_raster_command('x');}
    //if(random(100)<50){fixed_raster_command('y');}    
    for(int i=0;i<=12;i++){
      int rx=x-10+int(random((10)*2));
      int ry=y-10+int(random((10)*2));
      if(mb==LEFT){
        if(dist(x,y,rx,ry)<10)craft(rx,ry,0);
      }
      else
      {
        if(dist(x,y,rx,ry)<10)craft(rx,ry,0);
      }     
    }
  }
  
  if(tt==3){//cont line
    if(g_phase==0){
      g_prex=x;g_prey=y;craft(x,y,0);
    }
    doline(x,y,g_prex,g_prey,0);
    g_prex=x;g_prey=y;
  }  
   
  if(tt==5){//floodfill
    if(g_klikkeri==0){
      g_klikkeri=1;
      store_parameters();
      g_data['X']=0;g_data['Y']=0;
      g_data['c']=0;g_data['t']=0;
        if(ox<0||oy<0||ox>=X||oy>=Y){
          //changeborder(mb);
        }
      
      if(ox>=0&&ox<X&&oy>=0&oy<Y){
        store_undo();// exceptional!
        if(g_multic!=0){
          if(g_multic==2||g_multic==3){floodfill_iq(ox,oy,mb);}else{
            floodfillmc(ox,oy,mb);
          }
          }
          else
          {
            floodfill_iq(ox,oy,mb);
          }
      }
      restore_parameters();
    }
  }
  
  if(tt==6||tt==7||tt==8){//line,circle,rect
    if(g_phase==0){
      g_rx=x;g_ry=y;
      g_rx2=x;g_ry2=y;
      g_rubbermode=0;
    }
    if(g_phase==1){
      g_rx2=x;g_ry2=y;
    }
  }

  if(tt==0){ // magnifier graphic tool
    g_maglevel=2;
    g_rx=x-(magpixelx()/2);g_orx=x;
    g_ry=y-(magpixely()/2);g_ory=y;
    g_rx2=x+(magpixelx()/2+odd(magpixelx()));
    g_ry2=y+(magpixely()/2+odd(magpixely()));
    g_maglevel=0;
    g_rubbermode=1;
    if(g_phase==1){
       g_boxreconstruct=2;
       g_rubbermode=0;
       g_maglevel=2;
       
       set_tool(g_prevtool);
       g_phase=0;
       g_ofx=x-magpixelx()/2;
       g_ofy=y-magpixely()/2;
       refresh();
       g_repanel=-2;
       return;
    }
  }
  
  if(tt==4){ //brush grabber grab brush
    if(g_phase==0){
       g_rx=x;g_orx=x;
       g_ry=y;g_ory=y;
       g_rx2=x;g_ry2=y;
    }
  
    if(g_phase==1){
      g_rx2=x;g_rx=g_orx;
      g_ry2=y;g_ry=g_ory;
      if(x<g_orx){
        g_rx2=g_orx;g_rx=x;
      }
      if(y<g_ory){
        g_ry2=g_ory;g_ry=y;
      }
      if(g_data['c']==1||g_shift){
        g_rx2--;g_ry2--;
        if(g_multic==1||g_hzoomer==2)g_rx2--;
      }
    }
    g_rubbermode=1;
  }
  
  if(tt==0||tt==4){
    if(g_rubbermode==1){
      for(int xx=g_rx;xx<=g_rx2+2;xx++){
        updatepoint(xx,g_ry);
        updatepoint(xx,g_ry2);
      }
      for(int yy=g_ry;yy<=g_ry2;yy++){
        updatepoint(g_rx,yy);
        updatepoint(g_rx2,yy);
      }
    }
  }
}
