//collects mouse/key events and directly related command parsing

int g_markctr=0;
int g_maglevel;
int g_ylocker=0,g_xlocker=0;
int g_originalx,g_originaly;
int g_panx,g_pany;
int g_lockerid=0;
int g_mousex,g_mousey;
int g_mousevectorx,g_mousevectory;
int g_wheelstarty;
int g_ccontroller=0;

int PRESSED=1;
int DRAGGED=2;
int MOVED=3;
int RELEASED=4;
int HOVER=-4444;
boolean g_panmode=false;
boolean g_panning=false;
boolean g_dragged=false;

float g_percent_x;
float g_percent_y;
float g_percent_prevx;
float g_percent_prevy;

void console_newline(){
    for(int y=0;y<CONHEI-1;y++){
      for(int x=0;x<CONWID;x++){
        g_con[y*CONWID+x]=g_con[y*CONWID+x+CONWID];
      }         
    }
    for(int x=0;x<CONWID;x++){
      g_con[(CONHEI-1)*CONWID+x]=0;
    }     
}

void console_echo(String s){
  for(int i=0;i<s.length();i++){
    char c=s.charAt(i);
    do_console(c);
  }
  console_newline();
}

void do_console(int inp){
  //println(inp);
  if(inp==-1){
    for(int x=0;x<CONWID;x++){
      g_con[(CONHEI-1)*CONWID+x]=g_con[(CONHEI-2)*CONWID+x];
    }
    return;  
  }
  if(inp==8){
    for(int x=0;x<CONWID;x++){
      if(g_con[(CONHEI-1)*CONWID+x]==0){
        g_con[(CONHEI-1)*CONWID+x-1]=0;
        return;
      }
    }         
  }
  if(inp==10||inp==13){
    String comm="";
    for(int x=0;x<CONWID;x++){
      if(g_con[(CONHEI-1)*CONWID+x]!=0)comm=comm+char(g_con[(CONHEI-1)*CONWID+x]);
    }      
    //comm=comm+" ";
    console_newline();
    //comm=comm.toUpperCase();
    x_com(0,comm,0,0,0);
    return;
  }
  if(inp>=32&&inp<=127){
    for(int x=0;x<CONWID;x++){
      if(g_con[(CONHEI-1)*CONWID+x]==0){
        g_con[(CONHEI-1)*CONWID+x]=int(inp);
        return;
      }
    }
  }
}

void mouseWheel(processing.event.MouseEvent event)
{
  float e = event.getCount();
  if(e<-0.1)command(g_wheelup);
  if(e>0.1)command(g_wheeldown);//pull back i.e. zoom out
}

void keyPressed()
{
  if(key==ESC)
  {
    x_com(0,"QUIT",0,0,0);
    key=0;
    return;
  }
  if(find_window(81)>=0){
    if(key==CODED){
      if(keyCode==38){
        do_console(-1);return;
      }
    }
    do_console(int(key));
    return;
  }  
  if(key==CODED){ 
    int pz=8;
    //println(keyCode);  
    if(keyCode==36){
      message("Home");
      g_maglevel=0;
      refocus();
      return;
    }
   // if(g_shift)pz=8;
    if(keyCode==RIGHT)g_ofx=g_ofx+pz;
    if(keyCode==LEFT)g_ofx=g_ofx-pz;
    if(keyCode==UP)g_ofy=g_ofy-pz;
    if(keyCode==DOWN)g_ofy=g_ofy+pz;    
    if(keyCode==SHIFT)g_shift=true;
    if(platform==MACOSX)
    {
      if(keyCode==COMMAND)g_control=true;
    }
    else
    {
      if(keyCode==CONTROL)g_control=true;
    }  
    return;
  }
  
  //send to the indirect key handling
  //so commands can be invoked elsewhere too
  command(key);
}

void keyReleased()
{
  if(key==CODED){
    if(keyCode==CONTROL)g_control=false;
    if(keyCode==SHIFT)g_shift=false;
    if(platform==MACOSX)
    {
      if(keyCode==COMMAND)
      g_control=false;
    }
      else
    {
      if(keyCode==CONTROL)
      g_control=false;
    }  
  }
}


boolean insidewindow(int x,int y)
{
  if(x>=g_realx[1]&&y>=g_realy[1]&&x<=g_realx[1]+g_realw[1]&&y<=g_realy[1]+g_realh[1]){
    //inside VPORT
    return false;
  }
  
  //x_windowman
  if(in_icon(x,y)>=0)return true;
  
  //outside VPORT
  return true;
}

void mouseMoved()
{   
  if(g_markctr>0)g_markctr=10;
  int x=mouseX;
  int y=mouseY;
  if(finger(x,y,-4444,MOVED)>=0)return; 
    if(insidewindow(x,y)==false){
   //   helper_message("can't draw");
    }
}


void mousePressed()
{
    int msx,msy;
    float prevx=g_realx[g_preview_id];
    float prevy=g_realy[g_preview_id];
    
    if(g_global_dragmode>0)return;
    g_dragged=true;
    
    g_ccontroller=1;
    g_iconx=mouseX;
    g_icony=mouseY;
    g_originalx=g_iconx;
    g_originaly=g_icony;
    
    g_percent_x=float(g_iconx)/width*100.0;
    g_percent_y=float(g_icony)/height*100.0;
    g_percent_prevx=g_percent_x;
    g_percent_prevy=g_percent_y;
    
    g_button=mouseButton;
    
    g_onmenubar=false;
    
    g_realbutton=g_button;
     
    if(finger(g_iconx,g_icony,g_button,PRESSED)>=0){
      g_button=0;
      g_phase=0;
      g_iconx=-1;
      g_icony=-1;
      return;
    }
      else
    {   
     if(discard_menus()>0){
       realdiscardmenus(0);
       g_button=0;
       g_phase=0;
       return;
     }
   }
   
    g_realbutton=g_button;

    if(insidewindow(g_iconx,g_icony)){
        if(g_phase==0){
          g_repanel=-2;
          g_tooltrigger=100;
          g_piconx=g_iconx;
          g_picony=g_icony;
        }else{
          g_iconx=-1;g_icony=-1;
        }
      return;
     }
      else
     {        
        g_wheelstarty=g_icony;
        
        msx=g_iconx;
        msy=g_icony-get_topedge();
            
        if(g_button!=CENTER){
          if(tool()!=12&&tool()!=5&&tool()!=4)store_undo();
          if(tool()==4){//cut brush results in undo
            
            if(g_button==RIGHT){
              touch();
              store_undo();
            }
          }
        }
        
      if(g_button==CENTER){
        if(g_control==false){
          //command(g_middlebutton);
          //g_phase=1;
          return;
        }
      }
      
      g_phase=0;
      
      int t=tool();
      
      if(t!=4&&t!=12&&t!=0)touch();
      
      if(t==12){//pipette 'tool'
        do_tool(msx,msy,255+g_button);
        set_tool(g_prevtool);
        return;
      }      
      
      do_tool(msx,msy,g_button);
      g_phase=1;
   }
}

void mouseDragged()
{
  g_dragged=true;
  int msx,msy;
  if(g_markctr>0)g_markctr=10;  
  g_iconx=mouseX;
  g_icony=mouseY;
  float percent_x=float(g_iconx)/width*100.0;
  float percent_y=float(g_icony)/height*100.0;
  
  int tut=tool();
  
  if(g_tutvalid[tut]==1){
    if(g_global_dragmode==0){
      if(g_btype!=9){
        g_tutscore++;
      }
    }
  }
  
  int wheely=g_icony;
  g_mousevectorx=g_iconx-pmouseX;
  g_mousevectory=g_icony-pmouseY;
  
  int offsetx=g_originalx-g_iconx;
  int offsety=g_originaly-g_icony;
  
  if(g_ylocker>0){
    g_icony=g_ylocker;
    g_fingernumb=0;
    g_button=LEFT;   
    if(finger(g_iconx,g_icony,g_button,PRESSED)>=0){
      g_button=LEFT;
    }
    if(g_icony<g_ylocker-16*g_uizoom){g_ylocker=0;g_lockerid=255;g_repanel=-2;}
    if(g_icony>g_ylocker+16*g_uizoom){g_ylocker=0;g_lockerid=255;g_repanel=-2;}   
    if(g_ylocker>0)g_icony=g_ylocker;
    
    g_fingernumb=1;
    return;
  }
  
  // g_button=mouseButton;
  
  if(g_global_dragmode==1){
    float desx=percent_x+g_phandlex;
    float desy=percent_y+g_phandley;
    if(desx<.1)desx=.1;
    if(desy<1)desy=1;
    g_winlocx[g_window_id]=desx;
    g_winlocy[g_window_id]=desy;
    return;
  }

   if(finger(g_iconx,g_icony,-4444,DRAGGED)>=0){
     return;
   }

  if(insidewindow(g_iconx,g_icony)){
      if(g_phase==0){
        g_piconx=g_iconx;
        g_picony=g_icony;
        g_iconx=-1;
        g_icony=-1;
        g_repanel=-2;
        g_tooltrigger=100;
        return;
      }else{
          g_iconx=-1;
          g_icony=-1;
          g_piconx=-1;
          g_picony=-1;        
      }
  }else
  {
    
      msx=g_iconx-g_leftedge;
      msy=g_icony-get_topedge();
    
      g_iconx=-1;
      g_icony=-1;
  }
  g_iconx=-1;
  g_icony=-1;
  int t=tool();
  
  if(g_control==false){
    if(mouseButton==CENTER||t==13){
      
      //pan without tool change
      if(offsetx>g_uizoom*4||offsetx<-g_uizoom*4||offsety<-g_uizoom*4||offsety>g_uizoom*4)g_panning=true;
      
      if(g_control==false&&g_panning==true){
          cursor_state(MOVE);
          int psizex=g_magpix[magmode()];
          int psizey=g_magpiy[magmode()];
          g_panx=offsetx/psizex;
          g_pany=offsety/psizey;
          
          panlimitter(1);
          
          g_panmode=true;
      }
      return;
    }
  }
  
    // zoom without rolling wheel
    
  if(mouseButton==CENTER&&g_control==true){
      if(wheely<g_wheelstarty-32){
        command(g_wheelup);
        g_wheelstarty=g_wheelstarty-32;
      }
      if(wheely>g_wheelstarty+32){
        command(g_wheeldown);
        g_wheelstarty=g_wheelstarty+32;
      }
      return;
    }

  if(g_phase!=0&&g_tooltrigger==0)g_tooltrigger=1;
}


void mouseReleased()
{
  g_dragged=false;
  int swap;  
 //command('['); // auto-dither mod 
 //println("ofx:"+g_ofx);
  if(g_phase==0&&tool()!=13)cursor_state(ARROW);
  g_panning=false;
  g_global_dragmode=0;
  g_tooltrigger=0;
  g_klikkeri=0;
  g_ylocker=0;
  g_phandlex=0;
  g_phandley=0;
  g_mousevectorx=0;
  g_mousevectory=0;
  g_iconx=mouseX;
  g_icony=mouseY;
  if(g_panmode){
    g_ofx=g_ofx+g_panx;
    g_ofy=g_ofy+g_pany;
    panlimitter(0);
    g_panx=0;
    g_pany=0;
  }
  
  if(finger(g_iconx,g_icony,mouseButton,RELEASED)>=0){
     g_button=0;
     g_phase=0;
     g_iconx=-1;
     g_icony=-1;
     g_fingernumb=0;
     return;
  }else{
  }
  
  g_fingernumb=0;
  
  g_iconx=-1;g_icony=-1;
   
  if(g_lockerid>0){
    g_lockerid=255;
    g_repanel=-2;
    refresh_all();
    return;
  }
  
  // mouse release w/o moving = pipette
  if(g_button==CENTER&&g_panmode==false){
    if(g_control==false){
      command(g_middlebutton);
      g_phase=0;
      return;
    }
  }
  g_panmode=false;
  if(g_phase==1)g_tutscore++;
  if(tool()==8){
    if(g_phase==1){
      g_phase=0;
      rectangle(g_rx,g_ry,g_rx2,g_ry2);
    }
  }
  if(tool()==7){//circle
    if(g_phase==1){
      g_phase=0;
      docircle(g_rx,g_ry,g_rx2,g_ry2);
    }
  }  
  if(tool()==6){//line
    if(g_phase==1){
      g_phase=0;
      doline(g_rx,g_ry,g_rx2,g_ry2,0);
    }
  }
  
  if(g_data['4']==1){//cutbrush
    if(g_phase==1){
      g_phase=0;
      g_rubbermode=0;
      refresh();
      g_data['4']=0;g_data['d']=0;
      g_data['r']=0;g_data['R']=0;
      g_data['x']=0;g_data['y']=0;
      g_data['Z']=0;g_data['p']=0;
      g_data['t']=0;g_data['n']=0;
      switcher(2);
      if(g_multic==1 || g_hzoomer==2){
        g_rx=g_rx/2;
        g_rx=g_rx*2;
        g_rx2=g_rx2/2;
        g_rx2=g_rx2*2;
      }
      g_bsourcex=g_rx;
      g_bsourcey=g_ry;
      g_bsourcex2=g_rx2;
      g_bsourcey2=g_ry2;
      if(g_bsourcex<=0)g_bsourcex=0;
      if(g_bsourcey<=0)g_bsourcey=0;
      if(g_bsourcex>=X)g_bsourcex=X-1;
      if(g_bsourcey>=Y)g_bsourcex=Y-1;    
      if(g_bsourcex2<=0)g_bsourcex2=0;
      if(g_bsourcey2<=0)g_bsourcey2=0;
      if(g_bsourcex2>=X)g_bsourcex2=X-1;
      if(g_bsourcey2>=Y)g_bsourcey2=Y-1;
      
      set_tool(1);
      g_btype=9;
      g_repanel=-2;
      if(g_button==RIGHT){
        store_parameters();
        g_data['f']=1;
        g_data['X']=0;
        g_data['Y']=0;       
        doborx(g_rx,g_ry,g_rx2,g_ry2);
        restore_parameters();
      }
    }
  consistency();
  }
  
  if(g_phase==1){
    
     g_phase=0;
     g_rubbermode=0;
     refresh(); //needed otherwise the pen color is kept e.g. after right mousebutton
  }
  
  clear_fxtrigger(1);
  update_preview_window();
}

void macro_command(int ckey)
{
    //filter out load/save
    if(ckey=='s'||ckey=='S'||ckey=='l'||ckey=='E'||ckey=='w'||ckey=='W'||ckey=='A')return;
    command(ckey);
}


void inferpan(){
 // println("g_phase:"+g_phase);
 // println(twophasetool());
  if(g_phase==1&&twophasetool()==true){
    if(g_msy<-8*g_uizoom){
      if(g_maglevel==0&&g_ofy<=g_pancentrey)return;
      g_ofy--;
      if(g_msy<-32*g_uizoom)g_ofy--;
     // refresh();
    }
    if(g_msy>height+8*g_uizoom){
      if(g_maglevel==0&&g_ofy>=g_pancentrey)return;
      if(g_msy>height+32*g_uizoom)g_ofy++;
      g_ofy++;
     // refresh();
    }
    if(g_msx<-8*g_uizoom){
      if(g_maglevel==0&&g_ofx<=g_pancentrex)return;
      g_ofx--;
      if(g_msx<-32*g_uizoom)g_ofx--;
     // refresh();
    }
    if(g_msx>width+8*g_uizoom){
      if(g_maglevel==0&&g_ofx>=g_pancentrex)return;
      g_ofx++;
      if(g_msx>width+32*g_uizoom)g_ofx++;
     // refresh();
    }    
  } 
}
  
void panlimitter(int mod){

  int mmode=magmode();
  int psizex=g_magpix[mmode];
  int psizey=g_magpiy[mmode];
  
  final int EDGE=24;
  
  int virtualX=(width-48*g_uizoom)/psizex-EDGE;
  int virtualY=(height-48*g_uizoom)/psizey-EDGE;
  
  // from mouserelease
  
  if(mod==0){
    if(g_ofx>X-EDGE)g_ofx=X-EDGE;
    if(g_ofy>Y-EDGE)g_ofy=Y-EDGE;
    
    if(g_ofx<-(virtualX))g_ofx=-virtualX;
    if(g_ofy<-(virtualY))g_ofy=-virtualY;
  }
  
  // from mousedragged
  
  if(mod==1){
    if(g_ofx+g_panx>X-16)g_panx=X-16;
    if(g_ofy+g_pany>Y-16)g_pany=Y-16;
    
    if(g_ofx+g_panx<-(virtualX))g_panx=-virtualX;
    if(g_ofy+g_pany<-(virtualY))g_pany=-virtualY;
  }
  
  //from viewport
  
  if(mod==2){
    if(g_ofx+g_panx>X-EDGE)g_panx=-g_ofx+X-EDGE;
    if(g_ofy+g_pany>Y-EDGE)g_pany=-g_ofy+Y-EDGE;
    if(g_ofx+g_panx<-(virtualX))g_panx=-g_ofx-(virtualX);
    if(g_ofy+g_pany<-(virtualY))g_pany=-g_ofy-(virtualY);
  }  
}

int g_pullcount;

void maghelper(int rel)
{    
  
  int msx=mouseX;
  int msy=mouseY-get_topedge();
  
  // if mag glass on
  if(tool()==0){
    command('0');
    return;
  }
  
  // increase mag zoom
  
  if(rel>0){
    g_maglevel++;
    int optx=g_storedcoordx;
    int opty=g_storedcoordy;
    if(g_maglevel>4){
      g_maglevel=4;
      return;
    }
    g_ofx=g_storedcoordx-magpixelx()/2;
    g_ofy=g_storedcoordy-magpixely()/2;
    storecoords(msx,msy);
    g_ofx=g_ofx-(g_storedcoordx-optx);
    g_ofy=g_ofy-(g_storedcoordy-opty);    
    
    panlimitter(0);
    
    g_boxreconstruct=2;
    refresh();
  }
  
  
  // decrease mag zoom
  
  // recentre if second pull out - not
  
  if(rel<0){
    g_maglevel--;
    int optx=g_storedcoordx;
    int opty=g_storedcoordy;
    if(g_maglevel<0){
      g_maglevel=0;
      if(g_pullcount==0){
    //    refocus();
      }
      g_pullcount=20;
      return;
    }
    g_pullcount=20;
    g_ofx=g_storedcoordx-magpixelx()/2;
    g_ofx=g_storedcoordx-magpixelx()/2;
    g_ofy=g_storedcoordy-magpixely()/2;    
    storecoords(msx,msy);
    g_ofx=g_ofx-(g_storedcoordx-optx);
    g_ofy=g_ofy-(g_storedcoordy-opty);  
    
    panlimitter(0);
    
    g_boxreconstruct=2;
    refresh();
  }  
}

byte [] g_alt_state=new byte[256];

void state_exchange(){
  boolean okay=true;
  for(int i=0;i<=249;i++){
    if(i!='g' && i!='m' && i!='M' && i!='3' && g_data[i]!=0)okay=false;
  }
  
  if(okay==true){
    for(int i=0;i<=255;i++)
    {
      if(i!='g'&&i!='m'&&i!='M')g_data[i]=g_alt_state[i];
    }
    g_btype=int(g_alt_state[250]);
    g_bsize=int(g_alt_state[251]);
    g_data[FX]=g_alt_state[252];
  }
  else{
    for(int i=0;i<=255;i++)
    {
      g_alt_state[i]=g_data[i];
      if(i!='g'&&i!='m'&&i!='M')g_data[i]=0;
    }
    g_alt_state[250]=byte(g_btype);
    g_alt_state[251]=byte(g_bsize);
    g_alt_state[252]=g_data[FX];
    command('3');
    g_btype=0;
    g_bsize=0;
    g_data[FX]=byte(0);
    //g_data['f']=1;
  }
  refresh_all();
  g_boxreconstruct=2;
  g_repanel=-2;
}

void command(int ckey)
{
  int swap;
  //remember though 10 and 9 etc are valid ascii TAB etc
  //arrow keys simulated
  
  if(ckey==10000){g_ofx++;refresh();}
  if(ckey==10001){g_ofx--;refresh();}
  if(ckey==10002){g_ofy--;refresh();}
  if(ckey==10003){g_ofy++;refresh();}    
  //keypresses change g_data[] values directly as 1/0 switches
  //handling these presses "indirectly" adds complexity here
  //but is valuable elsewhere = corresponding icons have shortcuts automatically
  
  if(ckey=='-')ckey='h';
  if(ckey=='+')ckey='H';
  
  if(ckey=='*'){
    make_timestamp();
    return;
  }    

  if(ckey==BACKSPACE){
    message("Preview|on/off");
    toggle_preview();
  }
  
  if(ckey==TAB){
    if(g_shift==false){
      if(g_britemode==1&&g_machine!=ULAPLUS){
        if(g_realfront==7)g_realfront=-1;
        if(g_realfront==15)g_realfront=7;
      }
      selectcolor(0,g_realfront+1);
      g_repanel=-2;
    }else{
      if(g_britemode==1&&g_machine!=ULAPLUS){
        if(g_realfront==8)g_realfront=16;
        if(g_realfront==0)g_realfront=8;
      }
      selectcolor(0,g_realfront-1);
      g_repanel=-2;
    }
  }
  if(g_control==true){
    int UNDO=26,
    REDO=25,
    PASTE=22,
    SAVE=19,
    LOAD=15,
    NEW=14,
    COPY=3,
    COPYALT=24,
    ALL=1;
            
    if(platform==MACOSX){
      UNDO=122;
      REDO=25;
      PASTE=22;
      SAVE=115;
      LOAD=111;
      NEW=110;
      COPY=99;
      COPYALT=120;
      ALL=97;        
    }
        
    if(ckey==UNDO){
      ckey='u';
      if(g_shift)ckey='U';
    }//undo
    if(ckey==REDO)ckey='U';
    if(ckey==PASTE)ckey='9';
    if(ckey==SAVE){
      ckey='S';
      if(g_shift)ckey='s';
    }//save
    if(ckey==LOAD)ckey='l';
    if(ckey==NEW)ckey='o';
    if(ckey==COPY||ckey==COPYALT){
      ckey='4';
      message("Cut/Copy");
    }
    if(ckey==ALL){
      switcher(2);
      g_bsourcex=0;
      g_bsourcey=0;
      g_bsourcex2=X-1;
      g_bsourcey2=Y-1;
      ckey='9';
      g_data['p']=0;
      g_data['x']=0;g_data['y']=0;
      g_data['Z']=0;g_data['z']=0;
      g_data['t']=0;
      g_phase=0;
      g_rubbermode=0;
      set_tool(1);
      message("Copy All");
    }
  }
  
  if(ckey>=128&&ckey<=131){
    g_bsize=ckey-128;
    g_btype=0;
  }
  
  if(ckey>=132&&ckey<=135){
    g_bsize=ckey-132;
    g_btype=1;
  }
  
  if(ckey==' '||ckey=='.'){
    if(ckey=='.'){
      g_bsize=0;
      g_btype=0;
      g_data['n']=0;
      ckey='3';
    }
    if(ckey==' '){
      state_exchange();
      return;
    }    
  }
    
  if(ckey>=0&&ckey<=255){
    //g_depressed[ckey-48]=10;
  }
    

  
  if(ckey==59){//: semicolon ';' pull zoom
      maghelper(-1);
  }
  if(ckey==58){//; colon ':'
      maghelper(1);
  }
  
  if(ckey=='a'&&tool()==13){
      set_tool(g_prevtool);
      return;
  }

  if(ckey=='e'&&tool()==12){
      set_tool(g_prevtool);
      return;
  }
  if(ckey=='a'&&tool()==12){
    g_data['a']=0;
    g_data['e']=0;
  }
  if(ckey=='e'&&tool()==13){
    g_data['a']=0;
    g_data['e']=0;
  }
  
  if(ckey==','){
      g_repanel=-2;
     // do_tool(mouseX,mouseY,255);
      do_tool(g_mx,g_my,255);
      return;
  }
  
  if(ckey=='v'){
    g_repanel=-2;
   // do_tool(mouseX,mouseY,254);
    do_tool(g_mx,g_my,254);
    if(g_data['c']==1){
      g_data['p']=0;
    }
    return;
  }
  
  if(ckey=='['){
      x_com(0,"DITHERx",0,0,0);
      message("D.OFFSET "+str(g_raster_offset_x)+"."+str(g_raster_offset_y));
      g_repanel=-2;
      return;
  }
  if(ckey==']'){
      x_com(0,"DITHERy",0,0,0);
      message("D.OFFSET "+str(g_raster_offset_x)+"."+str(g_raster_offset_y));
      g_repanel=-2;
      return;
  }  
  if(ckey=='('){
      x_com(0,"DITHERp",0,0,0);
      message("DITHER "+str(g_raster_no)+"/9|[=PREV|]=NEXT");
      g_repanel=-2;
      return;
  }
  
  if(ckey==')'){
      x_com(0,"DITHERn",0,0,0);
      message("DITHER "+str(g_raster_no)+"/9|[=PREV|]=NEXT");
      g_repanel=-2;
      return;
  }
  
  if(ckey=='>'){
    if(g_map[1]>0){
     // selectcolor(0,g_rgb[int(g_map[1])]);
     // message("Current=Back");    
     // g_repanel=-2;
     // return;
    }
    if(g_button==CENTER){
      g_wizard=true;
      message("'Xyzzy'");
    }
  }
  if(ckey=='<'){
    g_repanel=-2;
    swap=g_farge;
    g_farge=g_backg;
    g_ofarge=g_farge;
    g_backg=swap;
    swap=int(g_map[19]);
    g_map[19]=g_map[20];
    g_map[20]=byte(swap);
    g_realfront=byte(g_farge);
    g_realback=byte(g_backg);
  }
  
  if(ckey=='0'){
      if(g_maglevel==0){
        if(tool()==0){
          set_tool(g_prevtool);
          g_repanel=-2;
           g_rubbermode=0;
           g_rx=-1;g_ry=-1;
           g_rx2=-1;g_ry2=-1;
          return;
        }
        if(tool()!=0){
//          g_prevtool=tool();
        }
      }else
      {
        ckey='m';
      }
   }
      
   if(ckey=='9'){
     g_repanel=-2;
     g_btype=9;
     return;
   }
   if(ckey>='0'&&ckey<='8'){
     g_repanel=-2;
     set_tool(ckey-48);
     g_phase=0;
     g_rubbermode=0;
     g_rx=-1;g_ry=-1;
     g_rx2=-1;g_ry2=-1;
     if(g_data[ckey]>1)g_data[ckey]=0;
     if(ckey=='4'){
       g_data['x']=0;
       g_data['y']=0;
       g_data['h']=0;
       g_data['Z']=0;
       g_data['t']=0;
       g_data['n']=0;
     }
  }
  

  if(ckey>='A'&&ckey<='Z'){
    g_repanel=-2;
    g_data[ckey]++;
    if(g_data[ckey]>1)g_data[ckey]=0;
    
    if(ckey=='F'){
      user_routine(0);
    }
    if(ckey=='I'){
      user_routine(1);
    }    
    if(ckey=='G'){
      g_data['G']=0;
      grid_doubler();
      g_repanel=-2;
      g_msgctr=0;
      help('g');
      g_msgctr=50;
    }
    
    if(ckey=='I'){
    }
    
    if(ckey=='T'){
    }
    
    if(ckey=='G'){
       if(g_data['g']==0)g_data['g']=1;
    }
    if(g_data['M']==0)g_boxreconstruct=2;
    
    if(g_maglevel<4){
      if(ckey=='M'){
        g_maglevel=4;
        g_ofx=g_storedcoordx-magpixelx()/2;
        g_ofy=g_storedcoordy-magpixely()/2;
        message("Super|Magnify");
        if(tool()==0){
          set_tool(g_prevtool);
          g_phase=0;
          g_rubbermode=0;
        }
      }
    }
    if(g_data['B']==1){      
      g_data['B']=0;
      if(g_machine==VICM&&g_farge==g_map[2]){
        message("Border|can't be|same as Aux");
        refresh();
        return;          
      }      
      if(g_machine==VICM&&g_farge==g_map[1]){
        message("Border|can't be|same as Back");
        refresh();
        return;          
      }       
      touch();
      changeborder(LEFT);
      if(g_machine==VICM)clever_background(0);
      if(g_machine==MSX)g_data['C']=1;
    }
    if(g_data['C']==1){
      g_data['C']=0;
      if(int(g_map[1])!=255){
        store_undo();
        if(g_machine==PLUS4M&&g_farge==int(g_map[2])){
            message("1st and 2nd|can't be|same");
            refresh();
            return;          
        }
        if(g_machine==VICM&&g_farge==int(g_map[0])){
            message("Back can't|be same as|Border");
            refresh();
            return;          
        }            
        if(g_machine==VICM&&g_farge==g_map[2]){
            message("Back can't|be same as|Aux");
            refresh();
            return;          
        }        
        
        g_map[1]=byte(g_farge);
        
        clever_background(1);
        
        if(g_machine==VIC||g_machine==VICM){
         // sussborder();
        }
        
        if(g_machine==MSX){
          g_map[0]=byte(g_farge);
          g_map[1]=byte(g_farge);
          g_rgb[0]=g_rgb[g_farge];
          g_r[0]=g_r[g_farge];
          g_g[0]=g_g[g_farge];
          g_b[0]=g_b[g_farge];
          sussborder();
        }
        touch();
        message("Set back|color");
       }
    }
    if(g_data['V']==1){
      g_data['V']=0;
      if(int(g_map[1])!=255){
        store_undo();
        if(g_machine==PLUS4M&&g_farge==int(g_map[1])){
          message("1st and 2nd|can't be|same");
          refresh();
          return;
        }
        if(g_machine==VICM&&g_farge==int(g_map[1])){
          message("Aux can't|be same as|Back");
          refresh();
          return;
        }        
        if(g_machine==VICM&&g_farge==int(g_map[0])){
          message("Aux can't|be same as|Border");
          refresh();
          return;
        }           
        g_map[2]=byte(g_farge);
        clever_background(2);
        touch();
        message("Set 2nd|back color");
       }
    }      
    if(g_data['W']==1){
      g_data['W']=0; 
      if(g_formatextension!=""){
        message("Format|export");
      }
        else
      {
        message("None for|"+g_name);
      }
    }
    if(g_data['N']==1){
        g_data['N']=0;
        int i=g_animspeed;
        i++;
        if(i>3)i=0;
        g_animspeed=i;
        message("Playbrush|speed="+g_animspeed);
      }
    refresh();
  }
  
  if(ckey>='a'&&ckey<='z'){
    if(ckey=='m'||ckey=='M'){
    
        if(tool()==0){
          command('0');
          return;
        }        
    }
    g_repanel=-2;
    g_data[ckey]++;
    if(g_data[ckey]>1){
      if(ckey=='m'||ckey=='M'){
        if(g_maglevel>0){
        g_boxreconstruct=2;
        g_data['M']=0;
        g_data['m']=0;
        g_maglevel=0;
      }
      }
      g_data[ckey]=0;
    }
    
    if(g_data['a']==1){
      set_tool(13);
      message("Pan");
    }
    
    if(g_data['e']==1){
      set_tool(12);
      message("Pipette|Pick color");
    }
    
    if(g_data['t']==1&&ckey=='t')message("Tile mode");
    
    if(ckey=='n'){
      if(g_data['n']==1){
        switcher(2);infersize();
        if(g_data['n']==1){
          command('1');command('9');
          g_data['p']=0;g_data['x']=0;g_data['y']=0;
          g_data['Z']=0;g_data['t']=0;
        }
      }
    }    
    
    if(g_data['i']==1){
      g_data['i']=0;
      selectcolor(0,nextluminance(g_farge,1));
    }
    if(g_data['k']==1){
      g_data['k']=0;
      selectcolor(0,nextluminance(g_farge,-1));
    }
    if(g_data['d']==0){
      if(ckey=='d')consistency();
    }
    if(g_data['z']==1){
      g_data['z']=0;
      int orient;
      orient=g_data['x']*100+g_data['y']*10+g_data['Z'];
      if(orient==0){
        g_data['x']=0;g_data['y']=0;g_data['Z']=1;
      }
      if(orient==1){
        g_data['x']=1;g_data['y']=1;g_data['Z']=0;
      }  
      if(orient==110){
        g_data['x']=1;g_data['y']=1;g_data['Z']=1;
      } 
      if(orient==111){
        g_data['x']=0;g_data['y']=0;g_data['Z']=0;
      }
      if(orient==100){
        g_data['x']=0;g_data['y']=1;g_data['Z']=1;
      }
      if(orient==11){
        g_data['x']=0;g_data['y']=1;g_data['Z']=0;
      }  
      if(orient==10){
        g_data['x']=1;g_data['y']=0;g_data['Z']=1;
      }
      if(orient==101){
        g_data['x']=1;g_data['y']=0;g_data['Z']=0;
      }      
      message("Rotate|brush");
    }    

    if(ckey=='m'){
      if(g_maglevel>0){
        g_maglevel=0;
        ckey=0;
        g_boxreconstruct=2;
        refocus();
        refresh();
        ckey='@';
      }
      if(g_maglevel==0&&ckey=='m'){
        message("Magnify");
        g_maglevel=2;        
        g_ofx=g_storedcoordx-magpixelx()/2;
        g_ofy=g_storedcoordy-magpixely()/2;
        ckey=0;
        g_boxreconstruct=2;
        refresh();
      }
      g_data['M']=0;     
      g_data['m']=0;
    }
    if(g_data['m']==1){
      if(ckey=='m'){
        g_data['M']=0;
        int moux,mouy;
        moux=g_mx/g_wzoom;
        mouy=g_my/g_wzoom;
        g_ofx=g_storedcoordx-magpixelx()/2;
        g_ofy=g_storedcoordy-magpixely()/2;
        message("Magnify");
        if(tool()==0){
          set_tool(g_prevtool);
          g_phase=0;
          g_rubbermode=0;
        }
      }
    }
    refresh();
  }
  
  if(g_data['J']==1){
    g_data['J']=0;g_data['j']=0;
    spare();
    store_undo();
    switch(g_spare){
      case 0:
        message("Copied to|Front");
        switcher(4);
      break;
      case 1:
        message("Copied to|Spare");
        switcher(4);        
      break;
    }
    spare(); 
    
    launch_alert("å  Notice           [X]|-|Copied to other page!|| [Revert]");
  }
  
  if(g_data['j']==1){
    discard_dialogues(1);//only the alert box
    g_data['j']=0;
    if(g_spare==0)message("Spare Page");
    if(g_spare==1)message("Front Page");
    spare();
    makecolor(259,g_r[int(g_map[0])],g_g[int(g_map[0])],g_b[int(g_map[0])]);
    
    update_preview_window();
    g_boxreconstruct=2;
  }
  if(g_data['E']==1){
    g_data['E']=0;
    launch_dialogue(69);
  }
  if(g_data['A']==1){
    g_data['A']=0;
    message("Executable|export");   
    //machine_export(0);  
  }
  if(g_data['w']==1){
    g_data['w']=0;
    
      if(g_formatextension!=""){
        message("Format|import");
      }
        else
      {
        message("None for|"+g_name);
      }    
  }   
  if(g_data['O']==1){
    g_data['O']=0;
    store_undo();
    global_clear();
  }
  
  if(g_data['o']==1){
    g_data['o']=0;
    message("Clear all");
    store_undo();
    setname("",g_spare);
    touch();
    global_clear();
  }
  
  //if(g_data['e']==1)g_data['e']=0;
 
  if(g_data['h']==1){
    g_data['h']=0;
    g_bsize--;
    if(g_bsize<0)g_bsize=0;
    g_msgctr=-2;
    help('h');  
  }
  if(g_data['H']==1){
    g_data['H']=0;
    g_bsize++;
    if(g_bsize>10)g_bsize=10;
    g_msgctr=-2;
    help('h');
  }  
  if(g_data['u']==1){
    g_data['u']=0;
    message("Undo");
    restore_undo();refresh();g_boxreconstruct=2;
    update_preview_window();
  }
  if(g_data['U']==1){
    g_data['U']=0;
    message("Redo");
    redo_undo();refresh();
    update_preview_window();
  }
  if(g_data['S']==1){
    g_data['S']=0;
    if(g_spare==0)elename=filename;
    if(g_spare==1)elename=sfilename;
    
    if(elename.length()>3){
      if(g_iconmode==0){
        //ctrl+s
       // println("Savekey");
        savekey(elename);
      }
    }
      else
    {
      message("No filename!");
      message("*");
      launch_alert("å  Warning!         [X]|-|Empty Filename||...use   [Save As]");
      g_data['S']=0;
      g_data['s']=0;
    }
  }
  if(g_data['l']==1){
    g_data['l']=0;
    gui=true;
    fileselect=true;
  }
  if(g_data['s']==1){
    g_data['s']=0;
    gui=true;
    saveas=true;
  }  
  if(g_data['L']==1)g_data['L']=0;
}
