// machine definitions
// source writer and other export/import functions
// the machine_export() makes use of bitmapexport() and colorexport() below
// Amstrad templates from Marq's PixelPolizei

// BIN specs
// g_map[88000]  parameters_
// 0        border
// 1        background (c64/plus4 multicolor 0)
// 2        background 2 (plus4 multicolor 1)
// 3        MODE variable = which MODE? = machine
// 4        max colors-1 (255=max=256 colours) = last colour #
// 5        (bitmap width/8)=MX (2-pixel wide resolutions like 160 are still 40)
// 6        0 (probable X size adjuster in future)
// 7        (bitmap height/8)=MY
// 8        0 (probable Y size adjuster in future)
// 9        C64 hard-coded palette selector #0 (e.g. 0=pepto,1=colodore) does not need to be addressed, RGB data is included in the file
// 10       'M'  <-File ID since 2019
// 11       'P'  <-File ID since 2019
// 12       tool # shortcut
// 13       machine colorsystem (e.g C64) not the same as 'machine', i.e. all C64 modes share the same colorsystem
// 14       bitplanes (for pixelmodes 3,4) since 2020
// 15       pixelmode (internal 1,2,3,4) since 2020
// 16       Image preference bits 128=comm,129=32w,130=db,131=hex,132,133,134,135
// 17       General preference bits 136=border export?,137=hexify,138=pixelgrid,139=remix palt,140,141,142,143 (mirrored?)
// 18       Submode (e.g. CGA color set 0xXY X=backg 0-15 Y=cga palt 0-5)
// 19       Current ink = color1
// 20       Current paper = color2
// 21       hardboot (0,1 = internal value)
// 22       global1 in charmode
// 23       global2 in charmode
// 24-25    Mirror X 16 bit HI,LO
// 26-27    Mirror Y 16 bit HI,LO
// 32-95    Internal stored export filename for autput export (not needed/used anymore?)
// 96       [ ] SUGGEST: Gridx storage
// 97       [ ] SUGGEST: Gridy storage
// 98       [ ] SUGGEST: Tilex size storage
// 99       [ ] SUGGEST: Tiley size storage
// 240      palette range #0 start
// 241      palette range #0 end
// 242      palette range #1 start
// 243      palette range #1 end
// 244      palette range #2 start
// 245      palette range #2 end
// 246      palette range #3 start
// 247      palette range #3 end
// 250-251  TURTLEX coord
// 252-253  TURTLEY coord
// 254-255  TURTLEA angle
// 256-1023 palette R,G,B 8-bit definitions (ARE present in non-paletted modes too, e.g. pepto/colodore/ptoing/)
// 1024-    bitmap etc definitions, can vary a lot depending on platform
// 65536-   typically, 8x8 attributes, but can have 2 colormaps, can vary a lot depending on platform

// Image prefs
// 128 comments?
// 129 force 32 wid
// 130 byte/db
// 131 hex out

//   01 23 45 67
//   po=ad[0]+ad[1]*2;
   
// 00 00 00 00 0 zeroc g_map[1]
// 10 10 10 10 1 cad+1000
// 01 01 01 01 2 cad
// 11 11 11 11 3 cad+2000
 
// supported

final int C64=0, MSX=5, SPECTRUM=6, C64M=10, PLUS4=9, PLUS4M=19, CPC=2;

final int CPC1=25; // Amstrad 320 x 200 with 4 colors

final int QLLOW=66,ULAPLUS=67,ATARIST=12,AMIGA=11;

final int CPCOC=26; // Amstrad Overscan test
final int C64NOLIMIT=32; // Commodore 64 without attribute limitations
final int VIC=22; // VIC-20 hires 176x176
final int VICM=222; // VIC-20 multi 88x176

final int ZXNEXT=70;// ZX Next 256x192 w/ 256
final int ZXNEXTB=71;// ZX Next 320x256 w/ 256

// experimental or incomplete

final int ATARIE=50; // Atari 8 160x192 x 4
final int ATARIENOLIMIT=51; // Atari 8 160x192 x 4

final int CPCNOLIMIT=98; // Amstrad 320 x 200 with full palette
final int TUTORIAL1=104;
final int TO8A=43; // Thomson TO8 160x200 w/ 16 of 4096
final int TO8B=44; // Thomson 320x200 w/ 16 of 4096
final int C64MNOLIMIT=42; // Commodore 64 without attribute limitations
final int GX4000=27; // Looks fine?
final int GXOC4000=28; // Looks fine?
final int COCO3=34; // Looks fine?
final int BK0010=99; // Aspect ratio?
final int APPLE2=77; // Apple2 280x192 hires only
final int TIC80=80; // currently assumes 16 colors only
final int PCCGA=23; // 320 x 200 PC CGA screen
final int MSX24=54; // 256 x 212 ST style RGB

//reserved but completely unimplemented

final int C64FLI=20,C64FLIM=21; //incomplete FLI & AFLI modes
final int ULATMX=68; // ULAplus 256x192 8x1 Timex mode
final int PCCGAX=24; // 320 x 200 PC CGA screen alternative, NOT USED
final int PCEGA=200; // 320 x 200 PC EGA screen, 16 colors of 64
final int PCVGA=255; // 320 x 200 PC VGA screen, 256 colors of 65536
final int NES=90; // 8-bit NES
final int SEGAM=91; // 8-bit Sega Master System
final int ULAFREE=69;
final int TIMEX=7;
final int JR200=8;
final int BBCLOW=35;
final int BBCHI=36;

// hypothetical or test

final int PICO8=88;
final int UNIA=33;

//profiles

final int PROF_BORDER=0;
final int PROF_BACKGND=1;
final int PROF_BACKGND2=2;
final int PROF_PALTOOLS=3;
final int PROF_FXTOOLS=4;
final int PROF_LOADPALETTE=5;
final int PROF_RESIZE=6;
final int PROF_REBITPLANE=7;
final int PROF_REPALETTE=8;
 
PImage image;

int g_palstepsr;
int g_palstepsg;
int g_palstepsb;

String g_formatname, g_formatextension;
String g_machinename;
String g_tempname;

int g_scanlimit; // new thing

int g_headpos;

int []wd=new int[16];

int []g_grids=new int[16];
int []g_colorprofile=new int[16];//0 border? 1 backg? 2 back2? 3 paltools? 4 fxtools?
int []g_usablecolor=new int[256];//bit 1=can use for border 2=can use for backgnd1  4=can use for backgnd2 8=can use for pen
int OLD=0;
int NEW=1;
int FLATRATIO=1;
int SQUARERATIO=0;
int g_gridmode=OLD;
int g_pixelw=1;
int g_planes=1;
int g_aspect=SQUARERATIO;
int g_interimwid=0;
int g_interimhei=0;
int []g_intr=new int[256];
int []g_intg=new int[256];
int []g_intb=new int[256];

String g_report;//file import report

float g_realaspect;//for preview
float g_pal_aspect;//euros
float g_alt_aspect;//ntsc generally

int tdeek(int ad){
  return(int(g_template[ad])*256+int(g_template[ad+1]));
}

void palettesteps(int s){
  g_palstepsr=s;
  g_palstepsg=s;
  g_palstepsb=s;
  make_slider_steps();
}

void make_pixelwidth()
{
  g_pixelw=1;
  if(g_multic==1||g_hzoomer==2)g_pixelw=2;    
}          

//validate width & height as multiples of X or Y
int xpass(int wid){
  if(wid==X)return 1;
  if(wid==X*2)return 1;
  if(wid==X*3)return 1;
  if(wid==X*4)return 1;
  return 0;
}
int ypass(int hei){
  if(hei==Y)return 1;
  if(hei==Y*2)return 1;
  if(hei==Y*3)return 1;
  if(hei==Y*4)return 1;
  return 0;
}

// image-based
int bbox(color cc,int par,int x1,int y1,int x2,int y2){
  if(par==1){
    for(int x=x1;x<x2;x++){
      for(int y=y1;y<y2;y++){
        if(image.get(x,y)!=cc)return x;
      }
    }
  }
  if(par==2){
   for(int y=y1;y<y2;y++){
    for(int x=x1;x<x2;x++){
        if(image.get(x,y)!=cc)return y;
      }
    }
  }
  if(par==3){
    for(int x=x2;x>x1;x--){
      for(int y=y1;y<y2;y++){
        if(image.get(x,y)!=cc)return x+1;
      }
    }
  } 
  if(par==4){
     for(int y=y2;y>y1;y--){
      for(int x=x2;x>x1;x--){
        if(image.get(x,y)!=cc)return y+1;
      }
    }
  }   
  return 0;
}

int[] border_analyser(){
  //println("[Border analyser]");
  int[] ret = new int[4];
  color cc=image.get(0,0);
  int wid=image.width;
  int hei=image.height;
  int x1=bbox(cc,1,0,0,wid/2,hei);
  int y1=bbox(cc,2,0,0,wid,hei/2);
  int x2=bbox(cc,3,wid/2,0,wid-1,hei-1);
  int y2=bbox(cc,4,0,hei/2,wid-1,hei-1);  
  
  if(xpass(x2-x1)==1&&ypass(y2-y1)==1){
    ret[0]=x1;
    ret[1]=y1;
    ret[2]=x2;
    ret[3]=y2;
    g_report=g_report+"Border crop OK|";
    if(g_colorprofile[PROF_BORDER]==1){
      set_border(find_rgb(cc));
    }
    return ret;
  }
  g_report=g_report+"No border fit|";
  ret[0]=0;
  ret[1]=0;
  ret[2]=wid;
  ret[3]=hei;
  return ret;
}

// do resize results fit within memory
// improve memory model in future

int tentative_mode(int x,int y,int bpl){
  x=x*8;
  y=y*8;
  if(g_colorprofile[PROF_REBITPLANE]==0)bpl=4;
 // println(x+","+y+" w "+bpl);
  int memrq=(x*y)/8*bpl;
  //println("="+memrq);
  if(memrq<80000)return 1;
  return 0;
}

void resize_mod(int ox,int oy,int bp){
  int plus=1;
  if(ox>32||oy>32){
    g_data[NEWY]=byte(oy/8);
    g_data[NEWX]=byte(ox/8);
    return;
  }
  
  if(g_shift||g_button==RIGHT)plus=4;
  for(int i=1;i<=plus;i++){
    if(tentative_mode(g_data[NEWX]+ox,g_data[NEWY]+oy,g_data[NEWBPL]+bp)==0)return;
    g_data[NEWY]=byte(g_data[NEWY]+oy);
    g_data[NEWX]=byte(g_data[NEWX]+ox);
    g_data[NEWBPL]=byte(g_data[NEWBPL]+bp);
    if(g_data[NEWY]<8)g_data[NEWY]=8;
    if(g_data[NEWY]>64)g_data[NEWY]=64;//512 tops
    if(g_data[NEWX]<8)g_data[NEWX]=8;
    if(g_data[NEWX]>80)g_data[NEWX]=80;//650 tops
    if(g_data[NEWBPL]<1)g_data[NEWBPL]=1;
    if(g_data[NEWBPL]>5)g_data[NEWBPL]=5;
  }
}



//mode 0=external image
//mode 1=internal fillmap
//par 0=passive count
//par 1=order palette, too

int count_unique_colors(int mode,int par){
  color list[]=new color[256];
  for(int i=0;i<256;i++){
    list[i]=color(0,0,0);
  }  
  int ptr=0;
  int count=0;
  boolean exists=false;
  int r=0,g=0,b=0;
  int ww=g_interimwid;
  int hh=g_interimhei;
  if(mode==0||mode==1){
    ww=image.width;
    hh=image.height;
  }
  for(int y=0;y<hh;y++){
    for(int x=0;x<ww;x++){
      
      color rgb=color(0,0,0);
      if(mode==0||mode==1)rgb=image.get(x,y);
      if(mode==1000){
        r=g_intr[g_fillmap[x+y*ww]];
        g=g_intg[g_fillmap[x+y*ww]];        
        b=g_intb[g_fillmap[x+y*ww]];
        rgb=color(r,g,b);
      }
      exists=false;
      if(ptr>0){
        for(int c=0;c<ptr;c++){
          if(list[c]==rgb)exists=true;
        }
      }
      if(exists==false){
        if(par==1){
          makecolor(ptr,r,g,b);
        }
        list[ptr]=rgb;
        ptr++;
        count++;
        if(ptr>=256)return 256;
      }
    }
  }
  return count;
}

color g_clist[]=new color[256];
int g_citem[]=new int[256];

int addlist(color c){
  for(int i=0;i<256;i++){
    if(g_citem[i]!=0&&g_clist[i]==c){
      return i;
    }
  }  
  for(int i=0;i<256;i++){
    if(g_citem[i]==0){
      g_citem[i]=1;
      g_clist[i]=c;
      return i;
    }
  }
  return 0;
}

int limitrgb(int inp){
  int out;
  inp=inp/32;
  inp=inp*32;
  out=inp&255;
  return out;
}

void color_preprocessor(){
  // limit to 9-bit RGB
  color c;
  
  image.resize(X,Y);
   for(int x=0;x<image.width;x++){
    for(int y=0;y<image.height;y++){
      c=image.get(x, y);
      int rr=limitrgb(int(red(c)));
      int gg=limitrgb(int(green(c)));
      int bb=limitrgb(int(blue(c)));
      image.set(x,y,color(rr,gg,bb));
      
    }
  }
  //image.save("interim.png");
}

void ulap_preprocessor(){
  float fx,fy;
  int x2,y2;
  color c;
  fillmap_clear();
  
  int ww=image.width;
  int hh=image.height;
  int offsetx=0;
  int offsety=0;
  for(int i=0;i<256;i++){
    g_citem[i]=0;
  }
  for(int x=0;x<image.width;x++){
    for(int y=0;y<image.height;y++){
      c=image.get(x, y);
      int rr=dampr(int(red(c)));
      int gg=dampg(int(green(c)));
      int bb=dampb(int(blue(c)));
      //fill(rr,gg,bb);
      image.set(x,y,color(rr,gg,bb));
    }
  }
  for(int yy=0;yy<Y;yy++){
    for(int xx=0;xx<X;xx++){      
      fx=(ww/X)*xx;
      fy=(hh/Y)*yy;
      x2=int(fx);
      y2=int(fy);
      c=image.get(x2+offsetx, y2+offsety);   
      int res=addlist(c);
      g_fillmap[xx+yy*g_interimwid]=byte(res);
    }
  }
  for(int i=0;i<256;i++){
    if(g_citem[i]==1){
      g_intr[i]=int(red(g_clist[i]));
      g_intg[i]=int(green(g_clist[i]));
      g_intb[i]=int(blue(g_clist[i]));
      
      //makecolor(i,red(g_clist[i]),green(g_clist[i]),blue(g_clist[i]));
    }
  }
}

void internalize(int offsetx,int offsety,float ww,float hh){

}

void image_preprocessor(){
  for(int y=0;y<image.height;y++){
    for(int x=0;x<image.width;x++){
      color c=image.get(x,y);
      color ss;
      float r=red(c);
      float g=green(c);
      float b=blue(c);
      ss=color(0,g,0);
     // image.set(x,y,ss);
    }
  }
}

color colormod(color c,int x,int y,int mod){
    int rr=int(red(c));
    int gg=int(green(c));
    int bb=int(blue(c));
    int ctr=0;
    
    if(mod==2){
      if((y&1)==0){
          ctr=24;
      }
      if((y&1)==2){
          ctr=16;
      }
    }
    if(mod==1){
      if(((x&1)==0)&&((y&1)==0))
      {
        ctr=24;
      }
      if(((x&1)==1)&&((y&1)==1)){
        ctr=16;
      }
    }
    rr=rr+ctr;
    gg=gg+ctr;
    bb=bb+ctr;
    if(rr>255)rr=255;
    if(gg>255)gg=255;
    if(bb>255)bb=255;
  return color(rr,gg,bb);
}

// void image_import

// at this point the source is in "image" whether loaded or not

void import_image(String name,int mode,int sourcemode) // ,1 = internal using g_fillmap (not used)
{  
  
    int passhistogram=1;
    
    int cmod=0;
    int bitx=0;
    int bity=0;
    
    if(getbit(139)==1){
      passhistogram=0;
    }
    if(getbit(140)==1){
      cmod=1;
    }    
    if(mode==1){
      passhistogram=0;
      cmod=0;
      if (g_colorprofile[PROF_REPALETTE]==0){
        passhistogram=1;
      }
    }
    
    g_report="| [X]  CONVERSION |-|";
    System.gc(); 
    println("IMPORT_IMAGE "+name+" , "+mode);
    if(mode==0){
      image = loadImage(name);      
      clear_autohistogram();
    }
    int balx, baly, xx, yy, x2, y2, rr, gg, bb, avg, molox, i, j, target;
    int cx, cy;
    int aas, bbs, swap, idefix, avx, avy;
    int[] pixut= new int[260];
    int[] idx=new int[260];
    int[] histog=new int[4097];
    float ww, hh, fld, compa, fx2, fy2;
    color c;
    int xcolors, limitter, vertti, erkki;
    int rh,gh,bh;
    int startcolor=0;
    int offsetx=0;
    int offsety=0;
    
    if(g_machine==MSX)startcolor=1;
    
    xcolors=g_maxcolors;
    vertti=CY;
    erkki=1;
    limitter=2;//for 2-attribute modes
    
    int uniques;
    
    uniques=count_unique_colors(mode,0);
    //println("Unique colors:"+uniques);
    
    image_preprocessor();
    
    if (g_machine==SPECTRUM) {
       // xcolors=8;
    }
    if (g_attrimode==0) {
        vertti=1;
        erkki=8;
    }
    
    if (int(g_map[13])==ULAPLUS&&sourcemode==SPECTRUM){
        println("ulap special");
        make_ulaplus_zx_palette();
        passhistogram=1;
    }    
    
    if (int(g_map[13])==ULAPLUS&&sourcemode==C64){
   //     prepare_ulaplus(0);
  //      passhistogram=1;
    }
    
    if(int(g_map[13])==ULAPLUS&&passhistogram==0){
      if(uniques<=16){
        if(mode==1){//internal
          ulap_preprocessor();
          ulaplus_prepalette(mode);
          passhistogram=1;
        }
        if(mode==0){//external
        }        
      }
    }
    
   // if(image.width>X*2&&image.height>Y*2){
   //   image.resize(X*2,Y*2);
   // }
 //   color_preprocessor();
    
    if (g_multic==1) {
        limitter=4;
    }//because zero color can be anywhere?
    
    if (g_multic==2||g_multic==3||g_multic==4) {//amiga,st,etc...
        limitter=g_maxcolors;
    }
    molox=1;
        
    store_undo();
    global_clear();
    
    if (g_multic==1||g_hzoomer==2) {
        molox=2;
    }
    ww=0;
    hh=0;
    
    if(mode==0){//file loaded externally
    
      ww=image.width;
      hh=image.height;
      if(ww>2048||hh>2048){
      //  return;
      }
      if(xpass(int(ww))==1&&ypass(int(hh))==1)
      {
          g_report="| [X]  CONVERSION |-|";
      }
      
      g_report=g_report+str(image.width)+" x "+str(image.height)+"|";
      
      if(ww>X&&hh>Y){
        if(xpass(int(ww))==0||ypass(int(hh))==0){
          int[]extents=border_analyser();
          offsetx=extents[0];
          offsety=extents[1];
          ww=extents[2]-extents[0];
          hh=extents[3]-extents[1];
        }         
        if(xpass(int(ww))==0||ypass(int(hh))==0){
          g_report=g_report+"Image scaled|";
        }
      }
      if(int(g_map[13])==ULAPLUS&&passhistogram==0){
        if(uniques<=64){    
          println("  ****");
          internalize(offsetx,offsety,ww,hh);
          //println(offsetx+"."+offsety+".ww:"+ww+" hh:"+hh);
          ulap_preprocessor();
          ulaplus_prepalette(mode);
          passhistogram=1;
          g_data['q']=1;
          //return;
        }
      }
    }
    
    //println("sourcemode:"+sourcemode);
    //println("newmode:"+g_machine);
    
    if(mode==1){//file "loaded" internally
      //previous screenmode
      ww=g_interimwid;
      hh=g_interimhei;
      //println("int:"+ww+"."+hh);
      if(ww<=X&&hh<=Y){
        ww=X;
        hh=Y;
        g_report=g_report+"Image cropped|";
      }
      ww=X;
      hh=Y;
 
      if (g_conv_exception==1) {
        //println("VIC->not VIC");
        ww=ww*2;
      }      
      if (g_conv_exception==2) {
        //println("not VIC->VIC");
        ww=ww/2;
      }
      if(g_machine==ULAPLUS&&passhistogram==0){ // preferable      
          ulap_preprocessor();
          ulaplus_prepalette(mode);
          passhistogram=1;
          g_data['q']=1;
      }
    }
    
    
    // internal or not
    
    if (ww<=16||hh<=16)return;
    
    if(uniques<256){
      g_report=g_report+"Colors:"+uniques+"|";
    }
    if(uniques>=256){
      g_report=g_report+"Colors:256+|";      
    }
    
    balx=int(ww/X);
    balx=balx*molox;
    baly=int(hh/Y);
    
    if (balx<1)balx=1;
    if (baly<1)baly=1;

  //stepped palettes

    if(g_palstepsr>32){
      passhistogram=1;
    }
    g_markctr=10;
    if(g_palstepsr>0&&passhistogram==0){
        for(i=0;i<g_maxcolors;i++){
          //println("emptypal");
          makecolor(i,0,0,0);
        }
        
      int maxhis;
      int pstepsr,pstepsg,pstepsb;
      int pallsr,pallsg,pallsb;
      int palbc,palrc,palgc;
      pstepsr=int(g_divsr);
      pstepsg=int(g_divsg);
      pstepsb=int(g_divsb);
      maxhis=0;
      pallsr=round(255/g_divsr);
      palrc=pallsr+1;
      pallsg=round(255/g_divsg);
      palgc=pallsg+1;
      pallsb=round(255/g_divsr);
      palbc=pallsb+1;
      //println("pallsr:"+pallsr+" * "+g_divsr+" = "+round(pallsr*g_divsr));
      for (cy=0; cy<MY*erkki; cy++) {
        for (cx=0; cx<MX; cx++) {
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
              bity++;
                for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;
                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;
                    bitx++;
                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                          
                          if(mode==0||mode==1){
                            c=image.get(x2+avx+offsetx, y2+avy+offsety);
                            c=colormod(c,bitx,bity,cmod);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));

                          }
                          avg++;
                        }
                    }
                    rh=rr/(avg);
                    gh=gg/(avg);
                    bh=bb/(avg);
                    int closestb=-1;
                    int closestr=-1;
                    int closestg=-1;
                    float distanceb=65536;                   
                    for(int bt=0;bt<g_palstepsr;bt++){
                      float dtest=dist(rh,0,g_stepr[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestr=bt;
                      }
                    }                    
                    distanceb=65536;
                    for(int bt=0;bt<g_palstepsg;bt++){
                      float dtest=dist(gh,0,g_stepg[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestg=bt;
                      }
                    }
                    distanceb=65536;
                    for(int bt=0;bt<g_palstepsb;bt++){
                      float dtest=dist(bh,0,g_stepb[bt],0);
                      if(dtest<distanceb){
                        distanceb=dtest;
                        closestb=bt;
                      }
                    }
                    bh=round(g_stepb[closestb]/g_divsb);
                    rh=round(g_stepr[closestr]/g_divsr);
                    gh=round(g_stepg[closestg]/g_divsg);
                    histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)]++;
                    if(histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)]>maxhis)
                      {
                        maxhis=histog[int(rh*(g_palstepsr*g_palstepsr)+gh*(g_palstepsg)+bh)];
                      }
                }
              }
            }
          }
    
    println(".");
    
      int step=0;
      for(j=maxhis;j>0;j--){
        for(i=0;i<=4096;i++){
           if(histog[i]==j){
              rh=i/int(g_palstepsr*g_palstepsr);
              gh=i-int(rh*(g_palstepsg*g_palstepsg));
              gh=gh/int(g_palstepsg);
              bh=i-int(rh*(g_palstepsr*g_palstepsr));
              bh=bh-int(gh*g_palstepsg);
              rh=round(rh*g_divsr);
              gh=round(gh*g_divsg);
              if(int(g_map[13])==ULAPLUS){
                bh=g_stepb[int(bh)];
              }else{
                bh=round(bh*g_divsb);
              }
              if(step<g_maxcolors){
                if(int(g_map[13])!=ULAPLUS){
                  makecolor(step,rh,gh,bh);
                  step++;
                }
                if(int(g_map[13])==ULAPLUS){
                  makecolor(step,rh,gh,bh);
                  step=step+16;
                  if(step>63)step=step-63;
                }
              }
            }
          }
        }

    }                            
    
    //finished with stepped palettes
    
    println(".");
    
    //histogrammed, let's draw, 8x8 area at time
    
    global_clear();
    g_markctr=10;
    
    int passes=1;
    int colorcount;
    
    if(int(g_map[13])==ULAPLUS)passes=2;
    
    int loss[]=new int[16];
    
    // in case of C64 multicolor mode, test 16 background variants
    // to find the least lossy solution
    // not especially ideal or fast, but at this point the image is not really c64-testable
        
    int ttest=-1;
    int testfrom=int(g_map[1]);
    int testto=int(g_map[1]);
    if(g_colorprofile[1]==0||g_maxcolors>16){
      testfrom=0;
      testto=1;
    }
    if(g_machine==C64M){testfrom=0;testto=17;ttest=1;}
    if(g_machine==MSX){testfrom=0;testto=1;ttest=0;}
    
    if(image.width>640||image.height>512){
      ttest=0;testfrom=0;testto=1;
    }
    
    // c64 modes, infer closest used palette
    
    if(g_map[13]==byte(C64)){
      if(image.width<640&&image.height<512){
        int res=infer_c64_palette();
        if(res>1000){
          res=res-1000;
          cmod=0;
        }
        //g_report=g_report+"Palette:"+res;  
        if(res<0)res=0;
        hard_c64_palette(res,0);
      }
    }
    
    
    for(int testcolor=testfrom;testcolor<testto;testcolor++){
      if(testcolor<16){
        loss[testcolor]=0;    
        g_map[1]=byte(testcolor);
      }
      
      if(testcolor==16&&ttest==1){
        int tru=15;int count=0;
        for(int scan=0;scan<16;scan++){
          if(loss[scan]>count)count=loss[scan];
        }
        for(int scan=0;scan<16;scan++){
          if(loss[scan]<count){count=loss[scan];tru=scan;}
        }
        g_map[1]=byte(tru);
      }
      
      for(int pass=0;pass<passes;pass++){
      
      g_data['q']=0;
      if(pass==0)g_data['q']=1;     
        
      for (cy=0; cy<MY*erkki; cy++) {
        print(".");
        
        for (cx=0; cx<MX; cx++) {
            
            // attack square
            
            colorcount=0;
            
            for (i=0; i<xcolors; i++) {
                pixut[i]=0;
                idx[i]=i;
            }             
            
            bitx=0;bity=0;
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
              bity++;
              
                for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;

                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;
                    bitx++;
                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                            c=image.get(x2+avx+offsetx, y2+avy+offsety);
                            c=colormod(c,bitx,bity,cmod);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));        
                            avg++;                                                              
                        }
                    }
                    rr=round(rr/(avg));
                    gg=round(gg/(avg));
                    bb=round(bb/(avg));
                    g_farge=0;
                    target=-1;
                    compa=65536;
                    
                    for (i=startcolor; i<xcolors; i++) {
                      
                        fld=dist(rr, gg, bb, g_r[i], g_g[i], g_b[i]);
                        
                        if((rr==g_r[i])&&(gg==g_g[i])&&(bb==g_b[i])){
                          compa=-65536;
                          target=i;
                        }
                        if (fld<compa) {
                          compa=fld;
                          target=i;
                        }
                    }
                                        
                    g_farge=target;
                    if(pixut[target]==0)colorcount++;
                    pixut[target]++;//histogramming
                }
            }
            
            //print("("+colorcount+")");
            // sort, but why : creates ordered palette
            // so you see which is the most/least used colors
            // not a huge reason of slowdown!
            
            for (aas=0; aas<xcolors; aas++) {
                for (bbs=0; bbs<=aas; bbs++) {
                    if (pixut[aas]>pixut[bbs]) {
                        swap=pixut[aas];
                        pixut[aas]=pixut[bbs];
                        pixut[bbs]=swap;
                        swap=idx[aas];
                        idx[aas]=idx[bbs];
                        idx[bbs]=swap;
                    }
                }
            }

            //colors identified in this square, are drawn in order
            
            //if(cy<4){println(cx+","+cy+" = "+idx[0]+" & "+idx[1]);}
            
            //limitter in case of some formats
            
            int blimitter=limitter;
            
            // advance the sorted list of colors
            
            int fixx=colorcount;
            if(fixx>limitter)fixx=limitter;
            
            for (idefix=0; idefix<fixx; idefix++) {
                
              i=idx[idefix];
                bitx=0;
                bity=0;
                for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                    bity++;
                    for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                      bitx++;

                        fx2=(ww/X)*xx;
                        fy2=(hh/Y)*yy;
                    
                        x2=int(fx2);
                        y2=int(fy2);

                        rr=0;
                        gg=0;
                        bb=0;
                        avg=0;
                        for (avy=0; avy<baly; avy++) {
                            for (avx=0; avx<balx; avx++) {
                             // if(mode==0||mode==1){
                                c=image.get(x2+avx+offsetx, y2+avy+offsety); 
                                c=colormod(c,bitx,bity,cmod);
                                rr=rr+int(red(c));
                                gg=gg+int(green(c));
                                bb=bb+int(blue(c));                
                                avg++;
                              }   
                           // }
                        }
                        rr=round(rr/(avg));
                        gg=round(gg/(avg));
                        bb=round(bb/(avg));
                        g_farge=0;
                        target=-1;
                        compa=256*256;
                        int fixed=g_maxcolors;
                        if(fixed>colorcount)fixed=colorcount;//what the histogram actually said
                        if(fixed>64)fixed=64;//8x8 after all...
                        if(fixed>limitter)fixed=limitter;
                        
                        //comparison only with the # of colors in area (e.g. 2)
                        for (j=0; j<fixed; j++) {
                            fld=dist(rr, gg, bb, g_r[idx[j]], g_g[idx[j]], g_b[idx[j]]);
                            if(rr==g_r[idx[j]]&&gg==g_g[idx[j]]&&bb==g_b[idx[j]]){
                              compa=-1;
                              target=idx[j];
                            }                            
                            if (fld<compa) {
                              compa=fld;
                              target=idx[j];
                            }
                        }
                        if (i==target&&idefix!=0) {
                            g_farge=target;
                            if(g_machine==MSX && g_farge==0){
                              g_farge=1;
                            }
                            makepoint(xx, yy);
                        }
                    }
                }
                
                if (idefix==0) {//idefix
                      g_farge=idx[0];
                      if(g_machine==MSX && g_farge==0){
                        g_farge=1;
                      }
                      for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                        for (xx=cx*CX; xx<cx*CX+CX; xx=xx+molox) {
                            makepoint(xx, yy);
                        }
                    }
                }
            }
        }
    }
      //testcolors

  }
        // simple lossiness calculation
        
        if(testcolor<16&&ttest==1){
        int f;
        color cmp;
        for(int y=0;y<Y;y++){
          for(int x=0;x<X;x++){
            f=easygetcolor(x,y);
            cmp=image.get(offsetx+x,offsety+y);
            if(red(cmp)!=g_r[f]){loss[testcolor]=loss[testcolor]+abs(int(red(cmp))-g_r[f]);}
            if(green(cmp)!=g_g[f]){loss[testcolor]=loss[testcolor]+abs(int(green(cmp))-g_g[f]);}
            if(blue(cmp)!=g_b[f]){loss[testcolor]=loss[testcolor]+abs(int(blue(cmp))-g_b[f]);}
          }
        }
      }
            
    }
    
//    for(int res=0;res<16;res++){
//      println(res+":"+loss[res]);
//    }
    
  g_data['q']=0;
  //println("");

}

void export_charimage(String name){

    PImage output;
    int wid=0;
    int hei=0;
    int xoff=0;
    int yoff=0;
    
    xoff=0;
    yoff=0;
    wid=128*g_omag;
    hei=128*g_omag;
  
    output= createImage (wid,hei,RGB);
  
    //output the visible graphics as image
    //with border
    //processing style
    int xx, yy, f, x2;
    color c;
    for (xx=0; xx<output.width; xx++) {
        for (yy=0; yy<output.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            output.set(xx, yy, c);
        }
    }

    for (xx=0; xx<128; xx++) {
        for (yy=0; yy<128; yy++) {
            x2=xx; 
            f=getabsa(x2, yy, 0);
            f=easygetcolor(x2,yy);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2; 
                f=getmultic(x2, yy, 0);
            }
            if (g_machine==MSX) {
                if (f==0) {
                    f=g_map[1];
                }
            }
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<=g_omag; vertti++) {
                for (int mortti=0; mortti<=g_omag; mortti++) {
                    output.set(xoff+xx*g_omag+mortti, yoff+yy*g_omag+vertti, c);
                }
            }
        }
    }    
    output.save(name);
}

void export_image(String name)
{
    PImage output;
    int wid=0;
    int hei=0;
    int xoff=0;
    int yoff=0;
    
    if(getbit(136)==0){
      xoff=0;
      yoff=0;
      wid=X*g_omag;
      hei=Y*g_omag;
    }//sans border
    
    if(getbit(136)==1){
      //println("bordv:"+g_bordv);
      wid=X*g_omag+(g_bordh)*g_omag;
      hei=Y*g_omag+(g_bordv)*g_omag;
      xoff=(g_bordh*g_omag)/2;
      yoff=(g_bordv*g_omag)/2;
    }//with border
    
    output= createImage (wid,hei,RGB);
  
    //output the visible graphics as image
    //with border
    //processing style
    int xx, yy, f, x2;
    color c;
    for (xx=0; xx<output.width; xx++) {
        for (yy=0; yy<output.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            output.set(xx, yy, c);
        }
    }

    for (xx=0; xx<X; xx++) {
        for (yy=0; yy<Y; yy++) {
            x2=xx; 
            //f=getabsa(x2, yy, 0);
            f=easygetcolor(x2,yy);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2; 
                f=getmultic(x2, yy, 0);
            }
            
            if (g_machine==MSX && f==0 )f=g_map[1];
            
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<g_omag; vertti++) {
                for (int mortti=0; mortti<g_omag; mortti++) {
                    output.set(xoff+xx*g_omag+mortti, yoff+yy*g_omag+vertti, c);
                }
            }
        }
    }
    output.save(name);
}

void copy_palette(int from,int tow){
  for(int i=0;i<16;i++){
    makecolor(tow+i,g_r[from+i],g_g[from+i],g_b[from+i]);
  }
}

void prepare_ulaplus(int parm){
  if(parm==0){//for c64 convs
    hard_c64_palette(3,0);
    hard_c64_palette(3,16);
    hard_c64_palette(3,32);
    hard_c64_palette(3,48);    
  }
  if(parm==1){
    copy_palette(0,16);
    copy_palette(0,32);
    copy_palette(0,48);
  }
}

int closest_ulared(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ular.length;i++){
    float dtest=dist(val,0,g_ular[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ular[closest];
}

int closest_ulagreen(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ulag.length;i++){
    float dtest=dist(val,0,g_ulag[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ulag[closest];
}

int closest_ulablue(int val){
  float distance=65536;
  int closest=-1;
  for(int i=0;i<g_ulab.length;i++){
    float dtest=dist(val,0,g_ulab[i],0);
    if(dtest<distance){
      distance=dtest;
      closest=i;
    }
  }      
  return g_ulab[closest];
}

int dampr(int v){
  return closest_ulared(v);
}
int dampg(int v){
  return closest_ulagreen(v);
}
int dampb(int v){
  return closest_ulablue(v);
}

void damp_palette(int par){
  int rh,gh,bh;
  for(int i=0;i<256;i++){
    rh=closest_ulared(g_r[i]);
    gh=closest_ulagreen(g_g[i]);
    bh=closest_ulablue(g_b[i]);
    if(par==0)makecolor(i,rh,gh,bh);
    if(par==1){
      g_intr[i]=rh;
      g_intg[i]=gh;
      g_intb[i]=bh;
    }
  }
}


int infer_c64_palette(){
  int score[]=new int[16];
  color cmp;
  int ad,rr,gg,bb;
  for(int i=0;i<16;i++){
    ad=i*16;
    score[i]=0;    
    if(g_rpal64[ad+1]>0){//does palt exist
      for(int y=0;y<image.height;y++){
        for(int x=0;x<image.width;x++){ 
          cmp=image.get(x,y);
          rr=int(cmp >> 16 & 0xff);
          gg=int(cmp >> 8 & 0xff);
          bb=int(cmp & 0xff);
          float maxdis=65536;
          for(int j=0;j<16;j++){
            float dis=dist(rr,gg,bb,g_rpal64[ad+j],g_gpal64[ad+j],g_bpal64[ad+j]);
            if(dis<maxdis)maxdis=dis;
          }
          score[i]=score[i]-int(maxdis);
        }
      }
    }
    
 // println("palt"+i+":"+score[i]);  
  }
  int target=-1;
  int count=0;
  
  for(int i=0;i<16;i++){
    if(score[i]<count){
      count=score[i];
    }
  }  
  
  for(int i=0;i<16;i++){
    if(score[i]>count&&g_rpal64[i*16+1]>0){
      count=score[i];
      target=i;
    }
  }
  
  if(target>=0){
  //  println("palt:"+target);
    return target;
  }
  return -1;
}

int g_rpal64[]=new int[256];
int g_gpal64[]=new int[256];
int g_bpal64[]=new int[256];

void store_c64_palettes(){
  for(int i=0;i<16;i++){
    hard_c64_palette(i,i*16);
  }
  for(int i=0;i<256;i++){
    g_rpal64[i]=g_r[i];
    g_gpal64[i]=g_g[i];
    g_bpal64[i]=g_b[i];
  }
}

void hard_c64_palette(int parm,int ofs){
  
  g_map[9]=byte(parm);
  
  if(parm==0){//pepto
    makecolor(0+ofs,0,0,0);
    makecolor(1+ofs,0xFF,0xFF,0xFF);
    makecolor(2+ofs,0x68,0x37,0x2B);
    makecolor(3+ofs,0x70,0xA4,0xB2);
    
    makecolor(4+ofs,0x6F,0x3D,0x86);
    makecolor(5+ofs,0x58,0x8D,0x43);
    makecolor(6+ofs,0x35,0x28,0x79);
    makecolor(7+ofs,0xB8,0xC7,0x6F);
    
    makecolor(8+ofs,0x6F,0x4F,0x25);
    makecolor(9+ofs,0x43,0x39,0x00);
    makecolor(10+ofs,0x9A,0x67,0x59);
    makecolor(11+ofs,0x44,0x44,0x44);
    
    makecolor(12+ofs,0x6C,0x6C,0x6C);
    makecolor(13+ofs,0x9A,0xD2,0x84);
    makecolor(14+ofs,0x6C,0x5E,0xB5);
    makecolor(15+ofs,0x95,0x95,0x95);  
  }
  
  if(parm==1){//colodore
    makecolor(0+ofs,0,0,0);
    makecolor(1+ofs,0xFF,0xFF,0xFF);
    makecolor(2+ofs,0x81, 0x33, 0x38);
    makecolor(3+ofs,0x75, 0xCE, 0xC8);
    
    makecolor(4+ofs,0x8E, 0x3C, 0x97);
    makecolor(5+ofs,0x56, 0xAC, 0x4D);
    makecolor(6+ofs,0x2E, 0x2C, 0x9B);
    makecolor(7+ofs,0xED, 0xF1, 0x71);
    
    makecolor(8+ofs,0x8E, 0x50, 0x29);
    makecolor(9+ofs,0x55, 0x38, 0x00);
    makecolor(10+ofs,0xC4, 0x6C, 0x71);
    makecolor(11+ofs,0x4A, 0x4A, 0x4A);
    
    makecolor(12+ofs,0x7B, 0x7B, 0x7B);
    makecolor(13+ofs,0xA9, 0xFF, 0x9F);
    makecolor(14+ofs,0x70, 0x6D, 0xEB);
    makecolor(15+ofs,0xB2, 0xB2, 0xB2);  
  }  
  
  if(parm==2){//ptoing out of tomseditor.com examples
      makecolor(0+ofs,0x00,0x00,0x00);
      makecolor(1+ofs,0xFF,0xFF,0xFF);
      makecolor(2+ofs,0x8C,0x3E,0x34);
      makecolor(3+ofs,0x7A,0xBF,0xC7);
      makecolor(4+ofs,0x8D,0x47,0xB3);
      makecolor(5+ofs,0x68,0xA9,0x41);
      makecolor(6+ofs,0x3E,0x31,0xA2);
      makecolor(7+ofs,0xD0,0xDC,0x71);
      makecolor(8+ofs,0x90,0x5F,0x25);
      makecolor(9+ofs,0x57,0x42,0x00);
      makecolor(10+ofs,0xBB,0x77,0x6D);
      makecolor(11+ofs,0x54,0x54,0x54);
      makecolor(12+ofs,0x80,0x80,0x80);
      makecolor(13+ofs,0xAC,0xEA,0x88);
      makecolor(14+ofs,0x7C,0x70,0xDA);
      makecolor(15+ofs,0xAB,0xAB,0xAB);
  }
  
  if(parm==3){//ulaplus "dr. terrorz"
    makecolor(0+ofs,0x00,0x00,0x00); 
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0x6d,0x24,0x00);//922464 technically?
    makecolor(3+ofs,0x6d,0xdb,0xb6);
    
    makecolor(4+ofs,0x92,0x49,0xb6); 
    makecolor(5+ofs,0x49,0xb6,0x6d);
    makecolor(6+ofs,0x24,0x24,0xb6);
    makecolor(7+ofs,0xdb,0xdb,0x6d); //dbff6d technically?

    makecolor(8+ofs,0x92,0x49,0x00);
    makecolor(9+ofs,0x49,0x24,0x00); //49 49 00 technically?
    makecolor(10+ofs,0xb6,0x6d,0x6d);
    makecolor(11+ofs,0x49,0x49,0x6d);
    
    makecolor(12+ofs,0x6d,0x6d,0x6d);
    makecolor(13+ofs,0xb6,0xff,0xb6);
    makecolor(14+ofs,0x6d,0x6d,0xff);
    makecolor(15+ofs,0xb6,0xb6,0xb6);
  }    
  
  if(parm==4){//ulaplus "canonical"
    makecolor(0+ofs,0x00,0x00,0x00); 
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0x92,0x00,0x00);
    makecolor(3+ofs,0xb6,0xff,0xff);
    
    makecolor(4+ofs,0xdb,0x49,0xff); 
    makecolor(5+ofs,0x00,0xdb,0x6d);
    makecolor(6+ofs,0x00,0x00,0xb6);
    makecolor(7+ofs,0xff,0xff,0x6d);

    makecolor(8+ofs,0xdb,0xb6,0x6d);
    makecolor(9+ofs,0x6d,0x49,0x00);
    makecolor(10+ofs,0xff,0x6d,0x6d);
    makecolor(11+ofs,0x24,0x24,0x00);
    
    makecolor(12+ofs,0x6d,0x6d,0x6d);
    makecolor(13+ofs,0xb6,0xff,0x6d);
    makecolor(14+ofs,0x00,0x92,0xff);
    makecolor(15+ofs,0xb6,0xb6,0xb6);
  }  
  if(parm==5){//community colors c64

    makecolor(0+ofs,0x00,0x00,0x00);
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0xaf,0x2a,0x29);
    makecolor(3+ofs,0x6e,0xd8,0xcc);
   
    makecolor(4+ofs,0xb0,0x3f,0xb6);
    makecolor(5+ofs,0x4a,0xc6,0x4a);
    makecolor(6+ofs,0x37,0x39,0xc4);
    makecolor(7+ofs,0xe4,0xed,0x4e);
    
    makecolor(8+ofs,0xb6,0x59,0x1c);
    makecolor(9+ofs,0x68,0x38,0x08);
    makecolor(10+ofs,0xea,0x74,0x6c);
    makecolor(11+ofs,0x4d,0x4d,0x4d);
    
    makecolor(12+ofs,0x84,0x84,0x84);
    makecolor(13+ofs,0xa6,0xfa,0x9e);
    makecolor(14+ofs,0x70,0x7c,0xe6);
    makecolor(15+ofs,0xb6,0xb6,0xb5);   
  }
  if(parm==6){//deekay
    makecolor(0+ofs,0x00,0x00,0x00);
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0x88,0x20,0x00);
    makecolor(3+ofs,0x68,0xd0,0xa8);
   
    makecolor(4+ofs,0xa8,0x38,0xa0);
    makecolor(5+ofs,0x50,0xb8,0x18);
    makecolor(6+ofs,0x18,0x10,0x90);
    makecolor(7+ofs,0xf0,0xe8,0x58);
    
    makecolor(8+ofs,0xa0,0x48,0x00);
    makecolor(9+ofs,0x47,0x2b,0x1b);
    makecolor(10+ofs,0xc8,0x78,0x70);
    makecolor(11+ofs,0x48,0x48,0x48);
    
    makecolor(12+ofs,0x80,0x80,0x80);
    makecolor(13+ofs,0x98,0xff,0x98);
    makecolor(14+ofs,0x50,0x90,0xd0);
    makecolor(15+ofs,0xb8,0xb8,0xb8);     
  }
  if(parm==7){//rgb
    makecolor(0+ofs,0x00,0x00,0x00);
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0xff,0x00,0x00);
    makecolor(3+ofs,0x00,0xff,0xff);
   
    makecolor(4+ofs,0xff,0x00,0xff);
    makecolor(5+ofs,0x00,0xff,0x00);
    makecolor(6+ofs,0x00,0x00,0xff);
    makecolor(7+ofs,0xff,0xff,0x00);
    
    makecolor(8+ofs,0xff,0x80,0x00);
    makecolor(9+ofs,0x80,0x40,0x00);
    makecolor(10+ofs,0xff,0x80,0x80);
    makecolor(11+ofs,0x40,0x40,0x40);
    
    makecolor(12+ofs,0x80,0x80,0x80);
    makecolor(13+ofs,0x80,0xff,0x80);
    makecolor(14+ofs,0x80,0x80,0xff);
    makecolor(15+ofs,0xc0,0xc0,0xc0);     
  }
  if(parm==8){//STE'86 previews on csdb :)
    makecolor(0+ofs,0x00,0x00,0x00);
    makecolor(1+ofs,0xff,0xff,0xff);
    makecolor(2+ofs,0xc8,0x35,0x35);
    makecolor(3+ofs,0x83,0xf0,0xdc);
   
    makecolor(4+ofs,0xcc,0x59,0xc6);
    makecolor(5+ofs,0x59,0xcd,0x36);
    makecolor(6+ofs,0x41,0x37,0xcd);
    makecolor(7+ofs,0xf7,0xee,0x59);
    
    makecolor(8+ofs,0xd1,0x7f,0x30);
    makecolor(9+ofs,0x91,0x5f,0x33);
    makecolor(10+ofs,0xf9,0x9b,0x97);
    makecolor(11+ofs,0x5b,0x5b,0x5b);
    
    makecolor(12+ofs,0x8e,0x8e,0x8e);
    makecolor(13+ofs,0x9d,0xff,0x9d);
    makecolor(14+ofs,0x75,0xa1,0xec);
    makecolor(15+ofs,0xc1,0xc1,0xc1);     
  }  
}

int []g_stepr=new int[256];
int []g_stepg=new int[256];
int []g_stepb=new int[256];

float g_divsr;
float g_divsg;
float g_divsb;
float g_divsbfix;

void make_slider_steps(){
  
   g_divsr=(255.0/(g_palstepsr-1));
   g_divsg=(255.0/(g_palstepsg-1));
   g_divsb=(255.0/(g_palstepsb-1));
   g_divsbfix=(255.0/(g_palstepsr-1));
   println("g_divsr:"+g_divsr);
   
  for(int i=0;i<g_palstepsr;i++){
    g_stepr[i]=round(i*g_divsr);
  }
  for(int i=0;i<g_palstepsg;i++){
    g_stepg[i]=round(i*g_divsg);
  }
  for(int i=0;i<g_palstepsb;i++){
    g_stepb[i]=round(i*g_divsb);
  }
  
  if(int(g_map[13])==ULAPLUS){    
    g_stepb[0]=0;
    g_stepb[1]=0x6d;
    g_stepb[2]=0xb6;
    g_stepb[3]=0xff;
  }    
}

void cga_background(int bg){
  int v=int(g_map[18]);
  v=v&0x0f;
  v=v|(bg*16);
  g_map[18]=byte(v);
  color_clone(bg+16,0);
}

void get_palette_variant(){
  int v=int(g_map[18]);
  int val=v&0x0f;
  cga_variant(val);
}

void cga_variant(int variant){
  
  //Mode 4
  int v=int(g_map[18]);
  v=v&0xf0;
  g_map[18]=byte(v|variant);
  
  if(variant==0){
   //color_clone(16,0);
   color_clone(16+2,1);
   color_clone(16+4,2);
   color_clone(16+6,3);
  }
  if(variant==1){
  // color_clone(16,0);
   color_clone(16+10,1);
   color_clone(16+12,2);
   color_clone(16+14,3);
  }
  if(variant==2){
 //  color_clone(16,0);
   color_clone(16+3,1);
   color_clone(16+5,2);
   color_clone(16+7,3);
  }  
  if(variant==3){
  // color_clone(16,0);
   color_clone(16+11,1);
   color_clone(16+13,2);
   color_clone(16+15,3);
  }    
  
  if(variant==4){
 //  color_clone(16,0);
   color_clone(16+3,1);
   color_clone(16+4,2);
   color_clone(16+7,3);
  }  
  if(variant==5){
  // color_clone(16,0);
   color_clone(16+11,1);
   color_clone(16+12,2);
   color_clone(16+15,3);
  }
  
  if(g_machine==APPLE2){
    // apple II
    if(variant==0){
        makecolor(0,0,0,0);
        makecolor(1,225,225,225);
        
        makecolor(2,57,213,0);//pseudo green
        makecolor(3,208,63,252);//pseude purple
        
        makecolor(4,65,190,0);//pseudo green dark
        makecolor(5,156,74,254);//pseude purple dark
        
        makecolor(6,65/2,190/2,0);//pseudo green dark
        makecolor(7,156/2,74/2,254/2);//pseude purple dark
          
    }  
    if(variant==1){
        makecolor(0,0,0,0);
        makecolor(1,225,225,225);
        
        makecolor(2,255,106,60);//pseudo orange        
        makecolor(3,20,207,253);//pseude blue
        
        makecolor(4,170,71,40);//pseudo orange dark        
        makecolor(5,13,138,169);//pseudo blue dark
        
        makecolor(6,255/2,106/2,60/2);//pseudo orange dark        
        makecolor(7,20/2,207/2,253/2);//pseudo blue dark
    }  
  }
  
}

void make_apple_palette()
{
    cga_variant(0);
}

void make_cga_palette()
{

    makecolor(16+ 0, 0x00, 0x00, 0x00);
    makecolor(16+ 1, 0x00, 0x00, 0xaa);
    makecolor(16+ 2, 0x00, 0xaa, 0x00);
    makecolor(16+ 3, 0x00, 0xaa, 0xaa);
    makecolor(16+ 4, 0xaa, 0x00, 0x00);
    makecolor(16+ 5, 0xaa, 0x00, 0xaa);
    makecolor(16+ 6, 0xaa, 0x55, 0x00);
    makecolor(16+ 7, 0xaa, 0xaa, 0xaa);
    
    makecolor(16+ 8, 0x55, 0xaa, 0xaa);    
    makecolor(16+ 9, 0x55, 0x55, 0xff);
    makecolor(16+10, 0x55, 0xff, 0x55);
    makecolor(16+11, 0x55, 0xff, 0xff);
    makecolor(16+12, 0xff, 0x55, 0x55);
    makecolor(16+13, 0xff, 0x55, 0xff);
    makecolor(16+14, 0xff, 0xff, 0x55);
    makecolor(16+15, 0xff, 0xff, 0xff);
    color_clone(16,0);
    cga_variant(3);
    
}

void make_vic_palette()
{
    /*int rgb[]={#000000,#FFFFFF,#c63729,#99ffff,#db44f9,#81ff5d,#4832ff,#ffff32,#e98f00,#ffdc6f,#ffb6ac,#bcffff,#ffaeff,#bfffa0,#baaaff,#ffff51};
    */
      
    int rgb[]={#000000,#FFFFFF,#8D3C34,#9ADEE3,#A24EB4,#84D171,#4236C4,#E0E866,
               #AF7C36,#EBBC81,#E6A39D,#B6F7FD,#ECA3FC,#B6FEA5,#A098FF,#FAFF85};
               
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#282828;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }       
    for(int i=8;i<16;i++){
      g_usablecolor[i]=6; // can use for backgs, but not for border or pen
    }
    g_map[13]=byte(VIC);
}

void make_c64_palette()
{
    // Pepto's murky C64 palette: http://www.pepto.de/projects/colorvic
    int rgb[]={#000000,#FFFFFF,#68372B,#70A4B2,#6F3D86,#588D43,#352879,#B8C76F, #6F4F25,#433900,#9A6759,#444444,#6C6C6C,#9AD284,#6C5EB5,#959595};
                                       
    //jampal
    
   // int rgb[]={#000000, #ffffff, #7d202c, #4fb3a5, #84258c, #339840, #2a1b9d, #bfd04a, #7f410d, #4c2e00, #b44f5c, #3c3c3c, #646464, #7ce587, #6351db, #939393};                 
                   
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#282828;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_map[9]=0;//pepto
    g_grids[1]=#d0d0d0;g_gridmode=NEW;
    g_map[13]=byte(C64);
    g_colorprofile[PROF_LOADPALETTE]=1;
    g_realaspect=0.937;
    g_alt_aspect=0.750;
}

void make_coco_palette()
{
    for(int i=0;i<g_maxcolors;i++){
      makecolor(i,0,0,0);
    }
}

// was a time plus4 machine identity was same as CPC :/
void plus4_fix(){
  if(g_machine==PLUS4||g_machine==PLUS4M){
    g_map[13]=byte(PLUS4);//legacy fix because of bug
  }
}

void make_plus4_palette()
{
  int rgb[]={
    #000000,#2C2C2C,#621307,#00424C,#510378,#004E00,#27188E,#303E00,#582100,#463000,#244400,#630448,#004E0C,#0E2784,#33118E,#184800,
    #3B3B3B,#702419,#00505A,#601685,#125D00,#36289B,#3F4C00,#663100,#553F00,#345200,#711656,#005C1D,#1F3691,#42229B,#285700,
    #424242,#772C21,#055861,#661E8C,#1B6400,#3E30A2,#475400,#6D3900,#5C4700,#3B5900,#771F5D,#046325,#273E98,#492AA1,#305E00,
    #515151,#843B31,#17656F,#742E99,#2B7100,#4C3FAF,#556200,#7A4709,#6A5500,#4A6700,#852F6B,#177135,#364CA5,#5739AE,#3F6B00,
    #7A7A7A,#AC665C,#468E97,#9C5AC0,#57992E,#766AD5,#7E8A13,#A2713A,#927E20,#748F14,#AC5A93,#459960,#6276CB,#8064D4,#6A9419,
    #959595,#C58178,#62A8B1,#B675D9,#73B34C,#9185ED,#99A433,#BB8C57,#AC993E,#8FAA34,#C676AD,#62B37B,#7D91E4,#9B80ED,#85AE38,
    #AFAFAF,#DE9B93,#7DC2CA,#CF90F2,#8DCD68,#AB9FFF,#B3BE51,#D5A673,#C6B35B,#A9C351,#DF91C7,#7DCC96,#97ABFD,#B59AFF,#9FC755,
    #E1E1E1,#FFCFC6,#B2F4FC,#FFC4FF,#C1FE9D,#DDD2FF,#E5F088,#FFD9A8,#F7E591,#DBF588,#FFC4F9,#B1FEC9,#CBDDFF,#E7CDFF,#D2F98C
  };
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_map[13]=byte(PLUS4);// now plus4 not cpc
    g_alt_aspect=0.844;
}

void make_msx_palette()
{
    int rgb[]={
    #000000,
    #000000,
    #3EB849,
    #74D07D,
    #5955E0,
    #8076F1,
    #B95E51,
    #65DBEF,
    #DB6559,
    #FF897D,
    #CCC35E,
    #DED087,
    #3AA241,
    #B766B5,
    #CCCCCC,
    #FFFFFF};

    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#1f1f1f;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_grids[5]=#9f95Ff;
    g_grids[7]=#84faEF;
    g_grids[9]=#ffa99d;
    g_grids[15]=#d8d8d8;g_gridmode=NEW;
    g_map[13]=byte(MSX);
    g_realaspect=1.138;
    g_alt_aspect=1.138;
}

void make_msx2_palette(){
    makecolor(0,0,0,0);
    makecolor(1,0,0,0);
    makecolor(2,g_stepr[1],g_stepg[6],g_stepb[1]);
    makecolor(3,g_stepr[3],g_stepg[7],g_stepb[3]);
    
    makecolor(4,g_stepr[1],g_stepg[1],g_stepb[7]);
    makecolor(5,g_stepr[2],g_stepg[3],g_stepb[7]);
    makecolor(6,g_stepr[5],g_stepg[1],g_stepb[1]);
    makecolor(7,g_stepr[2],g_stepg[6],g_stepb[7]);
    
    makecolor(8,g_stepr[7],g_stepg[1],g_stepb[1]);
    makecolor(9,g_stepr[7],g_stepg[3],g_stepb[3]);
    makecolor(10,g_stepr[6],g_stepg[6],g_stepb[1]);
    makecolor(11,g_stepr[6],g_stepg[6],g_stepb[4]);
    
    makecolor(12,g_stepr[1],g_stepg[4],g_stepb[1]);
    makecolor(13,g_stepr[6],g_stepg[2],g_stepb[5]);
    makecolor(14,g_stepr[5],g_stepg[5],g_stepb[5]);
    makecolor(15,g_stepr[7],g_stepg[7],g_stepb[7]);    
}

void make_bk_palette()
{
  int rgb[]={#000000,#0000ff,#00ff00,#ff0000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,};
  for(int i=0;i<g_maxcolors;i++){
    rgb[i]=rgb[i]&0xffffff;
    if(i<=8){g_grids[i]=rgb[i]+#282828;}
    makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
  }
  g_realaspect=1.355;
  g_alt_aspect=1.355;
}

void make_ql_palette()
{
  int rgb[]={#000000,#0000FF,#FF0000,#FF00FF,#00FF00,#00FFFF,#FFFF00,#FFFFFF};
    g_grids[0]=#282828;
    g_grids[1]=#0000d8;
    g_grids[2]=#d80000;
    g_grids[3]=#d800d8;
    g_grids[4]=#00d800;
    g_grids[5]=#00d8d8;
    g_grids[6]=#d8d800;
    g_grids[7]=#d8d8d8;  
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_gridmode=NEW;  
    g_realaspect=1.355;
    g_alt_aspect=1.355;
}

void make_ulaplus_palette(){
  //int rgb[]={#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,
  //           #000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff,#000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff};
             int rgb[]={#000000,#b60000,#00b600,#0000b6,#000000,#000000,#000000,#000000,
                        #000000,#6d6d6d,#b6b6b6,#ffffff,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000,
                        #000000,#000000,#000000,#000000,#000000,#000000,#000000,#000000};
    for(int i=0;i<64;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);   
    }
    for(int i=16;i<24;i++){
      rgb[i]=rgb[i]&0xffffff;  
    }     
    g_map[13]=byte(ULAPLUS); 
}

void make_ulaplus_zx_palette(){
  int rgb[]={#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,#000000,#0000b6,#b60000,#b600b6,#00b600,#00b6b6,#b6b600,#b6b6b6,
             #000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff,#000000,#0000ff,#ff0000,#ff00ff,#00ff00,#00ffff,#ffff00,#ffffff};

    for(int i=0;i<64;i++){
      makecolor(i,0,0,0);
    }
    for(int i=0;i<16;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i+16,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
      makecolor(i+24,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);    
    }
    for(int i=16;i<24;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i+16,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
      makecolor(i+24,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);    
    }     
    g_map[13]=byte(ULAPLUS);
}

void make_spectrum_palette()
{
  int rgb[]={#000000,#0000B6,#B60000,#B600B6,#00B600,#00B6B6,#B6B600,#B6B6B6,
              #000000,#0000FF,#FF0000,#FF00FF,#00FF00,#00FFFF,#FFFF00,#FFFFFF};
              
    g_grids[9]=#0000d8;
    g_grids[10]=#d80000;
    g_grids[11]=#d800d8;
    g_grids[12]=#00d800;
    g_grids[13]=#00d8d8;
    g_grids[14]=#d8d800;
    g_grids[15]=#d8d8d8;
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      if(i<=8){g_grids[i]=rgb[i]+#282828;}
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_gridmode=NEW;
    g_map[13]=byte(SPECTRUM);
}

void splurge_colors(String inp){
  int phase=0;
  int c=0;
  int r=0,g=0,b=0;
  for(int i=0;i<inp.length();i=i+2){
    char hi=inp.charAt(i);
    char lo=inp.charAt(i+1);
    int val=unhex(str(hi))*16+unhex(str(lo));
    if(phase==0)r=val;
    if(phase==1)g=val;
    if(phase==2)b=val;
    phase++;
    if(phase>2){
      makecolor(c,r,g,b);
      c++;
      phase=0;
    }
  }
}

void make_tic_palette()
{
  splurge_colors("1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57");
}
void make_zxnext_palette()
{
  int r=0;
  int g=0;
  int b=0;
  int bstep[]={0,73,182,255}; //?? correct ?? different from ulaplus?
  int rgstep[]={0,36,73,109,146,182,219,255};
 // splurge_colors("000000254854274ba7242554252ba7484855494ba8482ba76c2ca7472654902ca8b42da86c26548f27556c4855b427566d6d56496c56276c55296ea84a6ea84a50fb6d50fb6d4ba89051fbb551fb904ca8b44ca8d82ea9904956b44957d84a58b56d58906d574b90572b90572c91a94b72fb6d6ea86e72fb9172fb906fa8d852fcfd52fcb56fa9d84da9fc4daafc4a59fd6e5ad86d59b590599190586e90582fb4594b91a96e91a94c94fc6f94fc9191a9b572fcd873fcfd73fcd86fa9fd70aafd915cd8915a92b55b6fb55a4db55a70b6aa4db5aa30b5aa4eb7fc70b7fc9294fcb694fcd994fcb592aad992aafd92abd9b6abfdb55ed9b55cb6b55bb6b6ab93d85d71d85d4fd85c71d9ab50d9ab92b6aa51dafd93b7fcb6b8fdd9b8fdfd95fdfdb6acfed960dad95fdad9acb7d85eb7d9ac73fd6053fd6093d9ab73fdad53fdac54fffe72dafd94dafdb7dbfdfeb8fdfffffffed9adfffd64fffeaedbfd62b8fd61dbfeae95fd61b8fead95fead74fffe95fffeb8fffedbffffdadbfefedbfefed831fffd38dad82edbfd35b7d82cb8fd3395fd3173fd3052fd2f38fd2f38fd5f2afd5f39fdac2bfdac3afffe2dfffefd9026fdb52bd9b528b6b52592b42293d82a71d8284fd82733d82629fd2e33d85c22d85c34d9ab23d9ab26dafd35dafdfd6d21d86d1dd89022b5901e91901b6e90196fb4204db41f2eb41e22d8261ab41e1bb4591db5aa1fb7fc31b7fc2e94fcfc281cfc491ed84919b46c19906c156d6c12496c0f4a90172a90161390161390571691a91994fc1472fb2b72fbfd37fcfc0d1bd82717b4481490480f6c480b276c0e0b6c0d0c6c550f6ea82950fb9035fbb536fbd837fcfc2fa9d82957fc2a59d80a16b426118f250c484708254706064854094ba70f50fb4934fb6d35fbb426fbd827fcd819a9fc1ba9d80e57fc1158b406108f040a6c2407472404054706062ba70c34fb2734fb4924fb6d24fb9025fb6c15a79016a8b417a88f0955b40b566c02064701022300012424020223020225540b24fb0414a70105532724fb2514a74815a72406534706546c0754fd28fc"); 
  for(int i=0;i<256;i++){
    makecolor(i,rgstep[r],rgstep[g],bstep[b]);
    b=b+1;
    if(b>3){
      b=0;
      g=g+1;
      if(g>7){
        g=0;
        r=r+1;
      }
    }    
  }
  for(int i=0;i<256;i++){
    g_nextpalt[i*3]=byte(g_r[i]);
    g_nextpalt[i*3+1]=byte(g_g[i]);
    g_nextpalt[i*3+2]=byte(g_b[i]);
  }
}


void invoke_machine(String mname){
  for(int i=0;i<g_machinecalled.length;i++){
    if(mname.equals(g_machinecalled[i])){
      change_mode(g_machinemenu[i],i);
    }
  }
}

//provisional non-standard sizes
//follows from APPLY used in RESIZE window
void change_size(){
    int complexity=interim_store();
    MX=int(g_data[NEWX]);
    MY=int(g_data[NEWY]);
    X=MX*8;
    Y=MY*8;
    g_map[5]=byte(MX);
    g_map[7]=byte(MY);
    resize_preview();
    
    println("newX="+X);
    println("newY="+Y);
    if(g_colorprofile[PROF_REBITPLANE]==1){
      int newc=byte(g_data[NEWBPL]);
      g_planes=newc;
      println("newplanes:"+g_planes);
      newc=2<<(newc-1);
      g_maxcolors=newc;
      println("new colors:"+newc);
      g_map[4]=byte(newc-1);
      g_map[14]=byte(g_planes);
    }
    realdiscardmenus(0);
    make_mirror(X/2-1,Y/2-1);
    make_grid(8,8);// conflicting?
    re_scale();
    update_ui(false,0);
    clear_brush();
    reset_uq_engine();

    import_image("",1,1); // ,1 = internal using g_fillmap    
}

// for loading e.g. Amiga files
void infer_bitplanes(){
  g_planes=int(g_map[14]);
  g_maxcolors=int(g_map[4])+1;
  g_data[NEWBPL]=byte(g_planes);
}

// for loading e.g. Amiga files
void infer_size(){
  if(g_map[5]==0||g_map[7]==0)return;
  MX=int(g_map[5]);
  MY=int(g_map[7]);
  X=MX*8;
  Y=MY*8;
  resize_preview();
  realdiscardmenus(0);
 // make_grid(8,8);
  re_scale();
  update_ui(false,0);
}

void change_mode_value(int m){
  for(int i=0;i<g_machineidx.length;i++){
    if(g_machineidx[i]==m){
      for(int j=0;j<g_machinemenu.length;j++){
       if(g_machinemenu[j]==m){
         change_mode(g_machineidx[i],j);
        return;
       }
      }
    }
  }
}

int g_conv_exception;
//void mode_change

int g_pancentrex;
int g_pancentrey;

void refocus(){  
    int psizex=g_magpix[magmode()];
    int psizey=g_magpiy[magmode()];
    g_panx=0;
    g_pany=0;
   // println("XSIZE:"+viewport_width(0));
   // println("WSIZE:"+width);
    g_ofx=-((width-48*g_uizoom)-viewport_width(0))/2-g_leftedge;
   // println("psizex:"+psizex);
    g_ofx=g_ofx/psizex;
   // println("g_ofx:"+g_ofx);
   // println("g_ofy:"+g_ofy);
        
    g_ofy=-((height-48*g_uizoom)-viewport_height(0))/2;
    g_ofy=g_ofy/psizey;
    
    g_pancentrex=g_ofx;
    g_pancentrey=g_ofy;
}

void change_mode(int m,int idx)
{  
  
   reset_uq_engine();
   store_undo();
   
   if((m==ULAPLUS||m==ULAFREE||m==ULATMX)){
     if(int(g_map[13])==C64){
       hard_c64_palette(3,0);//ulaplus variant 
       //println("ULAPALT prepare");
     }else{
        // damp ulaplus palette
       damp_palette(0);
     }
   }
            
    g_banctr=20;
    reset_iconlist();
    store_palette(1);
    remake_palette();
    
    int oldmachine=g_machine;
    int complexity=interim_store();
    
    // after this point, it is in "image"
    
    int pastcolormode=int(g_map[13]);
    int pastcolors=g_maxcolors;
    int oldborder=int(g_map[0]);
    
    // previous size is in g_interimwid,hei
    
    g_conv_exception=0;
    
    if(oldmachine==VIC&&m!=VIC){
      g_conv_exception=1;
    }
    if(oldmachine!=VIC&&m==VIC){
      g_conv_exception=2;
    }    
    g_machine=m;
    g_machineindex=idx;
    g_machinename=get_machinename(m);
    println("MODENAME:"+g_machinename);
    println("MODECHANGE:("+m+","+idx+")");
    create_aspects();
    g_ext_executed=-1;
    g_ext_executeds=-1;
    g_extfilename="";
    g_extfilenames="";
    for(int i=0;i<256;i++){
      g_usablecolor[i]=255;
    }
    for(int i=0;i<16;i++){
       g_colorprofile[i]=0;
       g_grids[i]=#282828;
       g_rgb[i]=0xffffff;
    } 
    g_gridmode=OLD;
    
    //makecolor(257,255,180,180);
    //g_rgb[257]=0xff808080;
        
   set_machine(g_machine);
   g_pal_aspect=g_realaspect;
  
   //inter-c64 modes
   if(pastcolormode==C64&&int(g_map[13])==C64){
     recall_palette(1);
     remake_palette();
   } 
    if(width<viewport_width(0)+64*g_uizoom||height<viewport_height(0)+56*g_uizoom){
      surface.setSize(viewport_width(0)+64*g_uizoom,viewport_height(0)+56*g_uizoom);
    }
    
    if(g_aspect_override==1 && g_machine==MSX)g_aspect=SQUARERATIO;

    MX=X/8;
    MY=round(Y/8);
    resize_preview();
    
    refocus();
    
    g_map[5]=byte(MX);
    g_map[7]=byte(MY);
    
    g_data['m']=0;
    g_data['M']=0;
    
    g_maglevel=0;
    
    g_trustorex=X*g_magpix[magmode()];
    g_trustorey=Y*g_magpiy[magmode()];
        
    setup_windows(g_guileft,X,Y);//1=lefthander
    
    g_windowx=int(g_winlocx[0]);
    g_windowy=int(g_winlocy[0]); 
 
    g_map[4]=byte(g_maxcolors-1);
    //g_map[13]=byte(machine);
    g_data[FX]=byte(0);//paintmode
    g_ofarge=g_farge;
  
    clear_parameters();    
    
    g_rubbermode=0;
    magmode();
    
    if(pastcolormode==int(g_map[13])&&pastcolors==g_maxcolors){
      set_border(oldborder);
    }
    
    sussborder();
    true_clear();
  
   if(g_forcedpalette.length()>3)palette_loader(g_forcedpalette);
   
   wipe_out();
   global_clear();
   
   g_spare=0;
   copy_to_spare();
   refresh_all();
   update_ui(true,0);
   int x=int(g_data[GRIDX]);
   int y=int(g_data[GRIDY]);
   //x=8;
   //y=8;
   make_grid(CX,CY);
   
   clear_brush();
   
   g_spare=1;
   setname("",1);
   clamp_undo();
   untouch();
   
   g_spare=0;
   
   setname("",0);
   clamp_undo();
   untouch();
   set_tool(3);
   g_data['f']=1;
   g_data['g']=1;
   g_btype=0;
   g_bsize=0;
   
   if(complexity>1&&g_interimwid>0){   
     if(pastcolormode==int(g_map[13])){
       //prepare_ulaplus(0);
     }
     // import_image actually
     interim_recall(pastcolormode);
     clamp_undo();   
   }   
   
   if(pastcolormode==C64&&int(g_map[13])==C64){
     recall_palette(1);
     remake_palette();
     set_border(oldborder);
   }
  
   if(pastcolormode!=C64&&int(g_map[13])==C64){
     hard_c64_palette(0,0);//just pepto it
   }   
   force_autohistogram();  
   force_unique_chars();
   reboot();
   
   if(g_machine==TUTORIAL1){   
      //x_com(0,"COLODORE",0,0,0);
      x_com(0,"HELP",0,0,0);
   }
   refocus();
   check_maxcolor();
}

void check_maxcolor(){
  if(g_farge>=g_maxcolors){
    selectcolor(0,g_maxcolors-1);    
  }
  if(g_backg>=g_maxcolors){
    selectcolor(1,g_maxcolors-1);    
  }  
}

int interim_store(){
  for(int i=0;i<256;i++){
    g_intr[i]=g_r[i];
    g_intg[i]=g_g[i];
    g_intb[i]=g_b[i];
  }
  g_interimwid=X;
  g_interimhei=Y;
  int complex=get_complexity();
  return complex;    
}

color prc_color(int idx){
  return color(g_r[idx],g_g[idx],g_b[idx]);
}

int get_complexity(){
  image=createImage(X, Y, RGB);
  int prev=easygetcolor(0,0);
  int comp=0;
  //println("getc:"+X+"*"+Y);
  for(int y=0;y<Y;y++){
    for(int x=0;x<X;x++){
      int c=easygetcolor(x,y);
      if(c!=prev)comp++;
      prev=c;
      //g_fillmap[x+y*X]=byte(c);
      image.set(x,y,prc_color(c));
    }
  }
  return comp;
}

void interim_recall(int original){
  import_image("",1,original);
}

void wipe_out(){
   for(int y=0;y<Y;y++){
     for(int x=0;x<X;x++){
       absolute_clearpoint(x,y);
     }
  }
  for(int i=1024;i<65535;i++){
    g_map[i]=byte(0);
  }
  if(g_multic!=3&&g_multic!=4){
     for(int i=0;i<MX*MY*8;i++){
      g_map[65536+i]=byte(0);
      g_map[65536+i+MX*MY*8]=byte(0);
    }   
  }
 }
   
void set_machine(int m)
{
    g_realaspect=1.000;
    g_pal_aspect=1.000;
    g_alt_aspect=1.000;
    g_machine=m;
    g_multic=0;
    g_expname="";
    g_tempname="";
    g_map[3]=byte(g_machine);
    g_map[13]=byte(g_machine);
    palettesteps(0);
    g_map[0]=0;
    g_farge=1;g_backg=0;g_britemode=0;
    g_charlimit=0;g_hzoomer=1;g_backmode=0;
    g_pixelw=1;
    g_formatname="";
    g_gridmode=OLD;
    g_formatextension="";
    g_maxcolors=16;X=320;Y=200;
    g_aspect=SQUARERATIO;
    g_colorprofile[PROF_BORDER]=1;//border changeable?
    g_colorprofile[PROF_BACKGND]=1;//backg changeable?
    g_colorprofile[PROF_BACKGND2]=0;//backg2 changeable? plus4
    g_colorprofile[PROF_PALTOOLS]=0;//paltools changeable? atari ST, ulap, cpc
    g_colorprofile[PROF_FXTOOLS]=0;//fxtools atari st
    g_colorprofile[PROF_REPALETTE]=1;//repalette if internal conversion
    g_map[240]=0;
    g_map[241]=0;//range
    g_scanlimit=0; // colors per scanline limit (could be more than 1 in future)
    CX=8;
    CXM=4;
    CY=8;
    
    if (g_machine==TUTORIAL1) {//c64 hires
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="prg";
        g_formatname="";
        g_formatextension="";
        g_tempname="";
        g_name="c64";
        g_attrimode=1;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();        
    }
    
    if (g_machine==VIC) {    //vic "hires" 
        g_colorprofile[PROF_BACKGND]=1;
        g_charlimit=1;
        g_backmode=1;
        g_name="vch";g_expname="prg";
        X=176*2;Y=176;
        g_attrimode=1;
        g_multic=1;
        g_map[1]=byte(1);  
        g_map[0]=3;
        g_maxcolors=16;
        make_vic_palette();
        make_grid(16,16);
        CX=16;
        CXM=8;
        CY=16;
        g_backg=1;
        g_farge=0;
        g_realaspect=0.809;
        g_alt_aspect=0.750;
    }
    if (g_machine==VICM) {    //vic "multicolor" bit like plus4m but not really
        g_colorprofile[PROF_BACKGND]=1;
        g_colorprofile[PROF_BACKGND2]=1;//backg2
        g_backmode=1;
        g_charlimit=1;
        g_multic=1;
        g_name="vcm";g_expname="prg";
        X=176;Y=176;
        CX=8;
        CXM=4;
        CY=16;
        g_attrimode=1; 
        g_map[0]=byte(3);
        g_map[1]=byte(1); 
        g_map[2]=byte(14); 
        g_maxcolors=16;
        make_vic_palette();
        make_grid(8,16);
        g_backg=1;
        g_farge=0;
        g_realaspect=0.809*2;
        g_alt_aspect=0.750*2;
    }    
    
    if (g_machine==C64) {//c64 hires
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="prg";
        g_formatname="Art Studio";
        g_formatextension="art";
        g_tempname="c64show.prg";
        g_name="c64";
        g_attrimode=1;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (g_machine==C64M) {    //c64 multicolor
        g_backmode=1;
        g_charlimit=3;
        g_multic=1;
        g_name="c64m";g_expname="prg";
        g_formatname="Koala";
        g_tempname="c64mnew.prg";
        g_formatextension="kla";
        g_attrimode=1;
        g_map[1]=byte(0);  
        g_map[0]=6;
        make_c64_palette();
        g_colorprofile[9]=1;//UQ display
    }
    
    if (g_machine==GX4000) {  //Amstrad Plus/GX4000
        X=320;Y=200;
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_FXTOOLS]=1;//fxtool
        g_hzoomer=2;
        palettesteps(16);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;
        
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            }
        }
      g_map[240]=0;
      g_map[241]=15;//range
    }
    
        if (g_machine==GXOC4000) {  //Amstrad CPC mode 0 overscan
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_FXTOOLS]=1;//fxtool
        g_hzoomer=2;
        g_planes=4;
        palettesteps(16);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0oc.bin";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        X=384;Y=272;
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            }
        }
    }   
    /*
    
    if (g_machine==GXOC4000) {  //Amstrad Plus/GX4000
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
       // g_colorprofile[PROF_RESIZE]=1;//resizable
       // g_colorprofile[PROF_REBITPLANE]=1;//1-5 bitplanes
        g_backmode=1;
        X=384;Y=272;
        g_maxcolors=16;
        g_multic=4;
        g_planes=4;
        g_data[NEWBPL]=byte(g_planes);
        palettesteps(16);
        g_name="cpc";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            }
        }
    }
    */
    
        
    if (g_machine==TO8A) {  //Thomson 160x200
        X=320;Y=200;
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_FXTOOLS]=1;//fxtool
        g_hzoomer=2;
        palettesteps(16);
        g_name="to8";g_expname="bin";
        g_tempname="thomson.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;
        
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            }
        }
      g_map[240]=0;
      g_map[241]=15;//range
    }    
    
    if (g_machine==CPC) {  //Amstrad CPC mode 0
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }
    
    if (g_machine==CPC1) {  //Amstrad CPC mode 1
        g_colorprofile[PROF_BACKGND]=0;
        palettesteps(3);
        g_name="cp1";
        g_expname="bin";
        g_tempname="cpc_mode1.bin";
        g_formatname="";
        g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_maxcolors=4;

        g_colorprofile[PROF_PALTOOLS]=1;
        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }
    
    if (g_machine==CPCNOLIMIT) {  //Amstrad CPC mode 1 free
        g_colorprofile[PROF_BACKGND]=0;
        palettesteps(3);
        g_name="cp1";
        g_expname="bin";
        g_tempname="cpc_mode1.bin";
        g_formatname="";
        g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);
        g_map[0]=1;
        g_maxcolors=27;
        g_scanlimit=4;//4 per horizontal, just a warning
        
        g_colorprofile[PROF_REPALETTE]=0;//no repalette here
        g_colorprofile[PROF_PALTOOLS]=1;
        

        makecolor( 0,   0,   0,   0);// black        
        makecolor( 1,   0,   0, 128);// blue         
        makecolor( 2,   0,   0, 255);// bright blue  
        makecolor( 3, 128,   0,   0);// red          
        makecolor( 4, 128,   0, 128);// magenta      
        makecolor( 5, 128,   0, 255);// mauve        
        makecolor( 6, 255,   0,   0);// bright red   
        makecolor( 7, 255,   0, 128);// purple       
        makecolor( 8, 255,   0, 255);// bright magenta
        makecolor( 9,   0, 128,   0);// green        
        makecolor(10,   0, 128, 128);// cyan         
        makecolor(11,   0, 128, 255);// sky blue     
        makecolor(12, 128, 128,   0);// yellow       
        makecolor(13, 128, 128, 128);// white        
        makecolor(14, 128, 128, 255);// pastel blue  
        makecolor(15, 255, 128,   0);// orange       
        makecolor(16, 255, 128, 128);// pink         
        makecolor(17, 255, 128, 255);// pastel magenta
        makecolor(18,   0, 255,   0);// bright green 
        makecolor(19,   0, 255, 128);// sea green    
        makecolor(20,   0, 255, 255);// bright cyan  
        makecolor(21, 128, 255,   0);// lime         
        makecolor(22, 128, 255, 128);// pastel green 
        makecolor(23, 128, 255, 255);// pastel cyan  
        makecolor(24, 255, 255,   0);// bright yellow
        makecolor(25, 255, 255, 128);// pastel yellow
        makecolor(26, 255, 255, 255);// bright white 
    }    
    
    if (g_machine==PCCGA) {  //PC CGA 4-color
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_BORDER]=0;
        g_name="cga";g_expname="";
        g_formatname="";g_formatextension="";
        g_multic=4;
        g_planes=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_maxcolors=4;

        make_cga_palette();
        
    }
    
    if (g_machine==CPCOC) {  //Amstrad CPC mode 0 overscan
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0oc.bin";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        X=384;Y=272;
        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }    
    if (g_machine==MSX) {    // MSX
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=1;//misleading?
        g_map[1]=0;
        g_name="msx";
        g_expname="com";
        g_formatname="Screen 2";        
        g_tempname="msxshow.com";
        g_formatextension="sc2";
        X=256;Y=192;
        g_attrimode=0;
        g_backmode=1;
        g_aspect=FLATRATIO;
        g_farge=15;
        g_backg=0; 

        make_msx_palette();
    }
    
    if (g_machine==ULATMX) {    // Ulaplus Timex 8x1
    
        g_colorprofile[PROF_BORDER]=1;//border changeable?
        g_colorprofile[PROF_BACKGND]=1;//misleading?
        g_map[1]=0;
        g_name="tmx";
        g_expname="scr";
        g_formatname="ULA Timex";
        g_formatextension="scr";
        X=256;Y=192;
        g_attrimode=0;
        g_backmode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);

        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }
    
    if (g_machine==ULAFREE) {//ULAplus with less palette limitations
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        g_name="ULAfree";
        X=256;Y=192;
        g_attrimode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);
        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }    
    
    if (g_machine==ULAPLUS) { // ZX Spectrum ULAPLUS //grb332
        g_colorprofile[PROF_BACKGND]=0;   
        g_name="ulap";
        g_expname="tap";
        X=256;Y=192;
        g_formatname="Screen$";g_formatextension="scr";
        g_tempname="ulashow.tap";
        g_farge=9;
        g_backg=0;
        g_attrimode=1;
        g_britemode=1;
        g_maxcolors=64;
        g_map[0]=15;//==7 "default"
        g_map[1]=byte(255);
        g_colorprofile[PROF_PALTOOLS]=1;
        make_ulaplus_palette();

        g_palstepsr=8;
        g_palstepsg=8;
        g_palstepsb=4;
    }
 
    if (g_machine==SPECTRUM) { // ZX Spectrum
        g_colorprofile[PROF_BACKGND]=0;
        g_name="spec";
        g_expname="tap";
        X=256;Y=192;
        g_formatname="Screen$";g_formatextension="scr";
        g_tempname="specshow.tap";
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_britemode=1;
        g_map[0]=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }   
    if (g_machine==ZXNEXT) {    //ZX NEXT
        g_colorprofile[PROF_BORDER]=2;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=0;//resizable
        g_colorprofile[PROF_REBITPLANE]=0;//1-5 bitplanes
        g_colorprofile[PROF_REPALETTE]=0;//no repalette for zxnext
        g_backmode=1;
        //X=320;Y=256;
        X=256;Y=192;
        g_maxcolors=256;
        g_multic=4;
        g_planes=8;
        palettesteps(8);
        g_data[NEWBPL]=byte(g_planes);
        g_name="nxt";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
              
        make_zxnext_palette();
        //01010011 1
    }
    if (g_machine==ZXNEXTB) {    //ZX NEXT 320x256
        g_colorprofile[PROF_BORDER]=2;//not much of a border
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=0;//resizable
        g_colorprofile[PROF_REBITPLANE]=0;//1-5 bitplanes
        g_colorprofile[PROF_REPALETTE]=0;//no repalette for zxnext
        g_backmode=1;
        X=320;Y=256;
        g_maxcolors=256;
        g_multic=4;
        g_planes=8;
        palettesteps(8);
        g_data[NEWBPL]=byte(g_planes);
        g_name="nxt";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
              
        make_zxnext_palette();
        
    }   
    if (g_machine==PCVGA) {    //PC VGA
        g_colorprofile[PROF_BORDER]=2;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=0;//resizable
        g_colorprofile[PROF_REBITPLANE]=0;//1-5 bitplanes
        g_colorprofile[PROF_REPALETTE]=0;//no repalette for zxnext
        g_backmode=1;
        X=320;Y=200;
        g_maxcolors=256;
        g_multic=4;
        g_planes=8;
        palettesteps(64);
        g_data[NEWBPL]=byte(g_planes);
        //palettesteps(16);
        g_name="vga";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
              
        make_zxnext_palette();
        
    }    
    if (g_machine==TIMEX) {    // timex sinclair
        g_colorprofile[PROF_BACKGND]=0;
        g_name="tmx";
        X=256;Y=192;
        g_farge=7;
        g_backg=0;
        g_attrimode=0;
        g_britemode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }

    if (g_machine==JR200) {  // Panasonic JR200
        g_colorprofile[PROF_BACKGND]=0;
        g_name="jr200";
        X=256;Y=192;
        g_maxcolors=8;
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();//cheating
    }

    if (g_machine==PLUS4M||g_machine==PLUS4) { // Commodore plus/4
        g_colorprofile[PROF_BACKGND]=1;
        g_colorprofile[PROF_BACKGND2]=1;//backg2
        g_backmode=1;
        g_multic=1;    
        g_name="plus4m";
        g_expname="prg";
        g_attrimode=1;
        g_maxcolors=121;
        g_charlimit=2;
        g_map[1]=0;g_map[2]=61;g_farge=61;
        g_formatname="M.Botticelli";
        g_formatextension="prg";
        g_tempname="showpfourm.prg";
        if (g_machine==PLUS4) { // plus/4 hires
            g_tempname="showpfour.prg";
            g_colorprofile[PROF_BACKGND]=0;
            g_colorprofile[PROF_BACKGND2]=0;//backg2
            g_formatname="Botticelli";
            g_formatextension="prg";
            g_multic=0;
            g_backmode=0;
            g_charlimit=0;
            g_name="plus4";
            g_attrimode=1;
            g_map[1]=byte(255);
        }
        g_map[0]=6;
        make_plus4_palette();
    }


    if (g_machine==QLLOW) { // Sinclair QL low        
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_backmode=0;
        g_maxcolors=8;
        X=256;Y=256;
        g_name="QL";
        g_tempname="internal";
        g_formatname="mode8";
        g_formatextension="scr";
        g_multic=2;
        g_attrimode=2;
        g_aspect=FLATRATIO;
        g_map[1]=byte(0);       
        make_ql_palette();
    }
    
    if (g_machine==BK0010) { // BK0010 patch
        g_colorprofile[PROF_BACKGND]=0;
        g_backmode=0;
        g_maxcolors=4;
        X=256;Y=256;
        g_name="BK";
        g_multic=2;
        g_attrimode=2;
        g_aspect=FLATRATIO;
        g_map[1]=byte(0);       
        make_bk_palette(); 
    }    

    if (g_machine==CPCOC) {  //Amstrad CPC mode 0 overscan
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        palettesteps(3);
        g_name="cpc";g_expname="bin";
        g_tempname="cpc_mode0oc.bin";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
        g_colorprofile[PROF_PALTOOLS]=1;

        X=384;Y=272;
    }    
    
    if (g_machine==BBCHI) {    //generic 16bit 4096 color
        
        palettesteps(2);
        g_colorprofile[PROF_BACKGND]=0;
        g_planes=2;
        g_maxcolors=4;
        g_name="bbclo";g_expname="";
        g_tempname="";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        X=320;Y=256;
        
        makecolor(0,0,0,0);
        makecolor(1,255,0,0);
        makecolor(2,0,255,0);
        makecolor(3,255,255,0);
        makecolor(4,0,0,255);
        makecolor(5,255,0,255);
        makecolor(6,0,255,255);
        makecolor(7,255,255,255);
    }
    
    if (g_machine==BBCLOW) {    //generic 16bit 4096 color
        
        palettesteps(2);
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        g_planes=4;
        g_maxcolors=8;
        g_name="bbclo";g_expname="";
        g_tempname="";
        g_formatname="";g_formatextension="";
        g_multic=3;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        X=320;Y=256;
        
        makecolor(0,0,0,0);
        makecolor(1,255,0,0);
        makecolor(2,0,255,0);
        makecolor(3,255,255,0);
        makecolor(4,0,0,255);
        makecolor(5,255,0,255);
        makecolor(6,0,255,255);
        makecolor(7,255,255,255);
    }
    
    if (g_machine==AMIGA) {    //generic 16bit 4096 color
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=1;//resizable
        g_colorprofile[PROF_REBITPLANE]=1;//1-5 bitplanes
        g_backmode=1;
        X=320;Y=256;
        g_maxcolors=32;
        g_multic=4;
        g_planes=5;
        g_data[NEWBPL]=byte(g_planes);
        palettesteps(16);
        g_name="amy";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsg));
            } else
            {
                makecolor(z, round((z-16)*g_divsr), 0, 0);
            }
        }
    }

    if (g_machine==MSX24) {    //based on AMIGA
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=1;//resizable
        g_colorprofile[PROF_REBITPLANE]=1;//1-5 bitplanes
        g_backmode=1;
        X=256;Y=212;
        Y=216; // for now
        g_maxcolors=16;
        g_multic=4;
        g_planes=4;
        g_data[NEWBPL]=byte(g_planes);
        palettesteps(8);
        g_name="msx";
        g_tempname="internal";
        g_formatextension="com";
        g_attrimode=2;
        g_map[1]=byte(0);
        make_msx2_palette();
    }
    
    if (g_machine==ATARIST) {    //ATARI ST 512 color
        g_colorprofile[PROF_BORDER]=0;   //border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;  
        g_backmode=1;
        g_maxcolors=16;
        palettesteps(8);
        g_name="st";
        g_formatname="Degas";
        g_tempname="internal";
        g_formatextension="pi1";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(0);
        g_map[240]=byte(0);
        g_map[241]=byte(7);
        g_realaspect=1.0;
        g_alt_aspect=0.833;//60hz
              
        for (int z=0; z<8; z++) {
            makecolor(z, round(z*g_divsr), round(z*g_divsg), round(z*g_divsb));
            makecolor(z+8, round(z*g_divsr),0,0);
        }
    }
    
    if (g_machine==APPLE2) {    //1 bit 280x192
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=0;
        g_colorprofile[PROF_FXTOOLS]=0;
        g_colorprofile[PROF_RESIZE]=0;//resizable
        g_colorprofile[PROF_REBITPLANE]=0;//1-5 bitplanes
        g_backmode=1;
        X=280;Y=192;
        g_maxcolors=2;
        g_multic=4;
        g_planes=1;
        g_data[NEWBPL]=byte(g_planes);
       // palettesteps(16);
        g_name="a2";
        g_tempname="internal";
        g_formatextension="app";
        g_attrimode=2;
        g_map[1]=byte(0);
        
        
        make_apple_palette();
        
    }
    
    if (g_machine==C64FLI) {    //c64 hires FLI = AFLI
        g_colorprofile[PROF_BACKGND]=0;
        g_expname="prg";
        g_formatname="";g_formatextension="";
        g_name="afli";
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (g_machine==C64FLIM) {    //C64 FLI multicolor 
        g_hzoomer=2;
        g_maxcolors=16;
        g_name="fli";g_expname="";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }
    
    if (g_machine==C64NOLIMIT) {    // C64 hires without attribute limits
        g_name="c64hino";
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_BACKGND2]=0;
        g_colorprofile[PROF_RESIZE]=1;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=320;Y=200;
        g_multic=4;
        g_planes=4;
        g_attrimode=2;
        g_farge=15;
        g_backg=0; 
        make_c64_palette();
    }
    if (g_machine==C64MNOLIMIT) {    // C64 multicolor without attribute limits
        g_name="c64hino";
        g_colorprofile[PROF_BACKGND]=0;//backgnd should be enabled but maybe not now
        g_colorprofile[PROF_BACKGND2]=0;
        g_colorprofile[PROF_RESIZE]=1;
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=320;Y=200;
        g_multic=3;
        g_planes=4;
        g_attrimode=2;
        g_farge=15;
        g_backg=0; 
        g_hzoomer=2;
        make_c64_palette();
    }    
    if (g_machine==PICO8) {    // Pico-8 fantasy console
        g_name="pico8";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=128;Y=128;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0, 0);
        makecolor(1, 32, 51, 123);
        makecolor(2, 126, 37, 83);
        makecolor(3, 0, 144, 61);        
        makecolor(4, 171, 82, 54);
        makecolor(5, 52, 54, 53);
        makecolor(6, 194, 195, 199);
        makecolor(7, 255, 241, 232);      
        makecolor(8, 255, 0, 77);
        makecolor(9, 255, 155, 0);
        makecolor(10, 255, 231, 39);
        makecolor(11, 0, 226, 50);       
        makecolor(12, 41, 173, 255);
        makecolor(13, 132, 112, 169);
        makecolor(14, 255, 119, 168);
        makecolor(15, 255, 214, 197);
    }

    if (g_machine==TIC80) {    //4 planes
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_FXTOOLS]=1;
        g_colorprofile[PROF_RESIZE]=1;//resizable
        g_colorprofile[PROF_REBITPLANE]=1;//1-5 bitplanes
        g_backmode=1;
        X=240;Y=136;
       // X=64;Y=64;
       //X=128;Y=128;
        g_maxcolors=16;
        g_multic=4;
        g_planes=4;
        g_data[NEWBPL]=byte(g_planes);
        palettesteps(256);
        g_name="tic";
        g_tempname="internal";
        g_formatextension="iff";
        g_attrimode=2;
        g_map[1]=byte(0);
        make_tic_palette();

    }
    
    if (g_machine==COCO3) {    //6-bit RGB, 16 out of 64 possible
        g_colorprofile[PROF_BORDER]=0;//border changeable?
        g_backmode=1;
        g_maxcolors=16;
        palettesteps(4);
        
        g_colorprofile[PROF_PALTOOLS]=1;
        //00 00 00
        g_name="coco";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(0);
        make_coco_palette();
    }
    
    if (g_machine==UNIA) {    // Unia digital palette
        g_name="unia";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=256;Y=192;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0 , 0);
        makecolor(1, 0xff, 0xff, 0xff);
        makecolor(2, 0xff, 0xfd, 0x38);
        makecolor(3, 0xff, 0xc5, 0x00);        
        makecolor(4, 0xff, 0x00, 0x00);
        makecolor(5, 0xff, 0x3c, 0xb4);
        makecolor(6, 0xa0, 0x23, 0xbc);
        makecolor(7, 0x1b, 0xa1, 0xfc);      
        makecolor(8, 0xe1, 0xe1, 0xe1);
        makecolor(9, 0xb9, 0x63, 0x00);
        makecolor(10, 0xff, 0xaa, 0xbe);
        makecolor(11, 0xd2, 0x9b, 0xd7);       
        makecolor(12, 0xad, 0xad, 0xad);
        makecolor(13, 0x00, 0xb7, 0xb7);
        makecolor(14, 0x23, 0xaf, 0x32);
        makecolor(15, 0x29, 0xf7, 0xa7);
    }
    
    if (g_machine==ATARIE) {  //Atari 8-bit 
        g_colorprofile[PROF_BACKGND]=0;
        g_hzoomer=2;
        X=320;Y=192;
       // palettesteps(3);
        g_maxcolors=4;
        g_name="ata";g_expname="bin";
        g_tempname="atari0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
       // g_colorprofile[PROF_PALTOOLS]=1;
        g_colorprofile[PROF_LOADPALETTE]=1;
    }
    
    if (g_machine==ATARIENOLIMIT) {  //Atari 8-bit 
        g_colorprofile[PROF_BACKGND]=0;
        g_colorprofile[PROF_LOADPALETTE]=1;
        g_hzoomer=2;
        X=320;Y=192;
       // palettesteps(3);
        g_maxcolors=256;
        g_name="ata";g_expname="bin";
        g_tempname="atari0.bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(255);g_map[0]=1;
       // g_colorprofile[PROF_PALTOOLS]=1;
        g_scanlimit=4;//4 per horizontal, just a warning

    }    
    g_map[5]=byte(X/8);
    g_map[7]=byte(Y/8);
    
    g_map[14]=byte(g_planes);
    g_map[15]=byte(g_multic);
    
    make_pixelwidth();
    make_slider_steps();
    make_mirror(X/2-1,Y/2-1);
}
