// Pure Java UI elements, such as a file selector
// Adapted from Marq's PETSCII editor
//
// "this crap really makes me lose all my will to live, but it's needed now" -Marq

boolean gui=true;
boolean fileselect=false;
boolean saveas=false;
boolean refselect=false;
boolean g_control=false;
boolean g_shift=false;
boolean exporttxt=false;
boolean ext_select=false;

String path="",refpath="",filename="",elename="",sfilename="",refname="",g_expname="",g_fmtname="";
String exporttxtname="",exportemuname="",exportfmtname;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
//import javax.swing.filechooser.FileView;//not
import java.awt.Dimension;
import java.awt.GridLayout;
import processing.awt.*;

void javatheme()
{
  
  int whatever=1;
  
  // just crude fix for now
  // not setting a lookandfeel helped a windows user
  
  // win=unless forced, will skip
  // mac=unless force=2, go on
  // lin=unless force=2, go on
  
  println("theme:"+g_fselector_force);
  
  if(g_fselector_force==0&&platform==WINDOWS)whatever=0;  
  if(g_fselector_force==2)whatever=0;
  
  if(whatever==0)return;
  
    try // Let's try to set a native look
    {
        if(platform==LINUX)
        {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        else
        {
            if(platform==WINDOWS)
            {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            else // Others or Mac, better go with something generic (too bad)
            {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
        }
    }
    catch (Exception e) {};
}

class Selector extends JPanel implements ActionListener
{
    int selection;
    protected JButton b[];
    
    Selector(String title, String s) // Split string into options
    {
        Box box=Box.createVerticalBox();
        
        String splitz[]=splitTokens(s,",");
        b=new JButton[splitz.length];
        
        setLayout(new GridLayout(splitz.length,1,1,1));
        
        add(new JLabel(title,SwingConstants.CENTER));
        
        for(int i=0;i<splitz.length;i++)
        {
            b[i]=new JButton(splitz[i]);
            b[i].setActionCommand(str(i+'0'));
            b[i].addActionListener(this);
            //b[i].setHorizontalAlignment(SwingConstants.LEFT);
            b[i].setPreferredSize(new Dimension(140,26));
            
            add(b[i]);
        }
        
        selection=-1;
    }
    public void actionPerformed(ActionEvent e)
    {
        for(int i=0;i<b.length;i++)
        {
            if(str(i+'0').equals(e.getActionCommand()))
                selection=i;
        }
    }
}

// Select from a list
int selector(String title,String opt)
{
    JFrame frame=new JFrame(title);
    frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    frame.setLocationRelativeTo(null);
    
    Selector s=new Selector(title,opt);
    s.setOpaque(true);
    frame.setContentPane(s);
 
    //Display the window.
    frame.pack();
    frame.setVisible(true);
    frame.setLocationRelativeTo(null); // About in the middle
    
    while(s.selection==-1)
    {
        frame.toFront(); // A bit of a kludge to force the window on top
        frame.repaint();
        try { Thread.sleep(200); }
        catch(Exception e){};
    }
    
    frame.setVisible(false);
    
    System.gc(); // It'll leak anyway...
    return(s.selection);
}

final int LOADPIX=0,
          LOADIMG=1,
          SAVEIMG=2,
          SAVETXT=3,
          SAVEEMU=4,
          SAVEFMT=5,
          LOADFMT=6,
          LOADACT=7,
          EXTENDR=8;

// File selector

// The mode comes from gui_stuff

String fileselector(String dir,int mode)
{
    println("JFILE "+mode);
    println("Formatext:"+g_formatextension);
    JFileChooser fc=new JFileChooser(dir);
    
    fc.setPreferredSize(new Dimension(600, 500));

    if(mode==LOADPIX||mode==LOADIMG||mode==LOADFMT||mode==LOADACT){
      fc.setDialogTitle("Select a File to LOAD");
    }else{
      fc.setDialogTitle("Create or select a File to WRITE");
    }
    if(mode==EXTENDR){
      fc.setDialogTitle(g_exthook[g_ext_choice]);//extension instructions
    }    
    if(mode==EXTENDR)
        fc.setFileFilter(new FileNameExtensionFilter("Extension (*."+g_extext[g_ext_choice]+")",
                         g_extext[g_ext_choice]));
    if(mode==LOADACT) // Show palette
        fc.setFileFilter(new FileNameExtensionFilter("Palette (*.act)",
                         "act"));
    if(mode==LOADPIX) // Show image files
        fc.setFileFilter(new FileNameExtensionFilter("Images (*.png,*.gif,*.jpg)",
                         "png","gif","jpg","jpeg"));
    if(mode==LOADIMG||mode==SAVEIMG)
        fc.setFileFilter(new FileNameExtensionFilter("Multipaint files (*.bin) or png (*.png)","bin","png","jpg","act"));
    if(mode==SAVEEMU)
        fc.setFileFilter(new FileNameExtensionFilter("Export files (*."+g_extext[g_ext_choice]+") ",g_extext[g_ext_choice]));
    if(mode==SAVETXT)
        fc.setFileFilter(new FileNameExtensionFilter("Export data (*.txt,*.asm,*.s) ","s","asm","txt"));
        
    if(mode==SAVEFMT||mode==LOADFMT){
         if(g_formatextension==null||g_formatextension==""){
             message("NOpe");
             return "";
         }else{
            fc.setFileFilter(new FileNameExtensionFilter(g_formatname+" (*."+g_formatextension+")",g_formatextension));
         }
    }
        
    if(mode<=LOADIMG||mode==LOADFMT)
        fc.setApproveButtonText("Load");
    if(mode==SAVEIMG||mode==SAVEFMT)
        fc.setApproveButtonText("Save");
    if(mode==SAVETXT||mode==SAVEEMU)
        fc.setApproveButtonText("Export");  
        
    if(g_filelist==1){
      Action details = fc.getActionMap().get("viewTypeDetails");
      details.actionPerformed(null); 
    }
        
    int returnVal = fc.showOpenDialog(null);//"this" might not work, null is better?
    
    if(returnVal==JFileChooser.APPROVE_OPTION)
    {
        // Save cwd for next time
        if(mode==LOADPIX)
            refpath=fc.getCurrentDirectory().getPath();
        else
            path=fc.getCurrentDirectory().getPath();
        
        File file = fc.getSelectedFile();
        return file.getPath();
    }
    else
        return null;
}
