//Read preferences from file
//Adapted from Marq's PETSCII editor

//becoming redundant

final String machinenames[]={
          "C64",
          "C64M",
          "SPECTRUM",
          "ULAPLUS",
          "MSX",
          "PLUS4",
          "PLUS4M",
          "CPC",
          "QLLOW",
          "AMIGA",
          "ATARIST",
          "VIC",
          "VICM",
          "GX4000",
          "TO8",
          "JR200"
          };          
          
final String ext_machinenames[]={
          "C64",
          "C64M",
          "SPECTRUM",
          "MSX",
          "PLUS4",
          "PLUS4M",
          "CPC",
          "QLLOW",
          "AMIGA",
          "C64NOLIMIT",
          "PICO8",
          "BK0010",
          "COCO3",
          "ULAPLUS",
          "ATARIST",
          "ULATMX",
          "CPC1",          
          "CPCOC",
          "ULAFREE",
          "VIC",
          "VICM",
          "GX4000",
          "C64MNOLIMIT",
          "PCCGA",
          "PCEGA",
          "PCVGA",
          "TO8",          
          "JR200",
          "ZXNEXT",
          "ZXNEXTB",
          "TUTORIAL1",
          "TIC80",
          "APPLE2",
          "GX4000OC",
          "MSX2",
          "CPCFREE",
};

//what appears in the top menu bar
final String g_machinecalled[]={
          "C64 Hires",
          "C64 Multicolor",
          "ZX Spectrum",
          "ZX ULAplus",
          "MSX1 Mode 2",
          "Plus4 Hires",
          "Plus4 Multicolor",
          "Amstrad CPC Mode 0",
          "Sinclair QL Mode 8",
          "Amiga Low",
          "Atari ST Low",
          "ULA Timex",
          "C64 Hires Free",
          "Pico8",
          "BK0010",
          "COCO3",
          "Amstrad CPC Mode 1",
          "CPC Mode 0 Overscan",
          "ZX ULAplus Direct",
          "VIC 20 Hires",
          "VIC 20 Multi",
          "GX4000",
          "C64 Mcolor Free",
          "PC CGA Low",
          "PC EGA Low",
          "PC VGA Low",
          "Thomson Low",
          "JR200",
          "Spectrum Next 256",
          "Spectrum Next 320",
          "> Tutorial",
          "TIC 80",
          "Apple II Hires",
          "GX4000 OS",
          "MSX 2",
          "Amstrad CPC Free",
        };
final String g_machinetip[]={
          "320x200 16",
          "160x200 16",
          "256*192 15",
          "256*192 64|of 256",
          "256*192 16",
          "320x200 121",
          "160x200 121",
          "160x200 16|of 27",
          "256x256 8",
          "320x200 32|of 4096",
          "320x200 16|of 512",
          "256*192 64|of 256",
          "320x200 16|Not a real|C64 mode!",
          "aa",
          "aa",
          "aa",
          "320x200 4|of 27",
          "192x272 16|of 27|Overscan",
          "256*192 64|of 256|Not a real|ULAplus mode",
          "176*176 8-16|of 16|with limits",
          "88*176  8-16|of 16|with limits",
          "160*200 16|of 4096",
          "160*200 16|Not a real|C64 mode!",
          "320x200 4",
          "320x200 16",
          "320x200 256",
          "160x200 16|of 4096",
          "256x192 8",
          "256x192 256|of 512",
          "320x256 256|of 512",
          "Basic tools",
          "240x136 16",
          "280x192 2",
          "192*200 16|of 4096",
          "256x212 16|of 512",
          "320x200 27",
          
        };        
        
        
//final int CGA=23; // 320 x 200 PC CGA screen with black, white, cyan, magenta
//final int CGAX=24; // 320 x 200 PC CGA screen with black, yellow, green, red-ish
//final int EGA=200; // 320 x 200 PC EGA screen, 16 colors of 64
//final int VGA=255; // 320 x 200 PC VGA screen, 256 colors of 65536

final int g_getindex[]={0,1,2,4,5,6,7,8,9,12,13,14,15,3,10,11,16,17,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35};

//the real real menu
final int g_realmenu[]={30,0,1,2,3,28,29,4,5,6,7,16,17,8,10,9,19,20}; //21 for gx4000

//define
final int g_machinemenu[]={C64,C64M,SPECTRUM,ULAPLUS,MSX,PLUS4,PLUS4M,CPC,QLLOW,AMIGA,ATARIST,ULATMX,C64NOLIMIT,PICO8,BK0010,COCO3,CPC1,CPCOC,ULAFREE,VIC,VICM,GX4000,C64MNOLIMIT,PCCGA,PCEGA,PCVGA,TO8A,JR200,ZXNEXT,ZXNEXTB,TUTORIAL1,TIC80,APPLE2,GXOC4000,MSX24,CPCNOLIMIT};
//a bit sad
final int g_machineidx[]={C64,C64M,SPECTRUM,MSX,PLUS4,PLUS4M,CPC,QLLOW,AMIGA,C64NOLIMIT,PICO8,BK0010,COCO3,ULAPLUS,ATARIST,ULATMX,CPC1,CPCOC,ULAFREE,VIC,VICM,GX4000,C64MNOLIMIT,PCCGA,PCEGA,PCVGA,TO8A,JR200,ZXNEXT,ZXNEXTB,TUTORIAL1,TIC80,APPLE2,GXOC4000,MSX24,CPCNOLIMIT};

int[] g_pseudorgb = new int [266];


int g_filelist=0;
int g_wheelup=':';
int g_wheeldown=';';
int g_middlebutton=',';
int g_leftbutton=1;
int g_rightbutton=2;
int g_guileft=0;
int g_aspect_override=0;
int g_fselector_force=0;

String g_prefname="";

String g_forcedpalette="";

String get_machinename(int m){
  
  for(int i=0;i<g_machineidx.length;i++){
    if(g_machineidx[i]==m){
      return ext_machinenames[i];
    }
  }
  return "Unknown";
}

boolean pref_runner(){
  g_prefname="";
  if(pref_loader()==true){
    readprefs(g_prefname);
    return true;
  }
  return false;
}

boolean pref_loader(){
  
      println("PREF_LOADER");
      
      println("0. Default way");
      g_prefname="prefs.txt";
      
      String row[]=loadStrings(g_prefname);
      
      if(row!=null){        
        println("FOUND");
        return true;
      }
      
      println("1. Explicit way");
      g_prefname=sketchPath("prefs.txt");
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("2. Explicit way datapath");
      g_prefname=dataPath("prefs.txt");
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("3. Explicit way superpath");
      g_prefname=g_superpath+"prefs.txt";
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("4. User home");
      String last=System.getProperty("user.home")+File.separator;
      
      g_prefname=last+"prefs.txt";
      
      row=loadStrings(g_prefname);
      if(g_prefname!=null){        
        println("FOUND");
        return true;
      }
      
      println("prefs.txt read FAIL");
      return false;
}

void readprefs(String fname){
  
  String row[]=loadStrings(fname);
  
  if(row==null){
    println("-readprefs : null");
    return;
  }
      
  for(int i=0;i<row.length;i++) // Parse each line
  {
      if(row[i].length()>1)
      {
          String s[]=split(row[i],"=");
          
          if(s[0].equals("ZOOM"))// "scale" in xbasic
          {
              g_uizoom=int(s[1]);
              if(g_uizoom<1)g_uizoom=1;//lv 1 reinstated
              if(g_uizoom>3)g_uizoom=2;
              //g_uizoom=3;
          }
                         
          if(s[0].equals("INVERTGUI"))// xbasic toolbar
          {
              g_guileft=int(s[1]);
          } 

          if(s[0].equals("DARKTHEME"))// xbasic
          {
              g_data[GUIDARK]=byte(int(s[1]));
          } 

          if(s[0].equals("SCALELOCK")) // deprecated?
          {
              int sl=byte(int(s[1]));
              if(sl>0){
                g_data[GUILOCK]=byte(1);                
              }else{
                g_data[GUILOCK]=0;
              }
          } 
             
          if(s[0].equals("MACHINE") && s.length>1) // sys?
          {
              for(int j=0;j<ext_machinenames.length;j++)
                  if(s[1].equals(ext_machinenames[j])){
                      g_machine=g_machineidx[j];
                      g_machineindex=g_getindex[j];
                    }
          }
          
          if(s[0].equals("PATH") && s.length>1) // setdir in xbasic
          {
              path=s[1];
          }

          if(s[0].equals("PALETTE64") && s.length>1)
          {
              g_forcedpalette=s[1];
          }

          if(s[0].equals("GRIDBRIGHTNESS") && s.length>1)
          {
              grid_lightness(int(s[1]),0);
          }
          
          if(s[0].equals("KEYMACRO") && s.length>1 && s.length<80)
          {
              g_keymacro=s[1];
          }      
          
          if(s[0].equals("PNGSCALE"))
          {
              g_omag=int(s[1]);
              if(g_omag<1||g_omag>10)g_omag=1;
          }
          
          if(s[0].equals("PNGHBORDER"))
          {
              g_bordh=int(s[1]);
              if(g_bordh<1||g_bordh>256)g_bordh=64;
          }
          
          if(s[0].equals("PNGVBORDER"))
          {
              g_bordv=int(s[1]);
              if(g_bordv<1||g_bordv>256)g_bordv=72;
          }

          if(s[0].equals("NOASPECT"))
          {
              g_aspect=SQUARERATIO;
              g_aspect_override=1;
          }    
          
          if(s[0].equals("WHEELUP"))
          {
              g_wheelup=int(s[1]);
          }
          if(s[0].equals("WHEELDOWN"))
          {
              g_wheeldown=int(s[1]);
          } 
          if(s[0].equals("MIDDLEBUTTON"))
          {
              g_middlebutton=int(s[1]);
          }
          if(s[0].equals("FSELECTOR"))
          {
              g_fselector_force=int(s[1]);
          }
          if(s[0].equals("LMBSHIFT"))
          {
              g_leftbutton=int(s[1]);
          } 
          if(s[0].equals("RMBSHIFT"))
          {
              g_rightbutton=int(s[1]);
          }            
      }
  }
}

// incorporating preview
// separate window for MP 2024

final int PBBORDER=32;

int g_popen;
int g_preview=0;
int g_prevx=0;
int g_prevy=0;
float g_phandlex=0;
float g_phandley=0;
int g_machineindex;

boolean g_pwin=false;
boolean sa_visible=false;
int sa_update=0;
boolean g_previewsize=false;
boolean g_previewontop=false;

PreviewWindow g_window;
int[] g_pwindow = new int[(640+PBBORDER)*(512+PBBORDER)];
//int[] g_swindow = new int[(640+PBBORDER)*(512+PBBORDER)];//scanline kludge

PImage virtual;

int real_xsize(){
  return int(X*g_realaspect);
}

void toggle_preview_size(){
    g_previewsize=!g_previewsize;
    resize_preview();
    update_preview_window();
}

void toggle_preview_top(){
    g_previewontop=!g_previewontop;       
    g_window.getSurface().setAlwaysOnTop(g_previewontop);
    resize_preview();
    update_preview_window();
}

int g_last_actual_x=0;
int g_last_actual_y=0;

void resize_preview(){
  
  int XX=real_xsize();
  //let's not resize for nothing?
  //processing might actually handle this on its own
  if(g_last_actual_x!=X||g_last_actual_y!=Y){  
    actual.resize(X,Y);
    g_last_actual_x=X;
    g_last_actual_y=Y;
  }
  
  if(g_pwin==false)return;
  
  if(g_previewsize==true){
    g_window.getSurface().setSize((XX+PBBORDER)*2,(Y+PBBORDER)*2);
    virtual.resize((X+PBBORDER)*2,(Y+PBBORDER)*2);
    return;
  }
  g_window.getSurface().setSize(XX+PBBORDER,Y+PBBORDER);
  virtual.resize(X+PBBORDER,Y+PBBORDER);
}

void toggle_preview()
{
    // first time, launch window
    if(g_pwin==false){
      int XX=real_xsize();
      virtual = createImage(X+PBBORDER,Y+PBBORDER,RGB);
      g_window = new PreviewWindow();
      sa_visible=true;
      update_preview_window();
      g_pwin = true;
      resize_preview();
      g_window.getSurface().setSize(XX+PBBORDER,Y+PBBORDER);
     // g_window.getSurface().setAlwaysOnTop(true);
      // g_window.getSurface().setResizable(true);
      g_popen=10;
    }
    else
    {   
      
      //henceforth, just swap visibility (as in PETSCII editor)
      
      sa_visible=!sa_visible;
      g_window.getSurface().setVisible(sa_visible);
      g_popen=10;
      
      // legacy
      
      g_preview++;
      if(g_preview>1)g_preview=0;
      
      update_preview_window();
      
      g_trueclearbit=true;
      refresh();
      g_boxreconstruct=2;
    }
}

int g_prip=0;

class PreviewWindow extends PApplet {
  PreviewWindow() {
    super();
    PApplet.runSketch(new String[] {this.getClass().getSimpleName()}, this);
  }

  void settings() {
    size(320, 200);
    //noSmooth();
  }

  void setup() {
    background(0);
    frameRate(15);
  }
  
  void exit()
  {
      sa_visible=false;
      surface.setVisible(false);
  }

  void draw() { 
      
    if(!focused){
      delay(200);
    }
    
    if(g_prip>0)g_prip--;
    
    try { Thread.sleep(200); }
      catch(Exception e){
      };
    

   /* if (g_prevw!=width||g_prevh!=height) {    
      g_prevw=width;
      g_prevh=height;
      sa_update=2;
    }*/
    
    
    if(sa_visible==false)return;  
    if(sa_update==0)return;
    

    sa_update--;
    //if(xx>=width-8||yy>=height-8)return;
    int xx=0;
    int yy=0;
    int wix=MX*8+PBBORDER;
    int xs=1;
    int ys=1;
    int x2=MX*8+PBBORDER;
    int y2=MY*8+PBBORDER;
    noStroke();
    if(g_previewsize){
      for(int y=0;y<y2;y++){  
        for(int x=0;x<x2;x++){
          virtual.set(x*2,y*2,g_pwindow[x+y*wix]);
          virtual.set(x*2+1,y*2,g_pwindow[x+y*wix]);
          virtual.set(x*2+1,y*2+1,g_pwindow[x+y*wix]);//g_swindow
          virtual.set(x*2,y*2+1,g_pwindow[x+y*wix]);//g_swindow
        }
      }      
      
      //scanline+crt
      if(g_machine==APPLE2){
        for(int y=0;y<y2;y++){  
          float rr=0;
          float gg=0;
          float bb=0;
          for(int x=0;x<x2;x++){
            int v=g_pwindow[x+y*wix];
            float r=red(v);
            float g=green(v);
            float b=blue(v);
            rr=rr+(r-rr)/1.5;
            gg=gg+(g-gg)/1.5;
            bb=bb+(b-bb)/1.5;
            virtual.set(x*2,y*2,color(rr,gg,bb));
            virtual.set(x*2+1,y*2,color(rr,gg,bb));
            virtual.set(x*2,y*2+1,color(rr/1.5,gg/1.5,bb/1.5));
            virtual.set(x*2+1,y*2+1,color(rr/1.5,gg/1.5,bb/1.5));
            virtual.set(x*2,y*2,g_pwindow[x+y*wix]);
            virtual.set(x*2+1,y*2,g_pwindow[x+y*wix]);
          }
        }
      }
    }
    else{
      for(int y=0;y<y2;y++){  
        for(int x=0;x<x2;x++){
          virtual.set(x*xs,y*ys,g_pwindow[x+y*wix]);
        }
      }
    }
    image(virtual,0,0,width,height);
    //image(virtual,0,0,x2,y2);
    if(g_popen>0){
     // text("m=size  t=force top",10,10);
      g_popen--;  
    }
  }

  void keyPressed() {
    char c=key;
    if(c=='n'||c=='N'||c=='6')g_realaspect=g_alt_aspect;
    if(c=='p'||c=='P'||c=='5')g_realaspect=g_pal_aspect;
    if(c=='0'||c=='1')g_realaspect=1.0;
    if(c=='m')toggle_preview_size();
    if(c=='t')toggle_preview_top();
    resize_preview();
    update_preview_window();
  }
  void mousePressed() {
    g_prip=g_prip+6;
    if(g_prip>=10){
      toggle_preview_size();
      g_prip=0;
    }
  }
}

void draw_preview_window(int owin,int xx,int yy)
{

}

void update_preview_apple2() //done at mousereleased.. kludgy
{
  int wix=X+PBBORDER;   
  if(sa_visible==false)return;  
  for(int y=0;y<Y+PBBORDER;y++){
      for(int x=0;x<X+PBBORDER;x++){        
         if(y<PBBORDER/2||x<PBBORDER/2||y>=Y+PBBORDER/2||x>=X+PBBORDER/2){
           g_pwindow[y*wix+x]=g_rgb[int(g_map[0])];           
          // g_swindow[y*wix+x]=g_pseudorgb[g_map[0]];
         }else{
           int ink=easygetcolor(x-PBBORDER/2,y-PBBORDER/2);
           if(ink<0)ink=0;
           g_pwindow[x+y*wix]=g_rgb[ink];
           
           if(ink==0){
             int inkr=easygetcolor(x-PBBORDER/2+1,y-PBBORDER/2);
             int inkl=easygetcolor(x-PBBORDER/2-1,y-PBBORDER/2);             
             if(inkr==1&&inkl==1){
               if((x&1)==0){
                 g_pwindow[x+y*wix]=g_rgb[4];
               }else
               {
                 g_pwindow[x+y*wix]=g_rgb[5];
               }
             }       
             if(inkr==1&&inkl==0){
               if((x&1)==0){
                 g_pwindow[x+y*wix]=g_rgb[6];
               }else
               {
                g_pwindow[x+y*wix]=g_rgb[7];
               }
             } 
             if(inkr==0&&inkl==1){
               if((x&1)==0){
                 g_pwindow[x+y*wix]=g_rgb[6];
               }else
               {
                 g_pwindow[x+y*wix]=g_rgb[7];
               }
             }               
           }
           if(ink==1){
             int inkr=easygetcolor(x-PBBORDER/2+1,y-PBBORDER/2);
             int inkl=easygetcolor(x-PBBORDER/2-1,y-PBBORDER/2);
             if(inkr==0&&inkl==0){
               if((x&1)==0){
                 g_pwindow[x+y*wix]=g_rgb[3];
               }else
               {
                 g_pwindow[x+y*wix]=g_rgb[2];
               }
             }
           }
          // g_swindow[x+y*wix]=g_pseudorgb[ink];
         }
      }
  }
  sa_update=2;
}

void update_preview_window(){ //done at mousereleased
  if(g_machine==APPLE2){
    update_preview_apple2();
  }
  else{
    update_preview_normal();
  }
}

void update_preview_normal()
{
  int wix=X+PBBORDER;   
  if(sa_visible==false)return;  
  for(int y=0;y<Y+PBBORDER;y++){
      for(int x=0;x<X+PBBORDER;x++){        
         if(y<PBBORDER/2||x<PBBORDER/2||y>=Y+PBBORDER/2||x>=X+PBBORDER/2){
           g_pwindow[y*wix+x]=g_rgb[int(g_map[0])];
          // g_swindow[y*wix+x]=g_pseudorgb[g_map[0]];
         }else{
           int ink=easygetcolor(x-PBBORDER/2,y-PBBORDER/2);
           if(ink<0)ink=0;
           g_pwindow[x+y*wix]=g_rgb[ink];
          // g_swindow[x+y*wix]=g_pseudorgb[ink];
         }
      }
  }
  sa_update=2;
}



    
