byte[] g_xmem=new byte[256000];
byte[] g_xint=new byte[256000];
int[] g_var=new int[128];
int[] g_loopptr=new int[128];
int[] g_loopstep=new int[128];
int[] g_loopend=new int[128];
int[] g_condi=new int[128];
byte[] inp_file=new byte[256];
int g_tab=0;
int g_xhead=0;
int g_xinthead=0;
int g_xflen=0;
int g_xcur=0;
int g_outmode=0;
int g_hexout=0;
int g_xedge=0;
int g_xbytes=0;
int g_xfirst=0;
int g_xterminator=0;

boolean g_xdump;
boolean g_hardboot=true;

PrintWriter g_dump;

final int TOKEN_POKE=1;
final int TOKEN_ADDITEM=2;
final int TOKEN_ADDSAVE=3;
final int TOKEN_ADDMAKE=4;
final int TOKEN_ADDLOAD=5;
final int TOKEN_PEEK=6;
final int TOKEN_LENGTH=7;
final int TOKEN_COLORS=8;
final int TOKEN_BITPLANES=9;
final int TOKEN_ALERT=10;
final int TOKEN_SCALERGB=11;
final int TOKEN_GETPOINT=12;
final int TOKEN_PUTPOINT=13;
final int TOKEN_REM=14;
final int TOKEN_LET=15;
final int TOKEN_READ=16;
final int TOKEN_RESTORE=17;
final int TOKEN_XMOVE=18;
final int TOKEN_=19;
final int TOKEN_READW=20;
final int TOKEN_MAKECOLOR=21;
final int TOKEN_SAVE=22;
final int TOKEN_LOAD=23;
final int TOKEN_ECHO=24;
final int TOKEN_VERBOSE=25;
final int TOKEN_REFRESH=26;
final int TOKEN_XBYTE=27;
final int TOKEN_XREPEAT=28;
final int TOKEN_XWORD=29;
final int TOKEN_XWORDR=30;
final int TOKEN_XLONG=31;
final int TOKEN_XREM=32;
final int TOKEN_BYTE=33;
final int TOKEN_WORD=34;
final int TOKEN_LONG=35;
final int TOKEN_FOR=36;
final int TOKEN_NEXT=37;
final int TOKEN_IF=38;
final int TOKEN_ENDIF=39;
final int TOKEN_GRAB=40;
final int TOKEN_TO=41;
final int TOKEN_SETDIR=42;
final int TOKEN_STEP=43;
final int TOKEN_STOP=44;
final int TOKEN_FIND=45;
final int TOKEN_SETHEAD=46;
final int TOKEN_SETINT=47;
final int TOKEN_READL=48;
final int TOKEN_MESSAGE=49;
final int TOKEN_PLOT=50;
final int TOKEN_DRAW=51;
final int TOKEN_INK=52;
final int TOKEN_PAPER=53;
final int TOKEN_BORDER=54;
final int TOKEN_LINE=55;
final int TOKEN_LINETO=56;
final int TOKEN_FD=57;
final int TOKEN_RT=58;
final int TOKEN_LT=59;
final int TOKEN_FILL=60;
final int TOKEN_GRID=61;
final int TOKEN_DARKTHEME=62;
final int TOKEN_LIGHTTHEME=63;
final int TOKEN_SCALE=64;
final int TOKEN_AUTOSCALE=65;
final int TOKEN_TOOLBAR=66;
final int TOKEN_SYS=67;
final int TOKEN_ELLIPSE=68;
final int TOKEN_HOME=69;
final int TOKEN_CRUNCH=70;
final int TOKEN_RECENT=71;
final int TOKEN_SAVEKEY=72;


void x_open(String fname){
  println("x_open");
  g_dump=createWriter(fname);
  g_outmode=0;//byte 1, word 2 or comment 32 output
  g_xcur=0;//output tab
  g_xdump=true;//active
  g_xedge=80;//right edge
  g_hexout=0;//hexmode
  g_xbytes=0;//length limiter
  g_xterminator=0;//break 
  g_xfirst=1;
  if(getbit(129)==1)g_xedge=32;
  if(getbit(131)==1)g_hexout=1;
}

void x_prepline(){
  String preline="";
  if(g_outmode==0){
    if(getbit(130)==0)preline=char(9)+".byte ";
    if(getbit(130)==1)preline=char(9)+".db ";
  }
  if(g_outmode==1){
    if(getbit(130)==0)preline=char(9)+".word ";
    if(getbit(130)==1)preline=char(9)+".dw ";
  }
  if(g_outmode==32){
    preline="; ";
  }
  
  g_dump.print(preline);
  g_xcur=preline.length();
  if(g_outmode!=32)g_xcur=g_xcur+6;
  g_xbytes=g_xbytes+preline.length();  
  g_xfirst=1;
}

void x_dump(int v){
  if(g_xdump==false)return;
    
  if(g_xcur==0)x_prepline();
  
  int bam=0;  
  if(g_outmode==0)bam=2;
  if(g_outmode==1)bam=4;
  String ss=str(v);
  if(g_hexout==1){
    ss="$"+hex(v,bam);
  }
  
  if(g_outmode==32)ss=""+char(v);
      
  if(g_xcur+ss.length()>=g_xedge){
    g_dump.println();
    x_prepline();
  }   
  
  if(g_outmode!=32){
    if(g_xfirst==0){
      g_dump.print(",");
      g_xcur++;
      g_xbytes++;
    }
  }
  
  g_dump.print(ss);
  g_xfirst=0;
  g_xcur=g_xcur+ss.length();
  g_xbytes=g_xbytes+ss.length();

  if(g_xbytes>256*1024){
    x_close();
    launch_alert("å  Terminated!|-|Output length|exceeds 256Kb||  [Cancel/Close|window]");    
    g_xterminator=1;
    return;
  }

}

void x_dump_newline(){
  if(g_xdump==false)return;
    g_xcur=0;
    g_xbytes++;
    g_dump.println();
}

void x_close(){
  if(g_xdump==false)return;
  println("x_close");
  g_dump.println();
  g_dump.println();
  g_dump.flush();
  g_dump.close();
  g_xdump=false;
  g_data[DUMPMSG]=1;
}

int x_find(String phrase){
  int plen=phrase.length();
  int pos=-1;
  println(phrase+"."+plen);
  if(plen<1)return -1;
  if(g_xflen<plen)return -1;
  for(int i=0;i<g_xflen;i++){
     if(inp_file[i]==phrase.charAt(0)){
       int okay=1;
       for(int p=1;p<plen;p++){
         if(inp_file[i+p]!=phrase.charAt(p)){
           okay=0;
         }
       }
       if(okay==1){
         pos=i;
         return pos;
       }
     }
  }
  return pos;
}

int x_evaluate(String s){

  if (s==null)return 0;
  if(s.length()==1){
    return all_evaluate(s);
  }
  int closed=0;
  String com="";
  String res="";
  
  for(int i=0;i<s.length();i++){
    char c=char(s.charAt(i));
    if(closed==1&&c!=')'){
      com=com+c;
    }
    if(c=='('){
      closed=1;
      c=0;
    }
    if(c==')'&&closed==1){
      c=0;
      closed=0;
      int r=all_evaluate(com);
      res=res+str(r);
      com="";
    }
    if(c>0&&closed==0){
      res=res+c;
    }
  }  
  int r=all_evaluate(res);
  return r;
}

int all_evaluate(String s){
  
   if(s.length()==1){
     char c=char(s.charAt(0));
      if(c>='A'&&c<='Z'){
        return g_var[c];
      }
      if(c>='a'&&c<='z'){
        return g_var[c];
      }
      if(c>='0'&&c<='9'){
        return c-48;
      }
   }  
   
  int ll=s.length()-1;
  int v=0;
  int sign=0;
  int symbol=0;
  int imode=0;//DEC-HEX
  int mulu=10;//BASE
  int val[]=new int[32];
  int mod[]=new int[32];
  int p=0;
  
   //print("*");
  for(int i=0;i<s.length();i++){
    char c=char(s.charAt(i));
    if(c=='$'){
      imode=1;
      mulu=16;
    }    
    if(c>='0'&&c<='9'){
      v=v*mulu;
      v=v+c-'0';
      symbol=0;
    }
    if(imode==1){
      if(c>='A'&&c<='F'){    
        v=v*mulu;
        v=v+c-'A'+10;
        symbol=0;
      }
      if(c>='a'&&c<='f'){    
        v=v*mulu;
        v=v+c-'a'+10;
        symbol=0;
      }      
    }

    if(imode==0){
      if(c>='A'&&c<='Z'){
        v=g_var[c];
        symbol=0;
      }
      if(c>='a'&&c<='z'){
        v=g_var[c];
        symbol=0;
      }               
    }
 
    if(c=='/'||c=='*'||c=='+'||c=='|'||c=='&'||c=='^'||i==ll){
      imode=0;
      mulu=10;
      val[p]=v;
      if(sign>0)val[p]=-v;
      mod[p]=c;
      sign=0;
      symbol=1;
      v=0;
      p++;
    }
    if(i!=0&&c=='-'&&symbol==0){
      imode=0;
      mulu=10;
      val[p]=v;
      mod[p]='-';
      v=0;
      p++;
    }
    if(i>0&&c=='-'&&symbol==1){
      sign=1;
      imode=0;
      mulu=10;
      symbol=0;
    }        
    if(i==0&&c=='-'&&sign==0){
      sign=1;
      imode=0;
      mulu=10;
    }   
    /*
    if(c=='_'){
      imode=0;
      mulu=10;
      val[p]=v;
      if(sign>0)val[p]=-v;
      mod[p]=0;
      v=0;
      sign=0;
      p++;
    }*/
  }

  for(int i=0;i<p;i++){
    if(mod[i]=='*'){
      val[i+1]=val[i]*val[i+1];
      val[i]=0;
      mod[i]='+';
    }
    if(mod[i]=='/'){
      val[i+1]=val[i]/val[i+1];      
      val[i]=0;
      mod[i]='+';     
    }
  }
  
  for(int i=0;i<p;i++){
    if(mod[i]=='+'){
      val[i+1]=val[i]+val[i+1];
    }
    if(mod[i]=='-'){
      val[i+1]=val[i]-val[i+1];
    }
    if(mod[i]=='&'){
      val[i+1]=val[i]&val[i+1];//AND
    }
    if(mod[i]=='|'){
      val[i+1]=val[i]|val[i+1];//OR
    }
    if(mod[i]=='^'){
      val[i+1]=val[i]^val[i+1];//EOR
    }        
  }
  return(val[p-1]);
}

void xbasic_run(String fname){
  g_xhead=0;
  g_xinthead=0;
  g_tab=0;
  g_map[21]=0;
  if(g_hardboot)g_map[21]=1;
  println("xbasic_run:"+fname);
  //println(" fname:"+filename);
  //println(" fnames:"+sfilename);
  int clock=millis();
  for(int i=0;i<128;i++){
    g_condi[i]=0;
  }
  for(int i=0;i<65536;i++){
    g_xmem[i]=0;
  }
  String[] line = loadStrings(fname);
  if (line==null)return;
  for(int s=0;s<line.length;s++){   
    if(line[s].length()>1){
      line[s]=trim(line[s]);
      line[s]=line[s]+" ";
    }
  }
  int i=0;
  while(i<line.length){
    int rev=interpret(i,line[i]);
    if(rev==65536)return;
    if(rev==0)i++;
    if(rev>0)i=rev;//jump
  }

}

int g_verbose=0;


void x_xbyte(byte b)
{
  if(g_filemode!=5){
    g_xmem[g_xhead]=b;
    g_xhead++;
  }else
  {
    g_xint[g_xinthead]=b;
    g_xinthead++;
  }
}

// Define constants
static final int NONE = 0;
static final int EQ   = 1;
static final int GT   = 2;
static final int LT   = 3;
static final int GE   = 4;
static final int LE   = 5;
static final int NE   = 6; // "<>"

int parseCondition(String s) {
  if (s == null || s.isEmpty()) return NONE;

  // Find earliest occurrence of '=', '>', or '<'
  int eqPos = s.indexOf('=');
  int gtPos = s.indexOf('>');
  int ltPos = s.indexOf('<');

  // Pick the lowest non-negative index
  int pos = -1;
  if (eqPos >= 0) pos = (pos == -1) ? eqPos : Math.min(pos, eqPos);
  if (gtPos >= 0) pos = (pos == -1) ? gtPos : Math.min(pos, gtPos);
  if (ltPos >= 0) pos = (pos == -1) ? ltPos : Math.min(pos, ltPos);

  if (pos == -1) return NONE; // no operator found

  char c = s.charAt(pos);

  switch (c) {
    case '=':
      return EQ;
    case '>':
      if (pos + 1 < s.length() && s.charAt(pos + 1) == '=') return GE;
      return GT;
    case '<':
      if (pos + 1 < s.length()) {
        char nc = s.charAt(pos + 1);
        if (nc == '=') return LE;
        if (nc == '>') return NE;
      }
      return LT;
    default:
      return NONE;
  }
}

int interpret(int line, String s){
  
  if(s.length()<2)return 0;
  if(s.charAt(0)=='#')return 0;  
  if(g_xterminator==1)return 65536;
  /*
    if(g_verbose==1){
      if(g_condi[g_tab]==0)print(g_tab+" OK:");
      if(g_condi[g_tab]==1)print(g_tab+" NOT:");
      println(s);
    }
  */
  int condi=0;
  char nc=' ';
  
  condi=parseCondition(s);
  /*
  for(int i=1;i<s.length()-1;i++){
    if(condi==0){
      char c=s.charAt(i);
      if(c=='=')condi=1;
      if(c=='>'){
         condi=2;
         nc=s.charAt(i+1);
         if(nc=='=')condi=4;
      }
      if(c=='<'){
        condi=3;
        nc=s.charAt(i+1);
        if(nc=='=')condi=5;
        if(nc=='>')condi=6;
      }
    }
  }  
  */
  
  String com="";
  String zom="";
  int quote=0;
  String words[]=new String[255];
  int tok[]=new int[255];
  int wptr=0;
  int inside=0;
  int token=-1;
  
  for(int i=0;i<s.length();i++){
    char c=s.charAt(i);

    if(c=='['){inside=1;c=0;}
    if(c==']'){inside=0;c=0;}
    if(quote==1&&c!=34){
      words[wptr]=str(int(c));
      tok[wptr]=int(c);
      //println(wptr+" quote:"+c+" = "+words[wptr]);
      zom="";
      com="";
      wptr++;
      c=0;
    }    
    
    if(c==34){
      quote++;
      quote=quote&1;
      c=0;
    }
    if(c=='='||c==','||c=='<'||c=='>'){
      if(zom.length()>0){
        words[wptr]=zom;
        tok[wptr]=int(c);
        zom="";
        com="";
        wptr++;
      }
      c=0;
    }
    
    token=-1;
    
    if(com.length()>0&&inside==0&&c==' '){

      com=com.toUpperCase();    
      //println("cuit:"+com);      
      char ch=com.charAt(0);
      switch(ch){
        case 'A':
        //println(com);
          if(com.equals("ADDSAVE")){
            token=TOKEN_ADDSAVE;
            break;
          }
          if(com.equals("ADDMAKE")){
            token=TOKEN_ADDMAKE;
            break;
          }        
          if(com.equals("ADDLOAD")){
            token=TOKEN_ADDLOAD;
            break;
          } 
          if(com.equals("ADDITEM")){
            token=TOKEN_ADDITEM;
            break;
          }
          if(com.equals("ALERT")){
            token=TOKEN_ALERT;
            break;
          }  
          if(com.equals("AUTO")){
            token=TOKEN_AUTOSCALE;
          }
        break;        
        case 'B':       
          if(com.equals("BYTE")){
            token=TOKEN_BYTE;
            break;
          } 
          if(com.equals("BITPLANES")){
            token=TOKEN_BITPLANES;
          }      
          if(com.equals("BORDER")){
            token=TOKEN_BORDER;
          }     
        break;        
        case 'C':
          if(com.equals("COLORS")){
            token=TOKEN_COLORS;
          }
          if(com.equals("CRUNCH")){
            token=TOKEN_CRUNCH;
          }
        break;     
        case 'D':
          if(com.equals("DRAW")){
            token=TOKEN_DRAW;
          }
          if(com.equals("DARK")){
            token=TOKEN_DARKTHEME;
          }
        break;
        case 'E':      
          if(com.equals("ECHO")){
            token=TOKEN_ECHO;
          }
          if(com.equals("ENDIF")){
            token=TOKEN_ENDIF;
          }
          if(com.equals("ELLIPSE")){
            token=TOKEN_ELLIPSE;
          }             
        break;
        case 'F':
          if(com.equals("FOR")){
            token=TOKEN_FOR;
          }   
          if(com.equals("FILL")){
            token=TOKEN_FILL;
          }   
          if(com.equals("FIND")){
            token=TOKEN_FIND;
          }
          if(com.equals("FD")){
            token=TOKEN_FD;
          }                     
        break;
        case 'G':
          if(com.equals("GETPOINT")){
            token=TOKEN_GETPOINT;
            break;
          }
          if(com.equals("GRAB")){
            token=TOKEN_GRAB;
          }
          if(com.equals("GRID")){
            token=TOKEN_GRID;
          }      
        break;
        case 'H':
        if(com.equals("HOME")){
          token=TOKEN_HOME;
        }    
        break;
        case 'I':
        if(com.equals("IF")){
          token=TOKEN_IF;
        }    
        if(com.equals("INK")){
          token=TOKEN_INK;
        }     
        break;
        case 'L':
          if(com.equals("LENGTH")){
            token=TOKEN_LENGTH;
          }
          if(com.equals("LET")){
            token=TOKEN_LET;
          }
          if(com.equals("LIGHT")){
            token=TOKEN_LIGHTTHEME;
          }          
          if(com.equals("LOAD")){
            token=TOKEN_LOAD;
          }
          if(com.equals("LONG")){
            token=TOKEN_LONG;
          }
          if(com.equals("LINE")){
            token=TOKEN_LINE;
          }
          if(com.equals("LINETO")){
            token=TOKEN_LINETO;
          }
          if(com.equals("LT")){
            token=TOKEN_LT;
          }               
        break;
        case 'M':
          if(com.equals("MAKECOLOR")){
            token=TOKEN_MAKECOLOR;
          }
          if(com.equals("MESSAGE")){
            token=TOKEN_MESSAGE;
          }
        break;
        case 'N':
        if(com.equals("NEXT")){
          token=TOKEN_NEXT;
        }  
        break;
        case 'P':
          if(com.equals("POKE")){
            token=TOKEN_POKE;
            break;
          }   
          if(com.equals("PEEK")){
            token=TOKEN_PEEK;
            break;
          }
          if(com.equals("PUTPOINT")){
            token=TOKEN_PUTPOINT;
          }            
          if(com.equals("PRINT")){
            token=TOKEN_ECHO;
          }            
          if(com.equals("PLOT")){
            token=TOKEN_PLOT;
          }
          if(com.equals("PAPER")){
            token=TOKEN_PAPER;
          }               
        break;
        case 'R':
          if(com.equals("READ")){
            token=TOKEN_READ;
            break;
          }        
          if(com.equals("READW")){
            token=TOKEN_READW;
            break;
          }
          if(com.equals("READL")){
            token=TOKEN_READL;
            break;
          }      
          if(com.equals("REM")){
            token=TOKEN_REM;
            break;
          }    
          if(com.equals("RESTORE")){
            token=TOKEN_RESTORE;
          }       
          if(com.equals("REFRESH")){
            token=TOKEN_REFRESH;
          }

          if(com.equals("RT")){
            token=TOKEN_RT;
          }   
          if(com.equals("RECENT")){
            token=TOKEN_RECENT;
          }                 
        break;
        case 'S':
          if(com.equals("SCALERGB")){
            token=TOKEN_SCALERGB;
            break;
          }
          if(com.equals("STEP")){
            token=TOKEN_STEP;
            if(zom.length()>0){
              words[wptr]=zom.substring(0,zom.length()-4);
              tok[wptr]=0;
              wptr++;
              zom="";
            }        
            words[wptr]=com;
            tok[wptr]=token;
            wptr++;
            com="";
            token=-1;
            break;
          }             
          if(com.equals("STOP")){
            token=TOKEN_STOP;
            break;
          }            
          if(com.equals("SCALE")){
            token=TOKEN_SCALE;
          } 
          if(com.equals("SETDIR")){
            token=TOKEN_SETDIR;
          }    
          if(com.equals("SETINT")){
            token=TOKEN_SETINT;
          }    
 
          if(com.equals("SETHEAD")){
            token=TOKEN_SETHEAD;
          }                   
          if(com.equals("SAVE")){
            token=TOKEN_SAVE;
          }                         
          if(com.equals("SYS")){
            token=TOKEN_SYS;
          }                       
          if(com.equals("SAVEKEY")){
            token=TOKEN_SAVEKEY;
          }       
        break;
        case 'T':
        if(com.equals("TO")){
          token=TOKEN_TO;
          if(zom.length()>0){
            words[wptr]=zom.substring(0,zom.length()-2);
            tok[wptr]=0;
            wptr++;
            zom="";
          }        
          words[wptr]=com;
          tok[wptr]=token;
          wptr++;
          com="";
          token=-1;
          break;
        }
        if(com.equals("TOOLBAR")){
            token=TOKEN_TOOLBAR;
        }          
        break;
        case 'V':
          if(com.equals("VERBOSE")){
            token=TOKEN_VERBOSE;
          }
        break;
        case 'W':
          if(com.equals("WORD")){
            token=TOKEN_WORD;            
            break;
          }      
        break;
        case 'X': 
          if(com.equals("XBYTE")){
            token=TOKEN_XBYTE;          
            break;
          }      
          if(com.equals("XWORD")){
            token=TOKEN_XWORD;          
            break;
          }      
          if(com.equals("XLONG")){
            token=TOKEN_XLONG;            
            break;
          }
          if(com.equals("XMOVE")){
            token=TOKEN_XMOVE;
          }  
          if(com.equals("XREPEAT")){
            token=TOKEN_XREPEAT;
          }
          if(com.equals("XWORDR")){
            token=TOKEN_XWORDR;            
            break;
          }
          if(com.equals("XREM")){
            token=TOKEN_XREM;
          }    
        break;
        case 'Z':                    
          if(com.equals("ZOOM")){
            token=TOKEN_SCALE;
          } 
        break;
      }
      
      if(token>=0){
        words[wptr]=com;
        tok[wptr]=token;
        wptr++;
        com="";
        zom="";  
      }
      com="";
    }
    
    
    /*
    if(inside==1&&c=='+'){
      c=char(0);
    } 
    */
    if(c>' '){
      com=com+c;
      zom=zom+c;
    }
    if(inside==1&&c==' '){
      com=com+c;
      zom=zom+c;
    }  
  }
  if(zom.length()>0){
    words[wptr]=zom;
    tok[wptr]=token;
    wptr++;
    inside=0;
  }
  
  /*for(int i=0;i<wptr+1;i++){
    println(i+":"+words[i]);
  }*/

  if(tok[0]==TOKEN_REM)return 0;

// IF and ENDIF always move the 'tab' for conditions
// later, a valid IF will check if the commands within that 'tab' are executed

  if(tok[0]==TOKEN_IF){
    if(g_condi[g_tab]==1){
      words[0]="";
      tok[0]=-1;
      g_tab++;    
      g_condi[g_tab]=1;
    }
  }  
  if(tok[0]==TOKEN_ENDIF){
    if(g_condi[g_tab]==1){
      g_condi[g_tab]=0;
      g_tab--;
    }
    else{
      g_tab--;
    }
    return 0;
  }  
  
  if(g_condi[g_tab]==1){words[0]="";tok[0]=-1;}
  
  if(tok[0]==TOKEN_LET||words[0].length()==1){
    
    int pos=1;
    
    if(words[0].length()==1)pos=0;
    
    char p=words[pos].charAt(0);
    
    if(tok[pos+1]==TOKEN_GRAB){
      int px=x_evaluate(words[pos+2]);
      int py=x_evaluate(words[pos+3]);
      int ad=1024+px*CX+py*X;
      g_var[p]=int(g_map[ad+7])+int(g_map[ad+6])*2+int(g_map[ad+5])*4+int(g_map[ad+4])*8+int(g_map[ad+3])*16+int(g_map[ad+2])*32+int(g_map[ad+1])*64+int(g_map[ad])*128;
      
      if(g_machine==VIC){
        g_var[p]=int(g_map[ad+14])+int(g_map[ad+12])*2+int(g_map[ad+10])*4+int(g_map[ad+8])*8+int(g_map[ad+6])*16+int(g_map[ad+4])*32+int(g_map[ad+2])*64+int(g_map[ad])*128;
       // g_var[p]=255-g_var[p];
      
      }
      return 0;
    }    
    
    if(tok[pos+1]==TOKEN_FIND){      
      println("FIND:"+words[pos+2]);
      g_var[p]=x_find(words[pos+2]);
      return 0;
    }    
    if(tok[pos+1]==TOKEN_PEEK){
      int pp=x_evaluate(words[pos+2]);
      g_var[p]=int(g_map[pp]);
      return 0;
    }
    if(tok[pos+1]==TOKEN_LENGTH){
      g_var[p]=g_xflen;
      return 0;
    }
    if(tok[pos+1]==TOKEN_BITPLANES){
      g_var[p]=int(g_map[14]);
      return 0;
    }
    if(tok[pos+1]==TOKEN_COLORS){
      g_var[p]=int(g_map[4]);
      return 0;
    }    
    if(words.length>pos+1){
      if(tok[pos+1]==TOKEN_GETPOINT){
        int xx=x_evaluate(words[pos+2]);
        int yy=x_evaluate(words[pos+3]);
        if(g_multic==4){
          g_var[p]=bpl_getxy(xx,yy,0);
          return 0;
        }
        g_var[p]=easygetcolor(xx,yy);//map onto tools
        return 0;
      }
      if(tok[pos+1]==TOKEN_SCALERGB){
        int val=x_evaluate(words[pos+2]);
        int steps=x_evaluate(words[pos+3]);
        //val1=round(g_g[i]/(255/(g_palstepsg-1)));
        g_var[p]=round(val/(255/(steps-1)));
        return 0;
      }   
    }
    
    g_var[p]=x_evaluate(words[1+pos]);
    return 0;
  }
  
  //end of LET
    
  if(tok[0]==TOKEN_READ){
   // char p=words[1].charAt(0);
   // g_var[p]=int(g_xmem[g_xhead]);
   // g_xhead++;
   
    char p = words[1].charAt(0);
    g_var[p] = g_xmem[g_xhead++] & 0xFF;

    return 0;
  }
  
  if(tok[0]==TOKEN_READW){
    //char p=words[1].charAt(0);
    //int hi=int(g_xmem[g_xhead]);
    //g_xhead++;
    //int lo=int(g_xmem[g_xhead]);
    //g_var[p]=hi*256+lo;
    //g_xhead++;
    
    char p = words[1].charAt(0);

    int hi = g_xmem[g_xhead++] & 0xFF; // ensure unsigned
    int lo = g_xmem[g_xhead++] & 0xFF;

    g_var[p] = (hi << 8) | lo;

    return 0;
  } 
  
  if(tok[0]==TOKEN_READL){
    char p=words[1].charAt(0);
    int hihi=int(g_xmem[g_xhead]);
    g_xhead++;
    int hilo=int(g_xmem[g_xhead]);
    g_xhead++;
    int lohi=int(g_xmem[g_xhead]);
    g_xhead++;
    int lolo=int(g_xmem[g_xhead]);
    g_xhead++;
    g_var[p]=hihi*(65536*65536)+hilo*65536+lohi*256+lolo;
    return 0;
  }   
  
  
  if(tok[0]==TOKEN_XMOVE){ // always imported single byte, repeat times
      for(int j=0;j<x_evaluate(words[1]);j++){
        int v=g_xint[g_xinthead];
        g_xinthead++;
        v=v&0xff;   
        x_xbyte(byte(v));
        x_dump(v);
      }
    return 0;
  }      

  if(tok[0]==TOKEN_IF){
    char p=words[1].charAt(0);
    int v=x_evaluate(words[2]);
    //print("if "+p+" "+v+" ("+condi+")");
   
    g_tab++;
    //print(" tab:"+g_tab);
    g_condi[g_tab]=1;
    if((condi==1)&&(g_var[p]==v)){g_condi[g_tab]=0;return 0;}
    if((condi==2)&&(g_var[p]>v)){g_condi[g_tab]=0;return 0;}
    if((condi==3)&&(g_var[p]<v)){g_condi[g_tab]=0;return 0;}
    if((condi==4)&&(g_var[p]>=v)){g_condi[g_tab]=0;return 0;}
    if((condi==5)&&(g_var[p]<=v)){g_condi[g_tab]=0;return 0;}
    if((condi==6)&&(g_var[p]!=v)){g_condi[g_tab]=0;return 0;}
    return 0;
  }  
  
  //used to be earlier, I see no reason why
  
  if(tok[0]==TOKEN_SETHEAD){
    int v=x_evaluate(words[1]);
    g_xhead=v;
    return 0;
  }   
  
  if(tok[0]==TOKEN_STOP){
    return 65536;
  } 
  if(tok[0]==TOKEN_LOAD){
    make_recallpoint();
    println("load");
    System.gc();
    String fname="";
    fname=g_candidatename;
    if(fname==null)return 0;
    if(fname.length()<2)return 0;
    inp_file=loadBytes(fname);
    // don't do this here
    /*
    if(inp_file==null){
      g_alertmessage="å  Error!|-|File not found.||| [Cancel]";
      launch_dialogue(74);
      message("NO FILE");
      //recall_mode();
      return 65536;
    }
    */
    g_xflen=inp_file.length;
    println("Length:"+g_xflen);
    for(int i=0;i<inp_file.length;i++){
      g_xmem[i]=inp_file[i];
    }
    g_xhead=0;  
    return 0;
  }    
  
  if(tok[0]==TOKEN_REFRESH){
    if(g_ext_choice==-1)return 0;
    String ss=g_extsave[g_ext_choice];
    String fname="";
    for(int i=0;i<16;i++){
      if(g_extrun[i]!=null){
        if(g_extrun[i].equals(ss)){
          if(g_spare==0)g_ext_executed=i;
          if(g_spare==1)g_ext_executeds=i;
        }
      }
    }
    if(g_spare==0){
      g_extfilename=g_candidatename;
      fname=g_extfilename;
    }
    if(g_spare==1){
      g_extfilenames=g_candidatename;
      fname=g_extfilenames;
    }
    if(g_exttype[g_ext_choice]!=0)setname(fname,g_spare);
    
    g_data[NEWX]=byte(g_map[5]);
    g_data[NEWY]=byte(g_map[7]);
    g_data[NEWBPL]=byte(g_map[14]);
    infer_bitplanes();
    infer_size();
    refresh_all();
    refreshpalette();
    g_repanel=0;
    update_ui(true,0);
    update_preview_window();
    return 0;
  }
  
  if(tok[0]==TOKEN_SAVE){
    if(g_xdump==true)return 0;
    save_baked();//check return too
    return 0;
  }  

  if(tok[0]==TOKEN_ECHO){ // debugging
    int v=x_evaluate(words[1]);
    println("ECHO:"+v);
    console_echo(str(v));
    return 0;
  }
  if(tok[0]==TOKEN_ALERT){ // debugging
    int v=x_evaluate(words[1]);
    String ms="";
    if(v==1)ms="Wrong file format?|| [CANCEL]";
    if(v==2)ms="Wrong mode 256/320?|| [CANCEL]";
    if(v==0)ms="Failed|| [CANCEL]";
    if(v==255)ms="Passed|| [CANCEL]";
    launch_alert("Alert no. "+v+"|-|"+ms);
    return 0;
  }
  if(tok[0]==TOKEN_VERBOSE){ // debugging
    g_verbose=x_evaluate(words[1]);
    return 0;
  }  
  if(tok[0]==TOKEN_POKE){ // executable header byte
    int ad=x_evaluate(words[1]);
    int v=x_evaluate(words[2]);
    v=v&0xff;
    if(ad>=88000||ad<0)ad=0;
    g_map[ad]=byte(v);
    if(ad==9&&g_map[13]==C64)hard_c64_palette(v,0);
    return 0;
  }
  if(tok[0]==TOKEN_MAKECOLOR){ 
    
    int i=x_evaluate(words[1]);
    float rmax=float(x_evaluate(words[2]));
    float gmax=float(x_evaluate(words[3]));
    float bmax=float(x_evaluate(words[4]));

    float r=float(x_evaluate(words[5]));
    float g=float(x_evaluate(words[6]));
    float b=float(x_evaluate(words[7]));
    if(rmax==7&&gmax==7&&bmax==3){
      //000 00 0
      //001 00 0
      //010 00 0
      //011 01 1
      //100 00 0
      //101 10 1
      //110 00 0
      //111 11 1       
      if(b>0){
        int vb=int(b);
        vb=vb*2;vb=vb|1;bmax=7;
        b=float(vb);
      }
    }
   // println("r:"+r);
    makecolor(i,int(round(r/rmax*255.0)),int(round(g/gmax*255.0)),int(round(b/bmax*255.0)));
    return 0;
  }  
  if(tok[0]==TOKEN_PUTPOINT){ 
    int x=x_evaluate(words[1]);
    int y=x_evaluate(words[2]);
    int p=x_evaluate(words[3]);
    g_farge=p;
    makepoint(x,y);
    return 0;
  }
  if(tok[0]==TOKEN_LINE){ 
    if(words.length>4){
      store_undo();
      g_button=LEFT;
      
      doline(x_evaluate(words[1]),x_evaluate(words[2]),x_evaluate(words[3]),x_evaluate(words[4]),0);
      doke(TURTLEX,x_evaluate(words[3]));
      doke(TURTLEY,x_evaluate(words[4]));
    }
    return 0;
  }
  if(tok[0]==TOKEN_LINETO){   
    if(words.length>2){
      store_undo();
      g_button=LEFT;      
      doline(deek(TURTLEX),deek(TURTLEY),x_evaluate(words[1]),x_evaluate(words[2]),0);
      doke(TURTLEX,x_evaluate(words[1]));
      doke(TURTLEY,x_evaluate(words[2]));
    }
    return 0;
  }  
  if(tok[0]==TOKEN_RT){  
    if(words.length>1){
      store_undo();
      int val=deek(TURTLEA);
      float ang=x_evaluate(words[1]);
      ang=ang*100;
      val=val+int(ang);
     // println(val);
      if(val>35999)val=val-36000;
      if(val<0)val=val+36000;
      doke(TURTLEA,val);
    }
    return 0;
  }
  if(tok[0]==TOKEN_LT){    
    if(words.length>1){
      store_undo();
      int val=deek(TURTLEA);
      float ang=x_evaluate(words[1]);
      ang=ang*100;
      val=val-int(ang);
      if(val>35999)val=val-36000;
      if(val<0)val=val+36000;
      doke(TURTLEA,val);
    }
    return 0;
  }
  if(tok[0]==TOKEN_FD){  
    if(words.length>1){
      store_undo();
      g_button=LEFT;      
      float dis=x_evaluate(words[1]);
      float ang=float(deek(TURTLEA));
      float a=ang/18000*PI;
      float sx=dis*sin(a);
      float sy=-dis*cos(a);
      doline(deek(TURTLEX),deek(TURTLEY),deek(TURTLEX)+int(sx),deek(TURTLEY)+int(sy),0);
      doke(TURTLEX,deek(TURTLEX)+int(sx));
      doke(TURTLEY,deek(TURTLEY)+int(sy));      
    }
    return 0;
  }      
  if(tok[0]==TOKEN_ADDITEM){ // add and item to menu
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,0);
    return 0;
  }
  if(tok[0]==TOKEN_ADDLOAD){ // add an item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,1);
    return 0;
  }
  if(tok[0]==TOKEN_ADDMAKE){ // add a special item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,3);
    return 0;
  }      
  if(tok[0]==TOKEN_ADDSAVE){ // add an item with fileselector
    String ss="";
    for(int i=1;i<wptr;i++){
      ss=ss+words[i]+",";
    }
    //println(">"+ss+"<");
    x_additem(ss,2);
    return 0;
  }     
  if(tok[0]==TOKEN_BYTE){ // executable header byte
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      g_xmem[g_xhead]=byte(v);
      g_xhead++;
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_WORD){ // executable header word
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      g_xmem[g_xhead]=byte(hi);
      g_xhead++;
      g_xmem[g_xhead]=byte(lo);
      g_xhead++;
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_LONG){ // executable header longword
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int l1=v&0xff000000;
      l1=l1/(0x1000000);
      int l2=v&0x00ff;
      l2=l2/(0x10000);
      int l3=v&0x0000ff;
      l3=l3/(0x100);
      int l4=v&0x000000ff;    
      g_xmem[g_xhead]=byte(l1);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l2);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l3);
      g_xhead++;      
      g_xmem[g_xhead]=byte(l4);
      g_xhead++;      
      //print(" write "+v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XREM){ // exported comment
    if(getbit(128)==0)return 0;
    x_dump_newline();
    x_dump_newline();
    g_outmode=32;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      x_dump(v);
    }
    x_dump_newline();
    return 0;
  }  
  if(tok[0]==TOKEN_XBYTE){ // always exported byte
    if(g_outmode!=0)x_dump_newline();
    g_outmode=0;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      v=v&0xff;
      x_xbyte(byte(v));
      x_dump(v);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XWORD){ // always exported word MSB,LSB
    if(g_outmode!=1)x_dump_newline();
    g_outmode=1;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      x_xbyte(byte(hi));
      x_xbyte(byte(lo));
      x_dump(hi*256+lo);
    }
    return 0;
  }
  if(tok[0]==TOKEN_XWORDR){ // always exported word LSB,MSB
    if(g_outmode!=1)x_dump_newline();
    g_outmode=1;
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int hi=v&0xff00;
      hi=hi/256;
      int lo=v&0x00ff;
      x_xbyte(byte(lo));
      x_xbyte(byte(hi));
      x_dump(hi*256+lo);
    }
    return 0;
  }    
  if(tok[0]==TOKEN_XLONG){ // always exported longword
    for(int i=1;i<wptr;i++){
      int v=x_evaluate(words[i]);
      int l1=v&0xff000000;
      l1=l1/(0x1000000);
      int l2=v&0x00ff0000;
      l2=l2/(0x10000);
      int l3=v&0x0000ff00;
      l3=l3/(0x100);
      int l4=v&0x000000ff;    
      x_xbyte(byte(l1));
      x_xbyte(byte(l2));
      x_xbyte(byte(l3));
      x_xbyte(byte(l4));
      x_dump(v);
    }
    return 0;
  }     
  if(tok[0]==TOKEN_XREPEAT){ // always exported single byte, repeat times
      int v=x_evaluate(words[1]);
      v=v&0xff;
      for(int j=0;j<x_evaluate(words[2]);j++){  
        x_xbyte(byte(v));
        x_dump(v);
      }
    return 0;
  }
  if(tok[0]==TOKEN_RESTORE){ // set internal readhead
    int v=x_evaluate(words[1]);
    g_xinthead=v;
    return 0;
  }    
  if(tok[0]==TOKEN_MESSAGE){
    String literal="";
    int okay=0;
    for(int i=0;i<s.length();i++){
      char c=s.charAt(i);
      if(okay==1)literal=literal+c;
      if(c==' ')okay=1;
    }
    message(literal);
    return 0;
  }    
    
  if(tok[0]==TOKEN_FOR){
    char p=words[1].charAt(0);
    g_loopptr[p]=line+1;
    //print("loopptr "+p+" = "+line);
    g_var[p]=x_evaluate(words[2]);
    g_loopend[p]=x_evaluate(words[4]);
    g_loopstep[p]=1;
    if(words[5]!=null&&words[5].equals("STEP")){
      g_loopstep[p]=x_evaluate(words[6]);
    }
    return 0;
  }
  if(tok[0]==TOKEN_NEXT){
    char p=words[1].charAt(0);
    g_var[p]=g_var[p]+g_loopstep[p];
    if(g_var[p]<=g_loopend[p]){
      //println(" ... loop to "+g_loopptr[p]);
      
      return g_loopptr[p];
    }
  }  
  if(tok[0]==TOKEN_SETDIR){
    println("path:"+path);
    path=words[1];
    println("path:"+path);
    return 0;
  }
  
  if(tok[0]==TOKEN_PLOT){
    if(words.length>2){
      store_undo();
      makepoint(x_evaluate(words[1]),x_evaluate(words[2]));
      doke(TURTLEX,x_evaluate(words[1]));
      doke(TURTLEY,x_evaluate(words[2]));
    }
    return 0;    
  }
  if(tok[0]==TOKEN_DRAW){
     if(words.length>2){
      store_undo();
      g_button=LEFT;      
      doline(deek(TURTLEX),deek(TURTLEY),deek(TURTLEX)+x_evaluate(words[1]),deek(TURTLEY)+x_evaluate(words[2]),0);
      doke(TURTLEX,deek(TURTLEX)+x_evaluate(words[1]));
      doke(TURTLEY,deek(TURTLEY)+x_evaluate(words[2]));
    }
    return 0; 
  }
  if(tok[0]==TOKEN_ELLIPSE){
     if(words.length>4){
      store_undo();
      g_button=LEFT;   
      int x=x_evaluate(words[1]);
      int y=x_evaluate(words[2]);
      docircle(x,y,x+x_evaluate(words[3]),y+x_evaluate(words[4]));
      doke(TURTLEX,deek(TURTLEX)+x_evaluate(words[1]));
      doke(TURTLEY,deek(TURTLEY)+x_evaluate(words[2]));
    }
    return 0;
  }  
  if(tok[0]==TOKEN_FILL){
    if(words.length>2){
      store_undo();
      g_button=LEFT;
      easy_fill(x_evaluate(words[1]),x_evaluate(words[2]),g_farge);
    }
    return 0;
  }    
  if(tok[0]==TOKEN_INK){
    if(words.length>1){
      selectcolor(0,x_evaluate(words[1]));
      //g_farge=x_evaluate(words[1]);
      g_map[19]=byte(g_farge);
    }
    return 0;
  }
  if(tok[0]==TOKEN_PAPER){
    if(words.length>1){
      g_backg=x_evaluate(words[1]);
      g_map[20]=byte(g_backg);
    }
    return 0;
  }
  if(tok[0]==TOKEN_BORDER){
    if(words.length>1){
      set_border(x_evaluate(words[1]));
    }
    return 0;
  }
  if(tok[0]==TOKEN_CRUNCH){
    char_crunch(16);
    return 0;
  }  
  if(tok[0]==TOKEN_GRID){
    if(words.length>2){
      make_grid(x_evaluate(words[1]),x_evaluate(words[2]));
      g_data['g']=1;
    }
    return 0;
  }  
  if(tok[0]==TOKEN_DARKTHEME){
    println("DARK THEME");
    g_data[GUIDARK]=1;
    true_clear();
    refresh_all();
    update_ui(true,0);
    return 0;
  }
  if(tok[0]==TOKEN_LIGHTTHEME){
    g_data[GUIDARK]=0;
    true_clear();
    refresh_all();
    update_ui(true,0);
    return 0;
  }   
 
  if(tok[0]==TOKEN_SCALE){
    g_data[GUILOCK]=1;
    g_uizoom=x_evaluate(words[1]);
    refocus();
    true_clear();
    refresh_all();
    update_ui(true,0);  
    return 0;
  }
  if(tok[0]==TOKEN_AUTOSCALE){
    g_data[GUILOCK]=0;
    re_scale();
    refocus();
    true_clear();
    refresh_all();
    update_ui(true,0);
    return 0;
  } 
  if(tok[0]==TOKEN_HOME){  
    g_maglevel=0;
    refocus();
    return 0;
  }
  
  if(tok[0]==TOKEN_SAVEKEY){
    String recs="";
    for(int i=1;i<wptr;i++){
      //print(char(int(words[i])));
      recs=recs+(char(int(words[i])));
    }
      for(int i=0;i<g_extrun.length;i++){
        if(recs.equals(g_extrun[i])){
          //println("Designate the re-execute script as ("+i+") = "+g_extrun[i]);
          g_ext_choice=i;
          if(g_spare==0){
           // g_extfilename=filename;
            g_ext_executed=i;
            //println("g_Extfilename="+g_extfilename);
          }
          if(g_spare==1){
          //  g_extfilename=sfilename;
            g_ext_executeds=i;
          }
        }
      }
  
  }
  
  if(tok[0]==TOKEN_RECENT){
    println("TOKEN_RECENT:");
    String recs="";
    for(int i=1;i<wptr;i++){
     // print(char(int(words[i])));
      recs=recs+(char(int(words[i])));
    }
    String fname="";
    if(g_spare==0)fname=g_extfilename;
    if(g_spare==1)fname=g_extfilenames;
    //println(" Fname:"+fname);
    create_recentfile(recs,fname);
    //println("");
  }
  
  if(tok[0]==TOKEN_TOOLBAR){
    g_guileft=g_guileft+1;
    if(g_guileft>1){g_guileft=0;}
    
    if(words.length>1){
      int p;
      p=x_evaluate(words[1]);
      if(p>0)g_guileft=p-1;
    }
    setup_windows(g_guileft,g_trustorex,g_trustorey);//1=lefthander    
    g_windowx=int(g_winlocx[0]);
    g_windowy=int(g_winlocy[0]); 
    true_clear();
    refresh_all();
    update_ui(true,0);
    if(g_maglevel==0){
      g_leftedge=0;
      if(g_guileft==1)g_leftedge=int(g_realw[4]);
      refocus();
    }
    return 0;
  }
  if(tok[0]==TOKEN_SYS){
    println("WPR:"+wptr);
    println("VIT:"+words.length);
    if(wptr<=1){
      test_charexp();
      return 0;
    }
    if(wptr>1){
      make_recallpoint();
      change_mode_value(evaluate(words[1],2));
      if(get_complexity()>2&&g_machine!=TUTORIAL1){
        g_report="| [X]  Mode Changed |-|";
        g_report=g_report+"Recall old mode?| | [Recall]";
        launch_dialogue(83);
      }      
     clamp_undo();
     untouch();
    }
    return 0;
  }

 // println(tok[0]);
  //println();
  return 0;
}
