// Pull-down menus and new dialogues
// generated buttonlist
// x_com string command function

int g_global_dragmode=0;
int g_preview_id=0;

boolean g_iconban=false;

final int MAXW=32;
int[] g_wintype = new int[MAXW];
float[] g_winlocx = new float[MAXW];
float[] g_winlocy = new float[MAXW];
float[] g_winwid = new float[MAXW];
float[] g_winhei = new float[MAXW];
float[] g_realx = new float[MAXW];
float[] g_realy = new float[MAXW];
float[] g_realh = new float[MAXW];
float[] g_realw = new float[MAXW];
int[] g_wingets = new int[MAXW];
int[] g_wintie = new int[MAXW];
int[] g_winparam = new int[MAXW];

int g_window_id=0;
int g_writemode=0;
int g_fingernumb=0;

int g_entryad=0;
int g_entrymode=0;

String g_alertmessage;

int NUMBER=255;
int ICON=64;
int ASCII=32;
int TICKBOX=1;

final int ATTACH_BOTTOM=65536;
final int ATTACH_RIGHT=65536;
final int ATTACH_MENU=65534;

final int MENUBAR=1;
final int PULLDOWN=2;
final int DIALOGUE=4;
final int INTERACTIVE=8;
final int LITERAL=16;

boolean g_onmenubar=false;

// managing temporary iconlist
// "finger" is the central access point to the temp iconlist,
// activating the command() for that particular window

int MAXLT=1024;
String g_iconn[]=new String[MAXLT];
int g_iconx1[]=new int[MAXLT];
int g_icony1[]=new int[MAXLT];
int g_iconx2[]=new int[MAXLT];
int g_icony2[]=new int[MAXLT];
int g_iconat[]=new int[MAXLT];
int g_iconfrom[]=new int[MAXLT];
int g_iconlistptr;
String g_understring="";
String g_lastmenuitem="";



void re_scale(){
  int prev=g_uizoom;
  g_screenw = width;
  g_screenh = height;
  if(g_data[GUILOCK]==0){
    g_uizoom=2;
    if(g_screenw<(viewport_width(2)+48*2)||g_screenh<(viewport_height(2)+41*2)){
      g_uizoom=1;
    }
    if(g_screenw>(viewport_width(3)+48*3)&&g_screenh>(viewport_height(3)+56*3)){
      g_uizoom=3;
    }
    if(g_maglevel==0){
    //  if(prev!=g_uizoom){
        refocus();
    //  }
    }
  }
}


int get_topedge(){
  int res=g_topedge;
  if(g_maglevel>=0){
    res=12*g_uizoom;
  }
  return res;
}

void update_ui(boolean forced,int param)
{
  if(g_repanel<=0)g_repanel++;
    
  // when tooltipping, the panels are not really drawn
  
  int pass=0;
  if(g_machine==TUTORIAL1){
    for(int i=0;i<MAXW;i++){
      if(g_wintype[i]==90)pass=1;
      if(g_wintype[i]==77)pass=1;
    }
    if(pass==0)single_com(0,"Q",0,0,0); 
  }
  if(g_repanel>0&&forced==false){    
    reset_iconlist();
    for(int i=0;i<MAXW;i++){
      if(g_wintype[i]>0){        
        make_draw_window(i);    
      }
    }
    return;
  }
  
  if(g_repanel>0&&forced==false)return;
  
  // now they are properly drawn
  
  reset_iconlist();
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]>0){      
      make_draw_window(i);
    }
  }
}


void clear_windows(){
  for(int i=0;i<MAXW;i++){
    g_wintype[i]=0;
  }
}

void add_window(int t,int x,int y){
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==t&&t<100)return;
  }
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==0){
      g_wintype[i]=t;
      g_winlocx[i]=x;
      g_winlocy[i]=y;
      g_wingets[i]=0;
      g_wintie[i]=0;
      if(y==65535)g_wintie[i]=g_wintie[i]|1;
      if(x==65535)g_wintie[i]=g_wintie[i]|2;
      return;
    }
  }
}

void add_sized_window(int t,int x,int y,int w,int h){
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==t&&t<100)return;
  }
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==0){  
      if(t==100)g_preview_id=i;
      if(t==102){
        g_leftedge=x;
        g_topedge=y;
        if(x+w>=width)w--;
      }
      g_wintype[i]=t;
      g_winlocx[i]=x;
      g_winlocy[i]=y;
      g_wingets[i]=0;
      g_wintie[i]=0;
      if(y==65535)g_wintie[i]=g_wintie[i]|1;
      if(x==65535)g_wintie[i]=g_wintie[i]|2;
      if(y==ATTACH_MENU)g_wintie[i]=g_wintie[i]|4;
      if(t>=68&&t<=90){
        g_wingets[i]=1;
      }
      g_winwid[i]=w;
      g_winhei[i]=h;   
      return;
    }
  }
}

int find_window(int type){
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==type)return i;
  }
  return -1;
}

void reset_windows(){
  
  g_maglevel=0;
  
  if(g_aspect_override==1){
    g_aspect=SQUARERATIO;
  }
  
  int truviewportx = X * g_magpix[magmode()];
  int truviewporty = Y * g_magpiy[magmode()];
  
  setup_windows(g_guileft,X,Y);//1=lefthander
  g_trustorex=truviewportx;
  g_trustorey=truviewporty;
  
  paspect=g_wzoom;
  
  if(g_aspect==FLATRATIO)
  {
    if(g_wzoom==2)paspect=1;
    if(g_wzoom==3)paspect=2;
    if(g_wzoom==4)paspect=3;    
  }
  
  g_windowx=int(g_winlocx[0]);
  g_windowy=int(g_winlocy[0]); 
}

void setup_windows(int hand,int truex,int truey){
  
  int fixer=0;
  
  int yh=height/g_uizoom;
  
  truex=truex/2;truex=truex*3;
  truey=truey/2;truey=truey*3;  
  
  if(int(g_map[13])==ULAPLUS)fixer=2;
  
  clear_windows();

  int xroom=width-32;
  
  if(hand==0){//main toolbar RIGHT = old
    
    add_sized_window(99,3,5,40,25);//viewport
    
    //collars
    
    add_sized_window(102,0,1,95,88);//border
    //add_sized_window(102,0,3,4,88);//border
    
    add_sized_window(101,65535,0,3,100);
    add_sized_window(101,0,65535,100,3);
    
    //toolboxes etc
    
    add_sized_window(1,65535,4,4,24);//1st toolbox tie to right edge
    
     // 10+ onwards, non-icontable types
     
    add_sized_window(10,65535,65535,9,3); //messagebox tie to corner

    //BLOCK, tie to bottom edge
    
    add_sized_window(12,0,65535,18,3); //colorselector   
    add_sized_window(2,43+fixer,65535,3,3);//2nd toolbox  
    
    add_sized_window(11,55,65535,10,3); //palettebox
    
  }
  
  if(hand==1){//main toolbar LEFT
    
    add_sized_window(99,3,5,40,25);//viewport    
    
    add_sized_window(102,0,1,95,88);//border
    
    add_sized_window(101,65535,0,3,100);
    add_sized_window(101,0,65535,100,3);
    
    //toolboxes etc
    
    add_sized_window(1,0,4,4,24);//1st toolbox tie to left edge
    
     // 10+ onwards, non-icontable types
     
    add_sized_window(10,65535,65535,9,3); //messagebox tie to corner

    //BLOCK, tie to bottom edge
    
    add_sized_window(12,0,65535,18,3); //colorselector  
    add_sized_window(2,43+fixer,65535,3,3);//2nd toolbox  
    
    add_sized_window(11,55,65535,10,3); //palettebox
        
  }  
  
    add_window(100,25,25); //preview
    add_sized_window(20,0,0,width,1);//menubar
}

void make_draw_window(int win){

  if(g_wintype[win]==0)return;
  int t;
  float x,y,w,h;
  int xt,yt,wt,ht;
  
  float wwf=float(width);
  float hhf=float(height);
  float unity=100.0/hhf*(12*g_uizoom);//11 or 12?
  float unitx=100.0/wwf*(12*g_uizoom);//11 or 12?
  
  int okay=0;
  
  if(g_wintype[win]==99){ //viewport
   
    float xspace=(width-42*g_uizoom)-viewport_width(0);
        
    if(g_guileft==0){
      g_winlocx[win]=(xspace/2)/width*100.0;
    }
    else{
      g_winlocx[win]=(xspace/2+(42*g_uizoom))/width*100.0;
    }    
    
    float yspace=(height-24*g_uizoom)-viewport_height(0);
    g_winlocy[win]=(yspace/2)/height*100.0;
    g_winwid[win]=float(viewport_width(0))/width*100.0;
    g_winhei[win]=float(viewport_height(0))/height*100.0;
    okay=1;
  }  

  x=g_winlocx[win];
  y=g_winlocy[win];
  
  w=g_winwid[win];
  h=g_winhei[win];
  
  if((g_wintie[win]&1)==1){
    y=100-unity*h;
  }
   if((g_wintie[win]&2)==2){
    x=100-unitx*w;
  } 
  
  t=int(g_wintype[win]);
  
  if(w<45&&okay==0)w=w*unitx;
  if(h<45&&okay==0)h=h*unity;
  
  x=x/100*wwf;
  w=w/100*wwf;
  
  y=y/100*hhf;
  h=h/100*hhf;

  if(t==102){//border
    w=width-40*g_uizoom;
    h=height-48*g_uizoom;    
    h=g_realy[6]-g_realy[win];
  } 
  if(t==2){ //tie 2nd toolbar to right side of colorselector
    x=int(g_realw[win-1]);// a bit hack-y
  }
  if(t==20){ //tie 2nd toolbar to right side of colorselector
    h=12*g_uizoom;
  }
  if((g_wintie[win]&4)==4){
   y=11*g_uizoom;
  }     
  xt=int(x);
  yt=int(y);
  wt=int(w);
  ht=int(h);
  
  //debug stuff
  
  xt=xt-4;
  yt=yt-4;
  wt=wt+8;
  ht=ht+8;
  /*
  if(g_wizard){  
    noFill();
    stroke(255,0,255);
    if(t==12)stroke(0,255,0);
    if(t==99){
      stroke(255,255,0);
    }
    rect(xt,yt,wt,ht);
    line(xt,yt,xt+wt,yt+ht);
    line(xt,yt+h,xt+wt,yt);  
    fill(255,255,255);
    text(""+win+":"+g_wintype[win],x+8,y-8);
    
    noStroke();  
    noFill();
  }
  */
  
  
  xt=xt+4;
  yt=yt+4;
  wt=wt-8;
  ht=ht-8;
  
  
  g_realx[win]=xt;
  g_realy[win]=yt;
  g_realw[win]=wt;
  g_realh[win]=ht;
 
  if(t==99){
    g_windowx=xt;
    g_windowy=yt;
  } 
      
  if(t<8){
    //1 and 2 are icontables
    if(t==1)yt=16*g_uizoom;
    if(t==2)yt=yt+3*g_uizoom;
    icontable_new(win,xt,yt,t-1);
  }
  if(t==10)messagebox(win,xt+10*g_uizoom,yt+3*g_uizoom);  
  if(t==11){
    
   if(width>=512*g_uizoom){
      palettebox(win,xt,yt,wt,ht,0);//1=for grid
   }
  }
  if(t==12)colorselector_new(win,xt,yt,wt,ht);
  if(t==13)colorindicator(win,xt,yt);
  
  if(t==20)menubar(win,xt,yt,wt,ht);
  if(t>=32&&t<=90){if(y<16)yt=yt*g_uizoom;}
  if(t>=32&&t<=90)menubox(win,xt,yt,wt,ht-4*g_uizoom,t);
  if(t==100){
    g_preview_id=win;
    draw_preview_window(win,xt,yt);
  }  

}

void launch_alert(String msg){
  realdiscardmenus(0);
  g_alertmessage=msg;
  launch_dialogue(74);
}

// void launch_window
void launch_dialogue(int tp){
   int ww,hh;
   realdiscardmenus(0);
   ww=16;
   hh=10;
   terminate_click();
   
   if(tp==68){//recent files
     ww=24;
     hh=16;
   }
   
   if(tp==69){
     ww=20;hh=11;//text out dialogue
      for(int i=0;i<g_extension;i++){
        if(g_exttype[i]==2) hh=hh+2;     
      }
   }
   if(tp==70){//palette
     int heihei=0;
     heihei=(g_maxcolors/16);
     if(heihei<1)heihei=1;
     heihei=heihei+g_colorprofile[3]*5;
     if(g_colorprofile[0]!=0|g_colorprofile[1]!=0||g_colorprofile[2]!=0){
         heihei=heihei+2;
         if(g_maxcolors>=256)heihei=heihei-2;
     }     
     ww=25;
     if(g_colorprofile[0]!=0&&g_colorprofile[1]!=0&&g_colorprofile[2]!=0){
         ww=ww+4;
     }          
     hh=(9+heihei);
     if(g_machine==PCCGA)hh=hh+8;
     if(g_machine==APPLE2)hh=hh+1;
     if(g_maxcolors>=256){
       hh=hh-1;
     }
   }//palette
   
   if(tp==67){ww=21;hh=13;}//warning recent
   if(tp==71){ww=16;hh=9;}//warning
   if(tp==72){ww=21;hh=10;}//overwrite
   if(tp==76||tp==73){ww=23;hh=20;}//debug
   if(tp==73){hh=25;}
   if(tp==74){ww=16;hh=9;}//alert
   if(tp==77)hh=g_realmenu.length+4;//platform selector
   if(tp==78)hh=7+count_touched();
   
   if(tp==80){ww=22;hh=13;}//settings
   if(tp==81){ww=32;hh=9;}//console
   if(tp==82){ww=38;hh=12;}//paths
   
   if(tp==83){ww=14;hh=8;add_sized_window(tp,3,5,ww,hh);return;}//file import report
   
   if(tp==84){
     ww=14;
     hh=12;
     g_data[NEWX]=byte(MX);
     g_data[NEWY]=byte(MY);
     if(g_colorprofile[7]==1)hh=hh+4;
   }//resize dialogue
   if(tp==85){
     ww=20;
     hh=16;
     g_data[NEWX]=byte(MX);
     g_data[NEWY]=byte(MY); 
   }//set_grid
   if(tp==86){//script helper
     ww=32;
     hh=16;
     g_data[NEWX]=byte(MX);
     g_data[NEWY]=byte(MY);      
   }
   
   if(tp==87){//extras menu
     ww=20;
     hh=24;
   }
   if(tp==88){//version
     ww=24;
     hh=11;
   }
   if(tp==89){//cheatsheet
     ww=24;
     hh=20;
   }
   if(tp==90){//tutorial
     ww=24;
     hh=16;
   }
   
   add_sized_window(tp,50-(ww),45-(hh+hh/2),ww,hh);
}

void hide_menus(){
  discard_menus();
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]==20){
      g_trueclearbit=true;
      g_wintype[i]=21;
      g_repanel=-2;
      refresh_all();
    }
  }    
}

void launch_menu(int tp,int x,int y){
   int steps=0;
   discard_menus();
   buildmenu(tp,0);
   steps=g_optioncount;
   float fx=float(x)/width*100.0;
   add_sized_window(tp,int(fx),ATTACH_MENU,10,(2+steps));//menubar 
   g_onmenubar=true;
}

int count_pullmenus(){
  int res=0;
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]>=32&&g_wintype[i]<=40){
      res++;
    }
  }  
  return res;
}

int count_menus(){
  int res=0;
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]>=32&&g_wintype[i]<=89){
      res++;
    }
  }  
  return res;
}


void discard_dialogues(int par){
  int winmin=68;
  int winmax=98;
  if(par==1){
    winmin=74;
    winmax=74;
  }
    for(int i=0;i<MAXW;i++){
    if(g_wintype[i]>=winmin&&g_wintype[i]<=winmax){     
        g_wintype[i]=0;
        g_winlocx[i]=0;
        g_winlocy[i]=0;
        g_winwid[i]=0;
        g_winhei[i]=0;
      }
    }
}

int realdiscardmenus(int par){
  //println("realdiscarD");
  int res=0;
  int vika=-1;
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]!=0){if(i>vika)vika=i;
    }
  }
  
  for(int i=0;i<MAXW;i++){
    int t=g_wintype[i];
      if(par==70&&t==70){        
          g_wintype[i]=0;
          g_winlocx[i]=0;
          g_winlocy[i]=0;
          g_winwid[i]=0;
          g_winhei[i]=0;
          res++;   
      }
      if(par==0&&t>=32&&t<=89&&t!=70){
        g_wintype[i]=0;
        g_winlocx[i]=0;
        g_winlocy[i]=0;
        g_winwid[i]=0;
        g_winhei[i]=0;
        res++;   
      }  
      if(par==1&&t>=32&&t<=40){
        g_wintype[i]=0;
        g_winlocx[i]=0;
        g_winlocy[i]=0;
        g_winwid[i]=0;
        g_winhei[i]=0;
        res++;        
      }
  }
  if(res>0)refresh_all();
  return res;
}

int discard_menus(){
  int res=0;
  int vika=-1;
  for(int i=0;i<MAXW;i++){
    if(g_wintype[i]!=0){
      if(i>vika)vika=i;
    }
  }
  
  for(int i=0;i<MAXW;i++){
    int t=g_wintype[i];
    if(t>=69&&t<=89)return 0;
      if(t>=32&&t<=89){
        res++;   
      }  
  }
  return res;
}

int g_banclick=0;
void terminate_click(){
  g_banclick=1;
}

// buttonlist

int finger(int xx,int yy,int fgr,int origin){
  int act=in_icon(xx,yy);
  g_understring="";
  if(act==-1)return -1;
  if(g_banclick==1){g_banclick=0;return -1;}
  String comm="";
  String ttip="";
  int flop=0;
  if(origin==RELEASED){
    if(g_iconfrom[act]!=PULLDOWN){
      return -1;
    }
  }
  if(g_iconn[act].length()<1)return -1;
  for(int i=0;i<g_iconn[act].length();i++){
    char c=g_iconn[act].charAt(i);
    if(c=='#'){
      flop=1;
      c=0;
    }
    if(c>31){
      if(flop==0){comm=comm+c;}
      if(flop==1){ttip=ttip+c;}
    }
  }
  
  int mode=0;
  if(g_phase>0)return -1;
  if(fgr==LEFT)mode=1;
  if(fgr==RIGHT)mode=2;
  if(fgr==CENTER)mode=3;
  
  
  
  if(fgr!=HOVER&&act>=0&&origin==RELEASED){
     if(comm.equals("File")){g_understring=comm;return -1;}
     if(comm.equals("Edit")){g_understring=comm;return -1;}
     if(comm.equals("Tools")){g_understring=comm;return -1;}
     if(comm.equals("Other")){g_understring=comm;return -1;}
     if(comm.equals("FX")){g_understring=comm;return -1;}
  }
  
  if(fgr!=HOVER&&act>=0&&origin==PRESSED){    
    int okay=0;
     if(comm.equals("File"))okay=1;
     if(comm.equals("Edit"))okay=1;
     if(comm.equals("Tools"))okay=1;
     if(comm.equals("Other"))okay=1; 
     if(comm.equals("FX"))okay=1;   
    if(okay==1){
      g_understring=comm;
      g_fingernumb=0;
      okay=0;
       if(discard_menus()>0){
         //println("should remove");
         //println("1");
         realdiscardmenus(0);
         return -1;
       }
     }
  }
  
  if(fgr==HOVER&&act>=0){
    int okay=0;
   // println("tooltip on "+comm+":"+ttip);
    helper_message(ttip);
    x_tooltip(g_iconn[act]);
    if(origin==PRESSED||origin==DRAGGED||origin==MOVED){
      g_understring=comm;
      if(comm.equals("File")){okay=1;}
      if(comm.equals("Edit")){okay=1;}
      if(comm.equals("Tools")){okay=1;}
      if(comm.equals("Other")){okay=1;}
      if(comm.equals("FX")){okay=1;}

      if(okay==1){     
        g_fingernumb=0;
        //println("2");
        realdiscardmenus(1);
      }
      if(okay==0)act=-1;
      if(g_onmenubar==false)act=-1;
      mode=4;}
    else{
      return -1;
    }
  }
  
  if(act>=0){
      if(comm.equals("MBOX")){
        return 0;//0, not -1, No action but let's not destroy the box the items are on
      }
      if(comm.equals("MDRAG")&&origin==RELEASED){
        return 0;//0, not -1, No action but let's not destroy the box the items are on
      }      
      if(fgr!=HOVER){
         //println("LAST:"+g_lastmenuitem);
      }
      //discard_menus();
      if(fgr==4444)return -1;
      
      if(fgr!=HOVER){
        //discard menus if we're under a menu
        if(count_pullmenus()>0){
          //println("3");
          realdiscardmenus(0);
        }
        g_onmenubar=false;
      }
      if(g_iconn[act].charAt(0)=='@'){
        if(origin==RELEASED)return -1;
      }
      g_fingernumb=1;
      if(g_iconban)return -1;
      x_com(g_iconat[act],comm,mode,g_iconx1[act],g_icony1[act]);
      
      return act;
  }
  return -1;
}

void reset_iconlist(){
  g_iconlistptr=0;
}

void add_iconlist(int winat,String ss,int x,int y,int x2,int y2){
  g_iconn[g_iconlistptr]=ss;  
  g_iconx1[g_iconlistptr]=x;
  g_icony1[g_iconlistptr]=y;
  g_iconx2[g_iconlistptr]=x2;
  g_icony2[g_iconlistptr]=y2;
  g_iconat[g_iconlistptr]=winat;  
  g_iconfrom[g_iconlistptr]=g_writemode;
  g_iconlistptr++;
}

int in_window(int xx,int yy){
  for(int i=MAXW-1;i>=0;i--){
    if(g_wintype[i]!=0){
      if(xx>=g_realx[i]&&yy>=g_realy[i]&&xx<=g_realx[i]+g_realw[i]&&yy<=g_realy[i]+g_realh[i]){
        return i;
      }
    }
  }
  return -1;
}

boolean textoutputwin(){
  for(int i=MAXW-1;i>=0;i--){
    if(g_wintype[i]==69){
      return true;
    }
  }
  return false;
}

int in_window_type(int xx,int yy){
  int h=in_window(xx,yy);
  if(h>-1){
    return g_wintype[h];
  }
  return -1;
}


int in_icon(int xx,int yy){
  for(int i=g_iconlistptr-1;i>=0;i--){
    if(xx>=g_iconx1[i]&&yy>=g_icony1[i]&&xx<=g_iconx2[i]&&yy<=g_icony2[i]){
      return i;
    }
  }
  return -1;
}

boolean g_trueclearbit;

void true_clear(){
  g_trueclearbit=true;
}

void x_tooltip(String com)
{  
  char para=com.charAt(1); 
  if(com.charAt(0)=='@'){
    int value=leechvalue(com); 
    
    if(para=='f'){//farges
      if((g_usablecolor[value]&8)==0){
        if(value==int(g_map[0])){
          helper_message("Pick color|LMB=color1|RMB=color2|Border color");
          return;
        }
        if(value==int(g_map[1])){
          helper_message("Pick color|LMB=color1|RMB=color2|Back color");
          return;
        }
        if(value==int(g_map[2])){
          helper_message("Pick color|LMB=color1|RMB=color2|Aux color");
          return;
        }
        if(value!=int(g_map[0])&&value!=int(g_map[1])&&value!=int(g_map[2])){
          helper_message("Pick color|LMB=color1|RMB=color2|Not a pen");
          return;
        }
      }
      helper_message("Pick color|LMB=color1|RMB=color2");
      if((int(g_map[13])==VIC)&&value==int(g_map[0])){
        helper_message("Pick color|LMB=color1|RMB=color2|Border color");
      }
      if(g_machine==VICM&&value==int(g_map[1])){
        helper_message("Pick color|LMB=color1|RMB=color2|Back color");
      }      
    }
    if(para=='b'){//preset brushes
      helper_message("Preset|brushes");
    }
    if(para=='t'){//conventional tooltip
      char xc=com.charAt(2);
      help(xc);
    }        
  }
}

// command line parameters
// partly repeats prefs so improve

void cline(String xcom,int priority){
  
    String com[]=split(xcom,"=");
    
    if(priority==0){
      if(com[0].equals("MPPATH")){
        g_superpath=com[1];
        println("Multipaint path="+g_superpath);
        return;
      }
    }

    if(priority==0)return;
    
    if(com[0].equals("LOAD")){
      println("Load file "+com[1]);
      restore(com[1],0);
      return;
    }
    
    if(com[0].equals("EXIT")){
      exit();
      return;
    }
    
    if(com[0].equals("SAVE")){
      println("Save file "+com[1]);
      savekey(com[1]);
      return;
    }
    
    if(com[0].equals("PATH") && com[1].length()>1)
    {
        println("Working path="+com[1]);
        path=com[1];
    }    
    
    if(com[0].equals("PNGSCALE"))
    {
        g_omag=int(com[1]);
        if(g_omag<1||g_omag>10)g_omag=1;
    }
    
    if(com[0].equals("PNGHBORDER"))
    {
        g_bordh=int(com[1]);
        if(g_bordh<1||g_bordh>256)g_bordh=64;
    }
    
    if(com[0].equals("PNGVBORDER"))
    {
        g_bordv=int(com[1]);
        if(g_bordv<1||g_bordv>256)g_bordv=72;
    }

    if(com[0].equals("EXPBORDER"))
    {
        int par=int(com[1]);
        if(par<0)par=0;
        if(par>1)par=1;
        putbit(136,par);
    }    
    
    if(com[0].equals("MACHINE") && com[1].length()>1)
    {      
        for(int j=0;j<ext_machinenames.length;j++){

          if(com[1].equals(ext_machinenames[j])){
            println("Mode="+ext_machinenames[j]);
                                    
            change_mode(g_machineidx[j],g_getindex[j]);
          }
      }    
    }
}

int evaluate(String in,int mod){
  int r=0;
  float mega=1;
  int nega=0;
  int fpt=0;
  int input_mode=0;
  for(int i=0;i<in.length();i++){
    char c=in.charAt(i);
    if(c>='0'&&c<='9'){
      r=r*10;
      r=r+(c-48);
      if(fpt==1)mega=mega*10;
    }
    if(c=='.')fpt=1;
    if(c=='-')nega=1;
    if(c=='%')input_mode=1;
    if(c=='#')input_mode=2;
  }
  float val=float(r);
  val=val/mega;
  if(nega==1)val=-val;
  int res=round(val);
  if(mod!=2&&input_mode==1){// percentage
    val=val/100.0;
    if(mod==0)val=val*float(X-1); 
    if(mod==1)val=val*float(Y-1);    
    res=round(val);
  }
  if(mod!=2&&input_mode==2){// grid count
    if(mod==0)val=val*int(g_data[GRIDX])+int(g_data[XOFFSET]); 
    if(mod==1)val=val*int(g_data[GRIDY])+int(g_data[YOFFSET]);    
    res=round(val);
  }  
  return res;
}

void reboot(){
  x_resetitems();
  xbasic_run("boot.txt");
}

void launch_extension(int i){

  println("Type:"+g_exttype[i]);
  println("Name:"+g_exthook[i]);
  println("Ext :"+g_extext[i]);
  println("Run :"+g_extrun[i]);
  println("Save:"+g_extsave[i]);
  println("Make:"+g_extmake[i]);
  
  if(g_exthook[i].equals("null")){
    //println("*(null)");
    store_undo();
    xbasic_run(g_extrun[i]);
    return;
  }
    
  g_formatextension=g_extext[i];
  g_formatname=g_exthook[i];
  gui=true;
  ext_select=true;
  g_ext_choice=i;
  //println("g_ext_choice:"+i);
  if(textoutputwin()){
    exporttxt=true;
    ext_select=false;
  }
}


void x_com(int win,String com,int mode,int xx,int yy){
  String coms[]=split(com,':');
  for(int i=0;i<coms.length;i++){
    single_com(win,coms[i],mode,xx,yy);
  }
}

void single_com(int win,String com,int mode,int xx,int yy){  
  
  refresh_all();//?
  
  if(com.equals("X")){  
    discard_dialogues(0);
    g_trueclearbit=true;
    return;
  }
  
  if(com.equals("Q")){
     x_com(0,"RESETPARAMS",0,0,0);
     x_com(0,"INK 1",0,0,0);
     command('<');
     x_com(0,"INK 0",0,0,0);
     command('<');
     x_com(0,"CLS",0,0,0);    
     untouch();
     com="NEW";
  }
  if(g_wizard)println("X_COM @win"+win+":'"+com+"'");
  
  if(com.length()<2)return;
  char para=com.charAt(1); 

  if(com.charAt(0)=='+'){
    String comm=com.toUpperCase();
    for(int i=0;i<g_extension;i++){
     // println(comm+" == "+g_extname[i]);
      if(comm.equals(g_extname[i])){
      //  println("JACKPOT!");
        launch_extension(i);
        return;
      }
    }
    return;
  }
  
  if(com.charAt(0)=='@'){
    
    int value=leechvalue(com);

        if(para=='X'){//xslider, mode=icon#
      touch();//could be subtler
      int t=g_farge;
     // if(g_data[XYMODE]==1)t=257;// in special case, not done
      
      int ic=in_icon(xx+1,yy+1);
      float from=g_iconx1[ic];
      float tow=g_iconx2[ic]-g_iconx1[ic];
      float ptr=g_mousex-from;
      
      ptr=ptr/tow;
      ptr=ptr*255;

      char par=com.charAt(2);
      if(par=='R'){
        int dista=512;
        int target=-1;
         for(int i=0;i<g_palstepsr;i++){
           if(abs(g_stepr[i]-ptr)<dista){
             dista=abs(g_stepr[i]-int(ptr));
             target=i;
           }
         }     
         if(target>-1){
           makecolor(t,g_stepr[target],g_g[t],g_b[t]);
           update_preview_window();
        
           if(g_lockerid==0){
             g_lockerid=1;
             g_ylocker=(g_icony1[ic]+g_icony2[ic])/2;
           }   
         }
      return;
      }
      if(par=='G'){
        int dista=512;
        int target=-1;
         for(int i=0;i<g_palstepsg;i++){
           if(abs(g_stepg[i]-ptr)<dista){
             dista=abs(g_stepg[i]-int(ptr));
             target=i;
           }
         }     
         if(target>-1){
           makecolor(t,g_r[t],g_stepg[target],g_b[t]);
           update_preview_window();
           if(g_lockerid==0){
             g_lockerid=2;
             g_ylocker=(g_icony1[ic]+g_icony2[ic])/2;
           }     
         }
      return;
      }    
      if(par=='B'){
        int dista=512;
        int target=-1;
         for(int i=0;i<g_palstepsb;i++){
           if(abs(g_stepb[i]-ptr)<dista){
             dista=abs(g_stepb[i]-int(ptr));
             target=i;
           }
         }     
         if(target>-1){
           makecolor(t,g_r[t],g_g[t],g_stepb[target]);
           update_preview_window();
           if(g_lockerid==0){
             g_lockerid=3;
             g_ylocker=(g_icony1[ic]+g_icony2[ic])/2;
           }              
         }
      return;
      }  
    }
    if(g_lockerid>0)return;
    
    if(para=='x'){ 
      g_entryad=value;
      g_entrymode=TICKBOX;
      if(getbit(value)==0){putbit(value,1);return;}
      if(getbit(value)==1){putbit(value,0);return;}
      return;
    }  
    if(para=='v'){ 
      g_entryad=value;
      g_entrymode=NUMBER;
      return;
    }    
    if(para=='a'){ 
      g_entryad=value;
      g_entrymode=ASCII;
      return;
    }
    if(para=='m'){
      change_mode_value(value);
      return;
    }    
    if(para=='f'){
      selectcolor(mode-1,value);
      g_repanel=-2;
      return;
    }
    if(para=='b'){
      command(int(128+value));
      return;
    }
    if(para=='t'){
        char xc=com.charAt(2);
        if(xc=='C'&&g_realbutton==39)xc='V';
        if(xc=='u'&&g_realbutton==39)xc='U';
        if(xc=='n'&&g_realbutton==39)xc='N';     
        if(xc=='h'&&g_realbutton==39)xc='H';
        if(xc=='s'&&g_realbutton==39)xc='S';
        if(xc=='g'&&g_realbutton==39)xc='G';
        if(xc=='r'&&g_realbutton==39){
          xc=')';
          if(g_shift)xc='(';
        }        
      command(xc);
      g_repanel=-2;
      return;
    }
    

  }
  
  String word[]=split(com," ");   
    
  if(com.equals("DITHERp")){
    g_raster_no--;
    if(g_raster_no<0)g_raster_no=10;
    set_fixed_raster(g_raster_no);
    g_data['r']=1;
    return;
  }
  
  if(com.equals("DITHERn")){
    g_raster_no++;
    if(g_raster_no>10)g_raster_no=0;
    set_fixed_raster(g_raster_no);
    g_data['r']=1; 
    return;
  }
  
  if(com.equals("DITHERx")){
    g_raster_offset_x++;
    if(g_raster_offset_x>3)g_raster_offset_x=0;
    return;
  }
  
  if(com.equals("DITHERy")){
    g_raster_offset_y++;
    if(g_raster_offset_y>3)g_raster_offset_y=0;
    return;
  }  
  
    
  for(int i=0;i<g_machinecalled.length;i++){
    if(com.equals(g_machinecalled[i])){      
      make_recallpoint();
      change_mode(g_machinemenu[i],i);
      if(get_complexity()>2&&g_machine!=TUTORIAL1){
        g_report="| [X]  Mode Changed |-|";
        g_report=g_report+"Recall old mode?| | [Recall]";
        launch_dialogue(83);
      }
      return;
    }  
  }
  
  // can only be u-cased after certain stuff
  
  String lom=com;
  com=com.toUpperCase();
  
  // menu launchers are exceptions
  
  if(com.equals("FILE")){
    g_fingernumb=0;
    discard_dialogues(0);
    if(count_menus()>0&&mode!=4){discard_menus();return;}
    launch_menu(32,xx,yy);
    return;
  }
  if(com.equals("EDIT")){
    g_fingernumb=0;
    discard_dialogues(0);
    if(count_menus()>0&&mode!=4){discard_menus();return;}
    launch_menu(33,xx,yy);
    return;
  }
  if(com.equals("TOOLS")){
    discard_dialogues(0);
    g_fingernumb=0;
    if(count_menus()>0&&mode!=4){discard_menus();return;}
    launch_menu(34,xx,yy);
    return;
  }
  if(com.equals("OTHER")){
    discard_dialogues(0);
    g_fingernumb=0;
    if(count_menus()>0&&mode!=4){discard_menus();return;}
    launch_menu(35,xx,yy);
    return;
  }
  if(com.equals("FX")){
    discard_dialogues(0);
    g_fingernumb=0;
    if(count_menus()>0&&mode!=4){discard_menus();return;}
    launch_menu(36,xx,yy);
    return;
  }  
  
  // command executed, discard windows
  
  discard_menus();
  
  g_iconban=true;
  g_banctr=5;

  
  if(com.equals("<<")){
    hide_menus();
    return;
  }  
  
  if(com.equals("MDRAG")){
    g_global_dragmode=1;
    g_window_id=win;
    
    if(g_tutpage==0)g_tutpass=1;
    g_phandlex=g_winlocx[win]-g_percent_x;
    g_phandley=g_winlocy[win]-g_percent_y;
    return;
  }  
  
  if(com.equals("SETTINGS")){
    launch_dialogue(80);
    return;
  }   
  if(com.equals("QUIT")){
    launch_dialogue(78);
    return;
  } 
  if(com.equals("RESTORE")){
    store_undo();
    return;
  }
  if(com.equals("CLEAR")||com.equals("CLS")){
    command('o');
    return;
  }
  if(com.equals("CLEAR ")){
    command('<');
    command('o');
    command('<');
    return;
  }
  if(com.equals("OPEN")){
    g_filetype=0;
    command('l');
    return;
  }
  if(com.equals("SAVE")){
    command('S');
    return;
  }  
  if(com.equals("LOAD ACT")){
    g_iconban=true;
    g_filetype=FILE_PALETTE;
    fileselect=true;
    gui=true;
    return;
  }
  if(com.equals("SAVE ACT")){
    g_filetype=FILE_PALETTE;
    gui=true;
    saveas=true;
    return;
  }  
  if(com.equals("SAVE AS")){
    realdiscardmenus(0);
    command('s');
    return;
  }  
  if(com.equals("OVERWRITE")){
    realdiscardmenus(0);
    confirm_filewrite();
    retrieve_filename();
    return;
  }  
  if(com.equals("IGNORE")){
    realdiscardmenus(0);
    confirm_fileread();
    return;
  }      
  if(com.equals("EXPORT TXT")){
    g_data[DUMPMSG]=0;
    launch_dialogue(69);
    return;
  }    
  if(com.equals("EXPORT")){
    command('W');
    return;
  }  
  if(com.equals("OUTPUT")){
    command('A');
    return;
  }
  if(com.equals("IMPORT")){
    command('w');
    return;
  }  
   if(com.equals("TEXT OUT")){
    realdiscardmenus(0);
    command('E');
    return;
  }     
  if(com.equals("EXIT")){
    super.exit();
  }  
  if(com.equals("CANCEL")){
    realdiscardmenus(0);
    return;
  }    
  if(com.equals("CLOSE")){
    realdiscardmenus(0);
    return;
  } 
    
  if(com.equals("CHARCOUNT")){
    force_unique_chars();
   // println("count:"+g_uniques);
    return;
  }     
  
   if(com.equals("FLIP")){
     flip();
    return;
   }
   
   if(com.equals("PREVIEW")){
     command(BACKSPACE);
    return;
   }
   if(com.equals("ASPECT")){
     toggle_aspect();
    return;
   }  
  if(com.equals("UNDO")){
    command('u');
    return;
  }
  if(com.equals("RECALL")){
    recall_mode();
    return;
  } 
  if(com.equals("REVERT")){
    spare();
    restore_undo();
    spare();

    discard_dialogues(1);
    //realdiscardmenus(g_wintype[in_window(xx,yy)]);
    g_trueclearbit=true;
    return;    
  }
    
  if(com.equals("RECALL")){
    recall_mode();
    return;
  }
  if(com.equals("REDO")){
    command('U');
    return;
  }
  if(com.equals("SPARE")){
    command('j');
    return;
  }
  if(com.equals("TO SPARE")){
   // command('J');
    spare();
    store_undo();
    switch(g_spare){
      case 0:
        message("Copied to|Front");
        switcher(4);
      break;
      case 1:
        message("Copied to|Spare");
        switcher(4);        
      break;
    }
    spare();     
    return;
  } 
  if(com.equals("MERGE")){
    merge_pages();
    return;
  } 
  if(com.equals("SWAP")){
    command('<');
    return;
  }  
  if(com.equals("MAKE")){
    global_recolor(g_backg,g_farge);
    return;
  }
  if(com.equals("XCHG")){
    store_undo();
    global_exchange(g_backg,g_farge);
    return;
  }
  if(com.equals("COPY")){
    global_copy(g_farge,g_backg);
    return;
  }  
  if(com.equals("SPREAD")){
    palette_spread(g_farge,g_backg);
    return;
  }    
  if(com.equals("HIDE GRID")){
    g_data['g']=0;
    return;
  } 
  if(com.equals("SHOW GRID")){
    g_data['g']=1;
    return;
  }
  int xcheat=1;
  if(g_hzoomer==2||g_multic==1){xcheat=2;}
  if(com.equals("GRID 4*4")){
    clear_offset();
    make_grid(4*xcheat,4);
    g_data['g']=1;
    return;
  }
  if(com.equals("GRID 4*8")){
    clear_offset();
    make_grid(4*xcheat,8);
    g_data['g']=1;
    return;
  }  
  if(com.equals("GRID 4*16")){
    clear_offset();
    make_grid(4*xcheat,16);
    g_data['g']=1;
    return;
  }
  if(com.equals("GRID 8*16")){
    clear_offset();
    make_grid(8*xcheat,16);
    g_data['g']=1;
    return;
  }

  if(com.equals("GRID 32*32")){
    clear_offset();
    make_grid(32*xcheat,32);
    g_data['g']=1;
    return;
  }

  if(com.equals("GRID 16*32")){
    clear_offset();
    make_grid(16*xcheat,32);
    g_data['g']=1;
    return;
  }  
  if(com.equals("GRID 8*0")){
    clear_offset();
    make_grid(8*xcheat,0);
    g_data['g']=1;
    return;
  }  
  if(com.equals("GRID 8*8")){
    clear_offset();
    make_grid(8*xcheat,8);
    g_data['g']=1;
    return;
  } 
  if(com.equals("GRID 16*16")){
    clear_offset();
    make_grid(16*xcheat,16);
    g_data['g']=1;
    return;
  } 
  if(com.equals("GRID 24*21")){
    clear_offset();
    make_grid(24*xcheat,21);
    g_data['g']=1;
    return;
  }   
   if(com.equals("GRID 12*21")){
    clear_offset();
    make_grid(12*xcheat,21);
    g_data['g']=1;
    return;
  }    
  // console 
  

 
   
  if(word[0].equals("GLOBAL")){
    if(word.length>2){
      store_undo();
      global_recolor(evaluate(word[1],2),evaluate(word[2],2));
    }
    return;
  }    
  
   if(com.equals("COPY ALL")){
      switcher(2);
      g_bsourcex=0;
      g_bsourcey=0;
      g_bsourcex2=X-1;
      g_bsourcey2=Y-1;
      g_data['p']=0;
      g_data['x']=0;g_data['y']=0;
      g_data['z']=0;
      g_data['Z']=0;
      g_phase=0;
      g_rubbermode=0;
      set_tool(1);
      command('9');
    return;
  }   
  if(com.equals("RESET")){
    command(' ');
    return;
  }   
  if(com.equals("RESETPARAMS")){
    reset_parameters();
    return;
  }       
  if(com.equals("SET BORDER")){
    command('B');
    return;
  }     
  if(com.equals("SET BACK1")){
    command('C');
    return;
  }   
  if(com.equals("SET BACK2")){
    command('V');
    return;
  }
  if(com.equals("SET AUX")){
    command('V');
    return;
  }
  if(com.equals("PEPTO")){
    hard_c64_palette(0,0);
    return;
  }     
  if(com.equals("COLODORE")){
    hard_c64_palette(1,0);
    return;
  }       
  if(com.equals("PTOING")){
    hard_c64_palette(2,0);
    return;
  }
       
  if(com.equals("DEEKAY")){
    hard_c64_palette(6,0);
    return;
  }      
  if(com.equals("COMMUNITY")){
    hard_c64_palette(5,0);
    return;
  }     
  if(com.equals("ULAPALT")){
    hard_c64_palette(3,0);
    return;
  }      
  if(com.equals("ULAPALT2")){
    hard_c64_palette(4,0);
    return;
  }      
  if(com.equals("ULAPREP")){
    prepare_ulaplus(0);
    return;
  }                
  if(com.equals("ABOUT")){
    launch_dialogue(79);
    return;
  }                  
  if(com.equals("STAMP")){
    make_timestamp();
    return;
  }  
  if(com.equals("MODE")){
    launch_dialogue(77);
    return;
  }  
  if(com.equals("CHANGE")){
      discard_dialogues(0);
      g_trueclearbit=true;
      launch_dialogue(77);
    launch_dialogue(77);
    return;
  }
  if(com.equals("NEW")){
    if(touched()==1){
      launch_alert("å  Warning! New Mode|-|You may have unsaved|work! Can't Undo.||  [Change/Enter mode|selector]    [Cancel/Stay|in current|mode]");

    }else{
      
      discard_dialogues(0);
      g_trueclearbit=true;
      launch_dialogue(77);
    }    
    return;
  }      
  if(com.equals("CREATE")){
    // just too kludge-y    
  }     
  if(com.equals("ICONED")){
    dump_icons();
    return;    
  }
  if(com.equals("DEBUG")){
    launch_dialogue(76);
    return;    
  }
  if(com.equals("SCRIPT")){
    launch_dialogue(86);
    return;
  }
  if(com.equals("EXTRAS")){
    launch_dialogue(87);
    return;
  }
  if(com.equals("UP")){
    int w=find_window(76);
    int par=winparam_get(w);
    if(g_shift)par=4;
    if(par>0)winparam_put(w,par-4);
    return;
  }  
  if(com.equals("DOWN")){
    int w=find_window(76);
    int par=winparam_get(w);
    
    if(g_shift){
      if(par==1024/8){par=65536/8;}else{
        par=1024/8;
      }
    }else{
      par=par+4;
    }
    winparam_put(w,par);
    return;
  }    
  if(com.equals("WMAN")){
    launch_dialogue(73);
    return;
  }
  if(com.equals("NOWIZ")){
    g_wizard=false;
    return;
  }
  if(com.equals("PALETTE")){
    force_autohistogram();
    launch_dialogue(70);
    return;
  }
  if(com.equals("KEYSHEET")){
    force_autohistogram();
    launch_dialogue(89);
    return;
  }
  if(com.equals("CONSOLE")){
    launch_dialogue(81);
    console_echo("");
    console_echo("CLI");
    //console_echo("Experimental - Don't lose your work!");
   // console_echo(path);
    return;
  }
  if(com.equals("PATHS")){
    launch_dialogue(82);
    return;
  }   
  if(com.equals("RESIZE")){
    launch_dialogue(84);
    return;
  }   
  if(com.equals("SET GRID")){
    launch_dialogue(85);
    return;
  }      
  if(com.equals("OPAQUE")){
    g_backg=258;
    return;
  }
  if(com.equals("NORMAL")){
    g_data[FX]=byte(PAINT);
    return;
  }
  if(com.equals("SHADE")){
    g_data[FX]=byte(SHADE);
    return;
  }
  if(com.equals("SMOOTH")){
    g_data[FX]=byte(SMOOTH);
    return;
  }  
  if(com.equals("SMEAR")){
    g_data[FX]=byte(SMEAR);
    return;
  }
  if(com.equals("CYCLER")){
    g_data[FX]=byte(CYCLE);
    return;
  }
  if(com.equals("DARKEN")){
    g_data[FX]=byte(DARKEN);
    return;
  }
  if(com.equals("MIX")){
    g_data[FX]=byte(MIX);
    return;
  }  
  if(com.equals("TINT")){
    g_data[FX]=byte(TINT);
    return;
  } 
  if(com.equals("SMEAR")){
    g_data[FX]=byte(SMEAR);
    return;
  }
  if(com.equals("BLEND")){
    g_data[FX]=byte(BLENDER);
    return;
  }  
  if(com.equals("LINEAR")){
    user_routine(2);
    return;
  } 
  if(com.equals("TTILES")){
    user_routine(3);
    return;
  }  
  if(com.equals("TSPRITES")){
    user_routine(4);
    return;
  }
  if(com.equals("BITFY")){
    g_data[FX]=byte(BITFY);
    return;
  }
  if(com.equals("SHIFTER")){
    g_data[FX]=byte(SHIFTER);
    return;
  }
  if(com.equals("SET RANGE")){
    g_map[240]=byte(g_farge);
    g_map[241]=byte(g_backg);
    if(g_farge>g_backg){
          g_map[241]=byte(g_farge);
          g_map[240]=byte(g_backg);
    }
    message(str(int(g_map[240]))+" to "+str(int(g_map[241])));
    return;
  }
  if(com.equals("ROLL")){    
    store_undo();
    palette_roll(g_farge,g_backg,0);
    return;
  }
  if(com.equals("CYCLE")){
    palette_roll(int(g_map[240]),int(g_map[241]),1);
    return;
  }
  if(word[0].equals("CGA")){
    if(word.length>1){
      cga_variant(evaluate(word[1],2));
    }
    return;
  }
  if(word[0].equals("PLT")){
    if(word.length>1){
      cga_variant(evaluate(word[1],2));
    }
    return;
  }
   if(word[0].equals("SLOT")){
    if(word.length>1){
      
      if(g_shift){
        delete_recentitem(evaluate(word[1],2));
        populate_recentview();
        return;
      }
      
      g_recent_item=evaluate(word[1],2);
      
      if(untouched()==0){
        launch_dialogue(67);
        return;    
      }
     // launch_dialogue(67);
      //suggest_recent(evaluate(word[1],2));
      int ref=evaluate(word[1],2);
      
      if(g_retriever[ref].length()>3){
        g_candidatename=g_recentlist[ref];
        if(g_spare==0)g_extfilename=g_candidatename;
        if(g_spare==1)g_extfilenames=g_candidatename;
        
        if(fexists(g_candidatename)==false){
          g_alertmessage="å  Error!|-|File not found.||| [Cancel]";
          launch_dialogue(74);
          message("NO FILE");
          return;
        }
        
        global_clear();
        change_mode_value(g_recentmac[ref]);
        xbasic_run(g_retriever[ref]);
        setname(g_recentlist[ref],g_spare);
      }
      else{
        suggest_restore(g_recentlist[ref],0);
      }
    }
    return;
  } 
  if(com.equals("DO IT")){
      //global_clear();
      //change_mode_value(g_recentmac[g_recent_item]);
      //suggest_restore(g_recentlist[g_recent_item],0);
      
      int ref=g_recent_item;
      if(g_retriever[ref].length()>3){
        g_candidatename=g_recentlist[ref];

        if(fexists(g_candidatename)==false){
          g_alertmessage="å  Error!|-|File not found.||| [Cancel]";
          launch_dialogue(74);
          message("NO FILE");
          return;
        }
        
        global_clear();
        change_mode_value(g_recentmac[ref]);
        if(g_spare==0)g_extfilename=g_candidatename;
        if(g_spare==1)g_extfilenames=g_candidatename;
        xbasic_run(g_retriever[ref]);
        setname(g_recentlist[ref],g_spare);
      }
      else{
        suggest_restore(g_recentlist[ref],0);
      }
  }
   
  if(com.equals(" OK ")){
    realdiscardmenus(0);
    return;
  }
  if(com.equals("BPL+")){
      if(tentative_mode(g_data[NEWX],g_data[NEWY],g_data[NEWBPL]+1)==0)return;
      resize_mod(0,0,1);
      return;
  }  
  if(com.equals("BPL-")){
      if(tentative_mode(g_data[NEWX],g_data[NEWY],g_data[NEWBPL]-1)==0)return;
      resize_mod(0,0,-1);
      return;
  }  
  if(com.equals("X+")){
    if(g_data[XYMODE]==0){
      resize_mod(1,0,0);
    }
    if(g_data[XYMODE]==1&&g_gridx<128){
      grid_iron(1,0,0,0);
    }
    return;
  }  
  //println("/"+com+"/");
  if(com.equals("ALBERT 416X200")){
    if(g_data[XYMODE]==0){
      resize_mod(416,200,0);
    }   
  }
  if(com.equals("X-")){
    if(g_data[XYMODE]==0){
      resize_mod(-1,0,0);
    }
    if(g_data[XYMODE]==1&&g_gridx>0){
      grid_iron(-1,0,0,0);
    }
    return;
  }
  if(com.equals("Y+")){    
    if(g_data[XYMODE]==0){
      resize_mod(0,1,0);
    }
    if(g_data[XYMODE]==1&&g_gridy<128){
      grid_iron(0,1,0,0);
    }
    return;
  }  
  if(com.equals("Y-")){    
    if(g_data[XYMODE]==0){
      resize_mod(0,-1,0);
    }
    if(g_data[XYMODE]==1&&g_gridy>0){
      grid_iron(0,-1,0,0);
    }
    return;
  }
  if(com.equals("OX+")){
    grid_iron(0,0,1,0);
    return;
  }  
  if(com.equals("OX-")){
    grid_iron(0,0,-1,0);
    return;
  }
  if(com.equals("OY+")){  
    grid_iron(0,0,0,1);
    return;
  }  
  if(com.equals("OY-")){
    grid_iron(0,0,0,-1);
    return;
  }   
  
  if(com.equals("WORKSTAGE")){// w CONFIRM
    launch_dialogue(88);
    return;
  }    
  if(com.equals("CONFIRM")){
    make_new_version();
    realdiscardmenus(0);
    touch();
    return;
  }  
  
  if(com.equals("RECENT")){
    populate_recentview();
    launch_dialogue(68);
    return;
  }   
  if(com.equals("BRIGHTER")){
    grid_lightness(int(g_r[257]),8);    
    return;
  }
  if(com.equals("DARKER")){
    grid_lightness(int(g_r[257]),-8);    
    return;
  }
  if(com.equals("HELP")){
    launch_dialogue(90);
    g_tutpage=0;
    g_tutscore=0;
    g_tutpass=0;
    tutorial_step(g_tutpage);
    return;
  }      
  if(com.equals("FORWARD")){
    g_tutpage++;   
    tutorial_step(g_tutpage);
    g_tutpass=0;
    g_tutscore=0;
    clamp_undo();
    g_maglevel=0;
    refocus();
    return;
  }   
  if(com.equals("APPLY")){//Apply resize dialogue
      make_recallpoint();
      int gc=get_complexity();
      change_size();    
      if(gc>2){
        g_report="| [X]  Size Changed |-|";
        g_report=g_report+"Recall old size?| | [Recall]";
        launch_dialogue(83);
      }      
      return;
  }
  if(word[0].equals("RUN")){
    if(word.length>1){
      if(word[1].length()>3){
        println(word[1]);
        String fn=word[1].toLowerCase();
        xbasic_run(fn);        
      }
    }
    return;
  }
  
  //using original com
  int rev=interpret(0,lom+" ");
}

int leechvalue(String ss){
  int value=0;
  for(int i=0;i<ss.length();i++){
    int a=ss.charAt(i);
    if(a>='0'&&a<='9'){
      value=value*10;
      value=value+(a-48);
    }
  }
  return value;
}

void all_box_drag()
{
    g_boxreconstruct=2;
    refresh_all();
    g_repanel=-1;
    update_ui(true,0);
}

void winparam_put(int win,int par){
  if(win<0)return;
  if(win>MAXW)return;
  g_winparam[win]=par;
}

int winparam_get(int win){
  if(win<0)return 0;
  if(win>MAXW)return 0;
  return g_winparam[win];
}
